<?php
######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2014
#
# This php contains everything to do the password reset
#
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# v2014-12-07 FPG created the script
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
######################################################################

$resetuid=0;
$resetpid="";
$sQuery = "SELECT UID FROM `USER` WHERE UEMAIL = ?";
$defaultErrorMsg=$lang['contactSysadmin'];
$statement = mysqli_prepare($databaseConnection, $sQuery);
setSession("GLASQLEXIT", logSQLError($sQuery));

if (withoutSQLError()) {
    if (!mysqli_stmt_bind_param($statement, "s", $_POST['EMAIL'])) {
        setSession("GLASQLEXIT", logSQLErrorManual("Error binding input params with sql-statement: ".$sQuery));
    } else {
        mysqli_stmt_execute($statement);
        if (!mysqli_stmt_bind_result($statement, $resetuid)) {
            setSession("GLASQLEXIT", logSQLErrorManual("Error binding output params with sql-statement: ".$sQuery));
        } else {
            while (mysqli_stmt_fetch($statement)) {
                debugIntoFile ("resetuid=".$resetuid);
            }
        }
    }
}
closePreparedStatement($statement);

if ($resetuid != 0) {
    $sQuery = "INSERT INTO PWDRESET (PID, UID) VALUES (?, ?)";
    $defaultErrorMsg=$lang['contactSysadmin'];
    $statement = mysqli_prepare($databaseConnection, $sQuery);
    setSession("GLASQLEXIT", logSQLError($sQuery));

    if (withoutSQLError()) {
        $resetpid = GUID();
        if (!mysqli_stmt_bind_param($statement, "si", $resetpid, $resetuid)) {
            setSession("GLASQLEXIT", logSQLErrorManual("Error binding input params with sql-statement: ".$sQuery));
        } else {
            mysqli_stmt_execute($statement);
        }
    }
    closePreparedStatement($statement);

    debugIntoFile ("Server=".$projectURL);
    debugIntoFile ("We send an email for PID/UID=".$resetpid."/".$resetuid);
    #/index.php?mode=doresetpwd&pid=7CDAC3EB-93AD-4558-9CB5-6A98AF8891C0&uid=2

    $email['FROMMAIL'] = $emailAdmin;;

    $email['SUBJECT'] = $projectName." - ".$lang['resetPwdEmailHeader'];

    $email['MSG'] = "<html><body>";
    $tempEmailText = $lang['resetPWDEmail'];
    debugIntoFile ("first line=".$tempEmailText);
    $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>".$tempEmailText."</div>";
    $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
    $tempEmailText = $lang['resetPWDEmail2'];
    debugIntoFile ("second line=".$tempEmailText);
    $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>".$tempEmailText."</div>";
    $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
    $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
    $tempEmailText = $projectURL."index.php?mode=doresetpwd&pid=".$resetpid."&uid=".$resetuid;
    debugIntoFile ("third line=".$tempEmailText);
    $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'><a href=".$tempEmailText." target=_blank>".$tempEmailText."</a></div>";
    $email['MSG'] .= "</body></html>";

    $email['HEADERS'] = "Return-path: ".$email['FROMMAIL']."\n";
    $email['HEADERS'] .= "Content-type: text/html; charset=utf-8\n";
    $email['HEADERS'] .= "From: <".$email['FROMMAIL'].">\n";
    $email['HEADERS'] .= "Reply-To: <".$email['FROMMAIL'].">\n";

    $email['TOMAIL'] = $_POST['EMAIL'];

    @mail($email['TOMAIL'], $email['SUBJECT'], $email['MSG'], $email['HEADERS']);
}
?>
