<?php
######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2014
#
# This php contains everything to deal with updates
#
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# v2014-12-01 FPG created the script
# v2014-12-02 FPG adapted script for multi language support
# v2014-12-04 FPG adapted table FILE added column FILESIZE
# v2014-12-07 FPG adapted to database version 3 (PWDRESET))
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
######################################################################


debugIntoFile("check if update is necessary");
$dbExistingVersion=0;
if (withoutSQLError()) {
    $sQuery = "SELECT VVERSION, VDESC FROM APPVERSION WHERE VID=1";
    $result = getRessource($sQuery);
    if (withoutSQLError()) {
        while ($val = getRow($result)) {
            #debugIntoFile($val["VVERSION"]."/".$val["VDESC"]);
            $dbExistingVersion = $val["VVERSION"];
        }
    }
    freeRessource($result);

    if ($dbExistingVersion >= $databaseMinVersion) {
        debugIntoFile($lang['dbalreadymin']." ".$databaseMinVersion);
        setSession("CheckUpdate", 0);
    } else {
        if ($dbExistingVersion == 1) {
            logIntoFile($lang['updatingfromversion1'].": 1-2");
            $sQuery = "ALTER TABLE FILE ADD FSIZE INT;";
            getRessource($sQuery);
            $sQuery = "UPDATE FILE SET FSIZE = 0 WHERE FSIZE is null;";
            getRessource($sQuery);
            $sQuery = "ALTER TABLE FILE CHANGE FSIZE FSIZE INT NOT NULL;";
            getRessource($sQuery);
            $dbExistingVersion = 2;
        }
        if ($dbExistingVersion == 2) {
            logIntoFile($lang['updatingfromversion1'].": 2-3");
            $sQuery = "ALTER TABLE USER DROP USERNAME;";
            getRessource($sQuery);
            $sQuery = "ALTER TABLE USER CHANGE UEMAIL UEMAIL VARCHAR(50) NOT NULL;";
            getRessource($sQuery);
            $sQuery = "CREATE TABLE IF NOT EXISTS `PWDRESET` (
      `PID` varchar(100) NOT NULL,
      `UID` bigint(20) NOT NULL,
      PRIMARY KEY (`PID`)
    ) ENGINE=InnoDB  DEFAULT CHARSET=utf8;";
                getRessource($sQuery);
            $dbExistingVersion = 3;
        }
        if ($dbExistingVersion == 3) {
            logIntoFile($lang['updatingfromversion1'].": 3-4");
            $sQuery = "ALTER TABLE USER ADD UNIQUE (UEMAIL);";
            getRessource($sQuery);
            $dbExistingVersion = 4;
        }
        if ($dbExistingVersion == 4) {
            logIntoFile($lang['updatingfromversion1'].": 4-5");
            $sQuery = "ALTER TABLE `GROUP` ADD UNIQUE (GNAME);";
            getRessource($sQuery);
            $dbExistingVersion = 5;
        }

        # update version
        $sQuery = "UPDATE APPVERSION SET VVERSION=".$databaseMinVersion.", VDESC='".$myVersion.".".$SVNRevision."' WHERE VID=1;";
        getRessource($sQuery);
        logIntoFile($val['updatedone']);
        setSession("CheckUpdate", 0);
    }
}
?>
