<?php
######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2014
#
# This php contains everything to deal with logging
#
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# v2014-11-28 FPG created the script
# v2014-11-30 FPG - added logSQLErrorManual
#                 - adapted logSQLError
# v2014-12-01 FPG added logSQLErrorOracle
# v2014-12-02 FPG added getSessionIfUserLoggedIn and adapted
#                 logging, so that in debug entries the username is
#                 included if the user is logged in
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
######################################################################


#---------------------------------------------------------------------
# (c) www.glawar.at: will log the error into log file
#                    if $defaultErrorMsg is set, this text will be set
#                    to $_SESSION['GLAERRORMESSAGE'] and the sql-error-message
#                    as well; otherwise only the sql-error-message
#---------------------------------------------------------------------
function logSQLError ($sQuery) {
    global $defaultErrorMsg;
    global $lang;

    $GLAERRORMESSAGE = getError();

    if (empty($GLAERRORMESSAGE)) {
        $retVal = 0;
    } else {
        if (empty($defaultErrorMsg)) {
            setSession("GLAERRORMESSAGE", $GLAERRORMESSAGE);
        } else {
            setSession("GLAERRORMESSAGE", $defaultErrorMsg);
        }
        logError($defaultErrorMsg.": ".$GLAERRORMESSAGE." ".$lang['causedbyselect'].$sQuery);
        $retVal = 1;
    }

    return $retVal;
}


#---------------------------------------------------------------------
# (c) www.glawar.at: will log the error into log file for Oracle statement errors
#                    if $defaultErrorMsg is set, this text will be set
#                    to $_SESSION['GLAERRORMESSAGE'] and the sql-error-message
#                    as well; otherwise only the sql-error-message
#---------------------------------------------------------------------
function logSQLErrorOracle ($stmt, $sQuery) {
    global $defaultErrorMsg;

    $GLAERRORMESSAGE = getErrorOracle($stmt);

    if (empty($GLAERRORMESSAGE)) {
        $retVal = 0;
    } else {
        if (empty($defaultErrorMsg)) {
            setSession("GLAERRORMESSAGE", $GLAERRORMESSAGE);
        } else {
            setSession("GLAERRORMESSAGE", $defaultErrorMsg);
        }
        logError($defaultErrorMsg.": ".$GLAERRORMESSAGE." ".$lang['causedbyselect'].$sQuery);
        $retVal = 1;
    }

    return $retVal;
}


#---------------------------------------------------------------------
# (c) www.glawar.at: do manual logging of sql error
#---------------------------------------------------------------------
function logSQLErrorManual ($errorMsg) {
    setSession("GLAERRORMESSAGE", $errorMsg);

    logError($errorMsg);

    return 1;
}


#---------------------------------------------------------------------
# (c) www.glawar.at: will only log into file if error is empty
#---------------------------------------------------------------------
function logError($error) {
    if(!empty($error)) {
        logAlwaysIntoFile("ER", $error);
    }
}


#---------------------------------------------------------------------
# (c) www.glawar.at: returns the session of username if user is
#                    logged in
#---------------------------------------------------------------------
function getSessionIfUserLoggedIn() {
    $getSessionIfUserLoggedIn = "";

    if (!isSessionSet("UEMAIL")) {
        $getSessionIfUserLoggedIn = "";
    } else {
        $getSessionIfUserLoggedIn = " ".getSession("UEMAIL");
    }

    return $getSessionIfUserLoggedIn;
}


#---------------------------------------------------------------------
# (c) www.glawar.at: log into file $logFile
#---------------------------------------------------------------------
function logAlwaysIntoFile($logTpye, $logText){
    global $logFile;

    $tmpOutut = "[".$logTpye." ".getActualDateAndTime().getSessionIfUserLoggedIn()."] ".$logText;
    file_put_contents($logFile, $tmpOutut."\n", FILE_APPEND | LOCK_EX);
    setSession("GLALOGDISPLAY", getSession("GLALOGDISPLAY")."<div class=logging>".$tmpOutut."</div>");
}


#---------------------------------------------------------------------
# (c) www.glawar.at: log into file $logFile if $doLog is set to <1>
#                    if $logToScreen is set to <1> the logging also
#                    goes to the screen
#---------------------------------------------------------------------
function logIntoFile($logText){
    global $logFile;
    global $doLog;

    if ($doLog == 1) {
        logAlwaysIntoFile("IN", $logText);
    }
}


#---------------------------------------------------------------------
# (c) www.glawar.at: debug into file $logFile if $doDebug is set to <1>
#                    if $logToScreen is set to <1> the logging also
#                    goes to the screen
#---------------------------------------------------------------------
function debugIntoFile($logText){
    global $logFile;
    global $doDebug;

    if ($doDebug == 1) {
        logAlwaysIntoFile("DB", $logText);
    }
}
?>
