<?php
######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2014
#
# This php contains everything to deal with sessions
#
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# v2014-11-30 FPG created the script
# v2104-12-02 FPG added isSessionSet
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
######################################################################


#---------------------------------------------------------------------
# (c) www.glawar.at: set a session object with session prefix
#
# sessionName: name of the session
# sessionValue: value of the session
#---------------------------------------------------------------------
function setSession($sessionName, $sessionValue) {
    global $sessionPrefix;

    $tempSessionName = $sessionPrefix.$sessionName;

    $_SESSION[$tempSessionName] = $sessionValue;
}


#---------------------------------------------------------------------
# (c) www.glawar.at: get a session value with session prefix
#
# sessionName: name of the session
#---------------------------------------------------------------------
function getSession ($sessionName) {
    global $sessionPrefix;

    $tempSessionName = $sessionPrefix.$sessionName;

    if (empty($_SESSION[$tempSessionName])) {
        return "";
    } else {
        return $_SESSION[$tempSessionName];
    }
}


#---------------------------------------------------------------------
# (c) www.glawar.at: unset a session value with session prefix
#
# sessionName: name of the session
#---------------------------------------------------------------------
function unsetSession ($sessionName) {
    global $sessionPrefix;

    $tempSessionName = $sessionPrefix.$sessionName;
    unset($_SESSION[$tempSessionName]);
}


#---------------------------------------------------------------------
# (c) www.glawar.at: checks if the session is empty or not
#
# sessionName: name of the session
#---------------------------------------------------------------------
function isSessionEmpty($sessionName) {
    global $sessionPrefix;

    $tempSessionName = $sessionPrefix.$sessionName;

    return empty ($_SESSION[$tempSessionName]);
}


#---------------------------------------------------------------------
# (c) www.glawar.at: checks if the given session is set
#
# sessionName: name of the session
#---------------------------------------------------------------------
function isSessionSet($sessionName) {
    global $sessionPrefix;

    $tempSessionName = $sessionPrefix.$sessionName;

    return isset ($_SESSION[$tempSessionName]);
}


#---------------------------------------------------------------------
# (c) www.glawar.at: check if the actual sql was without an error
#---------------------------------------------------------------------
function withoutSQLError() {
    if (getSession("GLASQLEXIT") == 0) {
        return true;
    } else {
        return false;
    }
}
?>
