<?php
######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2014
#
# This php contains everything to deal with databases
#
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# v2014-11-28 FPG created the script
# v2014-12-01 FPG added getErrorOracle
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
######################################################################


#---------------------------------------------------------------------
# (c) www.glawar.at: returns a valid database connection in
#                    $databaseConnection
#---------------------------------------------------------------------
function getDatabaseConnection() {
    global $lang;
    global $databaseConnection;
    global $usedb;
    global $sqlHost;
    global $sqlUser;
    global $sqlPass;
    global $sqlDB;
    global $oracleUsername;
    global $oraclePassword;
    global $oracleServiceName;
    global $mySqlDB;

    setSession("GLASQLEXIT", 0);
    if ($usedb == "mysql") {
        debugIntoFile("getDatabaseConnection with mysql");
        $databaseConnection = mysqli_connect($sqlHost, $sqlUser, $sqlPass, $mySqlDB);
        if (mysqli_connect_errno()) {
            logAlwaysIntoFile ("ER", $lang['noAccessMySQL']." ".mysqli_connect_error());
            setSession("GLASQLEXIT", 1);
            setSession("GLAERRORMESSAGE", $lang['nodbaccess'].". ".$lang['contactSysadmin']);
        } else {
            if (!$databaseConnection) {
                logAlwaysIntoFile ("ER", $lang['noAccessMySQL']." ".getError());
                setSession("GLASQLEXIT", 1);
                setSession("GLAERRORMESSAGE", $lang['nodbaccess'].". ".$lang['contactSysadmin']);
            }
        }
    } else if ($usedb == "oracle") {
        debugIntoFile("getDatabaseConnection with oracle");
        $databaseConnection = oci_connect ($oracleUsername, $oraclePassword, $oracleServiceName);
        if (!$databaseConnection) {
            $tempError = getError();
            logAlwaysIntoFile ("ER", $lang['noAccessOracle']." ".$tempError);
            setSession("GLASQLEXIT", 1);
            setSession("GLAERRORMESSAGE", $lang['nodbaccess'].". ".$lang['contactSysadmin']);
        }
    } else {
        debugIntoFile("getDatabaseConnection with undefinied database");
        logAlwaysIntoFile ("ER", getError());
        setSession("GLASQLEXIT", 1);
        setSession("GLAERRORMESSAGE", $lang['contactSysadmin'].": ".getError());
    }
}


#---------------------------------------------------------------------
# (c) www.glawar.at: closes database connection $databaseConnection
#---------------------------------------------------------------------
function closeDatabaseConnection(){
    global $databaseConnection;
    global $usedb;

    if ($usedb == "mysql") {
        mysqli_close($databaseConnection);
    } else if ($usedb == "oracle") {
        oci_close($databaseConnection);
    }
}


#---------------------------------------------------------------------
# (c) www.glawar.at: returns the error if an error occured
#                    Oracle only for connecton
#---------------------------------------------------------------------
function getError () {
    global $lang;
    global $usedb;
    global $databaseConnection;

    if ($usedb == "mysql") {
        $retVal = mysqli_error($databaseConnection);
    } else if ($usedb == "oracle") {
        $tempValue = oci_error();
        $retVal = $tempValue['message'];
    } else {
        $retVal = $lang['databaseNotSupported'].".".$lang['contactSysadmin'];
    }

    return $retVal;
}


#---------------------------------------------------------------------
# (c) www.glawar.at: returns the error if an error occured for Oracle
#                    statements
#---------------------------------------------------------------------
function getErrorOracle ($stmt) {
    $tempValue = oci_error($stmt);
    $retVal = $tempValue['message'];

    return $retVal;
}

#---------------------------------------------------------------------
# (c) www.glawar.at: returns a valid ressource
#---------------------------------------------------------------------
function getRessource ($query) {
    global $databaseConnection;
    global $usedb;

    if ($usedb == "mysql") {
        $retVal = mysqli_query($databaseConnection, $query);
    } else if ($usedb == "oracle") {
        $retVal = oci_parse($databaseConnection, $query);
        oci_execute($retVal);
    }

    setSession("GLASQLEXIT", logSQLError($query));

    return $retVal;
}

#---------------------------------------------------------------------
# (c) www.glawar.at: return a row from the result set
#---------------------------------------------------------------------
function getRow ($ressource) {
    global $usedb;

    if ($usedb == "mysql") {
        $retVal = mysqli_fetch_assoc($ressource);
    } else if ($usedb == "oracle") {
        $retVal = oci_fetch_assoc($ressource);
    }

    return $retVal;
}


#---------------------------------------------------------------------
# (c) www.glawar.at: return the number of found rows
#---------------------------------------------------------------------
function getNumberOfRows ($result) {
    global $usedb;

    if ($usedb == "mysql") {
        $retVal = mysqli_num_rows($result);
    } else if ($usedb == "oracle") {
        $retVal = oci_num_rows($result);
    }

    return $retVal;
}


#---------------------------------------------------------------------
# (c) www.glawar.at: frees the ressource
#---------------------------------------------------------------------
function freeRessource($ressource){
    global $usedb;

    if ($usedb == "oracle") {
        oci_free_statement($ressource);
    } else if ($usedb == "mysql") {
        mysqli_free_result($ressource);
    }
}


#---------------------------------------------------------------------
# (c) www.glawar.at: close a prepared statement
#---------------------------------------------------------------------
function closePreparedStatement ($stmt) {
    global $usedb;

    if ($usedb == "mysql") {
        mysqli_stmt_close($stmt);
    } else if ($usedb == "oracle") {
        oci_free_statement($stmt);
    }
}

?>
