<?php
######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2014
#
# This php contains everything to manage files
#
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# v2014-11-30 FPG created the script
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
######################################################################

$defaultErrorMsg=$lang['contactSysadmin'];
debugIntoFile("We manage the files");
if (!empty($_FILES['datei']['name'])) {
    if (empty($_POST["FILENAME"])) {
        debugIntoFile("we have no file");
        setSession("GLAERRORMESSAGE", $lang['nonewfilenofilename']);
        header ("Location: index.php?mode=addentry");
    } else {
        $newFileName = GUID();
        $myFilesize = filesize($_FILES['datei']['tmp_name']);
        $file_namerev = strrev($_FILES['datei']['name']);
        $parts = explode(".", $file_namerev);
        $endung = strrev($parts[0]);
        #echo "Dateiendung: ".$endung."<br>";
        $newFileName .= ".".$endung;
        #echo "A2".$newFileName."<br>";

        if (!move_uploaded_file($_FILES['datei']['tmp_name'], "data/".$newFileName)) {
            debugIntoFile($lang['filenotsaved'].$_FILES['datei']['name']);
        }
        debugIntoFile("New File: ".$newFileName);
        #debugIntoFile("filename=data/".$newFileName);

        #debugIntoFile("filesize2=".filesize("data/".$newFileName));
        #$newFileName = "'".$newFileName."'";

        if ((!isset($_POST['FILEDESCRIPTION'])) || ($_POST['FILEDESCRIPTION'] == "")) {
            $fileDescription = "";
        } else {
            $fileDescription = str_replace("'","''",$_POST["FILEDESCRIPTION"]);
        }

        $sQuery = "INSERT INTO FILE (FFILE, FNAME, FDESC, FSIZE) VALUES (?, ?, ?, ?)";
        debugIntoFile($sQuery);
        $statement = mysqli_prepare($databaseConnection, $sQuery);
        setSession("GLASQLEXIT", logSQLError($sQuery));

         if (getSession("GLASQLEXIT") == 0) {
             $a=str_replace("'","''",$_POST["FILENAME"]);
             if (!mysqli_stmt_bind_param($statement, "sssi", $newFileName, $a, $fileDescription, $myFilesize)) {
                logError($lang['errorbindinginput'].$sQuery);
                setSession("GLASQLEXIT", 1);
            } else {
                if (!mysqli_stmt_execute($statement)) {
                    setSession("GLAERRORMESSAGE", $lang['filenotadded']);
                    setSession("GLASQLEXIT", logSQLError($sQuery));
                    $tempError = 1;
                    header ("Location: index.php?mode=addentry");
                } else {
                    closePreparedStatement($statement);
                    debugIntoFile("File |".$newFileName."| added");
                    setSession("GLAERRORMESSAGE", "");
                    $sQuery = "SELECT FID FROM FILE WHERE FFILE = '".$newFileName."'";
                    debugIntoFile("GetFile-Select=".$sQuery);
                    $result = getRessource($sQuery);
                    #logSQLError();
                    $newFileId = 0;
                    while ($val = getRow($result)) {
                        $newFileId = $val['FID'];
                    }
                    freeRessource($result);

                    $sQuery = "INSERT INTO FILEUSER (FID, UID) VALUES (".$newFileId.", ".getSession("UID").")";
                    debugIntoFile("Insert-FileGroup-Select=".$sQuery);
                    $result = getRessource($sQuery);
                    logIntoFile("File |".$newFileName."| added");
                    #logSQLError();
                    #freeRessource($result);



                    if (getSession("ADMIN") == 0) {
                        # user who has added the file is no administrator
                        # we have to send an email to the real administrator
                        $email['FROMMAIL'] = getSession("UEMAIL");
                        $email['SUBJECT'] = $projectName." - ".$lang['newupload'];

                        $email['MSG'] = "<html><body>";
                        $tempEmailText = $projectURL."index.php?mode=permission&id=".$newFileId."&reseterror=reseterror";
                        debugIntoFile ("Emaillink=".$tempEmailText);
                        $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'><a href=".$tempEmailText." target=_blank>".$tempEmailText."</a></div>";
                        $email['MSG'] .= "</body></html>";

                        $email['HEADERS'] = "Return-path: ".$email['FROMMAIL']."\n";
                        $email['HEADERS'] .= "Content-type: text/html; charset=utf-8\n";
                        $email['HEADERS'] .= "From: <".$email['FROMMAIL'].">\n";
                        $email['HEADERS'] .= "Reply-To: <".$email['FROMMAIL'].">\n";

                        $sQuery = "SELECT USER.UEMAIL FROM USER, GROUPMEMBER WHERE USER.UID = GROUPMEMBER.UID AND GROUPMEMBER.GID = 1";
                        $result = getRessource($sQuery);
                        while ($val = getRow($result)) {
                            $email['TOMAIL'] = $val['UEMAIL'];
                            @mail($email['TOMAIL'], $email['SUBJECT'], $email['MSG'], $email['HEADERS']);
                        }
                        freeRessource($result);
                    }






                }
            }
         }
    }
} else {
    setSession("GLAERRORMESSAGE", $lang['nonewfilenofile']);
    header ("Location: index.php?mode=addentry");
}
?>
