<?php
######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2014
#
# This php contains everything to do the login
#
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# v2014-11-30 FPG created the script
# v2014-12-06 FPG added a defaultErrorMsg as default
# v2014-12-07 FPG login is now by email and password
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
######################################################################


$defaultErrorMsg=$lang['contactSysadmin'];
setSession("GLAERRORMESSAGE", "");
$email = $_POST['EMAIL'];
$pass = sanitize($_POST['PASS'], $sanitizeUserPwd);
#debugIntoFile("pass=".$pass);
$passTransformed = transformPwd($pass);
#debugIntoFile("passTransformed=".$passTransformed);

if (getSession("GLASQLEXIT") == 0) {
    # actually only mysql is supported but I have prepared the code, to
    # be easily adapted after having added support for other databases

    if ($usedb == "mysql") {
        $sQuery = "SELECT UID, ULAST, UFIRST, UEMAIL, UACTIVE, UADD FROM USER WHERE UEMAIL = ? AND UPWD = ?";
        debugIntoFile($sQuery);
        $statement = mysqli_prepare($databaseConnection, $sQuery);
        setSession("GLASQLEXIT", logSQLError($sQuery));

        if (getSession("GLASQLEXIT") == 0) {
            if (!mysqli_stmt_bind_param($statement, "ss", $email, $passTransformed)) {
                logError($lang['errorbindinginput'].$sQuery);
                setSession("GLASQLEXIT", 1);
            } else {
                mysqli_stmt_execute($statement);
                if (!mysqli_stmt_bind_result($statement, $uid, $ulast, $ufirst, $uemail, $uactive, $uadd)) {
                    logError($lang['errorbindingoutput'].$sQuery);
                    setSession("GLASQLEXIT", 1);
                } else {
                    $intCount = 0;
                    while (mysqli_stmt_fetch($statement)) {
                        if ($uactive == 1) {
                            setSession("GLAERRORMESSAGE", "");
                            debugIntoFile ("valid User found that is active");

                            setSession("UID", $uid);
                            setSession("ULAST", $ulast);
                            setSession("UFIRST", $ufirst);
                            setSession("UEMAIL", $uemail);
                            setSession("UADD", $uadd);

                            logIntoFile("user logged in");

                            $intCount = 1;
                        } else {
                            setSession("GLAERRORMESSAGE", $lang['accountdeactivated']);
                            logIntoFile (getSession("GLAERRORMESSAGE").": ".$lang['user']." ".$_POST['EMAIL']);
                            $intCount = 2;
                        }
                    }
                    closePreparedStatement($statement);

                    if (!isSessionEmpty("UID")) {
                        debugIntoFile ("check if user is administrator");
                        $sQuery = "SELECT UID FROM GROUPMEMBER WHERE UID = ".getSession("UID")." AND GID = 1";
                        debugIntoFile($sQuery);
                        $result = getRessource ($sQuery);
                        #logSQLError();

                        $intCount = 0;
                        while ($val = getRow($result)) {
                            $intCount = $intCount + 1;
                        }
                        freeRessource($result);
                        if ($intCount == 1) {
                            setSession("ADMIN", 1);
                        } else {
                            setSession("ADMIN", 0);
                        }

                        if (isset ($_POST['mode'])) {
                            debugIntoFile ("mode is set to=".$_POST['mode']);
                        }

                        if (isset ($_POST['id'])) {
                            debugIntoFile ("id is set to=".$_POST['id']);
                        }

                        # http://80.66.47.92/download/index.php?mode=permission&id=24&reseterror=reseterror


                        if (isset ($_POST['mode']) && ($_POST['mode'] == "permission") && isset ($_POST['id'])) {
                            debugIntoFile ("We do a propper redirect=index.php?mode=permission&id=".$_POST['id']."&reseterror=reseterror");
                            header ("Location: index.php?mode=permission&id=".$_POST['id']."&reseterror=reseterror");
                            #exit;
                        } else {
                            header ("Location: index.php");
                        }




                    } else {
                        debugIntoFile ("check if user has been found.".$intCount);
                        if ($intCount == 0) {
                            #$_SESSION['GLAERRORMESSAGE'] = $lang['userpwdwrong'];
                            setSession("GLAERRORMESSAGE", $lang['userpwdwrong']);
                            logIntoFile (getSession("GLAERRORMESSAGE").": ".$lang['user']." ".$_POST['EMAIL']);
                        }
                        header ("Location: index.php");
                    }
                }
            }
        }
    }
}
?>
