<?php
######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2014
#
# This php contains everything to deal with strings
#
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# v2014-11-28 FPG created the script
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
######################################################################


#---------------------------------------------------------------------
# (c) ds.it@gmx.de: Loescht die nicht erlaubten Zeichen aus dem
#                   uebergebenen String
# $string der zu ueberpruefende String
# $allowed Array der zusaetzlich erlaubten Zeichen
#---------------------------------------------------------------------
function sanitize($string, $allowed = array())    {
    $allow = "";

    if(!empty($allowed)) {
        foreach ($allowed as $value) {
            $allow .= "\\$value";
        }
    }

    if(is_array($string)){
        foreach ($string as $key => $clean) {
            $cleaned[$key] = preg_replace( "/[^{$allow}a-zA-Z0-9]/", "", $clean);
        }
    } else{
        $cleaned = preg_replace( "/[^{$allow}a-zA-Z0-9]/", "", $string );
    }

    return $cleaned;
}
?>
