<?PHP
session_start();

# everything about date and time
include_once "include/session.php";

# everything about date and time
include_once "include/dateandtime.php";

# everything about logging
include_once "include/logging.php";

# everything about database
include_once "include/database.php";

# everything about encryption
include_once "include/encryption.php";

# everything about miscellaneous
include_once "include/misc.php";

# everything about caclulations
include_once "include/calc.php";

# everything about strings
include_once "include/string.php";

# everything about files
include_once "include/files.php";

# icnlude download
include_once "include/download.php";

ini_set('display_errors', '0');
error_reporting(E_ALL);

date_default_timezone_set('Europe/Vienna');
setlocale (LC_TIME, "de_DE");

######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2014
#
# This php file realizes a simple download managaement.
#
#
# (c) www.glawar.at 2014-11-15
#
#
# default user: admin/21232f297a57a5a743894a0e4a801fc3
#
######################################################################
# The standard user is admin with password admin
######################################################################
####  History
#---------------------------------------------------------------------
# v2014-11-15 FPG Project initialized
# v2014-11-16 FPG added better error handling, added layout, added
#                 multiple language support
# v2014-11-30 FPG adapted to master script
# v2014-12-01 FPG got new master include scripts
#                 added update-functionality
# v2014-12-02 FPG tested nearly everything, but not all input methods
#                 are done by prepared statements
# v2014-12-04 FPG added installation support
# v2104-12-06 FPG Added better css-properties and a individual css
#                 possibility to overrule css-properties
# v2014-12-07 FPG adapted to database version 3 (PWDRESET)
#                 login is now by email and password
#                 possibility to reset email
#                 support to add/change groups
#                 support to view groupmembers and usermemers too
#                 added support for sortable tables
# v2014-12-08 FPG adapted layout and added first try to internet
# v2014-12-14 FPG changing filename and filedescriptions is possible now
#                 if user that is no administrator but has right to
#                 add a file does this all administrators will get
#                 an email with a link included to this uploaded file
######################################################################
####  Variables that should be adapted if necessary
$myVersion="2.3";
$nightlyBuild=0;
$SVNRevision=661;
$myVersionDate='2014-12-14';
$databaseMinVersion=5;
####------------------------------------------------------------------
$doBaseInstallation=0;
# read params from configuration-file
$configFile = "conf/download.ini";
if (!file_exists($configFile)) {
    # we have a first installation --> we have to do the installation routine
    # and we have to create a configuration file
    copy("conf/download.ini.template", $configFile);
    $doBaseInstallation = 1;
}

$indivCSSFile="css/myDownload.css";
if (!file_exists($indivCSSFile)) {
    # we have no individual css-file, so we create one with an sample
    # entry
    file_put_contents($indivCSSFile, "/* You can specify your own styles only copy the original version\n", FILE_APPEND | LOCK_EX);
    file_put_contents($indivCSSFile, " * and save it in here. Theses settings will overrule the base\n", FILE_APPEND | LOCK_EX);
    file_put_contents($indivCSSFile, " * stylesheet settings. */\n", FILE_APPEND | LOCK_EX);
}
$iniParams = parse_ini_file($configFile);
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
# 1=no file deletion will be done
$doNoFileDeletion=0;
# params from config-file
$projectName = $iniParams["projectName"];
$projectURL = $iniParams["projectURL"];
$emailAdmin = $iniParams["emailAdmin"];
if (!isset($iniParams["BaseInstallationDone"])) {
    $doBaseInstallation = 1;
} else {
    $doBaseInstallation = 0;
}
$usedb = $iniParams["usedb"];
if (isset($iniParams["sqlHost"])) {
    $sqlHost = $iniParams["sqlHost"];
}
if (isset($iniParams["mySqlDB"])) {
    $mySqlDB = $iniParams["mySqlDB"];
}
if (isset($iniParams["sqlUser"])) {
    $sqlUser = $iniParams["sqlUser"];
}
if (isset($iniParams["sqlPass"])) {
    $sqlPass = $iniParams["sqlPass"];
}
$minLengthUsername = $iniParams["minLengthUsername"];
$minLengthPassword = $iniParams["minLengthPassword"];
$defaultLanguage = $iniParams["defaultLanguage"];
$logtoScreen = $iniParams["logtoScreen"];
$sessionPrefix = $iniParams["sessionPrefix"];
# global connection
$databaseConnection = null;
# overall action switch
$mode = "";
$reseterror = "";
$doLog = $iniParams["doLog"];
$doDebug = $iniParams["doDebug"];
$logFile = $iniParams["logFile"];
# so special characters allowed for username and password
$sanitizeUserPwd = "";
$defaultErrorMsg = "";
$tempError = 0;
$EmailFontSize=14;
######################################################################


# if doDebug is set doLog will be set automatically
if ($doDebug == 1) {
    $doLog = 1;
}

setSession("lang", $defaultLanguage);
include("lang/".getSession("lang").".php");

$defaultErrorMsg=$lang['contactSysadmin'];

if ($myVersionDate == 2) {
    $myVersionDate = "in progress";
}

getDatabaseConnection();

if (!isSessionSet("CheckUpdate")) {
    setSession("CheckUpdate", 1);
}

if ((getSession("CheckUpdate") == 1) && (!isSessionEmpty("ADMIN"))) {
    # do database update
    include "include/download_update.php";
}

if (isset($_POST['mode'])) {
    $mode = $_POST['mode'];
} elseif  (isset($_GET['mode'])) {
    $mode = $_GET['mode'];
}

if (isset($_POST['reseterror'])) {
    $reseterror = $_POST['reseterror'];
} elseif  (isset($_GET['reseterror'])) {
    $reseterror = $_GET['reseterror'];
}

#debugIntoFile ("Parameters from conf/download.ini");
#debugIntoFile ("projectName = ".$projectName);
#debugIntoFile ("appUrl      = ".$appUrl);
#debugIntoFile ("usedb       = ".$usedb);
#debugIntoFile ("sqlHost     = ".$sqlHost);
#debugIntoFile ("mySqlDB     = ".$mySqlDB);
#debugIntoFile ("sqlUser     = ".$sqlUser);
#debugIntoFile ("sqlPass     = ".$sqlPass);
#debugIntoFile ("coded admin = ".transformPwd('admin'));
#debugIntoFile ("guid        = ".GUID());
debugIntoFile("LoggedInUserId=".getSession("UID"));
?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN">
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <link rel="stylesheet" type="text/css" href="css/download.css">
        <link rel="stylesheet" type="text/css" href="css/myDownload.css">
        <script language="JavaScript" type="text/javascript" src="js/common.js"></script>
        <script language="JavaScript" type="text/javascript" src="js/checkemail.js"></script>
        <script language="JavaScript" type="text/javascript" src="js/checkforms.js"></script>
        <script language="JavaScript" type="text/javascript" src="js/TableSort.js"></script>
        <title>
            <?php echo $projectName; ?>
        </title>
    </head>

    <body>
        <div id="header">
            <table class=menutable>
                <tr>
                    <th>
                        <?php echo $projectName; ?>
                    </th>
                </tr>
                <tr>
                    <td>
                        <?php
                        $allowedLinkClass="menulink";
                        $notAllowedLinkClass="menulinkDeactivated";
                        $linkClassUsed=$allowedLinkClass;

                        if (!isSessionEmpty("UID")) {
                            $linkClassUsed=$allowedLinkClass;
                        } else {
                            $linkClassUsed=$notAllowedLinkClass;
                        }
                        echo "<a href=\"index.php?reseterror=reseterror\" class=".$linkClassUsed.">".$lang['listfiles']."</a>";

                        if ( !isSessionEmpty("UADD") && (getSession("UADD") == 1)) {
                            $linkClassUsed=$allowedLinkClass;
                        } else {
                            $linkClassUsed=$notAllowedLinkClass;
                        }
                        echo "<a href=\"?mode=addentry&reseterror=reseterror\" class=".$linkClassUsed.">".$lang['addnewfile']."</a>";

                        if (!isSessionEmpty("ADMIN") && (getSession("ADMIN") == 1)) {
                            $linkClassUsed=$allowedLinkClass;
                        } else {
                            $linkClassUsed=$notAllowedLinkClass;
                        }
                        echo "<a href=\"?mode=users&reseterror=reseterror\" class=".$linkClassUsed.">".$lang['showusers']."</a>";
                        echo "<a href=\"?mode=modifyuser&reseterror=reseterror\" class=".$linkClassUsed.">".$lang['adduser']."</a>";
                        echo "<a href=\"?mode=groups&reseterror=reseterror\" class=".$linkClassUsed.">".$lang['showgroups']."</a>";
                        echo "<a href=\"?mode=modifygroup&reseterror=reseterror\" class=".$linkClassUsed.">".$lang['addgroup']."</a>";

                        if (!isSessionEmpty("UID")) {
                            $linkClassUsed=$allowedLinkClass;
                        } else {
                            $linkClassUsed=$notAllowedLinkClass;
                        }
                        echo "<a href=\"?mode=changeperson&reseterror=reseterror\" class=".$linkClassUsed.">".$lang['myData']."</a>";
                        echo "<a href=\"?mode=changepwd&reseterror=reseterror\" class=".$linkClassUsed.">".$lang['changepassword']."</a>";
                        echo "<a href=\"?mode=logout&reseterror=reseterror\" class=".$linkClassUsed.">".$lang['logout']."</a>";

                        echo "<a href=\"index.php?mode=email&reseterror=reseterror\" class=menulink>".$lang['contact']."</a>";
                        ?>
                    </td>
                </tr>
            </table>
        </div>
<?php

if ($doBaseInstallation == 0) {
    # remove the installation file if it exists
    if ($doNoFileDeletion == 0) {
        deleteFileIfExists("install.php");
    }

    if ($reseterror == "reseterror") {
        debugIntoFile ("resetting Session GLAERRORMESSAGE");
        setSession("GLAERRORMESSAGE", "");
    }

    if (isSessionEmpty("UID")) {
        debugIntoFile ("no user is logged in");
        if (!empty($_POST['EMAIL']) && !empty($_POST['PASS']) ) {
            debugIntoFile ("email and password are set so we check if they match to a valid user");
            include "include/download_login.php";
        } else {
            debugIntoFile ("still no user is logged in");
            if ($mode == "fpwd") {
                debugIntoFile ("showing password reset");
                ?>
                <div class=passwordresetspace>&nbsp;</div>
                <div align=center>
                    <div class=myCaption><?php echo $lang['resetpassword']; ?></div>
                    <form name=resetpwdform method="post" action="<?php echo $_SERVER['PHP_SELF'];?>">
                        <input type=hidden name=resetpwd value=1>
                        <table class=passwordresettable>
                            <tr>
                                <td>
                                    <?php echo $lang['email']; ?>
                                </td>
                                <td>
                                    <input class='loginInput' type='text' name='EMAIL'>
                                </td>
                            </tr>
                            <tr>
                                <td colspan=2>
                                    <input type='submit' class=resetPwdButton value='<?php echo $lang['sendresetpwd']; ?>' onclick='return(checkEmail(document.resetpwdform.EMAIL.value, false, "<?php echo getSession("lang"); ?>"));'>
                                </td>
                            </tr>
                        </table>
                    </form>
                    <div>&nbsp;</div>
                        <a href="index.php"><?php echo $lang['back']; ?></a>
                </div>
                <?php
            } else if ($mode == "doresetpwd") {
                debugIntoFile ("We are doing the realy password reset");
                debugIntofile ("pid=".$_GET['pid']);
                debugIntofile ("uid=".$_GET['uid']);
                $resetUserWithUid=0;
                $sQuery = "SELECT UID FROM PWDRESET WHERE PID = ? AND UID = ?";
                $defaultErrorMsg=$lang['contactSysadmin'];
                $statement = mysqli_prepare($databaseConnection, $sQuery);
                setSession("GLASQLEXIT", logSQLError($sQuery));

                if (withoutSQLError()) {
                    if (!mysqli_stmt_bind_param($statement, "si", $_GET['pid'], $_GET['uid'])) {
                        setSession("GLASQLEXIT", logSQLErrorManual("Error binding input params with sql-statement: ".$sQuery));
                    } else {
                        mysqli_stmt_execute($statement);
                        if (!mysqli_stmt_bind_result($statement, $resetUserWithUid)) {
                            setSession("GLASQLEXIT", logSQLErrorManual("Error binding output params with sql-statement: ".$sQuery));
                        } else {
                            while (mysqli_stmt_fetch($statement)) {
                                debugIntoFile ("resetUserWithUid=".$resetUserWithUid);
                            }
                        }
                    }
                }
                closePreparedStatement($statement);
                if ($resetUserWithUid != 0) {
                    debugIntoFile ("We are doing password reset for userId=".$resetUserWithUid);
                    ?>
                    <center>
                        <form method="post" action="<?php echo $_SERVER['PHP_SELF'];?>">
                            <input type=hidden name=doresetpwdfromlink value='<?php echo $resetUserWithUid; ?>'>
                            <table class=formtable>
                                <tr>
                                    <td>
                                        <label for='pass'><?php echo $lang['newpassword']; ?></label>
                                    </td>
                                    <td>
                                        <input class='changepasswordInput' type='password' name='PASS1'>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for='pass'><?php echo $lang['retypepwd']; ?></label>
                                    </td>
                                    <td>
                                        <input class='changepasswordInput' type='password' name='PASS2'>
                                    </td>
                                </tr>
                                <tr>
                                    <td></td>
                                    <td>
                                        <input type='submit' class=changePasswordButton name='changepwd' value='<?php echo $lang['changepassword']; ?>'>
                                    </td>
                                </tr>
                            </table>
                        </form>
                    </center>
                    <?php
                } else {
                    debugIntoFile ("No anforderung for password reset found");
                    header ("Location: index.php");
                }
            } else if (isset($_POST['changepwd'])) {
                debugIntoFile ("do the database reset in the database");
                include "include/download_changepwd.php";
            } else if ($mode == "email") {
                debugIntoFile ("we show the contact form");
                include "include/download_contact.php";
            } else {
                debugIntoFile ("still no user is still logged in");
                if (!empty($_POST['resetpwd']) && !empty($_POST['resetpwd']) ) {
                    debugIntoFile ("We are doing the password reset");
                    include "include/download_pwdreset.php";
                    header ("Location: index.php");
                } else {
                    debugIntoFile ("We are showing the login page because we do not know what else to do");
                    ?>
                    <div class=loginscpace>&nbsp;</div>
                    <div align=center>
                        <form method="post" action="<?php echo $_SERVER['PHP_SELF'];?>">

                            <input type=hidden name=mode value='<?php echo $_GET['mode'];?>' >
                            <input type=hidden name=id value='<?php echo $_GET['id'];?>' >


                            <table class=logintable>
                                <tr>
                                    <td>
                                        <?php echo $lang['email']; ?>
                                    </td>
                                    <td>
                                        <input class='loginInput' type='text' name='EMAIL'>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <?php echo $lang['password']; ?>
                                    </td>
                                    <td>
                                        <input class='loginInput' type='password' name='PASS'>
                                    </td>
                                </tr>
                                <tr>
                                    <td></td>
                                    <td >
                                        <input type='submit' class=loginButton value='<?php echo $lang['login']; ?>'>
                                    </td>
                                </tr>
                            </table>
                        </form>
                        <div>&nbsp;</div>
                        <a href="index.php?mode=fpwd"><?php echo $lang['passwordforgotten']; ?></a>
                    </div>
                    <?php
                }
            }
        }
    } else {
        debugIntoFile ("we have an user that is logged in");
        #echo "<h2>Benutzer ist angemeldet</h2>";

        if ($mode == "logout") {
            logIntoFile ("user has choosen logged out");

            unsetSession("GLAERRORMESSAGE");
            unsetSession("GLASQLEXIT");
            unsetSession("UID");
            unsetSession("ULAST");
            unsetSession("UFIRST");
            unsetSession("UEMAIL");
            unsetSession("ADMIN");
            unsetSession("UADD");
            unsetSession("CheckUpdate");

            session_unset();
            session_destroy();
            header("Location: index.php");
        } else if ($mode == "changepwd") {
            debugIntoFile("form change password is shown");
            echo "<div class=myCaption>".$lang['changepassword']."</div>";
            ?>
            <form method="post" action="<?php echo $_SERVER['PHP_SELF'];?>">
                <table class=formtable>
                    <tr>
                        <td>
                            <label for='pass'><?php echo $lang['newpassword']; ?></label>
                        </td>
                        <td>
                            <input class='changepasswordInput' type='password' name='PASS1'>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <label for='pass'><?php echo $lang['retypepwd']; ?></label>
                        </td>
                        <td>
                            <input class='changepasswordInput' type='password' name='PASS2'>
                        </td>
                    </tr>
                    <tr>
                        <td></td>
                        <td>
                            <input type='submit' class=changePasswordButton name='changepwd' value='<?php echo $lang['changepassword']; ?>'>
                        </td>
                    </tr>
                </table>
            </form>
            <?php
        } else if ($mode == "changeperson") {
            debugIntoFile("form change my data");
            echo "<div class=myCaption>".$lang['myData']."</div>";
            ?>
            <form name=changemydataform method="post" action="<?php echo $_SERVER['PHP_SELF'];?>">
                <table class=formtable>
                    <tr>
                        <td>
                            <label for='pass'><?php echo $lang['lastname']; ?></label>
                        </td>
                        <td>
                            <input class='changepasswordInput' type='text' name='FANA' value='<?php echo getSession("ULAST"); ?>'>
                        </td>
                    </tr>
                     <tr>
                        <td>
                            <label for='pass'><?php echo $lang['firstname']; ?></label>
                        </td>
                        <td>
                            <input class='changepasswordInput' type='text' name='VONA' value='<?php echo getSession("UFIRST"); ?>'>
                        </td>
                    </tr>
                     <tr>
                        <td>
                            <label for='pass'><?php echo $lang['email']; ?></label>
                        </td>
                        <td>
                            <input class='changepasswordInput' type='text' name='EMAIL' value='<?php echo getSession("UEMAIL"); ?>'>
                        </td>
                    </tr>
                    <tr>
                        <td></td>
                        <td>
                            <input type='submit' class=changePasswordButton name='changemydata' value='<?php echo $lang['changemydata']; ?>' onclick='return(checkChangeMyData(document.changemydataform.FANA.value, document.changemydataform.VONA.value, document.changemydataform.EMAIL.value, false, "<?php echo getSession("lang"); ?>"));'>
                        </td>
                    </tr>
                </table>
            </form>
            <?php
        } else if ($mode == "addentry") {
            debugIntoFile("Form for adding an entry");
            if ( !isSessionEmpty("UADD") && (getSession("UADD") == 1)) {
                debugIntoFile("but only if user is allowed to add files or if logged in user is administrator");
                echo "<div class=myCaption>".$lang['addnewfile']."</div>";

                ini_set('max_execution_time', 300); //300 seconds = 5 minutes
                ?>
                <form name=addfileform method="post" enctype="multipart/form-data" action="<?php echo $_SERVER['PHP_SELF'];?>">
                    <input type="hidden" name="MAX_FILE_SIZE" value="<?php echo return_bytes(ini_get('post_max_size')); ?>" />
                    <table class=formtable>
                        <tr>
                            <td>
                                <?php echo $lang['upload']; ?> (*) max. <?php echo ini_get('upload_max_filesize'); ?>
                            </td>
                            <td>
                                <input type="file" name="datei">
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <?php echo $lang['filename']; ?> (*)
                            </td>
                            <td>
                                <input class='fileInput' type='text' name='FILENAME'>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <?php echo $lang['filedescription']; ?>
                            </td>
                            <td>
                                <textarea name="FILEDESCRIPTION" class=fileInputArea rows=3></textarea>
                            </td>
                        </tr>
                        <tr>
                            <td></td>
                            <td>
                                <input type='submit' class=uploadButton name='addentry' value='<?php echo $lang['upload']; ?>' onclick='return(checkAddNewFileForm(document.addfileform.datei.value, document.addfileform.FILENAME.value, "<?php echo getSession("lang"); ?>"));'>
                            </td>
                        </tr>
                    </table>
                </form>
                <?php
            } else {
                echo "<div class=hintmessage>".$lang['notenoughpermission']."</div>";
            }
        } else if ($mode == "modifyuser") {
            debugIntoFile("Form for changing an user");
            if ( !isSessionEmpty("ADMIN") && (getSession("ADMIN") == 1)) {
                debugIntoFile("but only if user is administrator");
                $type = "NEW";
                $activeChecked = " checked";
                $addChecked = " ";
                $uid = 1;
                $titleText = $lang['adduser'];
                $buttonClick = $lang['adduser'];
                if (isset($_GET['id'])) {
                    $titleText =  $lang['updateuser'];
                    $buttonClick = $lang['updateuser'];
                    $uid = $_GET['id'];
                    $type = "CHANGE";
                    if  (!$_GET['active'] == "1") {
                        $activeChecked = " ";
                    }
                    if  ($_GET['add'] == "1") {
                        $addChecked = " checked";
                    }
                    $lname = $_GET['lname'];
                    $fname = $_GET['fname'];
                    $email = $_GET['email'];
                } else {
                    $uid = 0;
                    $lname = "";
                    $fname = "";
                    $email = "";
                }
                echo "<div class=myCaption>".$titleText."</div>";
                ?>
                <form name="usermanipulation" method="post" action="<?php echo $_SERVER['PHP_SELF'];?>">
                    <input type='hidden' name='TYPE' value='<?php echo $type; ?>'>
                    <input type='hidden' name='UID' value='<?php echo $uid; ?>'>
                    <table class=formtable>
                        <tr>
                            <td>
                                <?php echo $lang['lastname']; ?> (*)
                            </td>
                            <td>
                                <input class='manageUserInput' type='text' name='LASTNAME' value='<?php echo $lname; ?>'>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <?php echo $lang['firstname']; ?> (*)
                            </td>
                            <td>
                                <input class='manageUserInput' type='text' name='FIRSTNAME' value='<?php echo $fname; ?>'>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <?php echo $lang['email']; ?> (*)
                            </td>
                            <td>
                                <input class='manageUserInput' type='text' name='EMAIL' value='<?php echo $email; ?>'>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <?php echo $lang['password']; ?>
                            </td>
                            <td>
                                <input class='manageUserInput' type='text' name='PASSWORD'>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <?php echo $lang['active']; ?>
                            </td>
                            <td>
                                <input name="ACTIVE" type="checkbox" <?php echo $activeChecked; ?>>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <?php echo $lang['allowedtoaddfiles']; ?>
                            </td>
                            <td>
                                <input name="ADD" type="checkbox" <?php echo $addChecked; ?>>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <?php echo $lang['group']; ?>
                            </td>
                            <td>

                        <?php
                        $sQuery = "SELECT GID, GNAME FROM `GROUP`ORDER BY GNAME";
                        $result = getRessource ($sQuery);
                        #logSQLError();

                        echo "<form method='post' action='".$_SERVER['PHP_SELF']."'>";
                        echo "<table border='0'>";
                        echo "<tr>";
                        echo "<td>";
                        echo "<select name=\"selectgroup[]\" size=\"7\" multiple=\"multiple\" tabindex=\"1\" width=50>";

                        while ($val = getRow($result)) {
                            if (isGroupMemberUser ($uid, $val['GID'])) {
                                $Member = " selected";
                            } else {
                                $Member = " ";
                            }

                            echo "<option value=\"".$val['GID']."\"".$Member.">".$val['GNAME']."</option>";
                        }
                        freeRessource($result);
                        echo "</select>";

                        ?>
                        </td>
                        </tr>
                        <tr>
                            <td colspan='2' aling=left>
                                <input type='submit' class=addUserButton name='manageuser' value='<?php echo $buttonClick; ?>' onclick='return(checkChangeMyData(document.usermanipulation.LASTNAME.value, document.usermanipulation.FIRSTNAME.value, document.usermanipulation.EMAIL.value, "<?php echo getSession("lang"); ?>"));'>
                            </td>
                        </tr>
                    </table>
                    </td>
                    </table>
                </form>
                <?php
            } else {
                echo "<div class=hintmessage>".$lang['notenoughpermission']."</div>";
            }
        } else if ($mode == "modifygroup") {
            debugIntoFile("Form for adding a group entry");
            if ( !isSessionEmpty("ADMIN") && (getSession("ADMIN") == 1)) {
                debugIntoFile("but only if logged in user is administrator");
                $type = "NEW";
                $gid = 1;
                $titleText = $lang['addgroup'];
                $buttonClick = $lang['addgroup'];
                if (isset($_GET['id'])) {
                    $type = "UPDATE";
                    $titleText =  $lang['updategroup'];
                    $buttonClick = $lang['updategroup'];
                    $gid = $_GET['id'];
                    $group = $_GET['group'];
                } else {
                    $gid = 0;
                    $group = "";
                }
                echo "<div class=myCaption>".$titleText."</div>";
                ?>
                <form name="groupmanipulation" method="post" action="<?php echo $_SERVER['PHP_SELF'];?>">
                    <input type='hidden' name='TYPE' value='<?php echo $type; ?>'>
                    <input type='hidden' name='GID' value='<?php echo $gid; ?>'>
                    <table class=formtable>
                        <tr>
                            <td>
                                <?php echo $lang['group']; ?>
                            </td>
                            <td>
                                <input class='manageUserInput' type='text' name='GROUP' value='<?php echo $group; ?>'>
                            </td>
                        </tr>
                        <tr>
                            <td colspan='2' aling=left>
                                <input type='submit' class=addUserButton name='managegroup' value='<?php echo $buttonClick; ?>' onclick='return(checkFormGroup(document.groupmanipulation.GROUP.value, "<?php echo getSession("lang"); ?>"));'>
                            </td>
                        </tr>
                    </table>
                    </td>
                    </table>
                </form>
                <?php
            } else {
                echo "<div class=hintmessage>".$lang['notenoughpermission']."</div>";
            }
        } else if ($mode == "users") {
            debugIntoFile("listing the users");
            #SELECT `GROUP`.GNAME FROM GROUPMEMBER, `GROUP` WHERE GROUPMEMBER.GID = `GROUP`.GID AND GROUPMEMBER.UID = 65 ORDER BY `GROUP`.GNAME
            if ( !isSessionEmpty("ADMIN") && (getSession("ADMIN") == 1)) {
                $defaultErrorMsg=$lang['contactSysadmin'];
                debugIntoFile("but only if logged in user is administrator");
                echo "<div class=myCaption>".$lang['showusers']."</div>";
                echo "<center>";

                debugIntoFile("Display Users");
                $sQuery = "SELECT UID, UPWD, ULAST, UFIRST, UEMAIL, UACTIVE, UADD, UCREATED, UMODIFIED FROM USER ORDER BY ULAST";
                debugIntoFile("User-Select=".$sQuery);
                $result = getRessource ($sQuery);
                #logSQLError();

                echo "<table class='sortierbar usertable'>";
                echo "<thead>";
                echo "<tr>";
                echo "<th>".$lang['lastname']."</th>";
                echo "<th>".$lang['firstname']."</th>";
                echo "<th>".$lang['email']."</th>";
                echo "<th>".$lang['groupmembers']."</th>";
                echo "<th>".$lang['active2']."</th>";
                echo "<th>".$lang['allowedtoaddfiles2']."</th>";
                echo "<th>".$lang['created']."</th>";
                echo "<th>".$lang['modified']."</th>";
                echo "</tr>";
                echo "</thead><tbody>";
                while ($val = getRow($result)) {
                    echo "<tr>";
                    echo "<td><a href=\"?mode=modifyuser&id=".$val['UID']."&lname=".$val['ULAST']."&fname=".$val['UFIRST']."&email=".$val['UEMAIL']."&active=".$val['UACTIVE']."&add=".$val['UADD']."\">".$val['ULAST']."</a></td>";
                    echo "<td>".$val['UFIRST']."</td>";
                    echo "<td>".$val['UEMAIL']."</td>";
                    echo "<td>".getGroupsForUser($val['UID'])."</td>";
                    echo "<td>".$val['UACTIVE']."</td>";
                    echo "<td>".$val['UADD']."</td>";
                    echo "<td>".$val['UCREATED']."</td>";
                    echo "<td>".$val['UMODIFIED']."</td>";
                    echo "</tr>";
                }
                echo "</tbody>";
                echo "</table>";
                freeRessource($result);
                echo "</center>";
            } else {
                echo "<div class=hintmessage>".$lang['notenoughpermission']."</div>";
            }
        } else if ($mode == "groups") {
            debugIntoFile("list the groups");
            if ( !isSessionEmpty("ADMIN") && (getSession("ADMIN") == 1)) {
                debugIntoFile("but only if logged in user is administrator");
                echo "<div class=myCaption>".$lang['showgroups']."</div>";
                #echo "<center>";

                debugIntoFile("Display Users");
                $sQuery = "SELECT GID, GNAME FROM `GROUP` ORDER BY GNAME";
                debugIntoFile("Group-Select=".$sQuery);
                $defaultErrorMsg=$lang['contactSysadmin'];
                $result = getRessource ($sQuery);
                #logSQLError();

                echo "<table class=usertable>";
                echo "<tr>";
                echo "<th>".$lang['group']."</th>";
                echo "<th>".$lang['user']."</th>";
                echo "</tr>";
                while ($val = getRow($result)) {
                    echo "<tr>";
                    echo "<td><a href=\"?mode=modifygroup&id=".$val['GID']."&group=".$val['GNAME']."\">".$val['GNAME']."</a></td>";
                    echo "<td>".getUsersForGroup($val['GID'])."</td>";
                    echo "</tr>";
                }
                echo "</table>";
                freeRessource($result);
                #echo "</center>";
            } else {
                echo "<div class=hintmessage>".$lang['notenoughpermission']."</div>";
            }
        } else if ($mode == "permission") {
            debugIntoFile("Form for chaning file permissions");
            if ( !isSessionEmpty("ADMIN") && (getSession("ADMIN") == 1)) {
                $defaultErrorMsg=$lang['contactSysadmin'];
                setSession("GLAERRORMESSAGE", "");

                $sQuery = "SELECT FFILE, FNAME, FDESC FROM FILE WHERE FID = ?";
                $statement = mysqli_prepare($databaseConnection, $sQuery);
                setSession("GLASQLEXIT", logSQLError($sQuery));
                $id = $_GET['id'];
                if (withoutSQLError()) {
                    if (!mysqli_stmt_bind_param($statement, "i", $id)) {
                        setSession("GLASQLEXIT", logSQLErrorManual("Error binding input params with sql-statement: ".$sQuery));
                    } else {
                        mysqli_stmt_execute($statement);
                        if (!mysqli_stmt_bind_result($statement, $pffile, $pfname, $pfdesc)) {
                            setSession("GLASQLEXIT", logSQLErrorManual("Error binding output params with sql-statement: ".$sQuery));
                        } else {
                            while (mysqli_stmt_fetch($statement)) {
                                #echo "<div>opentry/opdate: ".$opentry."/".$opdate."</div>";
                            }
                        }
                    }
                }
                closePreparedStatement($statement);

                debugIntoFile("but only if logged in user is administrator");
                echo "<div class=myCaption>".$lang['changepermission']."</div>";

                $sQuery = "SELECT GID, GNAME FROM `GROUP` ORDER BY GNAME";
                $result = getRessource ($sQuery);
                #logSQLError();

                echo "<form name=changepermission method='post' action='".$_SERVER['PHP_SELF']."'>";
                echo "<input type='hidden' name='FID' value='".$_GET['id']."'>";
                echo "<table class=formtable>";


                echo "<tr>";
                echo "<td>";




                echo $lang['filename']." (*)<a href=\"data/".$pffile."\"  target=\"_blank\"><img src='images/arrow-24x24.png' width=24 height=24 alt=goto></a>";
                echo "</td>";
                echo "<td colspan=3>";
                echo "<input class='fileInput' type='text' name='FILENAME' value='".$pfname."'>";
                echo "</td>";
                echo "</tr>";
                echo "<tr>";
                echo "<td>";
                echo $lang['filedescription'];
                echo "</td>";
                echo "<td colspan=3>";
                echo "<textarea name='FILEDESCRIPTION' class=fileInputArea rows=3>".$pfdesc."</textarea>";
                echo "</td>";
                echo "</tr>";


                echo "<tr>";
                echo "<td>";
                echo "<label for='group'>".$lang['group']."</label>";
                echo "</td>";
                echo "<td>";
                echo "<select name=\"selectgroup[]\" size=\"15\" multiple=\"multiple\" tabindex=\"1\">";

                while ($val = getRow($result)) {
                    if (isGroupMember ($_GET['id'], $val['GID'])) {
                        $Member = " selected";
                    } else {
                        $Member = " ";
                    }

                    echo "<option value=\"".$val['GID']."\"".$Member.">".$val['GNAME']."</option>";
                }
                freeRessource($result);
                echo "</select>";

                echo "<td>";
                echo "<label for='user'>".$lang['showusers']."</label>";
                echo "</td>";
                echo "<td>";
                echo "<select name=\"selectuser[]\" size=\"15\" multiple=\"multiple\" tabindex=\"1\">";

                $sQuery = "SELECT UID, UFIRST, ULAST, UEMAIL FROM USER ORDER BY ULAST";
                $result = getRessource ($sQuery);
                logSQLError();

                while ($val = getRow($result)) {
                    if (isUserMember ($_GET['id'], $val['UID'])) {
                        $Member = " selected";
                    } else {
                        $Member = " ";
                    }

                    echo "<option value=\"".$val['UID']."\"".$Member.">".$val['ULAST']." (".$val['UFIRST'].", ".$val['UEMAIL'].")</option>";
                }
                freeRessource($result);
                echo "</select>";

                echo "</td>";
                echo "</tr>";
                echo "<tr>";
                echo "<td colspan='4'>";
                echo "<input type='submit' class=permissionButton name='savepermission' value='".$lang['save']."' onclick='return(checkFormChangePermission(document.changepermission.FILENAME.value, \"".getSession("lang")."\"));'>";

                echo "</td>";
                echo "</tr>";
                echo "</table>";
                echo "</form>";
            }
        } else if ($mode == "email") {
            debugIntoFile ("we show the contact form");
            include "include/download_contact.php";
        } else {
            debugIntoFile("user is logged in but only action will take place and listing of allowed files");
            if (isset($_POST['addentry'])) {
                debugIntoFile("We will add a file");
                include "include/download_files.php";
            } else if (isset($_POST['savepermission'])) {
                debugIntoFile("We change Permissions");
                include "include/download_filepermissions.php";
            } else if (isset($_POST['changepwd'])) {
                include "include/download_changepwd.php";
            } else if (isset($_POST['changemydata'])) {
                include "include/download_changemydata.php";
            } else if (isset($_POST['manageuser'])) {
                debugIntoFile("We manage the user");
                include "include/download_manageuser.php";
            } else if (isset($_POST['managegroup'])) {
                debugIntoFile("We manage the group");
                include "include/download_managegroup.php";
            } else if (isset($_POST['emailcontact'])) {
                debugIntoFile("We manage the contact email");
                include "include/download_email.php";
            }

            #setSession("GLAERRORMESSAGE", "");

            # display standard
            #echo displayErrorMessage();
            echo "<div class=myCaption>".$lang['availablefile']."</div>";
            if (getSession("ADMIN") == 1) {
                $sQuery = "SELECT FID, FFILE, FNAME, FDESC, FDATE, FSIZE FROM FILE ORDER BY FDATE DESC";
            } else {
                $sQuery = "SELECT FILE.FID, FILE.FFILE, FILE.FNAME, FILE.FDESC, FILE.FDATE, FILE.FSIZE FROM FILE, FILEGROUP, `GROUP`, GROUPMEMBER WHERE FILEGROUP.FID = FILE.FID AND GROUP.GID = FILEGROUP.GID AND GROUPMEMBER.GID = GROUP.GID AND GROUPMEMBER.UID = ".getSession("UID")." UNION SELECT FILE.FID, FILE.FFILE, FILE.FNAME, FILE.FDESC, FILE.FDATE, FILE.FSIZE FROM FILE, FILEUSER WHERE FILEUSER.FID = FILE.FID AND FILEUSER.UID = ".getSession("UID")."  ORDER BY 5 DESC";
            }
            debugIntoFile("File-View-Select=".$sQuery);
            $result = getRessource ($sQuery);
            #logSQLError();
            echo "<table class='sortierbar filetable'>";
            echo "<thead>";
            echo "<tr>";
            if ( !isSessionEmpty("ADMIN") && (getSession("ADMIN") == 1)) {
                echo "<th>&nbsp;</th>";
            }
            echo "<th>".$lang['filename']."</th>";
            echo "<th>".$lang['filedescription']."</th>";
            echo "<th>".$lang['filesize']."</th>";
            echo "<th>".$lang['date']."</th>";
            echo "</tr>";
            echo "</thead><tbody>";
            while ($val = getRow($result)) {
                echo "<tr>";
               if ( !isSessionEmpty("ADMIN") && (getSession("ADMIN") == 1)) {
                    echo "<td class=action><a href=\"?mode=permission&id=".$val['FID']."&reseterror=reseterror\"><img src='images/change-24x24.png' width=24 height=24 alt=modify></a></td>";

                }
                echo "<td class=filename><a href=\"data/".$val['FFILE']."\"  target=\"_blank\">".$val['FNAME']."</a></td>";
                echo "<td class=filedescription>".$val['FDESC']."&nbsp;</td>";
                echo "<td class=filesize>".number_format($val['FSIZE'],0,'.','.')."</td>";
                echo "<td class=filedate>".$val['FDATE']."</td>";
                echo "</tr>";
            }
            ?>
            </tbody>
            </table>
            <?php
            freeRessource($result);
        }
    }

    debugIntoFile ("closing database connection");
    closeDatabaseConnection();
} else {
    debugIntoFile ("We do the base installation");
    echo "<div class=installationspace>&nbsp;</div>";
    echo "<div align=center class=myCaption><a href=install.php>".$lang['notinstalledbasenecessary']."</a></div>";
}

if ($logtoScreen == 1) {
    debugIntoFile ("we log the debug on the screen");
    echo "<div class=debugspace>&nbsp;</div>";
    echo "<div class=loggingcaption>".$lang['logtoscreen']."</div>";

    echo getSession("GLALOGDISPLAY");
    setSession("GLALOGDISPLAY", "");
}

?>

        <div id="footer">
            <table border=0 width=99% height=100%>
                <tr>
                    <td width=* align=left valign=top>
                        <span class=error><?php echo getSession("GLAERRORMESSAGE");?></span>
                    </td>
                    <td width=500px align=right valign=top>
                        <?php

                            $tempStr = "<span class=footertext>&copy; 2014 by <a href=http://software.glawar.at/downloadmanager target=_blank class=footerlink>software.glawar.at</a> v";
                            $tempStr .= $myVersion.".".$SVNRevision;

                            if ($nightlyBuild == 0) {
                                $tempStr .= " (".$myVersionDate.")";
                            } else {
                                $tempStr .= " (nightly build)";
                            }
                            $tempStr .= "</span>";

                            echo $tempStr;
                        ?>
                    </td>
                </tr>
            </table>
        </div>

    </body>
</html>
