<?PHP
session_start();

# include system
include_once "include/system.php";

# everything about date and time
include_once "include/session.php";

# everything about date and time
include_once "include/dateandtime.php";

# everything about logging
include_once "include/logging.php";

# everything about database
include_once "include/database.php";

# everything about encryption
include_once "include/encryption.php";

# everything about miscellaneous
include_once "include/misc.php";

# everything about caclulations
include_once "include/calc.php";

# everything about strings
include_once "include/string.php";

# everything about files
include_once "include/files.php";

# include download
include_once "include/download.php";

ini_set('display_errors', '1');
error_reporting(E_ALL);

date_default_timezone_set('Europe/Vienna');
setlocale (LC_TIME, "de_DE");

######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2014
#
# This php file does a simple download.
#
#
# (c) www.glawar.at
#
#
######################################################################
# The standard user is admin with password admin
######################################################################
####  History
#---------------------------------------------------------------------
# v2014-12-17 FPG created the script
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
$configFile = "conf/download.ini";
$iniParams = parse_ini_file($configFile);
$sessionPrefix = $iniParams["sessionPrefix"];
$projectName = $iniParams["projectName"];
$usedb = $iniParams["usedb"];
if (isset($iniParams["sqlHost"])) {
    $sqlHost = $iniParams["sqlHost"];
}
if (isset($iniParams["mySqlDB"])) {
    $mySqlDB = $iniParams["mySqlDB"];
}
if (isset($iniParams["sqlUser"])) {
    $sqlUser = $iniParams["sqlUser"];
}
if (isset($iniParams["sqlPass"])) {
    $sqlPass = $iniParams["sqlPass"];
}
####-----------------------------------------------------------------
$logPrefix = "download.php - ";
$logFile = getSession("logFile");
$doLog = getSession("doLog");
$doDebug = getSession("doDebug");
$databaseConnection = null;
$fid=0;
$file="";
$filename="";
$sanitizeFileName="abcdefghijklmnopqrstuvwxyz";
######################################################################

# include language
include_once ("lang/".getSession("lang").".php");


if ( isSessionEmpty("UID") || !isset ($_GET['fileid']) ) { ?>
    <html>
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <link rel="stylesheet" type="text/css" href="css/download.css">
            <link rel="stylesheet" type="text/css" href="css/myDownload.css">
            <title>
                <?php echo $projectName; ?>
            </title>
        </head>

        <body>
            <div class=nopermission><?php echo $lang['nopermission']; ?></div>
        </body>
    </html>
<?php } else {
    debugIntoFile($logPrefix."we will download file with id=".$_GET['fileid']);
    getDatabaseConnection();
    if (withoutSQLError()) {
        if (getSession("ADMIN") == 1) {
            $sQuery = "SELECT FID, FFILE, FNAME FROM ".getDBTablePrefix()."FILE WHERE FID = ?";
        } else {
            $sQuery = "SELECT FID, FFILE, FNAME, UID FROM FILEFULLVIEW WHERE FID = ? AND UID = ?";
        }
        debugIntoFile ($logPrefix."we have build select-statement=".$sQuery);
        $statement = mysqli_prepare($databaseConnection, $sQuery);
        if (withoutSQLError()) {
            if (getSession("ADMIN") == 1) {
                if (mysqli_stmt_bind_param($statement, "i", $_GET['fileid'])) {
                    mysqli_stmt_execute($statement);
                    if (mysqli_stmt_bind_result($statement, $fid, $file, $filename)) {
                        while (mysqli_stmt_fetch($statement)) {
                            debugIntoFile ($logPrefix."found fid/file/filename=".$fid."/".$file."/".$filename);
                        }
                    } else {
                        logIntoFile ($logPrefix."we have a problem with binding output params");
                    }
                } else {
                    logIntoFile ($logPrefix."we have a problem with binding input params");
                }
            } else {
                $a = getSession("UID");
                if (mysqli_stmt_bind_param($statement, "ii", $_GET['fileid'], $a)) {
                    mysqli_stmt_execute($statement);
                    if (mysqli_stmt_bind_result($statement, $fid, $file, $filename, $uid)) {
                        while (mysqli_stmt_fetch($statement)) {
                            debugIntoFile ($logPrefix."found fid/file/filename=".$fid."/".$file."/".$filename);
                        }
                    } else {
                        logIntoFile ($logPrefix."we have a problem with binding output params");
                    }
                } else {
                    logIntoFile ($logPrefix."we have a problem with binding input params");
                }
            }

            closePreparedStatement($statement);
        } else {
            logIntoFile ($logPrefix."we have a problem with sql-statement=".$sQuery);
        }
        closeDatabaseConnection();
    } else {
        logIntoFile ($logPrefix."We do nothing because no db connection available");
    }

    if ($fid == 0) { ?>
        <html>
            <head>
                <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
                <link rel="stylesheet" type="text/css" href="css/download.css">
                <link rel="stylesheet" type="text/css" href="css/myDownload.css">
                <title>
                    <?php echo $projectName; ?>
                </title>
            </head>

            <body>
                <div class=nopermission><?php echo $lang['nopermission']; ?></div>
            </body>
        </html>
    <?PHP } else {
        logIntoFile ($logPrefix."We will download file=".$file." as name=".makeCleanFilename($filename).".".getFileExtension($file));

        header ('Content-Disposition: attachment; filename="'.makeCleanFilename($filename).".".getFileExtension($file).'"');

        readfile('data/'.$file);
    }
}

?>
