<?php
######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2014
#
# This php contains everything to change the password
#
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# v2014-11-30 FPG created the script
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
######################################################################

$userIdToChangeThePassword=0;


if  (empty ($_POST['doresetpwdfromlink'])) {
    $userIdToChangeThePassword = getSession("UID");
} else {
    $userIdToChangeThePassword = $_POST['doresetpwdfromlink'];
    debugIntoFile ("we have to set the reset thing");
    $sQuery = "DELETE FROM ".getDBTablePrefix()."PWDRESET WHERE UID = ?";
    $defaultErrorMsg=$lang['contactSysadmin'];
    $statement = mysqli_prepare($databaseConnection, $sQuery);
    setSession("GLASQLEXIT", logSQLError($sQuery));

    if (withoutSQLError()) {
        if (!mysqli_stmt_bind_param($statement, "i", $_POST['doresetpwdfromlink'])) {
            setSession("GLASQLEXIT", logSQLErrorManual("Error binding input params with sql-statement: ".$sQuery));
        } else {
            mysqli_stmt_execute($statement);
        }
    }
    closePreparedStatement($statement);
}


if ((empty($_POST["PASS1"])) || (empty($_POST["PASS2"]))) {
    setSession("GLAERRORMESSAGE", $lang['changepwdfillout']);
} else {
    if ($_POST['PASS1'] == $_POST['PASS2']) {
        if (strlen($_POST['PASS1']) < $minLengthPassword) {
            setSession("GLAERRORMESSAGE", $lang['passwordminimumlength'].$minLengthPassword);
            header("Location: index.php?mode=changepwd");
        } else {
            $tempPasswdTemp=sanitize($_POST['PASS1'], $sanitizeUserPwd);
            #debugIntoFile("tempPasswdTemp=".$tempPasswdTemp);
            $tempPasswd=transformPwd($tempPasswdTemp);
            #debugIntoFile("tempPasswd=".$tempPasswd);

            $sQuery = "UPDATE ".getDBTablePrefix()."USER SET UPWD = ? WHERE UID = ?";
            debugIntoFile($sQuery);
            $statement = mysqli_prepare($databaseConnection, $sQuery);
            setSession("GLASQLEXIT", logSQLError($sQuery));

             if (getSession("GLASQLEXIT") == 0) {
                 if (!mysqli_stmt_bind_param($statement, "si", $tempPasswd, $userIdToChangeThePassword)) {
                    logError($lang['errorbindinginput'].$sQuery);
                    setSession("GLASQLEXIT", 1);
                    setSession("GLAERRORMESSAGE", $lang['passwordnotchanged']);
                } else {
                    if (!mysqli_stmt_execute($statement)) {
                        setSession("GLASQLEXIT", logSQLError($sQuery));
                    } else {
                        setSession("GLAERRORMESSAGE", "");
                        logIntoFile($lang['userhaschangedpwd']);
                    }
                    closePreparedStatement($statement);
                    header("Location: index.php");
                }
             }
        }
    } else {
        setSession("GLAERRORMESSAGE", $lang['passwordsnotmatch']);
        debugIntoFile (getSession("GLAERRORMESSAGE"));
        header("Location: index.php?mode=changepwd");
    }
}
?>
