<?php
######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2014
#
# This php contains everything to manage file permissions
#
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# v2014-12-02 FPG created the script
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
######################################################################


setSession("GLAERRORMESSAGE", "");
if (withoutSQLError()) {
    if (empty($_POST["FILENAME"])) {
        debugIntoFile("we have no file");
        setSession("GLAERRORMESSAGE", $lang['nonewfilenofilename']);
        header ("Location: index.php");
    } else {
        $sQuery = "UPDATE ".getDBTablePrefix()."FILE SET FNAME = ?, FDESC = ? WHERE FID = ?";
        debugIntoFile($sQuery);
        $statement = mysqli_prepare($databaseConnection, $sQuery);
        setSession("GLASQLEXIT", logSQLError($sQuery));
        if (getSession("GLASQLEXIT") == 0) {
            if (!mysqli_stmt_bind_param($statement, "ssi", $_POST['FILENAME'], $_POST['FILEDESCRIPTION'], $_POST['FID'])) {
                logError($lang['errorbindinginput'].$sQuery);
                setSession("GLASQLEXIT", 1);
            } else {
                if (!mysqli_stmt_execute($statement)) {
                    setSession("GLAERRORMESSAGE", $lang['filenotadded']);
                    setSession("GLASQLEXIT", logSQLError($sQuery));
                } else {
                    closePreparedStatement($statement);
                    $sQuery = "DELETE FROM ".getDBTablePrefix()."FILEGROUP WHERE FID = ?";
                    debugIntoFile("delete existing group permissions with sql select=".$sQuery);
                    $statement = mysqli_prepare($databaseConnection, $sQuery);
                    #debugIntoFile ("A");
                    setSession("GLASQLEXIT", logSQLError($sQuery));

                    if (withoutSQLError()) {
                        #debugIntoFile ("B");
                        $id = $_POST['FID'];
                        if (!mysqli_stmt_bind_param($statement, "i", $id)) {
                            #debugIntoFile ("C");
                            setSession("GLASQLEXIT", logSQLErrorManual($lang['errorbindinginput'].$sQuery));
                        } else {
                            #debugIntoFile ("D");
                            mysqli_stmt_execute($statement);
                        }
                    }
                    closePreparedStatement($statement);

                    $sQuery = "DELETE FROM ".getDBTablePrefix()."FILEUSER WHERE FID = ?";
                    debugIntoFile("delete existing file permissions with sql select=".$sQuery);
                    $statement = mysqli_prepare($databaseConnection, $sQuery);
                    setSession("GLASQLEXIT", logSQLError($sQuery));

                    if (withoutSQLError()) {
                        $id = $_POST['FID'];
                        if (!mysqli_stmt_bind_param($statement, "i", $id)) {
                            setSession("GLASQLEXIT", logSQLErrorManual($lang['errorbindinginput'].$sQuery));
                        } else {
                            mysqli_stmt_execute($statement);
                        }
                    }
                    closePreparedStatement($statement);

                    if (isset($_POST['selectgroup'])) {
                        $sQuery = "INSERT INTO ".getDBTablePrefix()."FILEGROUP (FID, GID) VALUES (?, ?)";
                        debugIntoFile("insert new group permissions with sql select=".$sQuery);
                        $statement = mysqli_prepare($databaseConnection, $sQuery);
                        setSession("GLASQLEXIT", logSQLError($sQuery));
                        $id = $_POST['FID'];
                        $value = 2;
                        if (!mysqli_stmt_bind_param($statement, "ii", $id, $value)) {
                            setSession("GLASQLEXIT", logSQLErrorManual($lang['errorbindinginput'].$sQuery));
                        }

                        if (withoutSQLError()) {
                            foreach ($_POST['selectgroup'] as $selectedOption) {
                                $value = $selectedOption;
                                debugIntoFile("insert value=".$value);
                                mysqli_stmt_execute($statement);
                            }
                        }
                        closePreparedStatement($statement);
                    }

                    if (isset($_POST['selectuser'])) {
                        $sQuery = "INSERT INTO ".getDBTablePrefix()."FILEUSER (FID, UID) VALUES (?, ?)";
                        debugIntoFile("insert new file permissions with sql select=".$sQuery);
                        $statement = mysqli_prepare($databaseConnection, $sQuery);
                        setSession("GLASQLEXIT", logSQLError($sQuery));
                        $id = $_POST['FID'];
                        $value = 2;
                        if (!mysqli_stmt_bind_param($statement, "ii", $id, $value)) {
                            setSession("GLASQLEXIT", logSQLErrorManual($lang['errorbindinginput'].$sQuery));
                        }

                        foreach ($_POST['selectuser'] as $selectedOption) {
                            $value = $selectedOption;
                            debugIntoFile("insert value=".$value);
                            mysqli_stmt_execute($statement);
                        }
                        closePreparedStatement($statement);
                    }
                    logIntoFile("changed file-permission for FileID ".$_POST['FID']);
                }
            }
        }
    }
}

?>
