<?php
######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2014
#
# This php contains everything to manage users
#
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# v2014-11-30 FPG created the script
# v2104-12-15 FPG added support for multi user langue support
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
######################################################################


$tempError = 0;
debugIntoFile("We manage the user");
setSession("GLAERRORMESSAGE", "");
$defaultErrorMsg = $lang['nouserupdate'];
$active = 0;
$add = 0;

if (isset ($_POST["ACTIVE"]) && $_POST["ACTIVE"] == "on") {
    $active  = 1;
}
if (isset ($_POST["ADD"]) && $_POST["ADD"] == "on") {
    $add  = 1;
}
$useridNew = 0;
if ( isset ($_POST["LASTNAME"]) && isset ($_POST["FIRSTNAME"])  && isset ($_POST["EMAIL"]) && !empty($_POST["LASTNAME"]) && !empty($_POST["FIRSTNAME"]) && !empty($_POST["EMAIL"]) ) {
    if ($_POST['TYPE'] == "NEW") {
        # we will add a new user
        $defaultErrorMsg = $lang['nousercreated'];
        $newPassword=GUID();
        if (isset ($_POST['PASSWORD']) && !empty($_POST["PASSWORD"]) ) {
            if (strlen($_POST['PASSWORD']) < $minLengthPassword) {
                setSession("GLAERRORMESSAGE", $lang['passwordminimumlength'].$minLengthPassword);
                $tempError = 1;
                header ("Location: index.php?mode=modifyuser");
            }
            $newPassword = sanitize($_POST['PASSWORD'], $sanitizeUserPwd);
        }
        if ($tempError == 0) {
            $sQuery = "INSERT INTO ".getDBTablePrefix()."USER (UPWD, ULAST, UFIRST, UEMAIL, UACTIVE, UADD, UMODIFIED, ULANG) VALUES (?, ?, ?, ?, ?, ?, now(), ?)";
            debugIntoFile($sQuery);
            $statement = mysqli_prepare($databaseConnection, $sQuery);
            setSession("GLASQLEXIT", logSQLError($sQuery));

             if (getSession("GLASQLEXIT") == 0) {
                 $b=transformPwd($newPassword);
                 $c=$_POST['LASTNAME'];
                 $d=$_POST['FIRSTNAME'];
                 $e=$_POST['EMAIL'];
                 $f=$_POST['USERLANGUAGE'];
                 if (!mysqli_stmt_bind_param($statement, "ssssiis", $b, $c, $d, $e, $active, $add, $f)) {
                    logError($lang['errorbindinginput'].$sQuery);
                    setSession("GLASQLEXIT", 1);
                } else {
                    if (!mysqli_stmt_execute($statement)) {
                        setSession("GLAERRORMESSAGE", $lang['nousercreated']);
                        setSession("GLASQLEXIT", logSQLError($sQuery));
                        $tempError = 1;
                        header ("Location: index.php?mode=modifyuser");
                    } else {
                        logIntoFile("User |".$_POST['EMAIL']."| added");
                        setSession("GLAERRORMESSAGE", "");
                        debugIntoFile("we determine the userid of the user created");
                        $sQuery = "SELECT UID FROM ".getDBTablePrefix()."USER WHERE UEMAIL = '".$_POST['EMAIL']."'";
                        debugIntoFile("GetUserID-Select-Insert=".$sQuery);
                        $result = getRessource($sQuery);
                        #logSQLError();
                        $useridNew = 0;
                        while ($val = getRow($result)) {
                            $useridNew = $val['UID'];
                        }
                        freeRessource($result);
                    }
                    closePreparedStatement($statement);
                }
             }
        }
    } else { # end new begin update
        # update user
        debugIntoFile("update existing user");
        $useridNew = $_POST['UID'];

        $changeAlsoPwd=0;
        if ((isset ($_POST['PASSWORD'])) && (!empty($_POST['PASSWORD']))) {
            #debugIntoFile("password set to |".$_POST['PASSWORD']."|");
            if (strlen($_POST['PASSWORD']) < $minLengthPassword) {
                setSession("GLAERRORMESSAGE", $lang['passwordminimumlength'].$minLengthPassword);
                $tempError = 1;
            }
            $changeAlsoPwd = 1;
        } else {
            debugIntoFile("no password set");
        }

        if ($tempError == 0) {
            if ($changeAlsoPwd == 1) {
                $sQuery = "UPDATE ".getDBTablePrefix()."USER SET UMODIFIED = now(), ULAST = ?, UFIRST = ?, UEMAIL = ?, UACTIVE = ?, UADD = ?, UPWD = ?, ULANG = ? WHERE UID = ?";
            } else {
                $sQuery = "UPDATE ".getDBTablePrefix()."USER SET UMODIFIED = now(), ULAST = ?, UFIRST = ?, UEMAIL = ?, UACTIVE = ?, UADD = ?, ULANG = ? WHERE UID = ?";
            }
            debugIntoFile($sQuery);
            $statement = mysqli_prepare($databaseConnection, $sQuery);
            setSession("GLASQLEXIT", logSQLError($sQuery));

             if (getSession("GLASQLEXIT") == 0) {
                 $a=$_POST['EMAIL'];
                 $b=transformPwd($_POST['PASSWORD']);
                 $c=$_POST['UID'];
                 $d=$_POST['LASTNAME'];
                 $e=$_POST['FIRSTNAME'];
                 $f=$_POST['USERLANGUAGE'];

                debugIntoFile("Paco.A");
                if ($changeAlsoPwd == 1) {
                    debugIntoFile("Paco.B");
                    if (!mysqli_stmt_bind_param($statement, "sssiissi", $d, $e, $a, $active, $add, $b, $f, $c)) {
                        debugIntoFile("Paco.C");
                        logError($lang['errorbindinginput'].$sQuery);
                        setSession("GLASQLEXIT", 1);
                        $tempError = 1;
                    }
                } else {
                    debugIntoFile("Paco.D");
                    if (!mysqli_stmt_bind_param($statement, "sssiisi", $d, $e, $a, $active, $add, $f, $c)) {
                        debugIntoFile("Paco.E");
                        logError($lang['errorbindinginput'].$sQuery);
                        setSession("GLASQLEXIT", 1);
                        $tempError = 1;
                    }
                }

                if ($tempError == 0) {
                    debugIntoFile("Paco.F");
                    if (!mysqli_stmt_execute($statement)) {
                        debugIntoFile("Paco.G");
                        setSession("GLAERRORMESSAGE", $lang['nouserupdate']);
                        setSession("GLASQLEXIT", logSQLError($sQuery));
                        $tempError = 1;
                        debugIntoFile("SessionUID.2=".getSession("UID"));
                        header ("Location: index.php?mode=users");
                    } else {
                        debugIntoFile("Paco.H");
                        logIntoFile("User |".$_POST['EMAIL']."| modified");
                        setSession("GLAERRORMESSAGE", "");
                        $sQuery = "DELETE FROM ".getDBTablePrefix()."GROUPMEMBER WHERE UID = ".$_POST['UID'];
                        debugIntoFile("Delete-GroupMember=".$sQuery);
                        getRessource($sQuery);
                        logSQLError();
                        #freeRessource($result);
                    }
                    closePreparedStatement($statement);
                 }
             }
        }
    } # end update

    debugIntoFile("Paco.I");

    if ($tempError == 0) {
        debugIntoFile("Paco.J");
        if (isset($_POST['selectgroup'])) {
            debugIntoFile("Paco.K");
            foreach ($_POST['selectgroup'] as $selectedOption) {
                #echo $selectedOption."\n";
                $sQuery = "INSERT INTO ".getDBTablePrefix()."GROUPMEMBER (UID, GID) VALUES (".$useridNew.", ".$selectedOption.")";
                debugIntoFile("Insert-Group-Select-Insert=".$sQuery);
                getRessource($sQuery);
                #logSQLError();
                #freeRessource($result);
            }
        }

    }
    header ("Location: index.php?mode=users");
} else {
    setSession("GLAERRORMESSAGE", $lang['manageusernotallfieldsfilledout']);
    debugIntoFile("errormessage set during add/modify new user");
    header ("Location: index.php?mode=modifyuser");
}
?>
