<?php
######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2014
#
# This php contains everything to deal with updates
#
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# v2014-12-01 FPG created the script
# v2014-12-02 FPG adapted script for multi language support
# v2014-12-04 FPG adapted table FILE added column FILESIZE
# v2014-12-07 FPG adapted to database version 3 (PWDRESET))
# v2014-12-15 FPG added support for languages for user
# v2014-12-17 FPG added a view for better select queries and
#                 creating .htaccess files in data and log
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
$file="";
######################################################################




debugIntoFile("check if update is necessary");
$dbExistingVersion=0;
if (withoutSQLError()) {
    $sQuery = "SELECT VVERSION, VDESC FROM ".getDBTablePrefix()."APPVERSION WHERE VID=1";
    $result = getRessource($sQuery);
    if (withoutSQLError()) {
        while ($val = getRow($result)) {
            #debugIntoFile($val["VVERSION"]."/".$val["VDESC"]);
            $dbExistingVersion = $val["VVERSION"];
        }
    }
    freeRessource($result);

    if ($dbExistingVersion >= $databaseMinVersion) {
        debugIntoFile($lang['dbalreadymin']." ".$databaseMinVersion);
        setSession("CheckUpdate", 0);
    } else {
        if ($dbExistingVersion == 1) {
            logIntoFile($lang['updatingfromversion1'].": 1-2");
            $sQuery = "ALTER TABLE ".getDBTablePrefix()."FILE ADD FSIZE INT;";
            getRessource($sQuery);
            $sQuery = "UPDATE ".getDBTablePrefix()."FILE SET FSIZE = 0 WHERE FSIZE is null;";
            getRessource($sQuery);
            $sQuery = "ALTER TABLE ".getDBTablePrefix()."FILE CHANGE FSIZE FSIZE INT NOT NULL;";
            getRessource($sQuery);
            $dbExistingVersion = 2;
        }
        if ($dbExistingVersion == 2) {
            logIntoFile($lang['updatingfromversion1'].": 2-3");
            $sQuery = "ALTER TABLE ".getDBTablePrefix()."USER DROP USERNAME;";
            getRessource($sQuery);
            $sQuery = "ALTER TABLE ".getDBTablePrefix()."USER CHANGE UEMAIL UEMAIL VARCHAR(50) NOT NULL;";
            getRessource($sQuery);
            $sQuery = "CREATE TABLE IF NOT EXISTS `".getDBTablePrefix()."PWDRESET` (
      `PID` varchar(100) NOT NULL,
      `UID` bigint(20) NOT NULL,
      PRIMARY KEY (`PID`)
    ) ENGINE=InnoDB  DEFAULT CHARSET=utf8;";
                getRessource($sQuery);
            $dbExistingVersion = 3;
        }
        if ($dbExistingVersion == 3) {
            logIntoFile($lang['updatingfromversion1'].": 3-4");
            $sQuery = "ALTER TABLE ".getDBTablePrefix()."USER ADD UNIQUE (UEMAIL);";
            getRessource($sQuery);
            $dbExistingVersion = 4;
        }
        if ($dbExistingVersion == 4) {
            logIntoFile($lang['updatingfromversion1'].": 4-5");
            $sQuery = "ALTER TABLE `".getDBTablePrefix()."GROUP` ADD UNIQUE (GNAME);";
            getRessource($sQuery);
            $dbExistingVersion = 5;
        }

        if ($dbExistingVersion == 5) {
            logIntoFile($lang['updatingfromversion1'].": 5-6");
            $sQuery = "ALTER TABLE ".getDBTablePrefix()."USER ADD ULANG VARCHAR(2);";
            getRessource($sQuery);
            $sQuery = "UPDATE ".getDBTablePrefix()."USER SET ULANG='de';";
            getRessource($sQuery);
            $sQuery = "ALTER TABLE ".getDBTablePrefix()."USER CHANGE ULANG ULANG VARCHAR(2) NOT NULL;";
            getRessource($sQuery);
            $dbExistingVersion = 6;
        }

        if ($dbExistingVersion == 6) {
            logIntoFile($lang['updatingfromversion1'].": 6-7");
            $sQuery = "CREATE OR REPLACE VIEW ".getDBTablePrefix()."FILEFULLVIEW AS SELECT ".getDBTablePrefix()."FILE.FID, ".getDBTablePrefix()."FILE.FFILE, ".getDBTablePrefix()."FILE.FNAME, ".getDBTablePrefix()."GROUPMEMBER.UID FROM ".getDBTablePrefix()."FILE, ".getDBTablePrefix()."FILEGROUP, `".getDBTablePrefix()."GROUP`, ".getDBTablePrefix()."GROUPMEMBER WHERE ".getDBTablePrefix()."FILEGROUP.FID = ".getDBTablePrefix()."FILE.FID AND ".getDBTablePrefix()."GROUP.GID = ".getDBTablePrefix()."FILEGROUP.GID AND ".getDBTablePrefix()."GROUPMEMBER.GID = ".getDBTablePrefix()."GROUP.GID UNION SELECT ".getDBTablePrefix()."FILE.FID, ".getDBTablePrefix()."FILE.FFILE, ".getDBTablePrefix()."FILE.FNAME, ".getDBTablePrefix()."FILEUSER.UID FROM ".getDBTablePrefix()."FILE, ".getDBTablePrefix()."FILEUSER WHERE ".getDBTablePrefix()."FILEUSER.FID = ".getDBTablePrefix()."FILE.FID;";
            getRessource($sQuery);
            $dbExistingVersion = 7;

            # create own .htaccess file for data-directory
            $file = "data/.htaccess";
            if (!file_exists($file)) {
                file_put_contents($file, "<Files *.* >\n", FILE_APPEND | LOCK_EX);
                file_put_contents($file, "    Order allow,deny\n", FILE_APPEND | LOCK_EX);
                file_put_contents($file, "    Deny from all\n", FILE_APPEND | LOCK_EX);
                file_put_contents($file, "    Satisfy All\n", FILE_APPEND | LOCK_EX);
                file_put_contents($file, "</Files>\n", FILE_APPEND | LOCK_EX);
            }

            # create own .htaccess file for log directory
            $file = "log/.htaccess";
            if (!file_exists($file)) {
                file_put_contents($file, "<Files *.* >\n", FILE_APPEND | LOCK_EX);
                file_put_contents($file, "    Order allow,deny\n", FILE_APPEND | LOCK_EX);
                file_put_contents($file, "    Deny from all\n", FILE_APPEND | LOCK_EX);
                file_put_contents($file, "    Satisfy All\n", FILE_APPEND | LOCK_EX);
                file_put_contents($file, "</Files>\n", FILE_APPEND | LOCK_EX);
            }
        }

        # update version
        $sQuery = "UPDATE ".getDBTablePrefix()."APPVERSION SET VVERSION=".$databaseMinVersion.", VDESC='".$myVersion.".".$SVNRevision."' WHERE VID=1;";
        getRessource($sQuery);
        logIntoFile($val['updatedone']);
        setSession("CheckUpdate", 0);
    }
}
?>
