<?php
######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2014
#
# This php contains everything to deal with files
#
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# v2014-12-05 FPG created the script
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
######################################################################


#---------------------------------------------------------------------
# (c) www.glawar.at copy $source into $target if $target does not
#                   exists
#---------------------------------------------------------------------
function copyFileIfNotExists ($source, $target) {
    if (!file_exists($target)) {
        copy($source, $target);
    }
}


#---------------------------------------------------------------------
# (c) www.glawar.at delete file if it exists
#---------------------------------------------------------------------
function deleteFileIfExists ($file) {
    if (file_exists($file)) {
        unlink($file);
    }
}


#---------------------------------------------------------------------
# (c) www.glawar.at create a directory if it does not exist
#---------------------------------------------------------------------
function createDirectoryIfNotExists ($directory) {
    if (!file_exists($directory)) {
        mkdir($directory);
    }
}
?>
