<?php
######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2014
#
# This php contains everything to deal with strings
#
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# v2014-11-28 FPG created the script
# v2014-12-17 FPG added getFileExtension and makeCleanFilename
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
######################################################################


#---------------------------------------------------------------------
# (c) ds.it@gmx.de: Loescht die nicht erlaubten Zeichen aus dem
#                   uebergebenen String
# $string der zu ueberpruefende String
# $allowed Array der zusaetzlich erlaubten Zeichen
#---------------------------------------------------------------------
function sanitize($string, $allowed = array())    {
    $allow = "";

    if(!empty($allowed)) {
        foreach ($allowed as $value) {
            $allow .= "\\$value";
        }
    }

    if(is_array($string)){
        foreach ($string as $key => $clean) {
            $cleaned[$key] = preg_replace( "/[^{$allow}a-zA-Z0-9]/", "", $clean);
        }
    } else{
        $cleaned = preg_replace( "/[^{$allow}a-zA-Z0-9]/", "", $string );
    }

    return $cleaned;
}


#---------------------------------------------------------------------
# (c) www.glawar.at: make a clean filename to save on disk
#---------------------------------------------------------------------
function makeCleanFilename ($filename) {
    $retVal = str_replace(" ","_", $filename);
    $retVal = str_replace("(","_", $retVal);
    $retVal = str_replace(")","_", $retVal);
    $retVal = str_replace("!","_", $retVal);
    $retVal = str_replace("?","_", $retVal);
    $retVal = str_replace(",","_", $retVal);
    $retVal = str_replace(";","_", $retVal);
    $retVal = str_replace(":","_", $retVal);
    $retVal = str_replace("'","_", $retVal);
    $retVal = str_replace("`","_", $retVal);
    $retVal = str_replace("ä","ae", $retVal);
    $retVal = str_replace("Ä","Ae", $retVal);
    $retVal = str_replace("ü","ue", $retVal);
    $retVal = str_replace("Ü","Ue", $retVal);
    $retVal = str_replace("ö","oe", $retVal);
    $retVal = str_replace("Ö","Oe", $retVal);
    $retVal = str_replace("ß","ss", $retVal);
    $retVal = str_replace("[","_", $retVal);
    $retVal = str_replace("]","_", $retVal);
    $retVal = str_replace("<","_", $retVal);
    $retVal = str_replace(">","_", $retVal);
    $retVal = str_replace('"',"_", $retVal);
    $retVal = str_replace("\"","_", $retVal);
    $retVal = str_replace("/","_", $retVal);
    $retVal = str_replace("|","_", $retVal);
    $retVal = str_replace("*","_", $retVal);
    $retVal = str_replace("%","_", $retVal);
    $retVal = str_replace("$","_", $retVal);
    $retVal = str_replace("+","_", $retVal);
    $retVal = str_replace("~","_", $retVal);

    return $retVal;
}


#---------------------------------------------------------------------
# (c) www.glawar.at: get the file extension of a filename
#---------------------------------------------------------------------
function getFileExtension ($filename) {
    $name = "winter.gif";
    $temp = explode(".",$filename);
    $endung = $temp[(count($temp)-1)];

    return $endung;
}
?>
