<?PHP
session_start();

# everything about date and time
include_once "include/session.php";

# everything about date and time
include_once "include/dateandtime.php";

# everything about logging
include_once "include/logging.php";

# everything about database
include_once "include/database.php";

# everything about files
include_once "include/files.php";

ini_set("display_errors", "0");
error_reporting(E_ALL);

date_default_timezone_set('Europe/Vienna');
setlocale (LC_TIME, "de_DE");

######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2014
#
# This php file realizes a simple download managaement.
#
#
# (c) www.glawar.at
#
#
######################################################################
# The standard user is admin with password admin
######################################################################
####  History
#---------------------------------------------------------------------
# v2014-11-15 paco Project initialized
# v2014-11-16 paco added better error handling, added layout, added
#                  multiple language support
# v2014-11-30 paco adapted to master script
# v2014-12-01 paco got new master include scripts
#                  added update-functionality
# v2104-12-02 paco tested nearly everything, but not all input methods
#                  are done by prepared statements
# v2014-12-05 paco tested at T
# v2014-12-14 paco added support for Datatables prefix
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
# read params from configuration-file
$configFile="conf/download.ini";
$iniParams = parse_ini_file($configFile);
# create log and data directory, if they do not exist
createDirectoryIfNotExists("log");
createDirectoryIfNotExists("data");
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
$usedb = "mysql";
$doLog = $iniParams["doLog"];
$doDebug = $iniParams["doDebug"];
# params from config-file
$projectName = $iniParams["projectName"];
$logFile = $iniParams["logFile"];
$defaultLanguage = $iniParams["defaultLanguage"];
$sessionPrefix = $iniParams["sessionPrefix"];
# global connection
$databaseConnection = null;
######################################################################

setSession("lang", $defaultLanguage);
include("lang/".getSession("lang").".php");
?>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN">
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <link rel="stylesheet" type="text/css" href="css/download.css">
        <script language="JavaScript" type="text/javascript" src="js/download.js"></script>
        <title>
            <?php echo $projectName; ?>
        </title>
    </head>

    <body>
        <?php
        if (isset($_POST['HOST']) && isset ($_POST['DBPREFIX'])) {
            logIntoFile ("We create the data model");
            $dbPrefix = $_POST['DBPREFIX'];

            $sqlHost = $_POST['HOST'];
            $mySqlDB = $_POST['SQLDATABASE'];
            $sqlUser = $_POST['USERNAME'];
            $sqlPass = $_POST['PASSWORD'];

            debugIntoFile ("sqlHost=".$sqlHost);
            debugIntoFile ("mySqlDB=".$mySqlDB);
            debugIntoFile ("sqlUser=".$sqlUser);
            debugIntoFile ("sqlPass=".$sqlPass);

            getDatabaseConnection();

            if (withoutSQLError()) {
                logIntoFile ($lang['creatingdatabasestructure']);
                $sQuery = "CREATE TABLE IF NOT EXISTS `".$dbPrefix."FILE` (
      `FID` bigint(20) NOT NULL AUTO_INCREMENT,
      `FFILE` varchar(100) NOT NULL,
      `FNAME` varchar(50) NOT NULL,
      `FDESC` varchar(255) DEFAULT NULL,
      `FDATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
      PRIMARY KEY (`FID`)
    ) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;";
                getRessource($sQuery);
                $sQuery = "CREATE TABLE IF NOT EXISTS `".$dbPrefix."FILEGROUP` (
      `FGID` bigint(20) NOT NULL AUTO_INCREMENT,
      `FID` bigint(20) NOT NULL,
      `GID` bigint(20) NOT NULL,
      `FGDATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
      PRIMARY KEY (`FGID`)
    ) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;";
                getRessource($sQuery);
                $sQuery = "CREATE TABLE IF NOT EXISTS `".$dbPrefix."FILEUSER` (
      `FUID` bigint(20) NOT NULL AUTO_INCREMENT,
      `FID` bigint(20) NOT NULL,
      `UID` bigint(20) NOT NULL,
      `FUDATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
      PRIMARY KEY (`FUID`)
    ) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;";
                getRessource($sQuery);
                $sQuery = "CREATE TABLE IF NOT EXISTS `".$dbPrefix."GROUP` (
      `GID` bigint(20) NOT NULL AUTO_INCREMENT,
      `GNAME` varchar(50) NOT NULL,
      PRIMARY KEY (`GID`)
    ) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;";
                getRessource($sQuery);
                $sQuery = "CREATE TABLE IF NOT EXISTS `".$dbPrefix."GROUPMEMBER` (
      `GMID` bigint(20) NOT NULL AUTO_INCREMENT,
      `UID` bigint(20) NOT NULL,
      `GID` bigint(20) NOT NULL,
      `MDATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
      PRIMARY KEY (`GMID`)
    ) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;";
                getRessource($sQuery);
                $sQuery = "CREATE TABLE IF NOT EXISTS `".$dbPrefix."USER` (
      `UID` bigint(20) NOT NULL AUTO_INCREMENT,
      `USERNAME` varchar(10) NOT NULL,
      `UPWD` varchar(50) NOT NULL,
      `ULAST` varchar(50) NOT NULL,
      `UFIRST` varchar(50) NOT NULL,
      `UEMAIL` varchar(50) DEFAULT NULL,
      `UACTIVE` int(1) DEFAULT NULL,
      `UADD` int(11) NOT NULL,
      `UCREATED` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
      `UMODIFIED` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
      PRIMARY KEY (`UID`),
      UNIQUE KEY `USERNAME` (`USERNAME`)
    ) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;";
                getRessource($sQuery);

                logIntoFile ($lang['insertingbasedata']);
                $sQuery = "INSERT INTO `".$dbPrefix."GROUP` (`GNAME`) VALUES ('Administrator');";
                getRessource($sQuery);
                $sQuery = "INSERT INTO `".$dbPrefix."USER` (`USERNAME`, `UPWD`, `ULAST`, `UFIRST`, `UEMAIL`, `UACTIVE`, `UADD`) VALUES ('admin', '21232f297a57a5a743894a0e4a801fc3', 'Lastname', 'Firstname', 'download@com.com', 1, 1);";
                getRessource($sQuery);
                $sQuery = "INSERT INTO `".$dbPrefix."GROUPMEMBER` (`UID`, `GID`) VALUES (1, 1);";
                getRessource($sQuery);

                logIntoFile ($lang['creatingversioncheck']);
                $sQuery = "CREATE TABLE ".$dbPrefix."APPVERSION (VID INT NOT NULL PRIMARY KEY, VVERSION INT, VDESC VARCHAR(100));";
                getRessource($sQuery);
                $sQuery = "INSERT INTO ".$dbPrefix."APPVERSION (VID, VVERSION, VDESC) VALUES (1, 1, 'Baseinstallation');";
                getRessource($sQuery);
                logIntoFile ($lang['creatingconfigentries']);
                file_put_contents($configFile, "; ####----------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
                file_put_contents($configFile, "; # DBTable Prefix\n", FILE_APPEND | LOCK_EX);
                file_put_contents($configFile, "DBTablePrefix = '".$_POST['DBPREFIX']."';\n", FILE_APPEND | LOCK_EX);
                file_put_contents($configFile, "; ####----------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
                file_put_contents($configFile, "; # MYSQL-parameter\n", FILE_APPEND | LOCK_EX);
                file_put_contents($configFile, "sqlHost = '".$sqlHost."';\n", FILE_APPEND | LOCK_EX);
                file_put_contents($configFile, "mySqlDB = '".$mySqlDB."';\n", FILE_APPEND | LOCK_EX);
                file_put_contents($configFile, "sqlUser = '".$sqlUser."';\n", FILE_APPEND | LOCK_EX);
                file_put_contents($configFile, "sqlPass = '".$sqlPass."';\n", FILE_APPEND | LOCK_EX);
                file_put_contents($configFile, "; ####----------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
                file_put_contents($configFile, "; # if set to 1 it means that the baseinstallation has been done\n", FILE_APPEND | LOCK_EX);
                file_put_contents($configFile, "BaseInstallationDone = 1;\n", FILE_APPEND | LOCK_EX);
                ?>
                <h1 align=center><?php echo $lang['installationdone']; ?></h1>
                <div align=center><a href="index.php">Start DownloadManager</a></div>
                <?php

            } else {
                ?>
                <div class=myError align=center><?php echo getSession("GLAERRORMESSAGE");?></div>
                <?php
            }
            unsetSession("GLAERRORMESSAGE");
            unsetSession("GLASQLEXIT");
            unsetSession("CheckUpdate");

            session_unset();
            session_destroy();
        } else {
            logIntoFile ("We display the installation form");
            ?>

            <h1 align=center><?php echo $lang['installationof']." ".$projectName; ?></h1>

            <center>
                <table border=0 width=80%>
                    <tr>
                        <td>
                            <center>
                                <table border=0 width=60%>
                                    <tr>
                                        <td>
                                            <h3 align=left><?php echo $lang['providedatabase']; ?></h3>
                                            <div class=sourcecode align=left>create database downloadmanager;</div>
                                            <div class=sourcecode align=left>grant all on downloadmanager.* to dmuser identified by 'dmpassword';</div>
                                            <div class=sourcecode>&nbsp;</div>
                                        </td>
                                    </tr>
                                </table>
                            </center>

                            <form method="post" action="<?php echo $_SERVER['PHP_SELF'];?>">
                                <center>
                                    <table class=installtable border=0>
                                        <tr>
                                            <td><?php echo $lang['dbtableprefix']; ?>:</td>
                                            <td><input class='installInput' type='text' name='DBPREFIX' value='DMA_'></td>
                                        </tr>
                                        <tr>
                                            <td>Host:</td>
                                            <td><input class='installInput' type='text' name='HOST' value='localhost'></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo $lang['MySQLDatabase']; ?>:</td>
                                            <td><input class='installInput' type='text' name='SQLDATABASE' value='downloadmanager'></td>
                                        </tr>
                                         <tr>
                                            <td><?php echo $lang['username']; ?>:</td>
                                            <td><input class='installInput' type='text' name='USERNAME' value='dmuser'></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo $lang['password']; ?>:</td>
                                            <td><input class='installInput' type='text' name='PASSWORD' value='dmpassword'></td>
                                        </tr>
                                        <tr>
                                            <td></td>
                                            <td >
                                                <input type='submit' class=installButton name='createDataModel' value='<?php echo $lang['doInstallation']; ?>'>
                                            </td>
                                        </tr>
                                    </table>
                                </center>
                            </form>
                        </td>
                    </tr>
                </table>
            </center>
            <?php
        }
        ?>

    </body>
</html>
