/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.dbcommunication;

import at.glawar.gladate.GLADate;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DBCFirebird {
    private Connection m_cCon = null;

    public DBCFirebird(Connection con) {
        this.m_cCon = con;
    }

    public static final String formatTimeStampParam(Date dValue) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "'" + df.format(dValue) + "'";
    }

    public void callDBProcedure(String strProcedureName, Object[] oaParameters, String strDBPrefix) throws SQLException {
        int i;
        CallableStatement caStatement = null;
        String strParameter = "";
        String strcaStmt = "{call " + strDBPrefix + strProcedureName;
        if (oaParameters != null && oaParameters.length > 0) {
            i = 0;
            while (i < oaParameters.length) {
                strParameter = String.valueOf(strParameter) + "?, ";
                ++i;
            }
            if (strParameter.length() > 0) {
                strParameter = strParameter.substring(0, strParameter.length() - 2);
            }
            strcaStmt = String.valueOf(strcaStmt) + " (" + strParameter + ")}";
        } else {
            strcaStmt = String.valueOf(strcaStmt) + "}";
        }
        try {
            caStatement = this.m_cCon.prepareCall(strcaStmt);
            if (oaParameters != null) {
                i = 0;
                while (i < oaParameters.length) {
                    caStatement.setObject(i + 1, oaParameters[i]);
                    ++i;
                }
            }
            caStatement.execute();
        }
        finally {
            try {
                if (caStatement != null) {
                    caStatement.close();
                    caStatement = null;
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public int callDBINTEGERFunction(String strFunctionName, Object[] oaParameters, String strDBPrefix, int iDefaultValue) throws SQLException {
        int iRet = iDefaultValue;
        CallableStatement caStatement = null;
        String strParameter = this.prepareParameterStatement(strFunctionName, oaParameters, strDBPrefix);
        try {
            try {
                caStatement = this.m_cCon.prepareCall(strParameter);
                caStatement.registerOutParameter(1, 4);
                caStatement.execute();
                iRet = caStatement.getInt(1);
            }
            catch (SQLException ex) {
                iRet = iDefaultValue;
                throw ex;
            }
        }
        finally {
            try {
                if (caStatement != null) {
                    caStatement.close();
                    caStatement = null;
                }
            }
            catch (SQLException sQLException) {}
        }
        return iRet;
    }

    public Date callDBTIMESTAMPFunction(String strFunctionName, Object[] oaParameters, String strDBPrefix, Date dDefaultValue) throws SQLException {
        Date dRet = dDefaultValue;
        CallableStatement caStatement = null;
        String strParameter = this.prepareParameterStatement(strFunctionName, oaParameters, strDBPrefix);
        try {
            try {
                caStatement = this.m_cCon.prepareCall(strParameter);
                caStatement.registerOutParameter(1, 93);
                caStatement.execute();
                dRet = caStatement.getTimestamp(1);
            }
            catch (SQLException ex) {
                dRet = dDefaultValue;
                throw ex;
            }
        }
        finally {
            try {
                if (caStatement != null) {
                    caStatement.close();
                    caStatement = null;
                }
            }
            catch (SQLException sQLException) {}
        }
        return dRet;
    }

    public String callDBVARCHARFunction(String strFunctionName, Object[] oaParameters, String strDBPrefix, String strDefaultValue) throws SQLException {
        String strRet = strDefaultValue;
        CallableStatement caStatement = null;
        String strParameter = this.prepareParameterStatement(strFunctionName, oaParameters, strDBPrefix);
        try {
            try {
                caStatement = this.m_cCon.prepareCall(strParameter);
                caStatement.registerOutParameter(1, 12);
                caStatement.execute();
                strRet = caStatement.getString(1);
            }
            catch (SQLException ex) {
                strRet = strDefaultValue;
                throw ex;
            }
        }
        finally {
            try {
                if (caStatement != null) {
                    caStatement.close();
                    caStatement = null;
                }
            }
            catch (SQLException sQLException) {}
        }
        return strRet;
    }

    public BigDecimal callDBNUMERICFunction(String strFunctionName, Object[] oaParameters, String strDBPrefix, BigDecimal bdDefaultValue) throws SQLException {
        BigDecimal bdRet = bdDefaultValue;
        CallableStatement caStatement = null;
        String strParameter = this.prepareParameterStatement(strFunctionName, oaParameters, strDBPrefix);
        try {
            try {
                caStatement = this.m_cCon.prepareCall(strParameter);
                caStatement.registerOutParameter(1, 3);
                caStatement.execute();
                bdRet = caStatement.getBigDecimal(1);
            }
            catch (SQLException ex) {
                bdRet = bdDefaultValue;
                throw ex;
            }
        }
        finally {
            try {
                if (caStatement != null) {
                    caStatement.close();
                    caStatement = null;
                }
            }
            catch (SQLException sQLException) {}
        }
        return bdRet;
    }

    private String prepareParameterStatement(String strFunctionName, Object[] oaParameters, String strDBPrefix) {
        String strRet = "{? = call " + strDBPrefix + strFunctionName;
        if (oaParameters != null && oaParameters.length > 0) {
            strRet = String.valueOf(strRet) + " (";
            int i = 0;
            while (i < oaParameters.length) {
                strRet = oaParameters[i] == null ? String.valueOf(strRet) + "null" : (oaParameters[i] instanceof Date ? String.valueOf(strRet) + DBCFirebird.formatTimeStampParam((Date)oaParameters[i]) : (oaParameters[i] instanceof java.sql.Date ? String.valueOf(strRet) + DBCFirebird.formatTimeStampParam(GLADate.castSQL2UtilDate((java.sql.Date)((java.sql.Date)oaParameters[i]))) : (oaParameters[i] instanceof String ? String.valueOf(strRet) + "'" + oaParameters[i] + "'" : String.valueOf(strRet) + oaParameters[i])));
                strRet = String.valueOf(strRet) + ", ";
                ++i;
            }
            strRet = strRet.substring(0, strRet.length() - 2);
            strRet = String.valueOf(strRet) + ")}";
        } else {
            strRet = String.valueOf(strRet) + "}";
        }
        return strRet;
    }
}

