/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.dbcommunication;

import at.glawar.gladate.GLADate;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DBCOracle {
    private Connection m_cCon = null;

    public DBCOracle(Connection con) {
        this.m_cCon = con;
    }

    public static final String formatSQLDDateParam(Date dValue) {
        SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy HH:mm");
        return "to_date('" + df.format(dValue) + "', 'dd-mm-yyyy hh24:mi')";
    }

    public void callDBProcedure(String strProcedureName, Object[] oaParameters, String strDBPrefix) throws SQLException {
        int i;
        CallableStatement caStatement = null;
        String strParameter = "";
        String strcaStmt = "{call " + strDBPrefix + strProcedureName;
        if (oaParameters != null && oaParameters.length > 0) {
            i = 0;
            while (i < oaParameters.length) {
                strParameter = String.valueOf(strParameter) + "?, ";
                ++i;
            }
            if (strParameter.length() > 0) {
                strParameter = strParameter.substring(0, strParameter.length() - 2);
            }
            strcaStmt = String.valueOf(strcaStmt) + " (" + strParameter + ")}";
        } else {
            strcaStmt = String.valueOf(strcaStmt) + "}";
        }
        try {
            caStatement = this.m_cCon.prepareCall(strcaStmt);
            if (oaParameters != null) {
                i = 0;
                while (i < oaParameters.length) {
                    caStatement.setObject(i + 1, oaParameters[i]);
                    ++i;
                }
            }
            caStatement.execute();
        }
        finally {
            try {
                if (caStatement != null) {
                    caStatement.close();
                    caStatement = null;
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public BigDecimal callDBNUMBERFunction(String strFunctionName, Object[] oaParameters, String strDBPrefix, BigDecimal bdDefaultValue) throws SQLException {
        BigDecimal bdRet = bdDefaultValue;
        CallableStatement caStatement = null;
        String strParameter = this.prepareParameterStatement(strFunctionName, oaParameters, strDBPrefix);
        try {
            try {
                caStatement = this.m_cCon.prepareCall(strParameter);
                caStatement.registerOutParameter(1, 3);
                caStatement.execute();
                bdRet = caStatement.getBigDecimal(1);
            }
            catch (SQLException ex) {
                bdRet = bdDefaultValue;
                throw ex;
            }
        }
        finally {
            try {
                if (caStatement != null) {
                    caStatement.close();
                    caStatement = null;
                }
            }
            catch (SQLException sQLException) {}
        }
        return bdRet;
    }

    public String callDBVARCHAR2unction(String strFunctionName, Object[] oaParameters, String strDBPrefix, String strDefaultValue) throws SQLException {
        String strRet = strDefaultValue;
        CallableStatement caStatement = null;
        String strParameter = this.prepareParameterStatement(strFunctionName, oaParameters, strDBPrefix);
        try {
            try {
                caStatement = this.m_cCon.prepareCall(strParameter);
                caStatement.registerOutParameter(1, 12);
                caStatement.execute();
                strRet = caStatement.getString(1);
            }
            catch (SQLException ex) {
                strRet = strDefaultValue;
                throw ex;
            }
        }
        finally {
            try {
                if (caStatement != null) {
                    caStatement.close();
                    caStatement = null;
                }
            }
            catch (SQLException sQLException) {}
        }
        return strRet;
    }

    public Date callDBDATEFunction(String strFunctionName, Object[] oaParameters, String strDBPrefix, Date dDefaultValue) throws SQLException {
        Timestamp dRet = null;
        CallableStatement caStatement = null;
        String strParameter = this.prepareParameterStatement(strFunctionName, oaParameters, strDBPrefix);
        try {
            try {
                caStatement = this.m_cCon.prepareCall(strParameter);
                caStatement.registerOutParameter(1, 93);
                caStatement.execute();
                dRet = caStatement.getTimestamp(1);
            }
            catch (SQLException ex) {
                dRet = null;
                throw ex;
            }
        }
        finally {
            try {
                if (caStatement != null) {
                    caStatement.close();
                    caStatement = null;
                }
            }
            catch (SQLException sQLException) {}
        }
        return dRet;
    }

    private String prepareParameterStatement(String strFunctionName, Object[] oaParameters, String strDBPrefix) {
        String strRet = "{? = call " + strDBPrefix + strFunctionName;
        if (oaParameters != null && oaParameters.length > 0) {
            strRet = String.valueOf(strRet) + " (";
            int i = 0;
            while (i < oaParameters.length) {
                strRet = oaParameters[i] == null ? String.valueOf(strRet) + "null" : (oaParameters[i] instanceof Date ? String.valueOf(strRet) + DBCOracle.formatSQLDDateParam((Date)oaParameters[i]) : (oaParameters[i] instanceof java.sql.Date ? String.valueOf(strRet) + DBCOracle.formatSQLDDateParam(GLADate.castSQL2UtilDate((java.sql.Date)((java.sql.Date)oaParameters[i]))) : (oaParameters[i] instanceof String ? String.valueOf(strRet) + "'" + oaParameters[i] + "'" : String.valueOf(strRet) + oaParameters[i])));
                strRet = String.valueOf(strRet) + ", ";
                ++i;
            }
            strRet = strRet.substring(0, strRet.length() - 2);
            strRet = String.valueOf(strRet) + ")}";
        } else {
            strRet = String.valueOf(strRet) + "}";
        }
        return strRet;
    }
}

