/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.gladataadapter;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheImpl;

public class GLAOracleDataAdapter {
    private String m_strHost = null;
    private String m_strPort = null;
    private String m_strDBName = null;
    private String m_strUser = null;
    private String m_strPassword = null;
    private String m_strConnectionURL = null;
    private String m_strDriverName = null;
    private boolean m_isPooled = false;
    private OracleConnectionCacheImpl m_occiItem = null;
    private int m_iMaxPooledConnections = 100;
    private int m_iCacheTimeToLiveTimeout = 20;
    private int m_iCacheInactivityTimeout = 30;
    private int m_iThreadWakeUpInterval = 10;
    private int m_iLoginTimeout = 3;

    public GLAOracleDataAdapter(String strHost, String strPort, String strDBName, String strUser, String strPassword, String strMaxPooledConnections, String strCacheTimeToLiveTimeout, String strCacheInactivityTimeout, String strThreadWakeUpInterval, String strLoginTimeout, boolean useConnectionPool) throws SQLException {
        this.m_strHost = strHost;
        this.m_strPort = strPort;
        this.m_strDBName = strDBName;
        this.m_strUser = strUser;
        this.m_strPassword = strPassword;
        this.m_strConnectionURL = "jdbc:oracle:thin:@" + this.m_strHost + ":" + this.m_strPort + ":" + this.m_strDBName;
        try {
            this.m_iMaxPooledConnections = new Integer(strMaxPooledConnections);
        }
        catch (Exception ex) {
            this.m_iMaxPooledConnections = 100;
        }
        try {
            this.m_iCacheTimeToLiveTimeout = new Integer(strCacheTimeToLiveTimeout);
        }
        catch (Exception ex) {
            this.m_iCacheTimeToLiveTimeout = 20;
        }
        try {
            this.m_iCacheInactivityTimeout = new Integer(strCacheInactivityTimeout);
        }
        catch (Exception ex) {
            this.m_iCacheInactivityTimeout = 30;
        }
        try {
            this.m_iThreadWakeUpInterval = new Integer(strThreadWakeUpInterval);
        }
        catch (Exception ex) {
            this.m_iThreadWakeUpInterval = 10;
        }
        try {
            this.m_iLoginTimeout = new Integer(strLoginTimeout);
        }
        catch (Exception ex) {
            this.m_iLoginTimeout = 3;
        }
        this.m_isPooled = useConnectionPool;
        this.doInit();
    }

    public GLAOracleDataAdapter(String strHost, String strPort, String strDBName, String strUser, String strPassword, String strMaxPooledConnections, String strCacheTimeToLiveTimeout, String strCacheInactivityTimeout, String strThreadWakeUpInterval, String strLoginTimeout) throws SQLException {
        this(strHost, strPort, strDBName, strUser, strPassword, strMaxPooledConnections, strCacheTimeToLiveTimeout, strCacheInactivityTimeout, strThreadWakeUpInterval, strLoginTimeout, true);
    }

    private void doInit() throws SQLException {
        this.m_occiItem = new OracleConnectionCacheImpl();
        this.m_occiItem.setURL(this.m_strConnectionURL);
        this.m_occiItem.setUser(this.m_strUser);
        this.m_occiItem.setPassword(this.m_strPassword);
        this.m_occiItem.setCacheScheme(3);
        this.m_occiItem.setMaxLimit(this.m_iMaxPooledConnections);
        this.m_occiItem.setCacheTimeToLiveTimeout((long)this.m_iCacheTimeToLiveTimeout);
        this.m_occiItem.setCacheInactivityTimeout((long)this.m_iCacheInactivityTimeout);
        this.m_occiItem.setThreadWakeUpInterval((long)this.m_iThreadWakeUpInterval);
        this.m_occiItem.setStmtCacheSize(this.m_iMaxPooledConnections, true);
        this.m_occiItem.setImplicitCachingEnabled(true);
        this.m_occiItem.setMaxStatements(this.m_iMaxPooledConnections);
        this.m_occiItem.setLoginTimeout(this.m_iLoginTimeout);
        this.setDriverName("oracle.jdbc.driver.OracleDriver");
    }

    public Connection getConnection() {
        if (this.m_isPooled) {
            Connection con = this.getPooledConnection();
            if (con == null) {
                return this.getNotPooledConnection();
            }
            return con;
        }
        return this.getNotPooledConnection();
    }

    public Connection getPooledConnection() {
        try {
            OracleConnection conn = (OracleConnection)this.m_occiItem.getConnection();
            if (conn == null) {
                this.doInit();
                conn = (OracleConnection)this.m_occiItem.getConnection();
            }
            return conn;
        }
        catch (SQLException e) {
            System.out.println("unable to get pooled connection from database...");
            e.printStackTrace();
            return null;
        }
    }

    public Connection getNotPooledConnection() {
        Connection con = null;
        try {
            con = DriverManager.getConnection(this.m_strConnectionURL, this.m_strUser, this.m_strPassword);
        }
        catch (SQLException e) {
            System.out.println("unable to get unpooled connection from database...");
            e.printStackTrace();
        }
        return con;
    }

    private void setDriverName(String strDriverName) {
        if (this.m_strDriverName != strDriverName || this.m_strDriverName != null && !this.m_strDriverName.equals(strDriverName)) {
            try {
                Class.forName(strDriverName);
            }
            catch (Exception e) {
                System.out.println("could not find driver manager (" + strDriverName + ") ...");
                e.printStackTrace();
            }
            try {
                DriverManager.registerDriver((Driver)Class.forName(strDriverName).newInstance());
            }
            catch (Exception e) {
                System.out.println("could not register driver manager (" + strDriverName + ") ...");
                e.printStackTrace();
            }
        }
        this.m_strDriverName = strDriverName;
    }
}

