/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.javaframework.gui.table.celleditor;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TextEditor
extends DefaultCellEditor {
    private String defaultVal;

    public TextEditor(boolean nullable, int chars) {
        super(new JTextField());
        if (!nullable) {
            this.getEditor().addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent arg0) {
                    this.checkInput();
                }

                @Override
                public void keyPressed(KeyEvent arg0) {
                    this.checkInput();
                }

                @Override
                public void keyReleased(KeyEvent arg0) {
                    this.checkInput();
                }

                private void checkInput() {
                    if (TextEditor.this.getEditor().getText().length() == 0) {
                        TextEditor.this.getEditor().setText(TextEditor.this.defaultVal);
                    }
                }
            });
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object param) {
                    super.setValue(param);
                    TextEditor.this.getEditor().setText(this.value.toString());
                    TextEditor.this.defaultVal = TextEditor.this.getEditor().getText();
                }

                @Override
                public Object getCellEditorValue() {
                    if (TextEditor.this.getEditor().getText() == null || TextEditor.this.getEditor().getText().length() == 0) {
                        return TextEditor.this.defaultVal;
                    }
                    return TextEditor.this.getEditor().getText();
                }
            };
        }
        this.getEditor().setDocument(new LengthLimitedDocument(chars));
    }

    public JTextField getEditor() {
        return (JTextField)this.getComponent();
    }

    public class LengthLimitedDocument
    extends PlainDocument {
        private int _limit;

        public LengthLimitedDocument(int limit) {
            this._limit = limit;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str != null && this.getLength() + str.length() <= this._limit) {
                super.insertString(offset, str, attr);
            }
        }
    }
}

