/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.javaframework.files;

import at.glawar.javaframework.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class LogFile {
    private String applicationName = null;
    private File fLogFile = null;
    private File fErrFile = null;
    private PrintStream psOut = System.out;
    private PrintStream psErr = System.err;

    public LogFile(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setLogFile(String fullLogFileName) throws IOException {
        this.fLogFile = new File(fullLogFileName + ".log");
        if (!this.fLogFile.exists()) {
            this.fLogFile.createNewFile();
        }
        FileOutputStream fo = new FileOutputStream(this.fLogFile, true);
        this.psOut = new PrintStream(fo);
        this.log2File(this.applicationName + " started", true, null);
        this.fErrFile = new File(fullLogFileName + ".err");
        if (!this.fErrFile.exists()) {
            this.fErrFile.createNewFile();
        }
        FileOutputStream foErr = new FileOutputStream(this.fErrFile, true);
        this.psErr = new PrintStream(foErr);
    }

    public void log2File(Object obj) {
        this.log2File(obj, true, null);
    }

    public void log2File(Throwable th) {
        this.log2File(th + " (For details see " + this.fErrFile.getName() + ")", true, null);
        this.err2File(th, null);
    }

    public void log2File(Object obj, String preText) {
        this.log2File(obj, true, preText);
    }

    public void log2File(Throwable th, String preText) {
        this.log2File(th + " (For details see " + this.fErrFile.getName() + ")", true, preText);
        this.err2File(th, preText);
    }

    public void log2File(Object obj, boolean withDateTimeStamp, String preText) {
        String pre = null;
        pre = preText == null || preText.length() == 0 ? "" : (preText.endsWith(".") ? preText : preText + ".");
        if (this.psOut != System.out) {
            if (withDateTimeStamp) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(Calendar.getInstance().getTime());
                this.psOut.println(cal.get(1) + "-" + StringUtils.make2Chars(cal.get(2) + 1) + "-" + StringUtils.make2Chars(cal.get(5)) + " " + StringUtils.make2Chars(cal.get(11)) + ":" + StringUtils.make2Chars(cal.get(12)) + ":" + StringUtils.make2Chars(cal.get(13)) + ":" + StringUtils.make3Chars(cal.get(14)) + " " + pre + obj);
            } else {
                this.psOut.println(pre + obj);
            }
        }
    }

    public void err2File(Object obj) {
        this.err2File(obj, true, null);
    }

    public void err2File(Object obj, String preText) {
        this.err2File(obj, true, preText);
    }

    public void err2File(Object obj, boolean withDateTimeStamp, String preText) {
        String pre = null;
        pre = preText == null || preText.length() == 0 ? "" : (preText.endsWith(".") ? preText : preText + ".");
        if (withDateTimeStamp) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(Calendar.getInstance().getTime());
            this.psErr.println(cal.get(1) + "-" + StringUtils.make2Chars(cal.get(2) + 1) + "-" + StringUtils.make2Chars(cal.get(5)) + " " + StringUtils.make2Chars(cal.get(11)) + ":" + StringUtils.make2Chars(cal.get(12)) + ":" + StringUtils.make2Chars(cal.get(13)) + ":" + StringUtils.make3Chars(cal.get(14)) + " " + pre + obj);
        } else {
            this.psErr.println(pre + obj);
        }
    }

    public void err2File(Throwable th) {
        this.err2File(th, null);
    }

    public void err2File(Throwable th, String preText) {
        String pre = null;
        pre = preText == null || preText.length() == 0 ? "" : (preText.endsWith(".") ? preText : preText + ".");
        if (th != null) {
            this.err2File("Details of Exception", true, pre);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream tmp = new PrintStream(baos);
            th.printStackTrace(tmp);
            this.err2File(new String(baos.toByteArray()), false, null);
        }
    }
}

