/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.javaframework.gui.table.celleditor;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;

public class DateTimeEditor
extends DefaultCellEditor {
    DateFormat dateTimeFormat;

    public DateTimeEditor(DateFormat dateTimeFormat) {
        super(new JFormattedTextField(dateTimeFormat));
        this.dateTimeFormat = dateTimeFormat;
        this.getEditor().setHorizontalAlignment(4);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object param) {
                Date _value = (Date)param;
                if (_value == null) {
                    DateTimeEditor.this.getEditor().setText(DateTimeEditor.this.dateTimeFormat.format(0.0));
                } else {
                    String _format = DateTimeEditor.this.dateTimeFormat.format(_value);
                    DateTimeEditor.this.getEditor().setText(_format);
                }
            }

            @Override
            public Object getCellEditorValue() {
                try {
                    String _field = DateTimeEditor.this.getEditor().getText();
                    if (_field != null && _field.length() > 0) {
                        return DateTimeEditor.this.dateTimeFormat.parse(_field);
                    }
                    return null;
                }
                catch (ParseException ex) {
                    Logger.getLogger(DateTimeEditor.class.getName()).log(Level.SEVERE, null, ex);
                    return null;
                }
            }
        };
    }

    public JTextField getEditor() {
        return (JFormattedTextField)this.getComponent();
    }
}

