/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.javaframework.picker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DatePicker {
    private int month = Calendar.getInstance().get(2);
    private int year = Calendar.getInstance().get(1);
    private JLabel l = new JLabel("", 0);
    private String day = "";
    private JDialog d;
    private JButton[] button = new JButton[49];
    private String myTitle = "Date Picker";

    public DatePicker(JFrame parent) {
        this(parent, null);
    }

    public DatePicker(JFrame parent, String title) {
        if (title != null) {
            this.myTitle = title;
        }
        this.d = new JDialog();
        this.d.setModal(true);
        String[] header = null;
        header = new String[7];
        if ("de".compareTo(Locale.getDefault().toString()) == 0) {
            header[0] = "Sun";
            header[1] = "Mon";
            header[2] = "Tue";
            header[3] = "Wed";
            header[4] = "Thur";
            header[5] = "Fri";
            header[6] = "Sat";
        } else {
            header[0] = "So";
            header[1] = "Mo";
            header[2] = "Di";
            header[3] = "Mi";
            header[4] = "Do";
            header[5] = "Fr";
            header[6] = "Sa";
        }
        JPanel p1 = new JPanel(new GridLayout(7, 7));
        p1.setPreferredSize(new Dimension(450, 200));
        for (int x = 0; x < this.button.length; ++x) {
            final int selection = x;
            this.button[x] = new JButton();
            this.button[x].setFocusPainted(false);
            this.button[x].setBackground(Color.white);
            if (x > 6) {
                this.button[x].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        DatePicker.this.day = DatePicker.this.button[selection].getActionCommand();
                        DatePicker.this.d.dispose();
                    }
                });
            }
            if (x < 7) {
                this.button[x].setText(header[x]);
                this.button[x].setForeground(Color.red);
            }
            p1.add(this.button[x]);
        }
        JPanel p2 = new JPanel(new GridLayout(1, 3));
        JButton previous = null;
        previous = "de".compareTo(Locale.getDefault().toString()) == 0 ? new JButton("<< zur\u00fcck") : new JButton("<< Previous");
        previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DatePicker.this.month--;
                DatePicker.this.displayDate();
            }
        });
        p2.add(previous);
        p2.add(this.l);
        JButton next = null;
        next = "de".compareTo(Locale.getDefault().toString()) == 0 ? new JButton("Weiter >>") : new JButton("Next >>");
        next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DatePicker.this.month++;
                DatePicker.this.displayDate();
            }
        });
        p2.add(next);
        this.d.add((Component)p1, "Center");
        this.d.add((Component)p2, "South");
        this.d.setResizable(false);
        this.d.pack();
        this.d.setLocationRelativeTo(parent);
        this.displayDate();
        this.d.setVisible(true);
    }

    private void displayDate() {
        for (int x = 7; x < this.button.length; ++x) {
            this.button[x].setText("");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("MMMM yyyy");
        Calendar cal = Calendar.getInstance();
        cal.set(this.year, this.month, 1);
        int dayOfWeek = cal.get(7);
        int daysInMonth = cal.getActualMaximum(5);
        int x = 6 + dayOfWeek;
        for (int day = 1; day <= daysInMonth; ++day) {
            this.button[x].setText("" + day);
            ++x;
        }
        this.l.setText(sdf.format(cal.getTime()));
        this.d.setTitle(this.myTitle);
    }

    public String getPickedDate() {
        if (this.day.equals("")) {
            return this.day;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        Calendar cal = Calendar.getInstance();
        cal.set(this.year, this.month, Integer.parseInt(this.day));
        return sdf.format(cal.getTime());
    }
}

