/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.strings;

import at.glawar.constants.GeneralConstants;
import at.glawar.constants.LanguageConstants;

public class StringUtil {
    private static StringUtil self = new StringUtil();

    private StringUtil() {
    }

    public static StringUtil getHandle() {
        return self;
    }

    public String replaceDoubleBackslash(String strInput) {
        String strRet = null;
        if (strInput != null) {
            strRet = strInput.replace('\\', '/');
        }
        return strRet;
    }

    public String makeTwoChars(String inputStr) {
        String returnValue = inputStr;
        if (returnValue.length() < 2) {
            returnValue = "0" + returnValue;
        }
        return returnValue;
    }

    public String makeTwoChars(int inputInt) {
        return this.makeTwoChars("" + inputInt);
    }

    public String makeThreeChars(int iValue) {
        String strRet = "";
        if (iValue < 100) {
            strRet = "0";
        }
        if (iValue < 10) {
            strRet = String.valueOf(strRet) + "0";
        }
        strRet = String.valueOf(strRet) + iValue;
        return strRet;
    }

    public boolean containsBlanks(String strText) {
        if (strText == null) {
            return false;
        }
        return strText.indexOf(" ") != -1;
    }

    public boolean containsApostrophe(String strText) {
        return this.containsDoubleApostrophe(strText) || this.containsSingleApostrophe(strText);
    }

    public boolean containsSingleApostrophe(String strText) {
        if (strText == null) {
            return false;
        }
        return strText.indexOf("'") != -1;
    }

    public boolean containsDoubleApostrophe(String strText) {
        if (strText == null) {
            return false;
        }
        return strText.indexOf("\"") != -1;
    }

    public String replaceStr(String strOriginal, String strFind, String strReplacement) {
        int pos = 0;
        if (strOriginal != null) {
            pos = strOriginal.indexOf(strFind);
            while (pos >= 0) {
                strOriginal = String.valueOf(strOriginal.substring(0, pos)) + strReplacement + strOriginal.substring(pos + strFind.length());
                pos = strOriginal.indexOf(strFind, pos + strReplacement.length());
            }
        }
        return strOriginal;
    }

    public boolean compareSimpleFormats(String strText1, String strText2) {
        return this.compareSimpleFormats(strText1, strText2, GeneralConstants.ALPHABET_UPPERCASE);
    }

    public boolean compareSimpleFormats(String strText1, String strText2, String strAllowedCharacters) {
        String strTemp1 = "";
        String strTemp2 = "";
        if (strText1 != null) {
            strTemp1 = this.transformIntoSimpleFormat(strText1, strAllowedCharacters);
        }
        if (strText2 != null) {
            strTemp2 = this.transformIntoSimpleFormat(strText2, strAllowedCharacters);
        }
        return strTemp1.compareTo(strTemp2) == 0;
    }

    public String transformIntoSimpleFormat(String strText) {
        return this.transformIntoSimpleFormat(strText, GeneralConstants.ALPHABET_UPPERCASE);
    }

    public String transformIntoSimpleFormat(String strText, String strAllowedCharacters) {
        if (strText == null) {
            return null;
        }
        String strRet = strText.toUpperCase();
        strRet = this.replaceStr(strRet, LanguageConstants.GERMANOE, "OE");
        strRet = this.replaceStr(strRet, LanguageConstants.GERMANAE, "AE");
        strRet = this.replaceStr(strRet, LanguageConstants.GERMANUE, "UE");
        strRet = this.replaceStr(strRet, LanguageConstants.GERMANSZ, "SS");
        char[] caText = strRet.toCharArray();
        strRet = "";
        int i = 0;
        while (i < caText.length) {
            if (strAllowedCharacters.indexOf(caText[i]) != -1) {
                strRet = String.valueOf(strRet) + caText[i];
            }
            ++i;
        }
        return strRet;
    }
}

