#!/bin/sh 
# 
# Authors: Franz-Peter Glawar, 2012
#
# Installation fuer OPList
#
# Bei der Installation koennen folgende Parameter angegeben werden:
# * --install              fuehrt die Installation durch
# * --help                 zeigt die Hilfe an
# * --schema SCHEMANAME    benutzt SCHEMANAME als Schema
# * --sid LMS              benutzt LMS als SID
# * --target /www/htdocs   benutzt /www/htdocs als Targetverzeichnis
# * --group www            benutzt www als Gruppe
#
######################################################################
# v2011-11-29 Paco erste Installations-Version
# v2011-11-30 Paco Erweiterung, so dass nicht irrtuemlich ohne Parameter
#                  installiert wird --> --install-Parameter notwendig
# v2014-07-21 Paco Erweiterung, dass ein Update-Skript erzeugt wird
######################################################################
TARGETDIR=/srv/www/htdocs
APPDIR=/u01/app
ZIPFILE=oplist.tgz
SCHEMA=SYSADM
SID=LMS
USER=root
GROUP=www
DEBUG=0
INSTALLYES=0
WITH_DB_MODEL=1
######################################################################


#---------------------------------------------------------------------
# Ueberprueft, ob der angemeldete Benutzer ROOT ist
#---------------------------------------------------------------------
checkIfRoot() {
    if [ ! "`id -u`" -eq 0 ]; then
        echo "Du bist leider nicht root"
        exit 1
    fi
}


#---------------------------------------------------------------------
# Ueberprueft, ob der angemeldete Benutzer ROOT ist
#---------------------------------------------------------------------
showExamples () {
    echo "Wird install.sh nur mit --install aufgerufen, so entspricht dies"
    echo "dem nachfolgendem Aufruf:"
    echo
    echo "Installation auf Apache:"
    echo "install.sh --install --schema OPLIST --sid LMS --target /srv/www/htdocs --group www"
    echo
    echo "Installation auf XAmp:"
    echo "install.sh --install --schema OPLIST --sid LMS --target /opt/lampp/htdocs --group www"
    echo
    echo "   --help                 zeigt die Hilfe an"
    echo
    echo "   --install              fuehrt die Installation durch"
    echo "   --schema SCHEMANAME    benutzt SCHEMANAME als Schema"
    echo "   --sid LMS              benutzt LMS als SID"
    echo "   --target /www/htdocs   benutzt /www/htdocs als Targetverzeichnis"
    echo "   --group www            benutzt www als Gruppe"
}


#---------------------------------------------------------------------
# Ueberprueft die angegebenen Parameter
#---------------------------------------------------------------------
checkParams () {
    READOPT=0
    UPDATEYES=0
    while [ ${READOPT} -eq 0 ]; do
        case ${1} in
            "--install")
                INSTALLYES=1
                shift
                ;;
            "--update")
                INSTALLYES=1
                UPDATEYES=1
                shift
                ;;
            "--schema")
                SCHEMA=${2}
                shift
                shift
                ;;
            "--sid")
                SID=${2}
                shift
                shift
                ;;
            "--target")
                TARGETDIR=${2}
                shift
                shift
                ;;
            "--group")
                GROUP=${2}
                shift
                shift
                ;;
            *)
                # if user option starts with '-'
                if [ ! "`echo $1 | grep -s '^-'`" = "" ] ; then
                    echo "unbekannte option $1"
                    exit 2
                else
                    # reading of users options finished
                    READOPT=1
                fi
        esac
    done
}


#---------------------------------------------------------------------
# Main
#---------------------------------------------------------------------
main() {
    #echo "Start hier"
    checkIfRoot
    
    if [ "${1}" = "--help" ]; then
        showExamples
        exit 0
    fi
    #echo "A"
    
    checkParams $*
    #echo "B"
    if [ ${INSTALLYES} -eq 0 ]; then
        showExamples
        exit 0
    fi
    
    echo "#!/bin/sh" > update.sh
    echo "#" >> update.sh
    echo "# Update-Script fuer OPList" >> update.sh
    echo "#" >> update.sh
    echo "./install.sh --update --schema ${SCHEMA} --sid ${SID} --target ${TARGETDIR} --group ${GROUP}" >> update.sh
    chmod 755 update.sh
    
    echo "Update <${UPDATEYES}>"
    
    if [ ${UPDATEYES} -eq 0 ]; then
        echo "Wir installieren das Datenmodell"
    else
        echo "Wir installieren nur die Updates und Inserts"
    fi
    
    echo "schema <${SCHEMA}>"
    echo "sid    <${SID}>"
    echo "target <${TARGETDIR}>"
    echo "group  <${GROUP}>"
    
    
    # only for testing
    #exit 0
    
    if [ ${DEBUG} -eq 0 ]; then
        # kopieren der Dateien
        cp ${ZIPFILE} ${TARGETDIR}
        cd ${TARGETDIR}
        
        # falls index.php bereits existiert (update) --> Sicherung
        if [ -f  ${TARGETDIR}/oplist/index.php ]; then
            cp ${TARGETDIR}/oplist/index.php ${TARGETDIR}/oplist/index.php_`date +%Y_%m_%d-%H_%M_%S`
        fi
        
        # Conf.ini aus template nehmen, sofern es noch nicht existiert
        if [ -f  ${TARGETDIR}/oplist/conf/oplist.ini ]; then
            echo "oplist.ini bereits vorhanden"
        else
            mv ${TARGETDIR}/oplist/conf/oplist.ini.template ${TARGETDIR}/oplist/conf/oplist.ini
        fi
        
        # extrahieren der Dateien
        tar xfvz ${ZIPFILE}
        
        # Rechte setzen
        chown -R root:${GROUP} oplist
        
        # Archiv loeschen
        rm ${ZIPFILE}
        
        
        # index.php fuer jedermann aenderbar machen
        cd oplist
        chmod g+r index.php
        chmod g+w index.php
        chmod o+r index.php
        chmod o+w index.php
        chmod 777 uploads
        
        # ueberpruefe ob es schon ein oplist.ini gibt
        if [ -f ${TARGETDIR}/oplist/conf/oplist.ini ]; then
            echo "${TARGETDIR}/oplist/conf/oplist.ini existiert bereits"
        else
            echo "Wir erstellen ${TARGETDIR}/oplist/conf/oplist.ini"
            cp ${TARGETDIR}/oplist/conf/oplist.ini.template ${TARGETDIR}/oplist/conf/oplist.ini
        fi
        
        # link in /u01/app/oplist erstellen (fuer einfacheres editieren)
        mkdir ${APPDIR}/oplist
        cd ${APPDIR}/oplist
        ln -sf ${TARGETDIR}/oplist/index.php .
        ln -sf ${TARGETDIR}/oplist/conf/oplist.ini .
        
        cd ${TARGETDIR}/oplist/doc
        if [ ${WITH_DB_MODEL} -eq 1 ]; then
            if [ ${UPDATEYES} -eq 0 ]; then
                echo "Wir installieren das Datenmodell"
                # Datenmodell ausfuehren
                sqlplus ${SCHEMA}/${SCHEMA}@${SID} @create-oracle-db-model-oplist.sql
            fi
        fi
        echo "Wir installieren die Updates und Inserts"
        sqlplus ${SCHEMA}/${SCHEMA}@${SID} @update-oracle-db-model-oplist.sql
        sqlplus ${SCHEMA}/${SCHEMA}@${SID} @merge-oracle-base-entries-oplist.sql
    else
        echo "Wir verwenden:"
        echo "install.sh --install --schema ${SCHEMA} --sid ${SID} --target ${TARGETDIR} --group ${GROUP}"
    fi

    exit 0
}

main $*
