SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
-- --------------------------------------------------------
--
-- Datenbank: oplist
--
-- --------------------------------------------------------
--
-- Tabellenstruktur für Tabelle OPLIST
--
CREATE TABLE IF NOT EXISTS OPLIST (
  OPID              bigint(20)          NOT NULL  AUTO_INCREMENT,
  OPDATECREATED     timestamp           NOT NULL  DEFAULT CURRENT_TIMESTAMP,
  OPDATEUPDATED     timestamp           NOT NULL  DEFAULT '0000-00-00 00:00:00',
  OPSID             bigint(20)          NOT NULL  DEFAULT '0',
  OPENTRY           varchar(4000)       NOT NULL,
  OPAID             bigint(20)          NOT NULL  DEFAULT '4',
  OPDESC            varchar(4000)                 DEFAULT NULL,
  OPPID             bigint(20)          NOT NULL  DEFAULT '4',
  OPPRIO            int(1)              NOT NULL  DEFAULT '0',
  OPUID_CREATED     bigint(20)          NOT NULL  DEFAULT '0',
  OPUID_UPDATED     bigint(20)          NOT NULL  DEFAULT '0',
  OPUID_ASSIGNED    bigint(20)          NOT NULL  DEFAULT '0',
  OPDELETED         int(1)              NOT NULL  DEFAULT '0',
  PRIMARY KEY (OPID),
  KEY IDX_OPLIST01 (OPSID),
  KEY IDX_OPLIST02 (OPAID),
  KEY IDX_OPLIST03 (OPPID),
  KEY IDX_OPLIST04 (OPUID_CREATED),
  KEY IDX_OPLIST05 (OPUID_UPDATED),
  KEY IDX_OPLIST06 (OPUID_ASSIGNED)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COMMENT='Tabelle zur Speicherung der OP-Punkte' AUTO_INCREMENT=1 ;
-- --------------------------------------------------------
--
-- Tabellenstruktur für Tabelle OPLIST_AREA
--
CREATE TABLE IF NOT EXISTS OPLIST_AREA (
  OPAID             bigint(20)          NOT NULL  AUTO_INCREMENT,
  OPATEXT           varchar(255)        NOT NULL,
  PRIMARY KEY (OPAID)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COMMENT='Tabelle zur Speicherung der Bereiche' AUTO_INCREMENT=100 ;
--
-- Daten für Tabelle OPLIST_AREA
--
INSERT INTO OPLIST_AREA (OPAID, OPATEXT) VALUES
(4, 'unbekannt'),
(10, 'Mechanik'),
(11, 'AT/Steuerung'),
(12, 'IT'),
(13, 'ISD');
-- --------------------------------------------------------
--
-- Tabellenstruktur für Tabelle OPLIST_COMMENT
--
CREATE TABLE IF NOT EXISTS OPLIST_COMMENT (
  OPCID             bigint(20)          NOT NULL  AUTO_INCREMENT,
  OPUID             bigint(20)          NOT NULL,
  OPCTEXT           varchar(4000)       NOT NULL,
  OPCDATE           timestamp           NOT NULL  DEFAULT CURRENT_TIMESTAMP,
  OPID              bigint(20)          NOT NULL,
  OPCPRIVATE        int(1)              NOT NULL  DEFAULT '0',
  OPCFILENAME       varchar(20)                   DEFAULT NULL,
  PRIMARY KEY (OPCID),
  KEY IDX_COMMENT01 (OPUID),
  KEY IDX_COMMENT02 (OPID)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COMMENT='Tabelle zur Speicherung der Benutzerkommentare' AUTO_INCREMENT=1 ;
-- --------------------------------------------------------
--
-- Tabellenstruktur für Tabelle OPLIST_DEBUG
--
CREATE TABLE IF NOT EXISTS OPLIST_DEBUG (
  ERST              timestamp           NOT NULL  DEFAULT CURRENT_TIMESTAMP,
  VALUE             varchar(4000)                 DEFAULT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COMMENT='Logging-Tabelle';
-- --------------------------------------------------------
--
-- Tabellenstruktur für Tabelle OPLIST_FILE
--
CREATE TABLE IF NOT EXISTS OPLIST_FILE (
  OPFID             bigint(20)          NOT NULL  AUTO_INCREMENT,
  OPLFT             int(11)             NOT NULL,
  PRIMARY KEY (OPFID)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COMMENT='Hilfstabelle fuer Dateinamen' AUTO_INCREMENT=1 ;
-- --------------------------------------------------------
--
-- Tabellenstruktur für Tabelle OPLIST_GROUP
--
CREATE TABLE IF NOT EXISTS OPLIST_GROUP (
  OPGID             bigint(20)          NOT NULL  AUTO_INCREMENT,
  OPGTEXT           varchar(20)         NOT NULL,
  PRIMARY KEY (OPGID)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COMMENT='Tabelle zur Speicherung der Benutzergruppen' AUTO_INCREMENT=100 ;
--
-- Daten für Tabelle OPLIST_GROUP
--
INSERT INTO OPLIST_GROUP (OPGID, OPGTEXT) VALUES
(1, 'Administrator'),
(2, 'Kunde'),
(3, 'IBN'),
(4, 'PL/ATSYS/ITSYS');
-- --------------------------------------------------------
--
-- Tabellenstruktur für Tabelle OPLIST_PRODUCT
--
CREATE TABLE IF NOT EXISTS OPLIST_PRODUCT (
  OPPID             bigint(20)          NOT NULL  AUTO_INCREMENT,
  OPPTEXT           varchar(255)        NOT NULL,
  PRIMARY KEY (OPPID)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COMMENT='Tabelle zur Speicherung der Produkte' AUTO_INCREMENT=100 ;
--
-- Daten für Tabelle OPLIST_PRODUCT
--
INSERT INTO OPLIST_PRODUCT (OPPID, OPPTEXT) VALUES
(4, 'unbekannt'),
(10, 'Connector-SST'),
(11, 'MFR'),
(12, 'Infosystem'),
(13, 'CI_LOG'),
(14, 'Pick-By-Light'),
(15, 'Visualisierung'),
(16, 'Funk'),
(17, 'Simulation'),
(18, 'OP-List'),
(19, 'Datenbank'),
(20, 'Hardware'),
(21, 'SAP'),
(22, 'Malfunction'),
(23, 'SyncSevice'),
(24, 'javautil');
-- --------------------------------------------------------
--
-- Tabellenstruktur für Tabelle OPLIST_STAT
--
CREATE TABLE IF NOT EXISTS OPLIST_STAT (
  OPSID             bigint(20)          NOT NULL  AUTO_INCREMENT,
  OPSTEXT           varchar(200)        NOT NULL,
  PRIMARY KEY (OPSID)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COMMENT='Tabelle zur Speicherung der Stati' AUTO_INCREMENT=100 ;
--
-- Daten für Tabelle OPLIST_STAT
--
INSERT INTO OPLIST_STAT (OPSID, OPSTEXT) VALUES
(1, 'offen'),
(2, 'in Bearbeitung'),
(3, 'erledigt'),
(4, 'abgeschlossen');
-- --------------------------------------------------------
--
-- Tabellenstruktur für Tabelle OPLIST_USERS
--
CREATE TABLE IF NOT EXISTS OPLIST_USERS (
  OPUID             bigint(20)          NOT NULL  AUTO_INCREMENT,
  OPGID             bigint(20)          NOT NULL  DEFAULT '3',
  OPUUSERNAME       varchar(255)        NOT NULL,
  OPULNAME          varchar(255)        NOT NULL,
  OPUFNAME          varchar(255)        NOT NULL,
  OPUEMAIL          varchar(255)                  DEFAULT NULL,
  OPUPASSWORD       varchar(100)        NOT NULL  DEFAULT 'pwd',
  OPUACTIVE         int(1)              NOT NULL  DEFAULT '0',
  OPUDATE           timestamp           NOT NULL  DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (OPUID),
  KEY IDX_USERS01 (OPGID)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COMMENT='Tabelle zur Speicherung der Benutzer' AUTO_INCREMENT=100 ;
--
-- Daten für Tabelle OPLIST_USERS
--
INSERT INTO OPLIST_USERS (OPUID, OPGID, OPUUSERNAME, OPULNAME, OPUFNAME, OPUEMAIL, OPUPASSWORD, OPUACTIVE, OPUDATE) VALUES
(0, 3, 'nicht zugewiesen', 'unknown', 'unknown', NULL, 'KMndc4EVsjgTqGYvIWYj', 0, '2011-11-26 19:40:02'),
(1, 1, 'TSI', 'TSI', 'Systems Integration', 'gerfried@glawar.at', 'f51a239f51148ce4cd5b4a6df654dbc6', 1, '2011-11-26 19:41:57');
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
