<?PHP
######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2011
#
# Dieses PHP-File realisiert eine einfache OP-Liste.
#
#
# (c) www.glawar.at 2011-11-13
#
######################################################################
# Der Standardbenutzer ist admin mit dem Standardkennwort admin
######################################################################
####  History
#---------------------------------------------------------------------
# v2006-03-16 ds.it@gmx.de based on phpToDoList V0.1 beta
#                          GPL (GNU Public License)
# v2011-11-12 Paco einige Funktionen hinzugefuegt wie
#                  - Filter
#                  - Suche
#                  - eigene Bereiche/Produkte
# v2011-11-14 Paco erster Versuch einer Abindung an Oracle-DB
# v2011-11-19 Paco komplette Adaption an Oracle, Hinzufuegen von
#                  Kommentaren moeglich
# v2011-11-20 Paco Emailversand und Dateiupload hinzugefuegt
# v2011-11-22 Paco Dateiupload direkt in den Kommtar hinzugefuegt
# v2011-11-26 Paco Adaptierung Datenmodell MySQL
# v2011-11-27 Paco Adatierung der Sortierung und der Spaltenbreiten
# v2011-11-29 Paco Adaptierung auf Layout (feststehende Kopf- und
#                  Fusszeile)
# v2011-12-21 Paco Beim Update Kennwort fehlte im SQL-Select ein
#                  Leerzeichen
# v2014-07-03 Paco Neue Installation im Zuge Projekt OPO CI_LOG5
# v2014-07-04 Paco neue Email und neuer Link
# v2014-07-21 Paco es werden nur Konstateneinträge berücksichtigt, deren
#                  Statis ACTIVE=1 ist
# v2014-08-01 Paco Logging kann jetzt in eine Datei geleitet werden
#                  Parameter
#                  - detailLogging
#                  - logFile
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
# toggle for debug
ini_set("display_errors", "1");
error_reporting(E_ALL);
// read params from configuration-file
$iniParams = parse_ini_file("conf/oplist.ini");
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
# params from config-file
$projectName = $iniParams["projectName"];
$appUrl = $iniParams["appUrl"];
$usedb=$iniParams["usedb"];
$sqlHost = $iniParams["sqlHost"];
$mySqlDB = $iniParams["mySqlDB"];
$sqlUser = $iniParams["sqlUser"];
$sqlPass = $iniParams["sqlPass"];
$oracleServiceName = $iniParams["oracleServiceName"];
$sqlDB = $iniParams["sqlDB"];
$oracleUsername = $iniParams["oracleUsername"];
$oraclePassword = $iniParams["oraclePassword"];
$usePwdTransformation=$iniParams["usePwdTransformation"];
$mailModus = $iniParams["mailModus"];
$mailGroup = $iniParams["mailGroup"];
$debugMail = $iniParams["debugMail"];
$debugSQL = $iniParams["debugSQL"];
# global connection
$connection = null;
# overall action switch
$mode = "";
# output
$tmpHTML = "";
# change next value to 1 if you want to activate logging
$logConstant = $iniParams["detailLogging"];
$logFile = $iniParams["logFile"];
$configFile = 'conf/oplist.ini';
######################################################################


date_default_timezone_set('Europe/Vienna');
setlocale (LC_TIME, "de_DE");


$header = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN">
    <html><head>
    <title>'.$projectName.'</title>
    <link rel="stylesheet" type="text/css" href="oplist.css">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <script language="JavaScript" type="text/javascript" src="oplist.js"></script>
    </head>
    <body link="#0000FF" vlink="#0000FF">
    <div class="header"><img src="img/logo.jpg" width=114 height=48 border=0 alt="OPList">';

$footer = '</div><div class="footer"><small>&copy; 2011 by <a href="http://software.glawar.at/oplist/" target="_blank">OPList</a> v1.8.526 (2014-07-30)</small></div></body></html>';


session_start();

#unset($_SESSION['BUID']);
#unset($_SESSION['USERNAME']);
#session_unset();
#session_destroy();


#---------------------------------------------------------------------
# (c) www.glawar.at: ergibt YYY-MM-DD HH:MM:SS
#---------------------------------------------------------------------
function getActualDateAndTime() {
    return strftime("%Y-%m-%d %H:%M:%S");
}


#---------------------------------------------------------------------
# (c) www.glawar.at: schreibt den uebergebenen Text in das LogFile
#                    sofern $debugSQL im OPLIST.INI auf 1 gestellt wurde
#---------------------------------------------------------------------
function debugIntoFile($debugText){
    global $debugSQL;
    global $logFile;

    if ($debugSQL == 1) {
        #echo $debugText;
        file_put_contents($logFile, "[".getActualDateAndTime()."] ".$debugText."\n", FILE_APPEND | LOCK_EX);
    }
}


#---------------------------------------------------------------------
# (c) www.glawar.at: schreibt den uebergebenen Text in das LogFile
#                    sofern $logConstant auf 1 gestellt wurde
#---------------------------------------------------------------------
function logIntoFile($logText){
    global $logConstant;
    global $logFile;

    if ($logConstant == 1) {
        file_put_contents($logFile, "[".getActualDateAndTime()."] ".$logText."\n", FILE_APPEND | LOCK_EX);
    }
}

# Check new parameter and create them if necessary
if (!isset($logConstant)) {
    logIntoFile("Wir setzen detailLogging");
    $logConstant = 0;
    file_put_contents($configFile, "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents($configFile, "; # 1: detailliertes Logging in Datei wird aktiviert\n", FILE_APPEND | LOCK_EX);
    file_put_contents($configFile, "; # 0: detailliertes Logging ist deaktivert\n", FILE_APPEND | LOCK_EX);
    file_put_contents($configFile, "detailLogging = 0;\n", FILE_APPEND | LOCK_EX);
} else {
    logIntoFile("logConstant hat einen Wert - naemlich <".$logConstant.">");
}

if (!isset($logFile)) {
    logIntoFile("Wir setzen logFile");
    $logFile = 'log/oplist.log';
    file_put_contents($configFile, "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents($configFile, "; # Name der Logdatei\n", FILE_APPEND | LOCK_EX);
    file_put_contents($configFile, "logFile = log/oplist.log\n", FILE_APPEND | LOCK_EX);
} else {
    logIntoFile("configFile hat einen Wert - naemlich <".$configFile.">");
}


#---------------------------------------------------------------------
# (c) www.glawar.at: liefert in Abhaengigkeit der obigen Parameter in
#                    $connection eine gueltige Datenbankverbindung
#---------------------------------------------------------------------
function getConnection() {
    global $connection;
    global $usedb;
    global $sqlHost;
    global $sqlUser;
    global $sqlPass;
    global $sqlDB;
    global $oracleUsername;
    global $oraclePassword;
    global $oracleServiceName;
    global $mySqlDB;

    if ($usedb == "mysql") {
        #$connection = mysql_connect($sqlHost, $sqlUser, $sqlPass);
        $connection = mysqli_connect($sqlHost, $sqlUser, $sqlPass, $mySqlDB);
        if (!$connection) {
            echo "Kein Zugriff auf die MySQL-Datenbank moeglich: ".getError();
            exit;
        }

        /*if (!mysqli_select_db($mySqlDB)) {
            echo "Kann die Datenbank ".$mySqlDB." nicht auswaehlen: " . getError();
            exit;
        }*/
    } else if ($usedb == "oracle") {
        $connection = oci_connect ($oracleUsername, $oraclePassword, $oracleServiceName);
         if (!$connection) {
            echo "Kein Zugriff auf die Oracle-Datenbank moeglich: ".getError();
            exit;
        }
    }
}


#---------------------------------------------------------------------
# (c) www.glawar.at: schließt die offene DB-Connection $connection
#---------------------------------------------------------------------
function closeConnection(){
    global $connection;
    global $usedb;

    if ($usedb == "mysql") {
        mysqli_close($connection);
    } else if ($usedb == "oracle") {
        oci_close($connection);
    }
}


#---------------------------------------------------------------------
# (c) www.glawar.at: liefert in Abhaengigkeit der obigen Parameter
#                    eine gueltige Ressource
#---------------------------------------------------------------------
function getRessource ($query) {
    global $connection;
    global $usedb;

    #debugIntoDB ("getRessource: ".$query);

    if ($usedb == "mysql") {
        #$retVal = mysql_query($query, $connection);
        $retVal = mysqli_query($connection, $query);
    } else if ($usedb == "oracle") {
        $retVal = oci_parse($connection, $query);
        oci_execute($retVal);
    }

    return $retVal;
}

#---------------------------------------------------------------------
# (c) www.glawar.at: liefert in Abhaengigkeit der obigen Parameter
#                    den DB-Error
#---------------------------------------------------------------------
function getError () {
    global $usedb;

    if ($usedb == "mysql") {
        $retVal = mysql_error();
    } else if ($usedb == "oracle") {
        $retVal = oci_error();
    }
    return $retVal;
}


#---------------------------------------------------------------------
# (c) www.glawar.at: liefert in Abhaengigkeit der obigen Parameter
#                    die Anzahl der vom Select betroffenen Datensaetze
#                    Wurde als DB oracle gewaehlt, so liefert dieses
#                    Funktion bei einem Select KEINE korrekten Werte!!
#---------------------------------------------------------------------
function getAmountOfResults ($ressource) {
    global $usedb;

    if ($usedb == "mysql") {
        $retVal = mysql_num_rows($ressource);
    } else if ($usedb == "oracle") {
        $retVal = oci_num_rows($ressource);
    }
}


#---------------------------------------------------------------------
# (c) www.glawar.at: liefert in Abhaengigkeit der obigen Parameter
#                    einen Datensatz
#---------------------------------------------------------------------
function getRow ($ressource) {
    global $usedb;

    if ($usedb == "mysql") {
        #$retVal = mysql_fetch_assoc($ressource);
        $retVal = mysqli_fetch_assoc($ressource);
    } else if ($usedb == "oracle") {
        $retVal = oci_fetch_assoc($ressource);
    }

    return $retVal;
}


#---------------------------------------------------------------------
# (c) www.glawar.at: gibt die belegte Ressource wieder frei
#---------------------------------------------------------------------
function freeRessource($ressource){
    global $usedb;
    if ($usedb == "oracle") {
        oci_free_statement($ressource);
    }
}


#---------------------------------------------------------------------
# (c) www.glawar.at: Verschluesselt das Kennwort
#---------------------------------------------------------------------
function transformPwd ($pwd) {
    global $usePwdTransformation;

    if ($usePwdTransformation == "md5") {
        return md5($pwd);
    } else {
        return $pwd;
    }
}

#---------------------------------------------------------------------
# (c) www.glawar.at: Schreibt debugText in OPLIST_DEBUG
#---------------------------------------------------------------------
function debugIntoDB ($debugText) {
    global $debugSQL;

    $len = strlen($debugText);
    if ($len > 3995) {
        $len = 3995;
    }
    $content = substr($debugText, 0, $len);

    $sQuery = "INSERT INTO OPLIST_DEBUG (VALUE) VALUES ('".str_replace("'", "''", $content)."')";
    debugIntoFile ("Insert into Logging-Table: <".$sQuery.">");
    #if ($debugSQL == 1) {
    #    echo "<p><b>Insert into Logging-Table:</b>".$sQuery."</p>";
    #}
    $result = getRessource($sQuery);
    echo getError();
    freeRessource($result);
}


#---------------------------------------------------------------------
# (c) www.glawar.at: Holt die Email
#---------------------------------------------------------------------
function getEmailOfId ($userId) {
    global $debugSQL;

    $retVal = null;

    $sQuery = "SELECT DISTINCT OPUEMAIL FROM OPLIST_USERS WHERE OPUID = ".$userId." AND OPUACTIVE = 1 AND OPUEMAIL IS NOT NULL";
    debugIntoFile("Email-Select: <".$sQuery.">");
    #if ($debugSQL == 1) {
    #    echo "<p><b>Email-Select:</b>".$sQuery."</p>";
    #}
    $result = getRessource($sQuery);
    echo getError();
    while ($val = getRow($result)) {
        $retVal = $val['OPUEMAIL'];
    }
    echo getError();
    freeRessource($result);

    return $retVal;
}


#---------------------------------------------------------------------
# (c) www.glawar.at: MAIN
#---------------------------------------------------------------------

if  (isset($_POST['mode'])) {
    $mode = $_POST['mode'];
} elseif  (isset($_GET['mode'])) {
    $mode = $_GET['mode'];
}

getConnection();

if (!$connection) {
    echo "Keine Verbindung zur DB: " . getError();
    exit;
}

# keine Sonderzeichen fuer Username und Kennwort moeglich
$sanitizeUserPwd = "";


#---------------------------------------------------------------------
# (c) ds.it@gmx.de: Loescht die nicht erlaubten Zeichen aus dem
#                   uebergebenen String
# $string der zu ueberpruefende String
# $allowed Array der zusaetzlich erlaubten Zeichen
#---------------------------------------------------------------------
function sanitize($string, $allowed = array())    {
    $allow = "";

    if(!empty($allowed)) {
        foreach ($allowed as $value) {
            $allow .= "\\$value";
        }
    }

    if(is_array($string)){
        foreach ($string as $key => $clean) {
            $cleaned[$key] = preg_replace( "/[^{$allow}a-zA-Z0-9]/", "", $clean);
        }
    } else{
        $cleaned = preg_replace( "/[^{$allow}a-zA-Z0-9]/", "", $string );
    }

    return $cleaned;
}

# user logged in?
if (empty($_SESSION['OPUID']) || empty($_SESSION['OPGID'])) {
    # no -> redirect to login page

    if ( !empty($_POST['USER']) && !empty($_POST['PASS']) ) {
        $user = sanitize($_POST['USER'], $sanitizeUserPwd);
        $pass = sanitize($_POST['PASS'], $sanitizeUserPwd);

        $sQuery = "SELECT OPU.OPUID, OPU.OPGID, OPU.OPUEMAIL, OPU.OPULNAME, OPU.OPUFNAME, OPG.OPGTEXT FROM OPLIST_USERS OPU, OPLIST_GROUP OPG WHERE OPG.OPGID = OPU.OPGID AND OPU.OPUACTIVE = 1 AND UPPER(OPU.OPUUSERNAME) = UPPER('".$user."') AND OPU.OPUPASSWORD = '".transformPwd($pass)."'";
        debugIntoFile("Login-Select: <".$sQuery.">");
        #if ($debugSQL == 1) {
        #    echo "<p><b>Login-Select:</b>".$sQuery."</p>";
        #}
        $result = getRessource ($sQuery);
        echo getError();

        if (!$result) {
            echo "Anfrage ($sQuery) konnte nicht ausgefuehrt werden : " . getError();
            exit;
        }

        $userArr = array();
        $intCount = 0;

        while ($val = getRow($result)) {
            $_SESSION['OPUID']=$val['OPUID'];
            $_SESSION['OPUUSERNAME']=$user;
            $_SESSION['OPGID']=$val['OPGID'];
            $_SESSION['OPUEMAIL']=$val['OPUEMAIL'];
            $_SESSION['OPULNAME']=$val['OPULNAME'];
            $_SESSION['OPUFNAME']=$val['OPUFNAME'];
            $_SESSION['OPUPASSWORD']=transformPwd($pass);
            $_SESSION['OPGTEXT']=$val['OPGTEXT'];

            $intCount = $intCount + 1;
            header ("Location: index.php");
        }

        freeRessource($result);

        if ($intCount == 0) {
            echo "Benutzerkonto wurde deaktiviert! |".$intCount."|";
            exit;
        }
    } else {
        # Paco.Anmeldung an ToDo-Liste
        $tmpHTML = "<div id='content'><fieldset>
            <form method=post action=\"".$_SERVER['PHP_SELF']."\">
            <table border='0'><tr><td>
            <label for='user'>Benutzername</label></td><td><input class='textfield' type='text' name='USER'></td></tr><tr><td><label for='pass'>Kennwort</label></td><td><input class='textfield' type='password' name='PASS'></td></tr><tr><td colspan='2'><input type='submit' value='Anmelden'></td></tr></fieldset></form>
            </table>";
    }
} else {
    $header .= "
        <script src='sort.js'></script>
        <div class='menuBar'>";

    #if (isset($_SESSION['OPGID']) && $_SESSION['OPGID'] != "2") {
        $header .= "<a class='menuitem' title='Meine OP-Punke' href='javascript:ajx(\"userlist\");'><img src='img/home.png' width=32 height=32 border=0 hspace=10 alt='Meine OP-Punkte'></a>";
    #}

    $header .= "<a class='menuitem' title='Alle OP-Punke' href='javascript:ajx(\"list\")'><img hspace=10 src='img/list.png' width=32 height=32 border=0 alt='Alle OP-Punke'></a>";


    #if ($_SESSION['OPGID']=="1" || $_SESSION['OPGID']=="2" || $_SESSION['OPGID']=="4") {
        $header .= "<a class='menuitem' title='Neuer OP-Punkt' href='javascript:ajx(\"new\")'><img hspace=10 src='img/new.png' width=32 height=32 border=0 alt='Neuer OP-Punkt'></a>";
    #}

    $header .= "<a class='menuitem' title='Benutzerverwaltung' href='javascript:ajx(\"config\")'><img hspace=10 src='img/config.png' width=32 height=32 border=0 alt='Benutzerverwaltung'></a><a class='menuitem' title='Benutzerhinweise' href='javascript:ajx(\"help\");'><img hspace=10 src='img/help.png' width=32 height=32 border=0 alt='Benutzerhinweise'></a>";

    $header .= "</div>";


    $header .= "<div class='loggedInUser'> ".$_SESSION['OPULNAME']." ".$_SESSION['OPUFNAME']." (".$_SESSION['OPGTEXT'].")</div>";

    $header .= "<div class='filterMenuBar'>";


    $header .= "<form method='post' action=".$_SERVER['PHP_SELF'].">";
    $header .= "<select name='FISTAT' class='textSizeFilter'>";
    $header .= "<option value='-1'>Alle Stati</option>";

    $sQuery = "SELECT OPSID, OPSTEXT FROM OPLIST_STAT WHERE (ACTIVE=1) ORDER BY OPSID";
    debugIntoFile("Status-Select: <".$sQuery.">");
    #if ($debugSQL == 1) {
    #    echo "<p><b>Status-Select:</b>".$sQuery."</p>";
    #}
    $result = getRessource($sQuery);
    echo getError();
    $statArr = array();
    while ($rows = getRow($result )) {
        Array_push($statArr, $rows);
    }

    freeRessource($result);

    if (isset($_POST['FISTAT'])) {
        $_SESSION['FISTAT'] = $_POST['FISTAT'];
    } else {
        $_SESSION['FISTAT'] = "-1";
    }

    foreach ($statArr as $key => $val) {
        $tempSelected = "";
        if ($_SESSION['FISTAT'] == $val['OPSID']) {
            $tempSelected = " selected";
        }
        $header .=  "<option".$tempSelected." value='".$val['OPSID']."'>".$val['OPSTEXT']."</option>";
    }
    $header .= "</select>";

    $sQuery = "SELECT OPAID, OPATEXT FROM OPLIST_AREA WHERE (ACTIVE=1) ORDER BY OPATEXT";
    debugIntoFile("Bereichs-Select: <".$sQuery.">");
    #if ($debugSQL == 1) {
    #    echo "<p><b>Bereichs-Select:</b>".$sQuery."</p>";
    #}
    $result = getRessource($sQuery);
    echo getError();
    $typeArr = array();
    while ($rows = getRow($result )) {
        Array_push($typeArr,$rows);
    }

    freeRessource($result);

    if (isset($_POST['FIAREA'])) {
        $_SESSION['FIAREA'] = $_POST['FIAREA'];
    } else {
        $_SESSION['FIAREA'] = "-1";
    }

    $header .= "<select name='FIAREA' class='textSizeFilter'>";
    $header .= "<option value='-1'>Alle Bereiche</option>";
    foreach ($typeArr as $key => $val) {
        $tempSelected = "";
        if ($_SESSION['FIAREA'] == $val['OPAID']) {
            $tempSelected = " selected";
        }
        $header .=  "<option".$tempSelected." value='".$val['OPAID']."'>".$val['OPATEXT']."</option>";
    }
    $header .= "</select>";


    $sQuery = "SELECT OPPID, OPPTEXT FROM OPLIST_PRODUCT WHERE (ACTIVE=1) ORDER BY OPPTEXT";
    debugIntoFile("Produkte-Select: <".$sQuery.">");
    #if ($debugSQL == 1) {
    #    echo "<p><b>Produkte-Select:</b>".$sQuery."</p>";
    #}
    $result = getRessource($sQuery);
    echo getError();
    $productArr = array();

    while ($rows = getRow($result )) {
        Array_push($productArr,$rows);
    }
    freeRessource($result);


    if (isset($_POST['FIPROD'])) {
        $_SESSION['FIPROD'] = $_POST['FIPROD'];
    } else {
        $_SESSION['FIPROD'] = "-1";
    }

    $header .= "<select name='FIPROD' class='textSizeFilter'>";
    $header .= "<option value='-1'>Alle Produkte</option>";
    foreach ($productArr as $key => $val) {
        $tempSelected = "";
        if ($_SESSION['FIPROD'] == $val['OPPID']) {
            $tempSelected = " selected";
        }
        $header .=  "<option".$tempSelected." value='".$val['OPPID']."'>".$val['OPPTEXT']."</option>";
    }
    $header .= "</select>";

    $header .= "<input class='textsearchFilter' size='20' type=text name='SEARCHTXT'>";
    $header .= "<input type=submit value='Filter' name='FILTERME' class='textSize1'>";
    $header .= "</form>";
    $header .= "</div>
    <div class='logoutMenuBar'><a class='menuitem' title='Benutzer abmelden' href='?mode=logout'><img src='img/lock.png' width=32 height=32 border=0 hspace=5 alt='Benutzer abmelden'></a></div></div>
    <div id='content' style=''>";
    $sQuery = "SELECT * FROM OPLIST_USERS ORDER BY UPPER(OPUUSERNAME)";
    debugIntoFile("Benutzer-Select: <".$sQuery.">");
    #if ($debugSQL == 1) {
    #    echo "<p><b>Benutzer-Select:</b>".$sQuery."</p>";
    #}
    $result = getRessource($sQuery);
    echo getError();
    $userArr = array();

    while ($rows = getRow($result )) {
        Array_push($userArr, $rows);
    }
    freeRessource($result);

    if ($usedb == "mysql") {
        $dateNow = "now()";
    } else if ($usedb == "oracle") {
        $dateNow = "sysdate";
    }

    $OPENTRY = "";
    $OPAID = "";
    $OPPID = "";
    $OPDESC = "";
    $OPSID = "";
    $OPPRIO = "";
    $OPUID_ASSIGNED = "";

    $prioArr = array(0 => "Niedrig", 1 => "Normal", 2 => "Hoch");

    if (!empty($_POST['updateuser'])) {
        $OPUACTIVE = "0";
        if (isset ($_POST["OPUACTIVE"]) && $_POST["OPUACTIVE"] == "on") {
            $OPUACTIVE = "1";
        }

        if (!empty($_POST['OPUPASSWORD'])) {
            $tempPwdString = "OPUPASSWORD = '".transformPwd($_POST["OPUPASSWORD"])."', ";
        } else {
            $tempPwdString = " ";
        }

        $sQuery = "UPDATE OPLIST_USERS SET " .
            "OPUEMAIL = '" . $_POST["OPUEMAIL"] . "', " .
            "OPUUSERNAME = '" . $_POST["OPUUSERNAME"] . "', " .
            "OPUACTIVE = " . $OPUACTIVE . ", " .
            "OPULNAME = '" . $_POST["OPULNAME"] . "', " .
            "OPUFNAME = '" . $_POST["OPUFNAME"] . "', " .
            $tempPwdString.
            "OPGID = " . $_POST["OPGID"] .
            " WHERE OPUID = ".$_POST["OPUID"];

        debugIntoFile("Update-User-Select: <".$sQuery.">");
        #if ($debugSQL == 1) {
        #    echo "<p><b>Update-User-Select:</b>".$sQuery."</p>";
        #}
        $result = getRessource($sQuery);
        echo getError();
        freeRessource($result);
    } else if (!empty($_POST['UPDATEUSERME'])) {
        if (!empty($_POST['OPUPASSWORD'])) {
            $tempPwdString = "OPUPASSWORD = '".transformPwd($_POST["OPUPASSWORD"])."'";
        } else {
            $tempPwdString = " ";
        }

        $sQuery = "UPDATE OPLIST_USERS SET " .
            "OPUEMAIL = '" . $_POST["OPUEMAIL"] . "', " .
            "OPULNAME = '" . $_POST["OPULNAME"] . "', " .
            $tempPwdString.
            "OPUFNAME = '" . $_POST["OPUFNAME"] . "' " .
            "WHERE OPUID = ".$_POST["OPUID"];
        debugIntoFile("Update-User-Select: <".$sQuery.">");
        #if ($debugSQL == 1) {
        #    echo "<p><b>Update-User-Select:</b>".$sQuery."</p>";
        #}
        $result = getRessource($sQuery);
        echo getError();
        freeRessource($result);
        $_SESSION['OPUEMAIL']=$_POST['OPUEMAIL'];
        $_SESSION['OPULNAME']=$_POST['OPULNAME'];
        $_SESSION['OPUFNAME']=$_POST['OPUFNAME'];
    } else if (!empty($_POST['SAVEUSER'])) {
        $OPUACTIVE = "0";
        if ($_POST["OPUACTIVE"]=="on") {
            $OPUACTIVE ="1";
        }

        if ($usedb == "mysql") {
            #$dateNow = "'".date("d.m.Y, H:i \U\h\\r")."'";
            $dateNow = "now()";
            $nextId = "null";
        } else if ($usedb == "oracle") {
            $dateNow = "sysdate";
            $nextId = "oplistusers_seq.nextval";
        }

        $sQuery = "INSERT INTO OPLIST_USERS (OPUID, OPGID, OPUUSERNAME, OPULNAME, OPUFNAME, OPUEMAIL, OPUPASSWORD, OPUACTIVE, OPUDATE) VALUES (".$nextId.", ".$_POST["OPGID"].", '".
            $_POST["OPUUSERNAME"]."','".
            $_POST["OPULNAME"] . "', '" .
            $_POST["OPUFNAME"] . "', '" .
            $_POST["OPUEMAIL"] . "', '" .
            transformPwd($_POST["OPUPASSWORD"]) . "', " .
            $OPUACTIVE . ", ".$dateNow.")";
        debugIntoFile("Neuer-Benutzer-Select: <".$sQuery.">");
        #if ($debugSQL == 1) {
        #    echo "<p><b>Neuer-Benutzer-Select:</b>".$sQuery."</p>";
        #}
        $result = getRessource($sQuery);
        echo getError();
        freeRessource($result);
    } else if (!empty($_POST['deleteuser'])) {
        $sQuery = "DELETE FROM OPLIST_USERS WHERE OPUID = ".$_POST["OPUID"];
        debugIntoFile("Benutzer-Loeschen-Select: <".$sQuery.">");
        #if ($debugSQL == 1) {
        #    echo "<p><b>Benutzer-Loeschen:</b>".$sQuery."</p>";
        #}
        $result = getRessource($sQuery);
        echo getError();
        freeRessource($result);
    } /*else if (isset($_POST['ADD'])) {
        if (!empty($_POST['NEWUSER'])) {
            $sQuery = "INSERT INTO oplist_users VALUES('','" . sanitize($_POST['NEWUSER']) . "','','');";
            $result = getRessource($sQuery);
            echo getError();
        }
    }*/ else if (isset($_POST['save'])) {
        # lege neuen OP an
        if ($usedb == "mysql") {
            $dateNow = "now()";
            $nextId = "null";
        } else if ($usedb == "oracle") {
            $dateNow = "sysdate";
            $nextId="oplist_seq.nextval";
        }

        $OPUID_ASSIGNED = "0";
        if (!empty($_POST['OPUID_ASSIGNED'])){
            $OPUID_ASSIGNED = $_POST['OPUID_ASSIGNED'];
        }

        if ($_POST['OPPID'] == "-1") {
            $OPPID = "4";
        } else {
            $OPPID = $_POST['OPPID'];
        }

        if ($_POST['OPAID'] == "-1") {
            $OPAID = "4";
        } else {
            $OPAID = $_POST['OPAID'];
        }

        $sQuery = "INSERT INTO OPLIST (OPID, OPDATECREATED, OPDATEUPDATED, OPSID, OPENTRY, OPAID, OPDESC, OPPID, OPPRIO, OPUID_ASSIGNED, OPUID_CREATED, OPUID_UPDATED)  VALUES (".$nextId."," .
            $dateNow . ", ".$dateNow.", 1, " .
             "'" . str_replace("'","''",$_POST['OPENTRY']) . "'," .
            $OPAID . "," .
             "'" .str_replace("'","''",$_POST['OPDESC'])  . "'," .
            $OPPID . "," .
            $_POST['OPPRIO']. ",".
            $OPUID_ASSIGNED . ", ".$_SESSION['OPUID'].", ".$_SESSION['OPUID'].")";
        debugIntoFile("Neuer-OP-Select: <".$sQuery.">");
        #if ($debugSQL == 1) {
        #    echo "<p><b>Insert OP-Entry:</b>".$sQuery."</p>";
        #}
        #exit;
        $result = getRessource($sQuery);
        echo getError();
        freeRessource($result);
        #logIntoFile("I am the debug Tester");
        logIntoFile("mailModus <".$mailModus.">");
        logIntoFile("debugMail <".$debugMail.">");
        logIntoFile("debugSQL  <".$debugSQL.">");
        if ($mailModus == 1 || $mailModus == 2) {
            # wir schicken den Betroffenen eine Email
            $email['FROMMAIL'] = getEmailOfId ($_SESSION['OPUID']);
            $email['SUBJECT'] = $projectName." - Neuer OP-Punkt: ".$_POST['OPENTRY'];
            $email['MSG'] = "Der OP-Punkt\n\n".$_POST['OPENTRY']."\n\nwurde hinzugefuegt.";
            $email['HEADERS'] = "Return-path: ".$email['FROMMAIL']."\n";
            $email['HEADERS'] .= "From: <".$email['FROMMAIL'].">\n";
            $email['HEADERS'] .= "Reply-To: <".$email['FROMMAIL'].">\n";
            $sQuery = "SELECT DISTINCT OPUEMAIL FROM OPLIST_USERS WHERE (OPUID in (".$OPUID_ASSIGNED.") OR (OPGID = ".$mailGroup.")) AND OPUACTIVE = 1 AND OPUEMAIL IS NOT NULL AND OPUID != ".$_SESSION['OPUID'];
            debugIntoFile("Email-Select: <".$sQuery.">");
            #if ($debugSQL == 1) {
            #    echo "<p><b>Emails-Select for Inserting new OP entry:</b>".$sQuery."</p>";
            #}
            $result = getRessource($sQuery);
            echo getError();
            while ($val = getRow($result)) {
                logIntoFile("email <".$val['OPUEMAIL'].">");
                $email['TOMAIL'] = $val['OPUEMAIL'];
                debugIntoDB ($email['TOMAIL']."|".$email['SUBJECT']."|".$email['MSG']."|".$email['HEADERS']);
                if ($debugMail == 0) {
                    @mail($email['TOMAIL'], $email['SUBJECT'], $email['MSG'], $email['HEADERS']);
                }
            }
            freeRessource($result);
        }
    } else if (isset($_POST['addcomment'])) {
        $OPCPRIVATE = "0";

        if (isset ($_POST["OPCHANGESTATUS"]) && $_POST["OPCHANGESTATUS"] == "on") {
            // we will change the status directly
            if ($_SESSION['OPGID'] == 2) {
                logIntoFile("Status FERTIG von Kunde gesetzt");
                $NEWSTATUS=4;
            } else {
                logIntoFile("Status FERTIG von IBN oder SYS gesetzt");
                $NEWSTATUS=3;
            }
            if ($usedb == "mysql") {
                $sQuery = "UPDATE OPLIST set OPSID = ".$NEWSTATUS." WHERE OPID = ".$_POST["OPID"];
                debugIntoFile("Update-OP-auf-Fertig-Select: <".$sQuery.">");
                $result = getRessource($sQuery);
                echo getError();
                freeRessource($result);
            } else if ($usedb == "oracle") {
                $sQuery = "UPDATE OPLIST set OPSID = ".$NEWSTATUS." WHERE OPID = ".$_POST["OPID"];
                debugIntoFile("Update-OP-auf-Fertig-Select: <".$sQuery.">");
                $result = getRessource($sQuery);
                echo getError();
                freeRessource($result);
            }
        }


        if (isset ($_POST["OPCPRIVATE"]) && $_POST["OPCPRIVATE"] == "on") {
            $OPCPRIVATE = "1";
        }
        if ($usedb == "mysql") {
            $nextId = "null";
        } else if ($usedb == "oracle") {
            $nextId="OPLISTCOMMENT_SEQ.nextval";
        }

        if (!empty($_FILES['datei']['name'])) {
            if ($usedb == "mysql") {
                $sQuery = "INSERT INTO OPLIST_FILE (OPLFT) VALUES (1)";
                debugIntoFile("Naechste-File-Id-ermitteln-Select: <".$sQuery.">");
                #if ($debugSQL == 1) {
                #    echo "<p><b>Naechste File-Id ermitteln-Select:</b>".$sQuery."</p>";
                #}
                $result = getRessource($sQuery);
                freeRessource($result);

                $newFileName = mysql_insert_id();
            } else if ($usedb == "oracle") {
                $sQuery = "SELECT OPLISTFILENAME_SEQ.NEXTVAL FROM DUAL";
                debugIntoFile("Naechstes-Attachment-Select: <".$sQuery.">");
                #if ($debugSQL == 1) {
                #    echo "<p><b>Naechster Attachment-Select:</b>".$sQuery."</p>";
                #}
                $result = getRessource($sQuery);
                echo getError();
                while ($val = getRow($result)) {
                    $newFileName = $val['NEXTVAL'];
                }
                freeRessource($result);
            }

            $file_namerev = strrev($_FILES['datei']['name']);
            $parts = explode(".", $file_namerev);
            $endung = strrev($parts[0]);
            #echo "Dateiendung: ".$endung."<br>";
            $newFileName .= ".".$endung;
            #echo "A2".$newFileName."<br>";

            if (!move_uploaded_file($_FILES['datei']['tmp_name'], "uploads/".$newFileName)) {
                echo "Die Datei ".$_FILES['datei']['name']." konnte nicht gespeichert werden.";
            }
            $newFileName = "'".$newFileName."'";
        } else {
            $newFileName = "null";
        }

        $sQuery = "INSERT INTO OPLIST_COMMENT (OPCID, OPUID, OPCTEXT, OPID, OPCPRIVATE, OPCFILENAME) VALUES (".$nextId.", ".$_SESSION['OPUID'].", '".$_POST["OPCTEXT"]."', ".$_POST["OPID"].", ".$OPCPRIVATE.", ".$newFileName.")";
        debugIntoFile("Insert-Kommentar-Select: <".$sQuery.">");
        #if ($debugSQL == 1) {
        #    echo "<p><b>Insert-Kommentar:</b>".$sQuery."</p>";
        #}
        $result = getRessource($sQuery);
        echo getError();
        freeRessource($result);

        if ($usedb == "mysql") {
            $dateNow = "now()";
        } else if ($usedb == "oracle") {
            $dateNow = "sysdate";
        }

        $sQuery = "UPDATE OPLIST SET OPDATEUPDATED = ".$dateNow.", OPUID_UPDATED = ".$_SESSION['OPUID']." WHERE OPID = ".$_POST["OPID"];
        debugIntoFile("Aktualisiere-OP-Select: <".$sQuery.">");
        #if ($debugSQL == 1) {
        #    echo "<p><b>Update-OP-Entry:</b>".$sQuery."</p>";
        #}
        $result = getRessource($sQuery);
        echo getError();
        freeRessource($result);


        if ($mailModus == 1) {
            $sendMail = 0;
            logIntoFile("Oeffentlicher Eintrag (0) <".$OPCPRIVATE.">");
            if ($OPCPRIVATE == 0) {
                logIntoFile("OP erhaelt einen oeffentlichen Kommentar --> Email an Eigentümer");
                # Email an OP-Ersteller
                #echo "Email an Eigentuemer";
                $sendMail = 1;
                $tempFromEmail = $_SESSION['OPUID'];
                $email['FROMMAIL'] = getEmailOfId ($_SESSION['OPUID']);
                $sQuery = "SELECT OPUID_ASSIGNED, OPUID_CREATED, OPENTRY FROM OPLIST WHERE OPID = ".$_POST['OPID'];
                debugIntoFile("Select: <".$sQuery.">");
                #if ($debugSQL == 1) {
                #    echo "<p><b>Select:</b>".$sQuery."</p>";
                #}
                $result = getRessource($sQuery);
                echo getError();
                while ($rows = getRow($result )) {
                    $assigned = $rows['OPUID_ASSIGNED'];
                    $oldUIdCreated = $rows['OPUID_CREATED'];
                    $opEntry = $rows['OPENTRY'];
                }
                freeRessource($result);
                $tempToMail = $oldUIdCreated;
            }
            if ($sendMail == 1) {
                $email['SUBJECT'] = $projectName." - Neuer Kommentar zu OP-Punk: ".$_POST['OPID']."-".$opEntry;
                $email['MSG'] = "Der OP-Punkt\n\n".$_POST['OPID']."-".$opEntry."\n\nerhielt einen neuen Kommentar.\n\n\n".$appUrl."/index.php?mode=comment&OPID=".$_POST["OPID"]."\n\n\n\n".$_POST["OPCTEXT"];
                $email['HEADERS'] = "Return-path: ".$email['FROMMAIL']."\n";
                $email['HEADERS'] .= "From: <".$email['FROMMAIL'].">\n";
                $email['HEADERS'] .= "Reply-To: <".$email['FROMMAIL'].">\n";
                $sQuery = "SELECT DISTINCT OPUEMAIL FROM OPLIST_USERS WHERE (OPUID in (".$tempToMail.",".$assigned.") OR (OPGID = ".$mailGroup.")) AND OPUACTIVE = 1 AND OPUEMAIL IS NOT NULL AND OPUID != ".$_SESSION['OPUID'];
                debugIntoFile("Select: <".$sQuery.">");
                #if ($debugSQL == 1) {
                #    echo "<p><b>Select:</b>".$sQuery."</p>";
                #}
                $result = getRessource($sQuery);
                echo getError();
                while ($val = getRow($result)) {
                    $email['TOMAIL'] = $val['OPUEMAIL'];
                    debugIntoDB ($email['TOMAIL']."|".$email['SUBJECT']."|".$email['MSG']."|".$email['HEADERS']);
                    if ($debugMail == 0) {
                        @mail($email['TOMAIL'], $email['SUBJECT'], $email['MSG'], $email['HEADERS']);
                    }
                }
                freeRessource($result);
            }
        }

        if ($mailModus == 2) {
            # wir schicken immer eime Email
            $sQuery = "SELECT OPUID_ASSIGNED, OPENTRY, OPUID_CREATED FROM OPLIST WHERE OPDELETED = 0 AND OPID = ".$_POST["OPID"];
            debugIntoFile("OP4Email-Select: <".$sQuery.">");
            #if ($debugSQL == 1) {
            #    echo "<p><b>OP-Entry4Email-Select:</b>".$sQuery."</p>";
            #}
            $result = getRessource($sQuery);
            $AssignedUser = 0;
            $OPName = null;
            $Owner = 0;
            echo getError();
            while ($val = getRow($result)) {
                $AssignedUser = $val['OPUID_ASSIGNED'];
                $OPName = $val['OPENTRY'];
                $Owner = $val['OPUID_CREATED'];
            }
            freeRessource($result);


            $email['FROMMAIL'] = getEmailOfId ($_SESSION['OPUID']);
            $email['SUBJECT'] = $projectName." - Update OP-Punk: ".$OPName;
            $email['MSG'] = "Der OP-Punkt\n\n".$OPName."\n\nwurde aktualisiert.\n\n\n".$appUrl."/index.php?mode=comment&OPID=".$_POST["OPID"];
            $email['HEADERS'] = "Return-path: ".$email['FROMMAIL']."\n";
            $email['HEADERS'] .= "From: <".$email['FROMMAIL'].">\n";
            $email['HEADERS'] .= "Reply-To: <".$email['FROMMAIL'].">\n";

            $sQuery = "SELECT DISTINCT OPUEMAIL FROM OPLIST_USERS WHERE (OPUID in (".$AssignedUser.") OR (OPGID = ".$mailGroup.")) AND OPUACTIVE = 1 AND OPUEMAIL IS NOT NULL AND OPUID != ".$_SESSION['OPUID'];
            debugIntoFile("Email-Select: <".$sQuery.">");
            #if ($debugSQL == 1) {
            #    echo "<p><b>Email-Select:</b>".$sQuery."</p>";
            #}
            $result = getRessource($sQuery);
            echo getError();
            while ($val = getRow($result)) {
                $email['TOMAIL'] = $val['OPUEMAIL'];
                debugIntoDB ($email['TOMAIL']."|".$email['SUBJECT']."|".$email['MSG']."|".$email['HEADERS']);
                if ($debugMail == 0) {
                    @mail($email['TOMAIL'], $email['SUBJECT'], $email['MSG'], $email['HEADERS']);
                }
            }
            freeRessource($result);

            #echo $Owner."|".$_SESSION['OPUID'];
            if ($Owner != $_SESSION['OPUID']) {
                $email['TOMAIL'] = getEmailOfId ($Owner);
                debugIntoDB ($email['TOMAIL']."|".$email['SUBJECT']."|".$email['MSG']."|".$email['HEADERS']);
                if ($debugMail == 0) {
                    @mail($email['TOMAIL'], $email['SUBJECT'], $email['MSG'], $email['HEADERS']);
                }
            }
        }
    } else if (isset($_POST['update'])) {
        # Update Bug-Eintrag
        if ($_POST['OPAID'] == "-1") {
            $OPAID = "4";
        } else {
            $OPAID = $_POST['OPAID'];
        }

        if ($_POST['OPPID'] == "-1") {
            $OPPID = "4";
        } else {
            $OPPID = $_POST['OPPID'];
        }

        $oldBugStatus = 0;
        $sQuery = "SELECT OPSID, OPUID_CREATED, OPUID_ASSIGNED FROM OPLIST WHERE OPID = ".$_POST['OPID'];
        debugIntoFile("Select: <".$sQuery.">");
        #if ($debugSQL == 1) {
        #    echo "<p><b>Select:</b>".$sQuery."</p>";
        #}
        $result = getRessource($sQuery);
        echo getError();
        while ($rows = getRow($result )) {
            $oldBugStatus = $rows['OPSID'];
            $oldUIdCreated = $rows['OPUID_CREATED'];
            $oldUIdAssigned = $rows['OPUID_ASSIGNED'];
        }
        freeRessource($result);
        #echo "OldStatus".$oldBugStatus;
        #echo "Erstreller".$oldUIdCreated;
        #echo "Zugewiesen".$oldUIdAssigned;

        if ($usedb == "mysql") {
            $dateNow = "now()";
        } else if ($usedb == "oracle") {
            $dateNow = "sysdate";
        }

        $sQuery = "UPDATE OPLIST SET
            OPDATEUPDATED = ".$dateNow.",
            OPSID = ".$_POST['OPSID'].",
            OPENTRY = '".str_replace("'", "''", $_POST['OPENTRY'])."',
            OPAID = ".$OPAID.",
            OPDESC = '".str_replace("'", "''", $_POST['OPDESC'])."',
            OPPID = ".$OPPID.",
            OPPRIO = ".$_POST['OPPRIO'].",
            OPUID_UPDATED = ".$_SESSION['OPUID'].",
            OPUID_ASSIGNED = ".$_POST['OPUID_ASSIGNED']."
            WHERE OPID = ".$_POST['OPID'];
        debugIntoFile("Aktualisiere-OP-Select: <".$sQuery.">");
        #if ($debugSQL == 1) {
        #    echo "<p><b>Update-OP-Entry:</b>".$sQuery."</p>";
        #}
        $result = getRessource($sQuery);
        echo getError();
        freeRessource($result);

        if ($mailModus == 1) {
            $sendMail = 0;
            logIntoFile("New Assigned to <".$_POST['OPUID_ASSIGNED'].">");
            logIntoFile("New OP-Status   <".$_POST['OPSID'].">");
            logIntoFile("oldUIdAssigned  <".$oldUIdAssigned.">");
            logIntoFile("oldOPStatus     <".$oldBugStatus.">");
            if ($oldUIdAssigned == 0 && $_POST['OPUID_ASSIGNED'] != 0) {
                logIntoFile("OP war nicht zugewiesen und ist nun zugewiesen --> Email an zugewiesenen IBN");
                # Email an zugewiesenen IBN
                #echo "Email an IBN";
                $sendMail = 1;
                $tempFromEmail = $oldUIdCreated;
                $email['FROMMAIL'] = getEmailOfId ($oldUIdCreated);
                $tempToMail = $_POST['OPUID_ASSIGNED'];
            } else if (($oldBugStatus == 1 || $oldBugStatus == 2) && $_POST['OPSID'] == 3) {
                logIntoFile("OP hatte Status offen oder in Bearbeitung und wechselt nun zu erledigt --> Email an OP-Eigentümer");
                # Email an OP-Ersteller
                #echo "Email an Eigentuemer";
                $sendMail = 1;
                $tempFromEmail = $_SESSION['OPUID'];
                $email['FROMMAIL'] = getEmailOfId ($_SESSION['OPUID']);
                $tempToMail = $oldUIdCreated;
            } else if ((($oldBugStatus == 3 || $oldBugStatus == 4) && $_POST['OPSID'] != $oldBugStatus) || (($oldBugStatus == 1 || $oldBugStatus == 2 || $oldBugStatus == 3) && $_POST['OPSID'] == 4))  {
                logIntoFile("OP hatte Status erledigt oder abgeschlossen und der Status wurde auf offen oder in Bearbeitung gestellt --> Email an zugewiesenen IBN");
                logIntoFile("oder: OP hatte Status offen, in Bearbeitung oder erledigt und wird auf Status abgeschlossen gedreht --> Email an IBN");
                # Email an zugewiesenen IBN
                #echo "Email an IBN2";
                $sendMail = 1;
                $tempFromEmail = $oldUIdCreated;
                $email['FROMMAIL'] = getEmailOfId ($oldUIdCreated);
                $tempToMail = $_POST['OPUID_ASSIGNED'];
            }
            if ($sendMail == 1) {
                $email['SUBJECT'] = $projectName." - Update OP-Punk: ".$_POST['OPID']."-".$_POST['OPENTRY'];
                $email['MSG'] = "Der OP-Punkt\n\n".$_POST['OPID']."-".$_POST['OPENTRY']."\n\nwurde aktualisiert.\n\n\n".$appUrl."/index.php?mode=comment&OPID=".$_POST["OPID"];
                $email['HEADERS'] = "Return-path: ".$email['FROMMAIL']."\n";
                $email['HEADERS'] .= "From: <".$email['FROMMAIL'].">\n";
                $email['HEADERS'] .= "Reply-To: <".$email['FROMMAIL'].">\n";
                $sQuery = "SELECT DISTINCT OPUEMAIL FROM OPLIST_USERS WHERE (OPUID in (".$tempToMail.") OR (OPGID = ".$mailGroup.")) AND OPUACTIVE = 1 AND OPUEMAIL IS NOT NULL AND OPUID != ".$_SESSION['OPUID'];
                debugIntoFile("Email-Select: <".$sQuery.">");
                #if ($debugSQL == 1) {
                #    echo "<p><b>Email-Select:</b>".$sQuery."</p>";
                #}
                $result = getRessource($sQuery);
                echo getError();
                while ($val = getRow($result)) {
                    $email['TOMAIL'] = $val['OPUEMAIL'];
                    debugIntoDB ($email['TOMAIL']."|".$email['SUBJECT']."|".$email['MSG']."|".$email['HEADERS']);
                    if ($debugMail == 0) {
                        @mail($email['TOMAIL'], $email['SUBJECT'], $email['MSG'], $email['HEADERS']);
                    }
                }
                freeRessource($result);
            }
        } else if ($mailModus == 2) {
            $email['FROMMAIL'] = getEmailOfId ($oldUIdCreated);
            $email['SUBJECT'] = $projectName." - Update OP-Punk: ".$_POST['OPENTRY'];
            $email['MSG'] = "Der OP-Punkt\n\n".$_POST['OPENTRY']."\n\nwurde aktualisiert.\n\n\n".$appUrl."/index.php?mode=comment&OPID=".$_POST["OPID"];
            $email['HEADERS'] = "Return-path: ".$email['FROMMAIL']."\n";
            $email['HEADERS'] .= "From: <".$email['FROMMAIL'].">\n";
            $email['HEADERS'] .= "Reply-To: <".$email['FROMMAIL'].">\n";
            $sQuery = "SELECT DISTINCT OPUEMAIL FROM OPLIST_USERS WHERE (OPUID in (".$_POST['OPUID_ASSIGNED'].") OR (OPGID = ".$mailGroup.")) AND OPUACTIVE = 1 AND OPUEMAIL IS NOT NULL AND OPUID != ".$_SESSION['OPUID'];
            debugIntoFile("Email-Select: <".$sQuery.">");
            #if ($debugSQL == 1) {
            #    echo "<p><b>Email-Select:</b>".$sQuery."</p>";
            #}
            $result = getRessource($sQuery);
            echo getError();
            while ($val = getRow($result)) {
                $email['TOMAIL'] = $val['OPUEMAIL'];
                debugIntoDB ($email['TOMAIL']."|".$email['SUBJECT']."|".$email['MSG']."|".$email['HEADERS']);
                if ($debugMail == 0) {
                    @mail($email['TOMAIL'], $email['SUBJECT'], $email['MSG'], $email['HEADERS']);
                }
            }
            freeRessource($result);
        }
    }

    $tempFilter = "";
    if (isset($_POST['FILTERME'])) {
        if (isset($_POST['FISTAT'])) {
            if ($_POST['FISTAT'] != "-1") {
                $tempFilter = " AND OP.OPSID = ".$_POST['FISTAT'];
            }
        }
        #echo $tempFilter;
        if (isset($_POST['FIAREA'])) {
            if ($_POST['FIAREA'] != "-1") {
                $tempFilter .= " AND OP.OPAID = ".$_POST['FIAREA'];
            }
        }
        if (isset($_POST['FIPROD'])) {
            if ($_POST['FIPROD'] != "-1") {
                $tempFilter .= " AND OP.OPPID = ".$_POST['FIPROD'];
            }
        }

        if (isset($_POST['SEARCHTXT'])) {
            if ($_SESSION['OPGID'] == "2") {
                $tempFilter .= " AND (UPPER(OP.OPENTRY) LIKE UPPER('%".$_POST['SEARCHTXT']."%') OR OP.OPID IN (SELECT OPC.OPID FROM OPLIST_COMMENT OPC WHERE upper(OPC.OPCTEXT) LIKE UPPER('%".$_POST['SEARCHTXT']."%') AND OPC.OPID = OP.OPID AND OPC.OPCPRIVATE = 0))";
            } else {
                $tempFilter .= " AND (
        UPPER(OP.OPENTRY) LIKE UPPER('%".$_POST['SEARCHTXT']."%') OR OP.OPID IN (SELECT OPC.OPID FROM OPLIST_COMMENT OPC WHERE UPPER(OPC.OPCTEXT) LIKE UPPER('%".$_POST['SEARCHTXT']."%') AND OPC.OPID = OP.OPID))";
            }
        }
    }

    if ($usedb == "mysql") {
        $beforeToChar = "";
        $afterToChar = "";
    } else if ($usedb == "oracle") {
        $beforeToChar = "TO_CHAR (";
        $afterToChar = ", 'DD.MM.YYYY HH24:MI')";
    }

    $sQuery = "SELECT OP.OPID, OP.OPSID, OPUC.OPUUSERNAME CREATEDUSER, OPS.OPSTEXT, OP.OPPRIO, OPA.OPATEXT, OPP.OPPTEXT, OP.OPENTRY, ".$beforeToChar."OP.OPDATECREATED".$afterToChar." OPDATECREATED, ".$beforeToChar."OP.OPDATEUPDATED".$afterToChar." OPDATEUPDATED, OP.OPUID_ASSIGNED, OPUU.OPUUSERNAME UPDATEDUSER, OP.OPAID, OP.OPPID, OPUA.OPUUSERNAME ASSIGNEDUSER
FROM OPLIST OP, OPLIST_AREA OPA, OPLIST_PRODUCT OPP, OPLIST_STAT OPS, OPLIST_USERS OPUU, OPLIST_USERS OPUC, OPLIST_USERS OPUA
WHERE OPA.OPAID = OP.OPAID
    AND OPP.OPPID = OP.OPPID
    AND OPS.OPSID = OP.OPSID
    AND OPUU.OPUID = OP.OPUID_UPDATED
    AND OP.OPDELETED = 0
    AND OP.OPUID_CREATED = OPUC.OPUID
    AND OPUA.OPUID = OP.OPUID_ASSIGNED".$tempFilter."
ORDER BY OP.OPSID ASC, OP.OPPRIO DESC, OP.OPDATEUPDATED DESC, OP.OPDATEUPDATED DESC";

    if (!empty($_GET['mode']) && $_GET['mode'] == "userlist") {
        if ($_SESSION['OPGID'] == '2') {
            # wir sind Kunde
            $groupFilter=" AND OP.OPUID_CREATED = '".$_SESSION['OPUID']."'";
        } else if ($_SESSION['OPGID'] == '3') {
            # wir sind IBN
            $groupFilter=" AND OP.OPUID_ASSIGNED = '".$_SESSION['OPUID']."'";
        } else {
            # wir sind SYS oder Admin
            $groupFilter=" AND OP.OPUID_ASSIGNED = '".$_SESSION['OPUID']."'";
        }
        $sQuery = "SELECT OP.OPID, OP.OPSID, OPUC.OPUUSERNAME CREATEDUSER, OPS.OPSTEXT, OP.OPPRIO, OPA.OPATEXT, OPP.OPPTEXT, OP.OPENTRY, ".$beforeToChar."OP.OPDATECREATED".$afterToChar." OPDATECREATED, ".$beforeToChar."OP.OPDATEUPDATED".$afterToChar." OPDATEUPDATED, OP.OPUID_ASSIGNED, OPUU.OPUUSERNAME UPDATEDUSER, OP.OPAID, OP.OPPID, OPUA.OPUUSERNAME ASSIGNEDUSER
FROM OPLIST OP, OPLIST_AREA OPA, OPLIST_PRODUCT OPP, OPLIST_STAT OPS, OPLIST_USERS OPUU, OPLIST_USERS OPUC, OPLIST_USERS OPUA
WHERE OPA.OPAID = OP.OPAID
    AND OPP.OPPID = OP.OPPID
    AND OPS.OPSID = OP.OPSID
    AND OPUU.OPUID = OP.OPUID_UPDATED
    AND OP.OPDELETED = 0
    AND OP.OPUID_CREATED = OPUC.OPUID
    AND OPUA.OPUID = OP.OPUID_ASSIGNED".$tempFilter.$groupFilter."
ORDER BY OP.OPSID ASC, OP.OPPRIO DESC, OP.OPDATEUPDATED DESC, OP.OPDATEUPDATED DESC";
    }
    debugIntoFile("OP-Listen-Select: <".$sQuery.">");
    #if ($debugSQL == 1) {
    #    echo "<p><b>OP-Listen-Select:</b>".$sQuery."</p>";
    #}
    $result = getRessource($sQuery);
    echo getError();
    $bugArr = array();
    while ($rows = getRow($result )) {
        Array_push($bugArr,$rows);
    }
    freeRessource($result);

    $sQuery = "SELECT OPGID, OPGTEXT FROM OPLIST_GROUP WHERE (ACTIVE=1) ORDER BY OPGTEXT";
    debugIntoFile("OP-Gruppen-Select: <".$sQuery.">");
    #if ($debugSQL == 1) {
    #    echo "<p><b>OP-Gruppen-Select:</b>".$sQuery."</p>";
    #}
    $result = getRessource($sQuery);
    echo getError();
    $grpArr = array();
    while ($rows = getRow($result )) {
        Array_push($grpArr,$rows);
    }
    freeRessource($result);

    if ($mode == "edit") {
        $sQuery = "SELECT * FROM OPLIST WHERE OPDELETED = 0 AND OPID = '".$_GET['OPID']."'";
        debugIntoFile("Select: <".$sQuery.">");
        #if ($debugSQL == 1) {
        #    echo $sQuery;
        #}
        $result = getRessource($sQuery);
        echo getError();
        while ($rows = getRow($result )) {
            $OPID         = $rows['OPID'];
            $OPDATECREATED   = $rows['OPDATECREATED'];
            $OPDATEUPDATED      = $rows['OPDATEUPDATED'];
            $OPSID      = $rows['OPSID'];
            $OPENTRY          = $rows['OPENTRY'];
            $OPAID      = $rows['OPAID'];
            $OPDESC      = $rows['OPDESC'];
            $OPPID      = $rows['OPPID'];
            $OPPRIO      = $rows['OPPRIO'];
            $OPUID_CREATED      = $rows['OPUID_CREATED'];
            $OPUID_UPDATED     = $rows['OPUID_UPDATED'];
            $OPUID_ASSIGNED         = $rows['OPUID_ASSIGNED'];
        }
        freeRessource($result);
    } else if ($mode == "del") {
        $sQuery = "UPDATE OPLIST SET OPDELETED = 1 WHERE OPID = '".$_GET['OPID']."'";
        debugIntoFile("Select: <".$sQuery.">");
        #if ($debugSQL == 1) {
        #    echo $sQuery;
        #}
        $result = getRessource($sQuery);
        echo getError();
        freeRessource($result);
    } /*else if ($mode=="savepwd") {
        $pass = sanitize($_POST['NEWPASS']);

        $sQuery = "UPDATE OPLIST_USERS SET OPUPASSWORD = '".transformPwd($OPUPASSWORD)."' WHERE OPUID = ".$_SESSION['OPUID'];
        $result = getRessource($sQuery);
    }*/

    if ($mode == "del") {
        $tmpHTML .= "Eintrag gel&ouml;scht.";
    } else if ($mode == "comment") {
        $sQuery = "SELECT * FROM OPLIST WHERE OPDELETED = 0 AND OPID = '".$_GET['OPID']."'";
        debugIntoFile("Select: <".$sQuery.">");
        #if ($debugSQL == 1) {
        #    echo $sQuery;
        #}
        $result = getRessource($sQuery);
        echo getError();
        while ($rows = getRow($result )) {
            $OPID    = $rows['OPID'];
            $OPENTRY = $rows['OPENTRY'];
            $OPDESC  = $rows['OPDESC'];
        }
        freeRessource ($result);
        $tmpHTML .= '
            <form method="post" name="addcommentform" enctype="multipart/form-data">
            <center>
            <table width=98% border="0" cellpadding=3 cellspacing=2>
            <tr bgcolor="#f0f0f0" >
            <td colspan=4 valign=center align=left>
            <b style="font-size:20px;">#'.$OPID .'&nbsp;'.$OPENTRY.'</b>
            </td>
            </tr>
            <tr bgcolor="#f0f0f0">
            <td>&nbsp;</td>
            <td colspan=3 valign=center align=left>
            <b style="font-size:14px;">'.nl2br($OPDESC).'</b>
            </td>
            </tr>
            <tr bgcolor="#f0f0f0">
            <td valign=top align=center style="width:20px;">&nbsp;</td>
            <td valign=top align=center style="width:*;">
            <b>Kommentar</b>
            </td>
            <td valign=top align=center style="width:110px;">
            <b>erstellt</b>
            </td>
            <td valign=top align=center style="width:50px;">
            <b>von</b>
            </td>
            </tr>';

        if ($_SESSION['OPGID'] == "2") {
            $tempSQL = " AND OPC.OPCPRIVATE = 0";
        } else {
            $tempSQL = "";
        }

        if ($usedb == "mysql") {
            $beforeToChar = "";
            $afterToChar = "";
        } else if ($usedb == "oracle") {
            $beforeToChar = "TO_CHAR (";
            $afterToChar = ", 'DD.MM.YYYY HH24:MI')";
        }

        $sQuery = "SELECT OPC.OPCFILENAME, OPC.OPCID, OPC.OPCTEXT, ".$beforeToChar."OPC.OPCDATE".$afterToChar." OPCDATE, OPU.OPUUSERNAME, OPC.OPCPRIVATE FROM OPLIST_COMMENT OPC, OPLIST_USERS OPU WHERE OPC.OPID = ".$_GET['OPID']." AND OPU.OPUID = OPC.OPUID".$tempSQL." ORDER BY OPC.OPCID";
        debugIntoFile("Select: <".$sQuery.">");
        #if ($debugSQL == 1) {
        #    echo $sQuery;
        #}
        $result = getRessource($sQuery);
        echo getError();
        while ($rows = getRow($result )) {
            if ($rows['OPCPRIVATE'] == "0") {
                $tmpHTML .=  "<tr style=\"background:#80FF80;\">";
            } else {
                $tmpHTML .=  "<tr style=\"background:#FF8040;\">";
            }

            if ($rows['OPCFILENAME'] != "") {
                $tmpHTML .= '<td valign=top align=left><a href="uploads/'.$rows['OPCFILENAME'].'" target=_newWindow><img src="img/file.png" width=16 height=16 border=0 alt="Dateianhang"></a></td>';
            } else {
                $tmpHTML .= '<td valign=top align=left>&nbsp;</td>';
            }

            $tmpHTML .= '
                <td valign=top align=left style="font-size:12px;">'.nl2br($rows['OPCTEXT']).'
                </td>
                <td valign=top align=left style="font-size:10px;">'.$rows['OPCDATE'].'
                </td>
                <td valign=top align=left style="font-size:10px;">'.$rows['OPUUSERNAME'].'
                </td>
                </tr>';
        }
        freeRessource ($result);
        $tmpHTML .= '
            <tr>
            <td></td>
            <td valign=top>
            <textarea name="OPCTEXT" style="width:750px;" rows=10></textarea>
            <input type="file" name="datei"><br>';
        if ($_SESSION['OPGID'] != "2") {
            $tmpHTML .= '
                <b>interner Kommentar:</b>&nbsp;<input name="OPCPRIVATE" type="checkbox" checked>';
        }
        $tmpHTML .= '
            <b>Status auf FERTIG stellen:</b>&nbsp;<input name="OPCHANGESTATUS" type="checkbox" unchecked>';
        $tmpHTML .= '

            </td>
            <td colspan=2 align=right valign=bottom>
            <input type="submit" name="addcomment" style="width:180px;" value="Kommentar hinzufuegen" onClick="return(checkAddComment(document.addcommentform.OPCTEXT.value));">
            <input type="hidden" name="OPID" value="'.$_GET['OPID'].'">
            </td>
            </tr>
            </table>
            </center>
            </form>
            <br><br><br>';
    } else if ($mode == "new" || $mode == "edit") {
        $tmpHTML .= '
            <form method="post" action="'.$_SERVER['PHP_SELF'].'" name="opform">
            <table width=100% border="0" cellpadding=3 cellspacing=2>';

        if ($mode == "edit") {
            $tmpHTML .= '
                <tr bgcolor="#f0f0f0" >
                    <td colspan=3 valign=center align=left>
                    <table width=100%>
                    <tr>
                    <td colspan=3>
                    <b style="font-size:20px;"> #'.$OPID .'&nbsp;'.substr($OPENTRY, 0, 80).'</b>
                    </td>
                    </tr>
                    <tr>
                    <td>
                    <b>&nbsp;</b>
                    </td>
                    <td>

                    </td>
                    <td align=right>&nbsp;
                    </td>
                    </tr>
                    </table>

                    </td>
                    <td bgcolor="#ffffff" ></td>
                </tr>';
        }
        $tmpHTML .= '
            <tr bgcolor="#f0f0f0" >
                <td valign=top>&nbsp;<b>Titel (*):</b></td>
                <td colspan=2><input type="text" name="OPENTRY" value="'.$OPENTRY.'" style="width:650px;"></td>
                <td bgcolor="#ffffff" ></td>
            </tr>

            <tr bgcolor="#f0f0f0" >
                <td valign=top>&nbsp;<b>Bereich:</b></td>
                <td valign=middle align=left colspan=2><select name="OPAID" style="width:200px;">
                    <option value="-1">-- Bitte auswaehlen --';


        foreach ($typeArr as $key => $val) {
            if ($OPAID != "") {
                if ($val['OPAID'] == $OPAID) {
                    $tmpHTML .= "<option selected value='".$val['OPAID']."'>".$val['OPATEXT'];
                } else {
                    $tmpHTML .=  "<option value='".$val['OPAID']."'>".$val['OPATEXT'];
                }
            } else {
                $tmpHTML .= "<option value='".$val['OPAID']."'>".$val['OPATEXT'];
            }
        }
        $tmpHTML .= '</select>';

        $tmpHTML .= '</td>
            <td valign=top  bgcolor="#ffffff" ></td>
        </tr>
        <tr bgcolor="#f0f0f0" >
            <td valign=top>&nbsp;<b>Produkt:</b></td>
            <td valign=middle align=left colspan=2><select name="OPPID" style="width:200px;">
                <option value="-1">-- Bitte auswaehlen --';

        foreach ($productArr as $key => $val) {
            if ($OPPID != "") {
                if ($val['OPPID'] == $OPPID) {
                    $tmpHTML .=  "<option selected value='".$val['OPPID']."'>".$val['OPPTEXT'];
                } else {
                    $tmpHTML .=  "<option value='".$val['OPPID']."'>".$val['OPPTEXT'];
                }
            } else {
                    $tmpHTML .=  "<option value='".$val['OPPID']."'>".$val['OPPTEXT'];
            }
        }
        $tmpHTML .= '</select>';

        $tmpHTML .= '</td>
            <td bgcolor="#ffffff" ></td>
        </tr>
        <tr bgcolor="#f0f0f0" >
            <td valign=top>&nbsp;<b>Beschreibung:</b></td>
            <td colspan=2><textarea name="OPDESC" style="width:650px;" rows=10>'.$OPDESC.'</textarea></td>
            <td bgcolor="#ffffff" ></td>
        </tr>';
        if ($_SESSION['OPGID'] == "1" || $_SESSION['OPGID'] == "4") {
            $tmpHTML .= '<tr bgcolor="#f0f0f0" >
                <td valign=middle>&nbsp;<b>Zugewiesen an:</b></td>
                <td valign=middle align=left colspan=2><select name="OPUID_ASSIGNED" style="width:200px;">
                <option value="">Bitte auswaehlen';

            foreach ($userArr as $k => $v) {
                if ($OPUID_ASSIGNED == $v['OPUID']) {
                    $tmpHTML .=  '<option selected value="'.$v['OPUID'].'">' . $v['OPUUSERNAME'];
                } else {
                    if ($v['OPUACTIVE'] == "1") {
                        $tmpHTML .=  '<option value="'.$v['OPUID'].'">' . $v['OPUUSERNAME'];
                    }
                }
            }
            $tmpHTML .= '</select>';
        } else {
            $tmpHTML .= '<input type="hidden" name="OPUID_ASSIGNED" value="'.$OPUID_ASSIGNED.'">';
        }

        $tmpHTML .= '</td>
            <td bgcolor="#ffffff" ></td>
        </tr>';
        $tmpHTML .= '
                <tr bgcolor="#f0f0f0" >
                    <td valign=top>&nbsp;<b>Status</b></td>
                    <td colspan=2>
                    <select name="OPSID">';

                foreach ($statArr as $k => $v) {
                    if ($OPSID == $v['OPSID']) {
                        $tmpHTML .=  '<option selected value="'.$v['OPSID'].'">' . $v['OPSTEXT'];
                    } else {
                        $tmpHTML .=  '<option value="'.$v['OPSID'].'">' . $v['OPSTEXT'];
                    }
                }

                $tmpHTML .= '
                    </select>
                    </td>
                    <td bgcolor="#ffffff" ></td>
                </tr>
                <tr bgcolor="#f0f0f0" >
                    <td valign=top>&nbsp;<b>Priorit&auml;t</b></td>
                    <td colspan=2><select name="OPPRIO">
                    <option value="">-- Bitte auswaehlen --';

                for ($i=0;$i<=count($prioArr)-1;$i++) {
                    if ($i == $OPPRIO ) {
                        $tmpHTML .=  "<option selected value='".$i."' >".$prioArr[$i];
                    } else {
                        $tmpHTML .=  "<option value='".$i."' >".$prioArr[$i];
                    }
                }
                $tmpHTML .= '
                        </select>
                        </td>
                        <td bgcolor="#ffffff" ></td>
                    </tr>';

        if ($OPUID_ASSIGNED == $_SESSION['OPUID'] || $_SESSION['OPGID'] == "1" || $_SESSION['OPGID'] == "2" || $_SESSION['OPGID']=="4") {
                if ($mode == "edit") {
                    $tmpHTML .= '
                            <tr >
                                <td colspan=3 align=center><input type="hidden" name="OPID" value="'.$OPID .'"><input type="submit" name="update" style="width:180px;" value="Aenderungen speichern" onClick="return(checkOPEntry(document.opform.OPENTRY.value));"></td>
                                <td bgcolor="#ffffff" ></td>
                            </tr>';
                } else {
                    $tmpHTML .= '
                    <tr >
                        <td colspan=3 align=center><input type="submit" name="save" style="width:180px;" value="Eintrag hinzufuegen" onClick="return(checkOPEntry(document.opform.OPENTRY.value));"></td>
                        <td bgcolor="#ffffff" ></td>
                    </tr>';
                }
            }


            $tmpHTML .= '

            </table>
            </form>
            <br><br><br>';
    } else if ($mode == "list" || $mode == "" || $mode == "userlist") {
        $tmpHTML .= '
            <center>
            <table class="sortable" id="unique_id" cellpadding=3 cellspacing=2 style="border:1px solid gray;" width=98%>
            <tr style="font-weight:bold;background:#f0f0f0;">
                <td valign=top style="width:40px;">&nbsp;</td>
                <td valign=top style="width:30px; font-size:10px;">Nr.</td>
                <td valign=top style="width:*; font-size:10px;">Titel</td>
                <td valign=top style="width:100px; font-size:10px;">angelegt</td>
                <td valign=top style="width:100px; font-size:10px;">Status</td>
                <td valign=top style="width:50px; font-size:10px;">Prio</td>
                <td valign=top style="width:70px; font-size:10px;">Bereich</td>
                <td valign=top style="width:90px; font-size:10px;">Produkt</td>
                <!--<td valign=top style="width:110px; font-size:10px;">erstellt</td>-->
                <td valign=top style="width:110px; font-size:10px;">letzte &Auml;nderung</td>
                <!--<td valign=top style="width:70px; font-size:10px;">ge&auml;ndert</td>-->
                <td valign=top style="width:90px; font-size:10px;">zugewiesen</td>
            </tr>';


        foreach ($bugArr as $k => $v) {
            if ($v['OPSID'] == "4") {
                $tmpHTML .=  "<tr style='text-decoration: line-through; background:#80FF80;'>";
            } else if ($v['OPSID'] == "3") {
                $tmpHTML .=  "<tr style=\"background:#80FF80;\">";
            } else if ($v['OPSID'] == "1") {
                $tmpHTML .=  "<tr style=\"background:#FF8040;\">";
            } else {
                $tmpHTML .=  "<tr style=\"background:#FFFF80;\">";
            }

            $tmpHTML .=  "<td nowrap='nowrap' valign='top' style='font-size:10px;'>";
            if ($v['OPUID_ASSIGNED'] == $_SESSION['OPUID'] || $_SESSION['OPGID']=="1" || $_SESSION['OPGID']=="2" || $_SESSION['OPGID']=="4") {
                $tmpHTML .=  "<a href='" .$_SERVER['PHP_SELF'] . "?mode=edit&OPID=".$v['OPID']."'><img src='img/edit.png' hspace=2 border=0></a>";
            }
            if ($_SESSION['OPGID'] == "1") {
                $tmpHTML .=  "<a href=\"" .$_SERVER['PHP_SELF'] . "?mode=del&OPID=".$v['OPID']."\" onClick=\"return(confirmDialogIntoFile('Wollen Sie diesen OP-Punkt wirklich loeschen?'));\"><img src='img/deletenew.png' hspace=2 border=0></a>";
            }

            $tmpHTML .=  "</td><td valign='top' style='font-size:10px;'>".$v['OPID']."</td>
            <td valign='top' style='font-size:10px;'><a href='" .$_SERVER['PHP_SELF'] . "?mode=comment&OPID=".$v['OPID']."'>".$v['OPENTRY']."</a></td>
                  <td valign='top' style='font-size:10px;'>".$v['CREATEDUSER']."</td>
                  <td valign='top' style='font-size:10px;'>".$v['OPSTEXT']."</td>
                  <td valign='top' style='font-size:10px;'>".$prioArr[$v['OPPRIO']] . "</td>
                  <td valign='top' style='font-size:10px;'>".$v['OPATEXT']."</td>
                  <td valign='top' style='font-size:10px;'>".$v['OPPTEXT']."</td>

                  <!--<td valign='top' style='font-size:10px;'>".$v['OPDATECREATED']."</td>-->
                  <td valign='top' style='font-size:10px;'>".$v['OPDATEUPDATED']."</td>
                  <!--<td valign='top' style='font-size:10px;'>".$v['UPDATEDUSER']."</td>-->
                  <td valign='top' style='font-size:10px;'>".$v['ASSIGNEDUSER']."</td>";
            $tmpHTML .= '</tr>';
        }
        $tmpHTML .= '
            </table>
            </center>
            <br><br>';
    } else if ($mode == "logout") {
        unset($_SESSION['BUID']);
        unset($_SESSION['USERNAME']);
        session_unset();
        session_destroy();
        header("Location: index.php");
    } else if ($mode == "config") {
        $tmpHTML .= '<form name=pwd method=post>';

        if ($_SESSION['OPGID'] == "1") {
            #userlist
            $tmpHTML .=  "<table border=0 width=1024><tr><td width=500 valign=top><table border=0 cellpadding=3 cellspacing=2 width=300 style='border:1px solid gray;' ><tr><td><h3>gespeicherte Benutzer <input type='button' onclick='location.href=\"index.php?mode=config&OPUID=NEW\"' value='Neu'></h3></td></tr>";
            foreach ($userArr as $kk => $kv) {
                if ($kv['OPUID'] != "0") {
                    $tempActivated = " ";
                    if ($kv['OPUACTIVE'] == "0") {
                        $tempActivated = " (Konto deaktiviert)";
                    }
                    $tmpHTML .=  "<tr><td nowrap='nowrap'><a href='" .$_SERVER['PHP_SELF'] . "?mode=config&OPUID=".$kv['OPUID']."'><!--<img src='img/edit.png' hspace=2 border=0 align=absmiddle>-->".$kv['OPUUSERNAME']."</a>".$tempActivated."</tr>";
                }
            }
            $tmpHTML .= '</table></td>';
            #edit user
            if (isset ($_GET['OPUID']) && $_GET['OPUID'] != "NEW") {
                $tmpHTML .= '<td width=500 valign=top><table width=100% border=0 cellpadding=3 cellspacing=2 style="border:1px solid gray;" >';
                foreach ($userArr as $k=>$v) {
                    if (($v['OPUID']==$_GET['OPUID'])) {
                        $OPUACTIVE = "";
                        if ($v['OPUACTIVE']=="1") {
                            $OPUACTIVE = "checked";
                        }


                        $tmpHTML .= '<tr><td class="tdh">Gruppe (*):</td><td><select name="OPGID" style="width:300px;">
                            <option value="-1">-- Bitte auswaehlen --';

                        foreach ($grpArr as $key => $val) {
                            if ($v['OPGID']!="") {
                                if ($val['OPGID'] == $v['OPGID']) {
                                    $tmpHTML .= "<option selected value='".$val['OPGID']."'>".$val['OPGTEXT'];
                                } else {
                                    $tmpHTML .=  "<option value='".$val['OPGID']."'>".$val['OPGTEXT'];
                                }
                            } else {
                                $tmpHTML .= "<option value='".$val['OPGID']."'>".$val['OPGTEXT'];
                            }
                        }
                        $tmpHTML .= '</select></td></tr>';

                        $tmpHTML .= '



                            <tr><td class="tdh">Benutzername (*):</td><td><input name="OPUUSERNAME" type="text" value="'.$v['OPUUSERNAME'].'" style="width:200px;"></td>
                            </tr><tr><td class="tdh">EMail:</td><td><input name="OPUEMAIL" type="text" value="'.$v['OPUEMAIL'].'" style="width:200px;"></td>
                            </tr><tr><td class="tdh">Aktiviert:</td><td><input name="OPUACTIVE" type="checkbox" '.$OPUACTIVE.'></td>
                            </tr><tr><td class="tdh">Familienname (*):</td><td><input name="OPULNAME" type="text" value="'.$v['OPULNAME'] .'" style="width:200px;"></td>
                            </tr><tr><td class="tdh">Vorname (*):</td><td><input name="OPUFNAME" type="text" value="'. $v['OPUFNAME'] .'" style="width:200px;"></td>
                            </tr><tr><td class="tdh">Kennwort (*):</td><td><input name="OPUPASSWORD" type="password" value="" style="width:200px;"></td>
                            </tr><tr><td></td><td><input type="submit" name="deleteuser" value="Loeschen"><input type="submit" name="updateuser" value="Aktualisieren" onClick="return(checkNewUser(document.pwd.OPUUSERNAME.value, document.pwd.OPGID.value, document.pwd.OPUFNAME.value, document.pwd.OPULNAME.value, document.pwd.OPUEMAIL.value, document.pwd.OPUPASSWORD.value));"><input name="OPUID" type="hidden" value="'.$v['OPUID'].'"><br><br></td></tr>';
                        }
                    }
                } else {
                    $tmpHTML .= '<td width=500 valign=top><table width=100% border=0 cellpadding=3 cellspacing=2 style="border:1px solid gray;" >';

                    $tmpHTML .= '<tr><td class="tdh">Gruppe (*):</td><td><select name="OPGID" style="width:300px;">
                        <option value="-1">-- Bitte auswaehlen --';

                    foreach ($grpArr as $key => $val) {
                        $tmpHTML .= "<option value='".$val['OPGID']."'>".$val['OPGTEXT'];
                    }
                    $tmpHTML .= '</select></td></tr>';

                    $tmpHTML .= '
                        <tr><td class="tdh">Benutzername (*):</td><td><input name="OPUUSERNAME" type="text" value="" style="width:200px;"></td>
                        </tr><tr><td class="tdh">EMail:</td><td><input name="OPUEMAIL" type="text" value="" style="width:200px;"></td>
                        </tr><tr><td class="tdh">Aktiviert:</td><td><input name="OPUACTIVE" type="checkbox" checked></td>
                        </tr><tr><td class="tdh">Familienname (*):</td><td><input name="OPULNAME" type="text" value="" style="width:200px;"></td>
                        </tr><tr><td class="tdh">Vorname (*):</td><td><input name="OPUFNAME" type="text" value="" style="width:200px;"></td>
                        </tr><tr><td class="tdh">Kennwort (*):</td><td><input name="OPUPASSWORD" type="password" value="" style="width:200px;"></td>
                        </tr><tr><td></td><td><input type="submit" name="SAVEUSER" value="Benutzer anlegen" onClick="return(checkNewUser(document.pwd.OPUUSERNAME.value, document.pwd.OPGID.value, document.pwd.OPUFNAME.value, document.pwd.OPULNAME.value, document.pwd.OPUEMAIL.value, document.pwd.OPUPASSWORD.value));"><br><br></td></tr>';
                }

            $tmpHTML .=  "</table></td></tr></table>";
        } else {
            $tmpHTML .= '<table cellpadding=3 cellspacing=2 style="border:1px solid gray;" >';
            $tmpHTML .= '
                <tr><td class="tdh">Benutzername:</td><td>'.$_SESSION['OPUUSERNAME'].'</td>
                </tr><tr><td class="tdh">EMail:</td><td><input name="OPUEMAIL" type="text" value="'.$_SESSION['OPUEMAIL'].'" style="width:200px;"></td>
                </tr><tr><td class="tdh">Familienname (*):</td><td><input name="OPULNAME" type="text" value="'.$_SESSION['OPULNAME'] .'" style="width:200px;"></td>
                </tr><tr><td class="tdh">Vorname (*):</td><td><input name="OPUFNAME" type="text" value="'. $_SESSION['OPUFNAME'] .'" style="width:200px;"></td>
                </tr><tr><td class="tdh">Kennwort (*):</td><td><input type="password" name="OPUPASSWORD" value="" style="width:200px;"></td>
                </tr><tr><td></td><td><input type="submit" name="UPDATEUSERME" value="Aktualisieren" onClick="return(checkUserAdaption(document.pwd.OPUFNAME.value, document.pwd.OPULNAME.value, document.pwd.OPUEMAIL.value, document.pwd.OPUPASSWORD.value));"><input name="OPUID" type="hidden" value="'.$_SESSION['OPUID'].'"><br><br></td></tr></table>';
        }

        $tmpHTML .= '</form>';
    } else if ($mode == "help") {
        # Paco.Help ausgewaehlt
        $tmpHTML .= '
            <table cellpadding=3 cellspacing=2      width=100%>
            <tr style="">
                <td>
                <div style="border: 1px solid gray; padding: 5px; width: 90%;">
                    <div style="background: rgb(240, 240, 240) none repeat scroll 0% 50%; font-size: 16px;">
                        <strong>Filter</strong>
                    </div>
                    <ul>
                        <br><strong>Meine OP-Punkte</strong> - Auswahl alle OP-Punkte, die dem angemeldeten Benutzer zugeweisen worden sind<br>
                        <br><strong>Alle OP-Punkte</strong> - Auswahl aller OP-Punkte<br>
                        <br><strong>Neuer OP-Punk</strong> - Anlage eines neuen OP-Punkts<br>
                        <br><strong>Benutzerverwaltung</strong> - Administratoren k&ouml;nnen alle Benutzer verwalten, der Rest ber Benutzer kann jeweils nur sein eigenes Benutzerkonto auml;ndern<br>
                        <br><strong>Filter nach Stati</strong> - Filter nach den einzelnen Stati<br>
                        <br><strong>Filter nach Bereichen</strong> - Filter nach Bereichen<br>
                        <br><strong>Filter nach Produkten</strong> - Filter nach den einzelnen Produkten<br>
                        <br><strong>Volltextsuche</strong> - Volltextsuche erfolgt auch in den OP-Kommentaren<br>
                    </ul>
                </div>
                <br><br>

                <div style="border: 1px solid gray; padding: 5px; width: 90%;">
                    <div style="background: rgb(240, 240, 240) none repeat scroll 0% 50%; font-size: 16px;">
                        <strong>Stati</strong>
                    </div>
                    <ul>
                        <br><strong>offen</strong> - unbearbeitete OP-Punkte aus interner Sicht<br>
                        <br><strong>in Bearbeitung</strong> - OP-Punkt befindet sich aus interner Sicht in Bearbeitung<br>
                        <br><strong>erledigt</strong> - intern ist der OP-Punkt erledigt<br>
                        <br><strong>abgeschlossen</strong> - Kunde &uuml;berpr&uuml;ft den Status und best&auml;tigt diesen<br>
                    </ul>
                </div>
                <br><br>


                <div style="border: 1px solid gray; padding: 5px; width: 90%;">
                    <div style="background: rgb(240, 240, 240) none repeat scroll 0% 50%; font-size: 16px;">
                        <strong>Bereiche</strong>
                    </div>
                    <ul>
                        <br><strong>AT/Steuerung</strong> - betrifft AT/Steuerung<br>
                        <br><strong>IT</strong> - betrifft IT<br>
                        <br><strong>Mechanik</strong> - betrifft Mechanik<br>
                        <br><strong>unbekannt</strong> - allgemeiner Status, wenn der Kunde keinen zuweist<br>
                        <br>Zus&auml;tzliche Bereiche k&ouml;nnen direkt in der Datenbank (OPLIST_AREA) erfasst werden<br>
                    </ul>
                </div>
                <br><br>


                <div style="border: 1px solid gray; padding: 5px; width: 90%;">
                    <div style="background: rgb(240, 240, 240) none repeat scroll 0% 50%; font-size: 16px;">
                        <strong>Produkte</strong>
                    </div>
                    <ul>
                        <br><strong>CI_LOG</strong> - betrifft CI_LOG<br>
                        <br><strong>Infosystem</strong> - betrifft Infosystem<br>
                        <br>Zus&auml;tzliche Produkte k&ouml;nnen direkt in der Datenbank (OPLIST_PRODUCT) erfasst werden<br>
                    </ul>
                </div>
                <br><br>


                <div style="border: 1px solid gray; padding: 5px; width: 90%;">
                    <div style="background: rgb(240, 240, 240) none repeat scroll 0% 50%; font-size: 16px;">
                        <strong>Benutzergruppen</strong>
                    </div>
                    <ul>
                        <br>Jeder Benutzer ist einer Benutzergruppe zugewiesen:<br>
                        <br><strong>Administrator</strong> - administriert die OP-Liste und legt Benutzer an<br>
                        <br><strong>IBN</strong> - Inbetriebnehmer, kann keine OP-Punkte anlegen<br>
                        <br><strong>Kunde</strong> - Kunde - darf OP-Punkte anlegen, Stati setzen<br>
                        <br><strong>PL/AT-SYS/IT-SYS</strong> - Projektleiter - darf Aufgaben zuweisen, Stati setzen<br>
                    </ul>
                </div>
                <br><br>


                <div style="border: 1px solid gray; padding: 5px; width: 90%;">
                    <div style="background: rgb(240, 240, 240) none repeat scroll 0% 50%; font-size: 16px;">
                        <strong>Kommentare</strong>
                    </div>
                    <ul>
                        <br>Durch Klick auf den OP-Punkt k&ouml;nnen jedem OP-Punkt beliebig viele Kommentare hinzugef&uuml;gt werden. Dabei existieren Kommentare, die ausschlie&szlig;lich intern gelesen werden k&ouml;nnen (interne Kommentare).<br>
                    </ul>
                </div>
                <br><br>



                <div style="border: 1px solid gray; padding: 5px; width: 90%;">
                    <div style="background: rgb(240, 240, 240) none repeat scroll 0% 50%; font-size: 16px;">
                        <strong>Dateinanh&auml;nge</strong>
                    </div>
                    <ul>
                        <br>Durch Klick auf einen Kommentar kann eine beliebige Datei upgeloaded werden.<br>
                    </ul>
                </div>
                <br><br>


                <div style="border: 1px solid gray; padding: 5px; width: 90%;">
                    <div style="background: rgb(240, 240, 240) none repeat scroll 0% 50%; font-size: 16px;">
                        <strong>Emailversand</strong>
                    </div>
                    <ul>
                        <br>Es gibt hier 3 verschiedene Stufen:<br>
                        <br><strong>mailModus = 0</strong> - kein Emailversand<br>
                        <br><strong>mailModus = 1 (Standard)</strong> - Sobald sich die Stati eines OP-Punkts zwischen ERLEDIGT und ABGESCHLOSSEN &auml;ndern, werden jeweils der Ersteller des OP-Punkts auch als der zugewiesene Mitarbeiter informiert (je nachdem, wer den Status &auml;ndert).<br>
                        <br><strong>mailModus = 2</strong> - jede &Auml;nderung verursacht einen Emailversand<br>
                        <br>Zus&auml;tzlich kann auch eine Gruppe (Standard PL/AT-SYS/IT-SYS) definiert werden, die zu den Punkten 2 und 2 auch noch zus&auml;tzlich informiert werden.<br>
                    </ul>
                </div>
                <br><br>
                </td>
            </tr>
            </table>';
    }

    $tmpHTML .= "<script>";
    $tmpHTML .= "function submitter(command) {";
    $tmpHTML .= "    document.forms.siteflx.action.value = command;";
    $tmpHTML .= "    document.forms.siteflx.submit();";
    $tmpHTML .= " } ";
    $tmpHTML .= "</script>";
}

closeConnection();


if (isset($_GET['ajx'])) {
    echo $tmpHTML;
} else {
    echo $header . $tmpHTML . $footer;
}
?>
