----------------------------------------------------------------------
-- OPLIST_STAT
----------------------------------------------------------------------
CREATE TABLE OPLIST_STAT
(
  OPSID    NUMBER(12)                           NOT NULL,
  OPSTEXT  VARCHAR2(201 BYTE)                   NOT NULL
)
TABLESPACE USER_DATA
/
COMMENT ON TABLE OPLIST_STAT IS 'Tabelle zur Speicherung der Stati';
/
COMMENT ON COLUMN OPLIST_STAT.OPSID IS 'PK';
COMMENT ON COLUMN OPLIST_STAT.OPSTEXT IS 'Statusbezeichnung';
/
CREATE UNIQUE INDEX PKOPLISTSTAT ON OPLIST_STAT
(OPSID)
TABLESPACE USER_INDEX;
/
ALTER TABLE OPLIST_STAT ADD (
  CONSTRAINT PKOPLISTSTAT
 PRIMARY KEY
 (OPSID)
    USING INDEX 
    TABLESPACE USER_INDEX);
/
----------------------------------------------------------------------
-- OPLIST_AREA
----------------------------------------------------------------------
CREATE TABLE OPLIST_AREA (
    OPAID           NUMBER(12)                              NOT NULL,
    OPATEXT         VARCHAR2(255)                           NOT NULL
)
TABLESPACE USER_DATA;
/
COMMENT ON TABLE OPLIST_AREA IS 'Tabelle zur Speicherung der Bereiche';
/
COMMENT ON COLUMN OPLIST_AREA.OPAID IS 'PK';
COMMENT ON COLUMN OPLIST_AREA.OPATEXT IS 'Bereich';
/
ALTER TABLE OPLIST_AREA ADD (
  CONSTRAINT PKOPLISTAREA
 PRIMARY KEY
 (OPAID));
/
CREATE UNIQUE INDEX UIOPLISTAREA01 ON OPLIST_AREA (OPATEXT)
TABLESPACE USER_INDEX;
/
----------------------------------------------------------------------
-- OPLIST_PRODUCT
----------------------------------------------------------------------
CREATE TABLE OPLIST_PRODUCT (
    OPPID           NUMBER(12)                              NOT NULL,
    OPPTEXT         VARCHAR2(255)                           NOT NULL
)
TABLESPACE USER_DATA;
/
COMMENT ON TABLE OPLIST_PRODUCT IS 'Tabelle zur Speicherung der Produkte';
/
COMMENT ON COLUMN OPLIST_PRODUCT.OPPID IS 'PK';
COMMENT ON COLUMN OPLIST_PRODUCT.OPPTEXT IS 'Produkt';
/
ALTER TABLE OPLIST_PRODUCT ADD (
  CONSTRAINT PKOPLISTPRODUCT
 PRIMARY KEY
 (OPPID));
/
CREATE UNIQUE INDEX UIOPLISTPRODUCT01 ON OPLIST_PRODUCT (OPPTEXT)
TABLESPACE USER_INDEX;
/
----------------------------------------------------------------------
-- OPLIST_GROUP
----------------------------------------------------------------------
CREATE TABLE OPLIST_GROUP (
    OPGID            NUMBER(12)                             NOT NULL,
    OPGTEXT          VARCHAR2(20)                           NOT NULL
)
TABLESPACE USER_DATA;
/
COMMENT ON TABLE OPLIST_GROUP IS 'Tabelle zur Speicherung der Benutzergruppen';
/
COMMENT ON COLUMN OPLIST_GROUP.OPGID IS 'PK';
COMMENT ON COLUMN OPLIST_GROUP.OPGTEXT IS 'Benutzergruppe';
/
ALTER TABLE OPLIST_GROUP ADD (
  CONSTRAINT PKOPLISTGROUP
 PRIMARY KEY
 (OPGID));
/
CREATE UNIQUE INDEX UIOPLISTGROUP01 ON OPLIST_GROUP (OPGTEXT)
TABLESPACE USER_INDEX;
/
----------------------------------------------------------------------
-- OPLIST_USERS
----------------------------------------------------------------------
CREATE TABLE OPLIST_USERS (
    OPUID           NUMBER(12)                              NOT NULL,
    OPGID           NUMBER(12)          DEFAULT 3           NOT NULL,
    OPUUSERNAME     VARCHAR2(255)                           NOT NULL,
    OPULNAME        VARCHAR2(255)                           NOT NULL,
    OPUFNAME        VARCHAR2(255)                           NOT NULL,
    OPUEMAIL        VARCHAR2(255),
    OPUPASSWORD     VARCHAR2(32)        DEFAULT 'pwd'       NOT NULL,
    OPUACTIVE       NUMBER(1)           DEFAULT 0           NOT NULL,
    OPUDATE         DATE                DEFAULT SYSDATE     NOT NULL
)
TABLESPACE USER_DATA;
/
COMMENT ON TABLE OPLIST_USERS IS 'Tabelle zur Speicherung der Benutzer';
/
COMMENT ON COLUMN OPLIST_USERS.OPUID IS 'PK';
COMMENT ON COLUMN OPLIST_USERS.OPGID IS 'FK: Gruppenzugehoerigkeit';
COMMENT ON COLUMN OPLIST_USERS.OPUUSERNAME IS 'Unique: Benutzername';
COMMENT ON COLUMN OPLIST_USERS.OPULNAME IS 'Familienname';
COMMENT ON COLUMN OPLIST_USERS.OPUFNAME IS 'Vorname';
COMMENT ON COLUMN OPLIST_USERS.OPUEMAIL IS 'Email';
COMMENT ON COLUMN OPLIST_USERS.OPUPASSWORD IS 'Kennwort';
COMMENT ON COLUMN OPLIST_USERS.OPUACTIVE IS '1=aktiviert, 0=deaktiviert';
COMMENT ON COLUMN OPLIST_USERS.OPUDATE IS 'Datum der letzten Aenderung';
/
ALTER TABLE OPLIST_USERS ADD (
  CONSTRAINT PKOPLISTUSERS
 PRIMARY KEY
 (OPUID));
/
CREATE UNIQUE INDEX UIOPLISTUSERS01 ON OPLIST_USERS (OPUUSERNAME)
TABLESPACE USER_INDEX;
/
ALTER TABLE OPLIST_USERS ADD CONSTRAINT FKOPLISTUSERS01
FOREIGN KEY (OPGID) REFERENCES OPLIST_GROUP (OPGID);
/
----------------------------------------------------------------------
-- OPLIST
----------------------------------------------------------------------
CREATE TABLE OPLIST (
    OPID            NUMBER(12)                              NOT NULL,
    OPDATECREATED   DATE                DEFAULT SYSDATE     NOT NULL,
    OPDATEUPDATED   DATE                DEFAULT SYSDATE     NOT NULL,
    OPSID           NUMBER(12)          DEFAULT 0           NOT NULL,
    OPENTRY         VARCHAR2(4000)                          NOT NULL,
    OPAID           NUMBER(12)          DEFAULT 4           NOT NULL,
    OPDESC          VARCHAR2(4000),
    OPPID           NUMBER(12)          DEFAULT 4           NOT NULL,
    OPPRIO          NUMBER(1)           DEFAULT 0           NOT NULL,
    OPUID_CREATED   NUMBER(12)          DEFAULT 0           NOT NULL,
    OPUID_UPDATED   NUMBER(12)          DEFAULT 0           NOT NULL,
    OPUID_ASSIGNED  NUMBER(12)          DEFAULT 0           NOT NULL,
    OPDELETED       NUMBER(1)           DEFAULT 0           NOT NULL
)
TABLESPACE USER_DATA;
/
COMMENT ON TABLE OPLIST IS 'Tabelle zur Speicherung der OP-Punkte';
/
COMMENT ON COLUMN OPLIST.OPID IS 'PK';
COMMENT ON COLUMN OPLIST.OPDATECREATED IS 'Datum der Erstellung';
COMMENT ON COLUMN OPLIST.OPDATEUPDATED IS 'Datum der letzten Aenderung';
COMMENT ON COLUMN OPLIST.OPSID IS 'FK Status';
COMMENT ON COLUMN OPLIST.OPENTRY IS 'OP-Punkt';
COMMENT ON COLUMN OPLIST.OPAID IS 'FK: Bereich';
COMMENT ON COLUMN OPLIST.OPDESC IS 'Beschreibung des OP-Punkts';
COMMENT ON COLUMN OPLIST.OPPID IS 'FK: Produkt';
COMMENT ON COLUMN OPLIST.OPPRIO IS 'Prioritaet (0=Niedrig, 1=Normal, 2=Hoch)';
COMMENT ON COLUMN OPLIST.OPUID_CREATED IS 'FK: Erstellbenutzer';
COMMENT ON COLUMN OPLIST.OPUID_UPDATED IS 'FK: Aenderungsbenutzer';
COMMENT ON COLUMN OPLIST.OPUID_ASSIGNED IS 'FK: Benutzer, dem der OP-Punkt zugewiesen wurde';
COMMENT ON COLUMN OPLIST.OPDELETED IS '1: gelschter OP-Punkt, sonst 0';
/
ALTER TABLE OPLIST ADD (
  CONSTRAINT PKOPLIST
 PRIMARY KEY
 (OPID));
/
ALTER TABLE OPLIST ADD CONSTRAINT FKOPLIST01
FOREIGN KEY (OPAID) REFERENCES OPLIST_AREA (OPAID);
/
ALTER TABLE OPLIST ADD CONSTRAINT FKOPLIST02
FOREIGN KEY (OPPID) REFERENCES OPLIST_PRODUCT (OPPID);
/
ALTER TABLE OPLIST ADD CONSTRAINT FKOPLIST03
FOREIGN KEY (OPUID_CREATED) REFERENCES OPLIST_USERS (OPUID);
/
ALTER TABLE OPLIST ADD CONSTRAINT FKOPLIST04
FOREIGN KEY (OPUID_UPDATED) REFERENCES OPLIST_USERS (OPUID);
/
ALTER TABLE OPLIST ADD CONSTRAINT FKOPLIST05
FOREIGN KEY (OPUID_ASSIGNED) REFERENCES OPLIST_USERS (OPUID);
/
ALTER TABLE OPLIST ADD CONSTRAINT FKOPLIST06
FOREIGN KEY (OPSID) REFERENCES OPLIST_STAT (OPSID);
/
----------------------------------------------------------------------
-- OPLIST_COMMENT
----------------------------------------------------------------------
CREATE TABLE OPLIST_COMMENT (
    OPCID           NUMBER(12)                              NOT NULL,
    OPUID           NUMBER(12)                              NOT NULL,
    OPCTEXT         VARCHAR2(4000)                          NOT NULL,
    OPCDATE         DATE                DEFAULT SYSDATE     NOT NULL,
    OPID            NUMBER(12)                              NOT NULL,
    OPCPRIVATE      NUMBER(1)           DEFAULT 0           NOT NULL,
    OPCFILENAME     VARCHAR2(20)
)
TABLESPACE USER_DATA;
/
COMMENT ON TABLE OPLIST_COMMENT IS 'Tabelle zur Speicherung der Benutzerkommentare';
/
COMMENT ON COLUMN OPLIST_COMMENT.OPCID IS 'PK';
COMMENT ON COLUMN OPLIST_COMMENT.OPUID IS 'FK: Benutzer, welcher Eintrag getaetigt hat';
COMMENT ON COLUMN OPLIST_COMMENT.OPCTEXT IS 'Kommentar';
COMMENT ON COLUMN OPLIST_COMMENT.OPCDATE IS 'Datum des Eintrags';
COMMENT ON COLUMN OPLIST_COMMENT.OPID IS 'FK: OP-Punkt, zu welchem der Eintrag hinzugefuegt wurde';
COMMENT ON COLUMN OPLIST_COMMENT.OPCPRIVATE IS '0=fuer Kunde lesbar, 1=nur fuer TGW/TSI lesbar';
COMMENT ON COLUMN OPLIST_COMMENT.OPCFILENAME IS 'angehngter Dateiname';
/
ALTER TABLE OPLIST_COMMENT ADD (
  CONSTRAINT PKOPLISTCOMMENT
 PRIMARY KEY
 (OPCID));
/
ALTER TABLE OPLIST_COMMENT ADD CONSTRAINT FKOPLISTCOMMENT01
FOREIGN KEY (OPUID) REFERENCES OPLIST_USERS (OPUID);
/
ALTER TABLE OPLIST_COMMENT ADD CONSTRAINT FKOPLISTCOMMENT02
FOREIGN KEY (OPID) REFERENCES OPLIST (OPID);
/
----------------------------------------------------------------------
-- OPLIST_DEBUG
----------------------------------------------------------------------
CREATE TABLE OPLIST_DEBUG
(
  ERST             DATE                DEFAULT sysdate     NOT NULL,
  VALUE            VARCHAR2(4000)
)
TABLESPACE USER_DATA;
/
COMMENT ON TABLE OPLIST_DEBUG IS 'Logging-Tabelle';
/
COMMENT ON COLUMN OPLIST_DEBUG.ERST 'Zeitpunkt des Logeintrags';
COMMENT ON COLUMN OPLIST_DEBUG.VALUE 'Logeintrag';
/
----------------------------------------------------------------------
-- ERSTELLUNG SEQUENCES
----------------------------------------------------------------------
CREATE SEQUENCE OPLISTAREA_SEQ
  START WITH 100
  MAXVALUE 2147483647
  MINVALUE 1
  NOCYCLE
  NOCACHE
  NOORDER;
/
CREATE SEQUENCE OPLISTPRODUCT_SEQ
  START WITH 100
  MAXVALUE 2147483647
  MINVALUE 1
  NOCYCLE
  NOCACHE
  NOORDER;
/
CREATE SEQUENCE OPLISTGROUP_SEQ
  START WITH 100
  MAXVALUE 2147483647
  MINVALUE 1
  NOCYCLE
  NOCACHE
  NOORDER;
/
CREATE SEQUENCE OPLISTUSERS_SEQ
  START WITH 100
  MAXVALUE 2147483647
  MINVALUE 1
  NOCYCLE
  NOCACHE
  NOORDER;
/
CREATE SEQUENCE OPLIST_SEQ
  START WITH 1
  MAXVALUE 2147483647
  MINVALUE 1
  NOCYCLE
  NOCACHE
  NOORDER;
/
CREATE SEQUENCE OPLISTCOMMENT_SEQ
  START WITH 1
  MAXVALUE 2147483647
  MINVALUE 1
  NOCYCLE
  NOCACHE
  NOORDER;
/
CREATE SEQUENCE OPLISTFILENAME_SEQ
  START WITH 1
  MAXVALUE 2147483647
  MINVALUE 1
  NOCYCLE
  NOCACHE
  NOORDER;
/
exit
