// ueberprueft, ob mindestens 10 Zeichen fuer einen OP-Punkt angegeben worden sind
function checkOPEntry (strTitle) {
    if (strTitle.length < 1) {
        alert ("Titel ist nicht ausgefuellt (min 10 Zeichen!)!");
        return false;
    } else {
        return true;
    }
}

// ueberprueft ob alle notwendigen Felder bei der Anlage eines neuen Benutzers ausgefuellt worden sind
function checkNewUser (strUsername, strGroup, strFirstname, strLastname, strEmail, strPassword) {
    if (strPassword.length > 0) {
        bRet = checkNewPassword(strPassword, strPassword, 3);
    } else {
        bRet = true;
    }

    if (bRet) {
        if (strUsername.length < 3) {
            alert("Benutzername min. 3 Zeichen!")
            bRet = false;
        }
        if (bRet) {
            if (strFirstname.length < 5) {
                alert("Vorname min. 5 Zeichen!")
                bRet = false;
            }
            if (bRet) {
                if (strLastname.length < 5) {
                    alert("Familienname min. 5 Zeichen!")
                    bRet = false;
                }
                if (bRet) {
                    if (strGroup == "-1") {
                        alert("Keine Gruppe ausgewaehlt!")
                        bRet = false;
                    }
                    if (bRet){
                        if (strEmail.length > 0) {
                            bRet = checkEmail(strEmail);
                        }
                    }
                }
            }
        }
    }
    return bRet;
}

// ueberprueft ob alle notwendigen Felder bei aenderung der eigenen Daten ausgefuellt wurden
function checkUserAdaption (strFirstname, strLastname, strEmail, strPassword) {
        if (strPassword.length > 0) {
        bRet = checkNewPassword(strPassword, strPassword, 3);
    } else {
        bRet = true;
    }

    if (bRet) {
        if (strUsername.length < 1) {
            alert("Benutzername min. 3 Zeichen!")
            bRet = false;
        }
        if (bRet) {
            if (strFirstname.length < 1) {
                alert("Vorname min. 5 Zeichen!")
                bRet = false;
            }
            if (bRet) {
                if (strLastname.length < 1) {
                    alert("Familienname min. 5 Zeichen!")
                    bRet = false;
                }
                if (bRet){
                    if (strEmail.length > 0) {
                        bRet = checkEmail(strEmail);
                    }
                }
            }
        }
    }
    return bRet;
}

// ueberprueft die Eingabe des Kommentars
function checkAddComment (strEntry) {
    if (strEntry.length < 1) {
        alert ("Kommentar ist zu kurz (min. 10)!");
        return false;
    } else {
        return true;
    }
}

// testscript zum ausprobieren
function checkTestMe (strEmail, strLastname) {
    if (strLastname.length < 1) {
        alert("Familienname min. 5 Zeichen!")
        bRet = false;
    } else {
        bRet = true;
    }
    if (bRet) {
        bRet = checkEmail(strEmail);
    }
    return bRet;
}



// check if the registration form has been filled out correct
function checkRegistration(strUsername, strPwd1, strPwd2, strLastname, strFirstname, strEmail, iLength){
  bRet = checkNewPassword(strPwd1, strPwd2, iLength);
  if (bRet){
    bRet = checkPassword(strUsername, iLength);
    if (bRet){
      if ((strLastname.length < 1) || (strFirstname.length < 1)){
        alert("Familienname bzw. Vorname ist zu kurz!");
        bRet = false;
      }
      if (bRet){
        bRet = checkEmail(strEmail);
      }
    }
  }
  return bRet;
}

// display msgText to the user and return true if the user has clicked OK, false otherwise
function confirmDialog(strMsg){
  if (confirm(strMsg)){
    return true;
  } else {
    return false;
  }
}

// true if strPwd is a valid password (no blanks and no apostrophes) with the min length iLength specified
function checkPassword(strPwd, iLength){
  if (strPwd.length < iLength){
    alert("Ihr Benutzername bzw. Kennwort ist zu kurz!");
    return false;
  }

  if ((strPwd.indexOf("'") >= 0) || (strPwd.indexOf(" ") >= 0) || (strPwd.indexOf('"') >= 0)) {
    alert("Ihre Benutzername bzw. Ihr Kennwort ist ungueltig!\nBitte waehlen geben Sie ein anderes ein.");
    return false;
  }
  return true;
}

// true if both values are equal, are of min length iLength and are valid passwords
function checkNewPassword(strPwd1, strPwd2, iLength){
  if (strPwd1 != strPwd2){
    alert("Das Kennwort stimmt nicht mit Ihrer wiederholten Eingabe ueberein!");
    return false;
  }

  return checkPassword(strPwd1, iLength);
}

// valid alphabet for integer numbers
function getAlphabetIntegerNumber(){
  return "-0123456789";
}

// valid alphabet for positive integer numbers
function getAlphabetIntegerNumberPositive(){
  return "0123456789";
}

// valid alphabet for numbers (containing decimal seperators)
function getAlphabetDoubleNumber(){
  return "-0123456789.,";
}

// valid alphabet for telephon-numbers
function getAlphabetTelephon(){
  return "+()/- 0123456789";
}

// valid alphabet for emails
function getAlphabetEmail(){
  return "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz@._-0123456789";
}

// true if all characters of strText are inclosed in strAlphabet
function checkText(strAlphabet, strText){
  var ok = true;
  var i = 0;
  while (ok && i < strText.length) {
    var strCharacter = strText.substring(i, i + 1);
    if (strAlphabet.indexOf(strCharacter) < 0){
      ok = false;
    }
    i++;
  }
  return ok;
}

// true if strEmail is an valid email-address
// <input type="submit" onclick="return(checkEmail(document.pwd.OPUEMAIL.value));" />
function checkEmail(strEmail){
  var lengthEmail = strEmail.length;
  // min length of a valid email is 6
  if (lengthEmail < 6){
    alert("Ihre Email ist zu kurz!");

    return false;
  }

  // check if email only contains valid email-characters
  if (!checkText(getAlphabetEmail(), strEmail)){
    alert("Ihre Email enthaelt ungueltige Zeichen!");

    return false;
  }

  var posFirstAt = strEmail.indexOf("@");
  var posLastAt = strEmail.lastIndexOf("@");
  var posFirstDot = strEmail.indexOf(".");
  var posLastDot = strEmail.lastIndexOf(".");
  var dot4At = strEmail.indexOf(".@");
  var at4Dot = strEmail.indexOf("@.");
  var dotdot = strEmail.indexOf("..");


  if ((posFirstDot <= 0 ) || ((lengthEmail - posLastDot) < 3) || (posFirstAt != posLastAt) || (posFirstAt <= 0) || (posLastAt >= (posLastDot - 1)) || (dot4At != -1) || (at4Dot != -1) || (dotdot != -1)){
    /* first character is a dot or even no dot could be found at all, text after last dot is shorter than 2 characters of length, there are more than one @, first character is an @ or even no @ could be found at all, text between @ and last dot must be min. 1 character of length, dot is directly before the @, dot is directyl after the @, there are two dots directly behind*/
    alert("Ihre Email ist ungueltig!");

    return false;
  }
  return true;
}
