<?PHP
######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2015
#
# Ueberprueft, ob ein Update in der Datenbank durch zu fuehren ist
#
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# 2015-08-07 Paco Anlage der Update-Datei
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
$dbExistingVersion=0;
######################################################################


function check4NecessaryDBUpdates() {
    global $databaseMinVersion;
    global $myVersion;
    global $SVNRevision;
    global $usedb;

    #logAlwaysIntoFile ("Check for necessary database update:");
    $dbExistingVersion=getDBVersion();
    #logAlwaysIntoFile ("We have version ".$dbExistingVersion." installed");
    #logAlwaysIntoFile ("We need version ".$databaseMinVersion." installed");
    
    if ($dbExistingVersion >= $databaseMinVersion) {
        #logAlwaysIntoFile ("We do not need a database update.");
        debugIntoFile("DB-Model has already version ".$dbExistingVersion." and needs no update (min=".$databaseMinVersion.")");
    } else {
        if ($dbExistingVersion == 1) {
            logIntoFile("Updating DB-Model: 1-2");

            if ($usedb == "mysql") {
                $sQuery = "ALTER TABLE OPLIST_STAT ADD OPSRC INT(1)";
                getRessource($sQuery);
                logSQLError();
                $sQuery = "UPDATE OPLIST_STAT SET OPSRC = OPSID WHERE OPSRC IS NULL";
                getRessource($sQuery);
                logSQLError();
                $sQuery = "ALTER TABLE OPLIST_STAT MODIFY OPSRC INT(1) NOT NULL";
                getRessource($sQuery);
                logSQLError();
                $sQuery = "COMMENT ON COLUMN OPLIST_STAT.OPSRC IS 'Sortierungsreihenfolge'";
                getRessource($sQuery);
                logSQLError();
            } else {
                $sQuery = "ALTER TABLE OPLIST_STAT ADD OPSRC NUMBER(1)";
                debugIntoFile("Update-Select1=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "UPDATE OPLIST_STAT SET OPSRC = OPSID WHERE OPSRC IS NULL";
                debugIntoFile("Update-Select2=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "ALTER TABLE OPLIST_STAT MODIFY OPSRC NUMBER(1) NOT NULL";
                debugIntoFile("Update-Select3=".$sQuery);
                getRessource($sQuery);
                logSQLError();
            }
            $dbExistingVersion = 2;
        }
        
        if ($dbExistingVersion == 2) {
            $dbExistingVersion = 3;
        }

        # update version
        $sQuery = "UPDATE OPLIST_VERSION SET OPVVERSION=".$databaseMinVersion.", OPVDESC='".$myVersion.".".$SVNRevision."' WHERE OPVID = 1";
        debugIntoFile("Update-Select=".$sQuery);
        #logAlwaysIntoFile("Database-Update-String=".$sQuery);
        getRessource($sQuery);
        logSQLError();
        logIntoFile("Update done to version ".$databaseMinVersion);
        
        #logAlwaysIntoFile ("Necessary database update done.");
    }    
}

?>
