#!/bin/sh
#
# Authors: Franz-Peter Glawar <office@glawar.at>, 2014
#
#
# This script creates an installation package for OPList
#---------------------------------------------------------------------
# Additional technical information:
#
# ./make.sh
#
# will create oplist_v1.10.556.tgz
#
#
# ./make.sh nightly-build
#
# will create oplist_vnightly-build.tgz
#
#
# Installation
#
# tar xfvz oplist_v1.10.556.tgz
# cd oplist
# ./install.sh
#---------------------------------------------------------------------
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# v20??-??-?? FPG created the script
# v2014-11-28 FPG adapted the replacement
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
VERSIONTOCREATE=0
####------------------------------------------------------------------
####  Exit-values
EXIT_OK=0
EXIT_NOT_ROOT=1
######################################################################


# go to base directory
cd ..

ACTUALDATE=`date +%Y_%m_%d-%H_%M_%S`
echo "ACTUALDATE=${ACTUALDATE}"

# make a backup if someone has forgotten to check in befor making a
# new installation package
mv index.php backup/index_${ACTUALDATE}.php

#exit 0

# get actual version from svn
svn update

# get the svn revision
SVNREVISION=`svn info https://svn.glawar.at/svn/ | grep 'Revision' | awk '{ print $2; }'`
echo "SVNREVISION=${SVNREVISION}"

# set actual date
ACTUALDATE=`date +%Y\-%m\-%d`
echo "ACTUALDATE=${ACTUALDATE}"

# change revision
sed -i "s/SVNRevision=1;/SVNRevision=${SVNREVISION};/g" index.php

# change actual date
sed -i "s/myVersionDate=2;/myVersionDate='${ACTUALDATE}';/g" index.php


if [ $# -eq 1 ]; then
    echo "We use ${1}"
    VERSIONTOCREATE=nightly-build

    # change parameter nightly build
    sed -i 's/nightlyBuild=0;/nightlyBuild=1;/g' index.php
else
    # i dont know how to come from $myVersion="2.1"; to 2.1
    # find only the first appearance of myVersion in file index.php
    VERSIONTOCREATE=`grep myVersion index.php | grep -n myVersion | grep "^1:" | grep -Po '".*?"'`

    # delete all double quotes in the text
    VERSIONTOCREATE=`echo ${VERSIONTOCREATE} | sed 's/\"//g'`
    echo "We have determined ${VERSIONTOCREATE}"

    VERSIONTOCREATE="${VERSIONTOCREATE}.${SVNREVISION}"
fi

echo "We use ${VERSIONTOCREATE}"


# indiv nach template umbenennen
cd include
mv index_indiv.php index_indiv.php.template

cd ..
# indiv nach template umbenennen

cd ..
tar cfvz oplist.tgz oplist/* --exclude='*.ini' --exclude='oplist_v*.tgz' --exclude='oplist*.log' --exclude='backup'
mv oplist.tgz oplist/make/oplist
cd oplist/make
tar cfvz oplist_v${VERSIONTOCREATE}.tgz oplist/*
rm oplist/oplist.tgz

# delete changed index.php and do another svn update
cd ..
rm index.php


# indiv nach template umbenennen rückgängig machen
cd include
mv index_indiv.php.template index_indiv.php

cd ..
# indiv nach template umbenenne rückgängig machen


svn update
cd make

exit 0
