<?PHP
######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2015
#
# Ueberprueft, ob ein Update in der Datenbank durch zu fuehren ist
#
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# 2015-08-07 Paco Anlage der Update-Datei
# 2015-12-21 Paco - neue Datenbankversion 3 (Reihungsocde für Area und Product)
#                 - neue Datenbankversion 4
#                   * interne Sicht fuer Gruppen einstellbar
# 2016-10-23 Paco PL-Kunde mit ID 5 ist immer noch nicht korrekt
#                 im Datenmodell --> bereinigt
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
$dbExistingVersion=0;
######################################################################


function check4NecessaryDBUpdates() {
    global $databaseMinVersion;
    global $myVersion;
    global $SVNRevision;
    global $usedb;

    #logAlwaysIntoFile ("Check for necessary database update:");
    $dbExistingVersion=getDBVersion();
    #logAlwaysIntoFile ("We have version ".$dbExistingVersion." installed");
    #logAlwaysIntoFile ("We need version ".$databaseMinVersion." installed");

    if ($dbExistingVersion >= $databaseMinVersion) {
        #logAlwaysIntoFile ("We do not need a database update.");
        debugIntoFile("DB-Model has already version ".$dbExistingVersion." and needs no update (min=".$databaseMinVersion.")");
    } else {
        if ($dbExistingVersion == 1) {
            logIntoFile("Updating DB-Model: 1 --> 2");

            if ($usedb == "mysql") {
                $sQuery = "ALTER TABLE OPLIST_STAT ADD OPSRC INT(1)";
                getRessource($sQuery);
                logSQLError();
                $sQuery = "UPDATE OPLIST_STAT SET OPSRC = OPSID WHERE OPSRC IS NULL";
                getRessource($sQuery);
                logSQLError();
                $sQuery = "ALTER TABLE OPLIST_STAT MODIFY OPSRC INT(1) NOT NULL";
                getRessource($sQuery);
                logSQLError();
                $sQuery = "COMMENT ON COLUMN OPLIST_STAT.OPSRC IS 'Sortierungsreihenfolge'";
                getRessource($sQuery);
                logSQLError();
            } else {
                $sQuery = "ALTER TABLE OPLIST_STAT ADD OPSRC NUMBER(1)";
                debugIntoFile("Update-Select1=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "UPDATE OPLIST_STAT SET OPSRC = OPSID WHERE OPSRC IS NULL";
                debugIntoFile("Update-Select2=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "ALTER TABLE OPLIST_STAT MODIFY OPSRC NUMBER(1) NOT NULL";
                debugIntoFile("Update-Select3=".$sQuery);
                getRessource($sQuery);
                logSQLError();
            }
            $dbExistingVersion = 2;
        }

        if ($dbExistingVersion == 2) {
            logIntoFile("Updating DB-Model: 2 --> 3");

            if ($usedb == "mysql") {
                $sQuery = "ALTER TABLE OPLIST_AREA ADD OPARC INT(1)";
                debugIntoFile("Update-Select1=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "UPDATE OPLIST_AREA SET OPARC = 1 WHERE OPARC IS NULL";
                debugIntoFile("Update-Select2=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "ALTER TABLE OPLIST_AREA MODIFY OPARC INT(1) NOT NULL";
                debugIntoFile("Update-Select3=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "ALTER TABLE OPLIST_PRODUCT ADD OPPRC INT(1)";
                debugIntoFile("Update-Select4=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "UPDATE OPLIST_PRODUCT SET OPPRC = 1 WHERE OPPRC IS NULL";
                debugIntoFile("Update-Select5=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "ALTER TABLE OPLIST_PRODUCT MODIFY OPPRC INT(1) NOT NULL";
                debugIntoFile("Update-Select6=".$sQuery);
                getRessource($sQuery);
                logSQLError();
            } else {
                $sQuery = "ALTER TABLE OPLIST_AREA ADD OPARC NUMBER(1)";
                debugIntoFile("Update-Select1=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "UPDATE OPLIST_AREA SET OPARC = 1 WHERE OPARC IS NULL";
                debugIntoFile("Update-Select2=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "ALTER TABLE OPLIST_AREA MODIFY OPARC NUMBER(1) NOT NULL";
                debugIntoFile("Update-Select3=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "ALTER TABLE OPLIST_PRODUCT ADD OPPRC NUMBER(1)";
                debugIntoFile("Update-Select4=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "UPDATE OPLIST_PRODUCT SET OPPRC = 1 WHERE OPPRC IS NULL";
                debugIntoFile("Update-Select5=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "ALTER TABLE OPLIST_PRODUCT MODIFY OPPRC NUMBER(1) NOT NULL";
                debugIntoFile("Update-Select6=".$sQuery);
                getRessource($sQuery);
                logSQLError();
            }
            $dbExistingVersion = 3;
        }

        if ($dbExistingVersion == 3) {
            logIntoFile("Updating DB-Model: 3 --> 4");

            if ($usedb == "mysql") {
                $sQuery = "ALTER TABLE OPLIST_GROUP ADD INTERNAL INT(1)";
                debugIntoFile("Update-Select1=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "UPDATE OPLIST_GROUP SET INTERNAL = 0";
                debugIntoFile("Update-Select2=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "UPDATE OPLIST_GROUP SET INTERNAL = 1 WHERE OPGID = 3 OR OPGID = 4";
                debugIntoFile("Update-Select3=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "ALTER TABLE OPLIST_GROUP MODIFY INTERNAL INT(1) NOT NULL";
                debugIntoFile("Update-Select4=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "Insert into OPLIST_GROUP (OPGID, OPGTEXT, ACTIVE, INTERNAL) Values (5, 'PL-Kunde', 1, 0)";
                debugIntoFile("Update-Select5=".$sQuery);
                getRessource($sQuery);
                logSQLError();
            } else {
                $sQuery = "ALTER TABLE OPLIST_GROUP ADD INTERNAL NUMBER(1)";
                debugIntoFile("Update-Select1=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "UPDATE OPLIST_GROUP SET INTERNAL = 0";
                debugIntoFile("Update-Select2=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "UPDATE OPLIST_GROUP SET INTERNAL = 1 WHERE OPGID = 3 OR OPGID = 4";
                debugIntoFile("Update-Select3=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "ALTER TABLE OPLIST_GROUP MODIFY INTERNAL NUMBER(1) NOT NULL";
                debugIntoFile("Update-Select4=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "Insert into OPLIST_GROUP (OPGID, OPGTEXT, ACTIVE, INTERNAL) Values (5, 'PL-Kunde', 1, 0)";
                debugIntoFile("Update-Select5=".$sQuery);
                getRessource($sQuery);
                logSQLError();
            }
            $dbExistingVersion = 4;
        }

        if ($dbExistingVersion == 4) {
            logIntoFile("Updating DB-Model: 4 --> 5");

            if ($usedb == "mysql") {
                $sQuery = "ALTER TABLE OPLIST_GROUP ADD CLIENT INT(1)";
                debugIntoFile("Update-Select1=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "UPDATE OPLIST_GROUP SET CLIENT = 0";
                debugIntoFile("Update-Select2=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "UPDATE OPLIST_GROUP SET CLIENT = 1 WHERE OPGID = 2 OR OPGID = 5";
                debugIntoFile("Update-Select3=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "ALTER TABLE OPLIST_GROUP MODIFY CLIENT INT(1) NOT NULL";
                debugIntoFile("Update-Select4=".$sQuery);
                getRessource($sQuery);
                logSQLError();
            } else {
                $sQuery = "ALTER TABLE OPLIST_GROUP ADD CLIENT NUMBER(1)";
                debugIntoFile("Update-Select1=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "UPDATE OPLIST_GROUP SET CLIENT = 0";
                debugIntoFile("Update-Select2=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "UPDATE OPLIST_GROUP SET CLIENT = 1 WHERE OPGID = 2 OR OPGID = 5";
                debugIntoFile("Update-Select3=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "ALTER TABLE OPLIST_GROUP MODIFY CLIENT NUMBER(1) NOT NULL";
                debugIntoFile("Update-Select4=".$sQuery);
                getRessource($sQuery);
                logSQLError();
            }
            $dbExistingVersion = 5;
        }

        if ($dbExistingVersion == 5) {
            logIntoFile("Updating DB-Model: 5 --> 6");

            if ($usedb == "oracle") {
                $sQuery = "COMMENT ON COLUMN OPLIST.OPDELETED IS '1: geloeschter OP-Punkt, sonst 0'";
                debugIntoFile("Update-Select1=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "COMMENT ON COLUMN OPLIST_AREA.ACTIVE IS '1: Bereich wird verwendet, sonst 0'";
                debugIntoFile("Update-Select2=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "COMMENT ON COLUMN OPLIST_AREA.OPARC IS 'Reihungscode fuer Sortierung'";
                debugIntoFile("Update-Select3=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "COMMENT ON COLUMN OPLIST_COMMENT.OPCFILENAME IS 'angehaengter Dateiname'";
                debugIntoFile("Update-Select4=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "COMMENT ON COLUMN OPLIST_DEBUG.ERST IS 'Zeitstempel des Log-Eintrags'";
                debugIntoFile("Update-Select5=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "COMMENT ON COLUMN OPLIST_DEBUG.VALUE IS 'Log-Eintrag'";
                debugIntoFile("Update-Select6=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "COMMENT ON COLUMN OPLIST_GROUP.ACTIVE IS '1: Benutzergruppe wird verwendet, sonst 0'";
                debugIntoFile("Update-Select7=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "COMMENT ON COLUMN OPLIST_GROUP.INTERNAL IS '1: Mitglieder der Benutzergruppe duerfen interne Kommentare sehen und drucken, sonst 0'";
                debugIntoFile("Update-Select8=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "COMMENT ON COLUMN OPLIST_GROUP.CLIENT IS '1: Mitlgieder der Benutzergruppe sind Kunden, sonst 0'";
                debugIntoFile("Update-Select9=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "COMMENT ON COLUMN OPLIST_PRODUCT.ACTIVE IS '1: Produkt wird verwendet, sonst 0'";
                debugIntoFile("Update-Select10=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "COMMENT ON COLUMN OPLIST_PRODUCT.OPPRC IS 'Reihungscode fuer Sortierung'";
                debugIntoFile("Update-Select11=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "COMMENT ON COLUMN OPLIST_STAT.ACTIVE IS '1: Bereich wird verwendet, sonst 0'";
                debugIntoFile("Update-Select12=".$sQuery);
                getRessource($sQuery);
                logSQLError();
                $sQuery = "COMMENT ON COLUMN OPLIST_STAT.OPSRC IS 'Reihungscode fuer Sortierung'";
                debugIntoFile("Update-Select13=".$sQuery);
                getRessource($sQuery);
                logSQLError();
            }
            $dbExistingVersion = 6;
        }

        if ($dbExistingVersion == 6) {
            logIntoFile("Updating DB-Model: 6 --> 7");

            $sQuery = "Insert into OPLIST_GROUP (OPGID, OPGTEXT, ACTIVE, INTERNAL, CLIENT) Values (5, 'PL-Kunde', 1, 0, 1)";
            debugIntoFile("Update-Select1=".$sQuery);
            getRessource($sQuery);
            logSQLError();

            $dbExistingVersion = 7;
        }

        if ($dbExistingVersion == 7) {
            logIntoFile("Updating DB-Model: 7 --> 8");

            if ($usedb == "mysql") {
                $sQuery = "ALTER TABLE OPLIST ADD OPDEADLINE2 DATE COMMENT 'Termin'";
                debugIntoFile("Update-Select1=".$sQuery);
                getRessource($sQuery);
                logSQLError();
            } else {
                $sQuery = "ALTER TABLE OPLIST ADD OPDEADLINE DATE";
                debugIntoFile("Update-Select1=".$sQuery);
                getRessource($sQuery);
                logSQLError();

                $sQuery = "COMMENT ON COLUMN OPLIST.OPDEADLINE IS 'Termin'";
                getRessource($sQuery);
                logSQLError();
            }


            $dbExistingVersion = 8;
        }

        # update version
        $sQuery = "UPDATE OPLIST_VERSION SET OPVVERSION=".$databaseMinVersion.", OPVDESC='".$myVersion.".".$SVNRevision."' WHERE OPVID = 1";
        debugIntoFile("Update-Select=".$sQuery);
        #logAlwaysIntoFile("Database-Update-String=".$sQuery);
        getRessource($sQuery);
        logSQLError();
        logIntoFile("Update done to version ".$databaseMinVersion);

        #logAlwaysIntoFile ("Necessary database update done.");
    }
}

?>
