<?PHP
session_start();

ini_set("display_errors", "1");
error_reporting(E_ALL);

date_default_timezone_set('Europe/Vienna');
setlocale (LC_TIME, "de_DE");

include_once "include/index_indiv.php";
include_once "include/update.php";


######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2011
#
# Dieses PHP-File realisiert eine einfache OP-Liste.
#
#
# (c) www.glawar.at 2011-11-13
#
######################################################################
# Der Standardbenutzer ist admin mit dem Standardkennwort admin
######################################################################
####  History
#---------------------------------------------------------------------
# v2006-03-16 ds.it@gmx.de based on phpToDoList V0.1 beta
#                          GPL (GNU Public License)
# v2011-11-12 Paco einige Funktionen hinzugefuegt wie
#                  - Filter
#                  - Suche
#                  - eigene Bereiche/Produkte
# v2011-11-14 Paco erster Versuch einer Abindung an Oracle-DB
# v2011-11-19 Paco komplette Adaption an Oracle, Hinzufuegen von
#                  Kommentaren moeglich
# v2011-11-20 Paco Emailversand und Dateiupload hinzugefuegt
# v2011-11-22 Paco Dateiupload direkt in den Kommtar hinzugefuegt
# v2011-11-26 Paco Adaptierung Datenmodell MySQL
# v2011-11-27 Paco Adatierung der Sortierung und der Spaltenbreiten
# v2011-11-29 Paco Adaptierung auf Layout (feststehende Kopf- und
#                  Fusszeile)
# v2011-12-21 Paco Beim Update Kennwort fehlte im SQL-Select ein
#                  Leerzeichen9
# v2014-07-03 Paco Neue Installation im Zuge Projekt OPO CI_LOG5
# v2014-07-04 Paco neue Email und neuer Link
# v2014-07-21 Paco es werden nur Konstateneinträge berücksichtigt, deren
#                  Statis ACTIVE=1 ist
# v2014-08-01 Paco Logging kann jetzt in eine Datei geleitet werden
#                  Parameter
#                  - detailLogging
#                  - logFile
# v2014-08-03 Paco Neuer Parameter IBNcanAddOPEntries mit dem eingestellt
#                  werden kann, ob ein IBN auch OP-Punkte anlegen darf
#                  oder nicht
# v2014-11-19 Paco Fehler bei Passwortaenderung behoben
# v2014-11-24 Paco Sonderzeichen bei Emails behoben; Emailversand jetzt
#                  in HTML-Format mit integriertem Link
# v2014-11-25 Paco direkter Link kann nun auch ohne Anmeldung angeklickt werden
# v2014-11-28 Paco added logSQLError()
# 2015-01-10 Paco Ergänzung, so dass geplante Testfälle ebenso erfasst werden können
# 2014-01-14 Paco Wir schicken bei Anlage eines neuen OP-Punkts nur eine Email, wenn
#                 der OP-Punkt mit Status 1 (OFFEN) angelegt wurde
# 2015-01-29 Paco Formattierung für Textareas hinzugefuegt (tinymce)
#                 und AJX entfernt
# 2015-01-30 Paco debugIntoDB: maximale Laenge entsprechend adaptiert
#                 Verschieben von js und css in entsprechende
#                 Unterverzeichnisse
# 2015-02-01 Paco Anpassung der Anzeige der Beschreibung (nicht mehr
#                 fett)
# 2015-02-09 Paco Suchfilter bleiben nun bestehen, bis diese geloescht
#                 werden
# 2015-07-29 Paco Produkt und Bereich koennen nun im Konfig-File
#                 beliebig benannnt und die
#                 Produkte deaktiviert werden
# 2015-07-31 Paco Als Emailgruppe kann nun mehr als eine Gruppe
#                 angegebene werden (Array)
# 2015-08-07 Paco indiv-Index-Datei eingefuegt fuer individuelle
#                 Anpassungen
#                 DB-Updates in eigenes Include-PHP ausgelagert
# 2015-08-09 Paco neues Installationspaket
# 2015-08-24 Paco neue Indivs:
#                 - canChangeStatus
#                 - userIsClient
#                 - displayInternalComment
#                 DisplayName (also ob Kurzzeichen oder Name angezeigt)
#                 wird nun auch in der Anzeige der Kommentare verwendet
# 2015-12-16 Paco neuer Parameter addNewItemAllowed mit dem das Hinzufügen
#                 neuer OP-Punkte aktiviert bzw. deaktiviert werden kann
# 2015-12-21 Paco - neues Datenmodell mit Reihungscode für Area und Product
#                 - Sortierung in index.php entsprechend angepasst
#                 - Korrektur Installationsdatenmodell
#                 - Erweiterung Datenmodell um PL-Kunde mit eigener fixer Gruppen-ID
#                 - Minimum-Vorname jetzt 3 und nicht mehr 5 Zeichen
#                 - Fehler ausgebessert, dass Kunde interne Eintraege sehen kann
#                 - indiv displayInternalComment geloescht
#                 - indiv shouldInternalsBePrinted geloescht
#                 - indiv userIsClient geloescht
#                 - neuer Konfig-Parameter displayDevInfos
# 2016-01-26 Paco - minimal Settings für JavaScript-Abfragen in Konfig
#                   aufgenommen
#                 - Fix Bug, dass EmailFontSize permanent in das Konfig
#                   File geschrieben wird
# 2016-02-12 Paco Bei der Emailverstaendigung "Neuer Kommentar" wird nun
#                 auch der Kommentar direkt in der Email angezeigt
# 2016-02-14 Paco Verbesserter Emailversand bei
#                 - Neuanlage OP-Punkt
#                 - Aktualisierung OP-Punkt
#                 Neuer Parameter $isDevelopment für Development-Infos
#                 zur Anzeige der Debug-Einträge
#                 Kunden-Projektleiter kann jetzt auch Fremdeinträge
#                 bezüglich des Status ändern.
# 2016-02-15 Paco in der Konfigurationsdatei gibt es nun einen Parameter
#                 defaultEmailFrom über den ein eigener Absender für den
#                 Emailversand eingegeben werden kann info@oplist.com
#                 ist default und bedeutet: Keine Verwendung einer eigenen
#                 Absenderemailadresse
# 2016-03-14 Paco Tinymce (Formatierungen) flog scheinbar raus -->
#                 wieder eingebaut!
# 2016-10-23 Paco Bug behoben, dass IT-SYSen einen OP-Punkt nicht
#                 editieren kann
# 2017-06-29 Paco neue Konfigurationsparameter hinzugefuegt:
#                 viewAddedBy, viewAllocated und viewDeadline
# 2017-07-04 Paco neuer Konfigurationsparameter viewOPID
# 2017-07-05 Paco neue Konfigurationsparameter oplistcolumns
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
// read params from configuration-file
$iniParams = parse_ini_file("conf/oplist.ini");
####------------------------------------------------------------------
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
# params from config-file
$projectName = $iniParams["projectName"];
#$appUrl = $iniParams["appUrl"];
$appUrl = getApplicationUrl();
$usedb=$iniParams["usedb"];
if (isset($iniParams["sqlHost"])) {
    $sqlHost = $iniParams["sqlHost"];
}
if (isset($iniParams["mySqlDB"])) {
    $mySqlDB = $iniParams["mySqlDB"];
}
if (isset($iniParams["sqlUser"])) {
    $sqlUser = $iniParams["sqlUser"];
}
if (isset($iniParams["sqlPass"])) {
    $sqlPass = $iniParams["sqlPass"];
}
$oracleServiceName = $iniParams["oracleServiceName"];
if (isset($iniParams["sqlDB"])) {
    $sqlDB = $iniParams["sqlDB"];
}
$oracleUsername = $iniParams["oracleUsername"];
$oraclePassword = $iniParams["oraclePassword"];
$usePwdTransformation=$iniParams["usePwdTransformation"];
$mailModus = $iniParams["mailModus"];
$debugMail = $iniParams["debugMail"];
$debugSQL = $iniParams["debugSQL"];
$DefaultStatusNewOPEntry = $iniParams["DefaultStatusNewOPEntry"];
# global connection
$connection = null;
# overall action switch
$mode = "";
# output
$tmpHTML = "";
# change next value to 1 if you want to activate logging
$logConstant = $iniParams["detailLogging"];
$logFile = $iniParams["logFile"];
$configFile = 'conf/oplist.ini';
#---------------------------------------------------------------------
$databaseMinVersion=8;
$myVersion="17.07";
$SVNRevision=1438;
$myVersionDate='2017-07-07';
#---------------------------------------------------------------------
$nightlyBuild=0;
$defaultErrorMsg = "";
#1= Development-Infos anzeigen, 0 = nicht anzeigen
$isDevelopment=0;
######################################################################

if (isset($iniParams["mailGroup"])) {
    $mailGroup = $iniParams["mailGroup"];

    $mailGroupString = "";
    for ($i=0;$i<=count($mailGroup)-1;$i++) {
        if ($i == 0) {
            $mailGroupString = $mailGroup[$i];
        } else {
            $mailGroupString .= ", ".$mailGroup[$i];
        }
    }
} else {
    $mailGroupString = "0";
}


if (isset($iniParams["productText"])) {
    $productText = $iniParams["productText"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # Beschriftung PRODUCT\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "productText = \"Bereich\";\n", FILE_APPEND | LOCK_EX);
    $productText = "Bereich";
}

if (isset($iniParams["areaText"])) {
    $areaText = $iniParams["areaText"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # Beschriftung AREA\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "areaText = \"Bereich\";\n", FILE_APPEND | LOCK_EX);
    $areaText = "Bereich";
}

if (isset($iniParams["useProducts"])) {
    $useProducts = $iniParams["useProducts"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # Sollen Produkte verwendet werden (1/0)\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "useProducts = 1;\n", FILE_APPEND | LOCK_EX);
    $useProducts = 1;
}


if (isset($iniParams["ChangeTitleDescriptionPossible"])) {
    $ChangeTitleDescriptionPossible = $iniParams["ChangeTitleDescriptionPossible"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # Titel und Beschreibung nachtraeglich aenderbar (1/0)\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "ChangeTitleDescriptionPossible = 0;\n", FILE_APPEND | LOCK_EX);
    $ChangeTitleDescriptionPossible = 0;
}

if (isset($iniParams["CustomerCanChangeOPEntries"])) {
    $CustomerCanChangeOPEntries = $iniParams["CustomerCanChangeOPEntries"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # Kunde kann OP-Eintraege aendern (1/0)\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "CustomerCanChangeOPEntries = 0;\n", FILE_APPEND | LOCK_EX);
    $CustomerCanChangeOPEntries = 0;
}

if (isset($iniParams["CustomerCanChangeStatus"])) {
    $CustomerCanChangeStatus = $iniParams["CustomerCanChangeStatus"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # Kunde kann den Status eines OP-Eintras aendern (1/0)\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "CustomerCanChangeStatus = 0;\n", FILE_APPEND | LOCK_EX);
    $CustomerCanChangeStatus = 0;
}

if (isset($iniParams["displayName"])) {
    $displayName = $iniParams["displayName"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # Soll der Name (1) oder das Kurzzeichen (0) angezeigt werden\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "displayName = 0;\n", FILE_APPEND | LOCK_EX);
    $displayName = 0;
}

if (isset($iniParams["addNewItemAllowed"])) {
    $addNewItemAllowed = $iniParams["addNewItemAllowed"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # Aktiviere/Deaktiviere die Möglichkeit, OP-Punkte anzulegen\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # 1: neuer OP-Punkt kann hinzugefügt werden\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; ## 0: es kann kein neuer OP-Punkt mehr hinnzugefügt werden\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "addNewItemAllowed = 1;\n", FILE_APPEND | LOCK_EX);
    $addNewItemAllowed = 0;
}

if (isset($iniParams["displayDevInfos"])) {
    $displayDevInfos = $iniParams["displayDevInfos"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # Sollen Entwicklungsinfo direkt auf der Homepage ausgegeben werden? (1/0)\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "displayDevInfos = 0;\n", FILE_APPEND | LOCK_EX);
    $displayDevInfos = 0;
}

if (isset($iniParams["minPwdLength"])) {
    $minPwdLength = $iniParams["minPwdLength"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # minimale Laenge des Kewnnworts\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "minPwdLength = 8;\n", FILE_APPEND | LOCK_EX);
    $minPwdLength = 5;
}

if (isset($iniParams["minOpentryLength"])) {
    $minOpentryLength = $iniParams["minOpentryLength"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # minimale Laenge des OP-Eintrags\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "minOpentryLength = 10;\n", FILE_APPEND | LOCK_EX);
    $minOpentryLength = 1;
}

if (isset($iniParams["minUsernameLength"])) {
    $minUsernameLength = $iniParams["minUsernameLength"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # minimale Laenge des Benutzernamens\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "minUsernameLength = 3;\n", FILE_APPEND | LOCK_EX);
    $minUsernameLength = 1;
}

if (isset($iniParams["minFirstnameLength"])) {
    $minFirstnameLength = $iniParams["minFirstnameLength"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # minimale Laenge des Vornamens\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "minFirstnameLength = 5;\n", FILE_APPEND | LOCK_EX);
    $minFirstnameLength = 1;
}

if (isset($iniParams["minLastnameLength"])) {
    $minLastnameLength = $iniParams["minLastnameLength"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # minimale Laenge des Familiennamens\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "minLastnameLength = 5;\n", FILE_APPEND | LOCK_EX);
    $minLastnameLength = 1;
}

if (isset($iniParams["defaultEmailFrom"])) {
    $defaultEmailFrom = $iniParams["defaultEmailFrom"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # manchmal erlauben SMTP-Server den Versand von Emails nur von einer\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # bestimmten Adresse. Wenn man eine bestimmte Adresse verwenden\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # möchte, so ist info@oplist.com durch diese zu ersetzen.\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # ist info@oplist.com eingestellt, so wird keine eigenen Absenderemail\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # verwendet\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "defaultEmailFrom = \"info@oplist.com\";\n", FILE_APPEND | LOCK_EX);
    $defaultEmailFrom = "info@oplist.com";
}

if (isset($iniParams["viewAddedBy"])) {
    $viewAddedBy = $iniParams["viewAddedBy"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # zeige ANGELEGT in der Uebersicht an\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "viewAddedBy = 1;\n", FILE_APPEND | LOCK_EX);
    $viewAddedBy = "1";
}

if (isset($iniParams["viewAllocated"])) {
    $viewAllocated = $iniParams["viewAllocated"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # zeige ZUGEWIESEN in der Uebersicht an\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "viewAllocated = 1;\n", FILE_APPEND | LOCK_EX);
    $viewAllocated = "1";
}

if (isset($iniParams["viewDeadline"])) {
    $viewDeadline = $iniParams["viewDeadline"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # zeige Termin in der Uebersicht an\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "viewDeadline = 0;\n", FILE_APPEND | LOCK_EX);
    $viewDeadline = "0";
}

if (isset($iniParams["defaultAssigned"])) {
    $defaultAssigned = $iniParams["defaultAssigned"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # Benutzer-ID des default zugewiesenen Benutzers\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "defaultAssigned = 0;\n", FILE_APPEND | LOCK_EX);
    $defaultAssigned = "0";
}


if (isset($iniParams["viewOPID"])) {
    $viewOPID = $iniParams["viewOPID"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # Anzeige der Nummer des OP-Eintrags\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "viewOPID = 1;\n", FILE_APPEND | LOCK_EX);
    $viewOPID = "0";
}

$oplistcolumnsAmount = 10;
if (isset($iniParams["oplistcolumns"])) {
    $oplistcolumns = $iniParams["oplistcolumns"];
} else {
    file_put_contents("conf/oplist.ini", "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # Um die Reihenfolge der Anzeige der einzelnen Spalten zu aendern\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # bitte einfach die nachfolgenden Zeilen in die entsprechend\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "; # gewuenschte Reihenfolge bringen\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "oplistcolumns[] = \"NR\";\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "oplistcolumns[] = \"TITLE\";\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "oplistcolumns[] = \"CREATED\";\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "oplistcolumns[] = \"STATE\";\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "oplistcolumns[] = \"DEADLINE\";\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "oplistcolumns[] = \"PRIORITY\";\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "oplistcolumns[] = \"AREA\";\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "oplistcolumns[] = \"PRODUCT\";\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "oplistcolumns[] = \"CHANGED\";\n", FILE_APPEND | LOCK_EX);
    file_put_contents("conf/oplist.ini", "oplistcolumns[] = \"ASSIGNED\";\n", FILE_APPEND | LOCK_EX);
    $oplistcolumns[0] = "NR";
    $oplistcolumns[1] = "TITLE";
    $oplistcolumns[2] = "CREATED";
    $oplistcolumns[3] = "STATE";
    $oplistcolumns[4] = "DEADLINE";
    $oplistcolumns[5] = "PRIORITY";
    $oplistcolumns[7] = "AREA";
    $oplistcolumns[6] = "PRODUCT";
    $oplistcolumns[8] = "CHANGED";
    $oplistcolumns[9] = "ASSIGNED";
}














#logAlwaysIntoFile ("This text will always be logged");

if ($logConstant == 1) {
    $debugSQL=1;
    logAlwaysIntoFile ("logConstant=1: detail logging will be done");
}


if ($debugSQL == 1) {
    logAlwaysIntoFile ("debugSQL=1: logging is activated");
}

logAlwaysIntoFile ("mailModus: <".$mailModus.">");


if ($myVersionDate == 2) {
    $myVersionDate = "in progress";
}

$header = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN">
    <html><head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <link rel="stylesheet" type="text/css" href="css/oplist.css">
    <link rel="stylesheet" type="text/css" href="css/oplist_indiv.css">
    <title>'.$projectName.'</title>
    <script>
    var jsMinPwdLength='.$minPwdLength.';
    var jsMinOpentryLength='.$minOpentryLength.';
    var jsMinUsernameLength='.$minUsernameLength.';
    var jsMinFirstnameLength='.$minFirstnameLength.';
    var jsMinLastnameLength='.$minLastnameLength.';
    </script>
    <script language="JavaScript" type="text/javascript" src="js/oplist.js"></script>
    <script language="JavaScript" type="text/javascript" src="js/tinymce/tinymce.min.js"></script>
    <script type="text/javascript">
        tinymce.init({
            selector: "textarea",
            forced_root_block : "div",
            statusbar : false,
            menubar : false
        });
    </script>
    </head>
    <body link="#0000FF" vlink="#0000FF">
    <div class="header"><img src="img/logo.jpg" width=114 height=48 border=0 alt="OPList">';

#unset($_SESSION['BUID']);
#unset($_SESSION['USERNAME']);
#session_unset();
#session_destroy();


#---------------------------------------------------------------------
# (c) www.glawar.at: ergibt YYY-MM-DD HH:MM:SS
#---------------------------------------------------------------------
function getActualDateAndTime() {
    return strftime("%Y-%m-%d %H:%M:%S");
}


#---------------------------------------------------------------------
# (c) www.glawar.at: schreibt den uebergebenen Text in das LogFile
#                    sofern $debugSQL im OPLIST.INI auf 1 gestellt wurde
#---------------------------------------------------------------------
function debugIntoFile($debugText){
    global $logConstant;
    global $logFile;

    if ($logConstant == 1) {
        #echo $debugText;
        #file_put_contents($logFile, "[".getActualDateAndTime()."] ".$debugText."\n", FILE_APPEND | LOCK_EX);
        file_put_contents($logFile, "[".getActualDateAndTime()."] D: ".$debugText."\n", FILE_APPEND | LOCK_EX);
    }
}


#---------------------------------------------------------------------
# (c) www.glawar.at: schreibt den uebergebenen Text in das LogFile
#                    sofern $logConstant auf 1 gestellt wurde
#---------------------------------------------------------------------
function logIntoFile($logText){
    global $debugSQL;
    global $logFile;

    if ($debugSQL == 1) {
        file_put_contents($logFile, "[".getActualDateAndTime()."] L: ".$logText."\n", FILE_APPEND | LOCK_EX);
    }
}

#---------------------------------------------------------------------
# (c) www.glawar.at: schrebt den angegebenen Text immer ins log-File
#---------------------------------------------------------------------
function logAlwaysIntoFile($logText){
    global $logFile;

    file_put_contents($logFile, "[".getActualDateAndTime()."] L: ".$logText."\n", FILE_APPEND | LOCK_EX);
}


# Check new parameter and create them if necessary
if (!isset($logConstant)) {
    logIntoFile("Wir setzen detailLogging");
    $logConstant = 0;
    file_put_contents($configFile, "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents($configFile, "; # 1: detailliertes Logging in Datei wird aktiviert\n", FILE_APPEND | LOCK_EX);
    file_put_contents($configFile, "; # 0: detailliertes Logging ist deaktivert\n", FILE_APPEND | LOCK_EX);
    file_put_contents($configFile, "detailLogging = 0;\n", FILE_APPEND | LOCK_EX);
} else {
    logIntoFile("logConstant hat einen Wert - naemlich <".$logConstant.">");
}

if (!isset($logFile)) {
    logIntoFile("Wir setzen logFile");
    $logFile = 'log/oplist.log';
    file_put_contents($configFile, "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents($configFile, "; # Name der Logdatei\n", FILE_APPEND | LOCK_EX);
    file_put_contents($configFile, "logFile = log/oplist.log;\n", FILE_APPEND | LOCK_EX);
} else {
    debugIntoFile("configFile hat einen Wert - naemlich <".$configFile.">");
}

if (!isset($iniParams["IBNcanAddOPEntries"])) {
    logIntoFile("Wir setzen IBNcanAddOPEntries");
    $IBNcanAddOPEntries = 0;
    file_put_contents($configFile, "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents($configFile, "; # 1: Gruppe IBN kann OP-Einträge anlegen\n", FILE_APPEND | LOCK_EX);
    file_put_contents($configFile, "; # 0: Gruppe IBN kann keine OP-Einträge anlegen\n", FILE_APPEND | LOCK_EX);
    file_put_contents($configFile, "IBNcanAddOPEntries = 0;\n", FILE_APPEND | LOCK_EX);
} else {
    $IBNcanAddOPEntries = $iniParams["IBNcanAddOPEntries"];
    debugIntoFile("IBNcanAddOPEntries hat einen Wert - naemlich <".$IBNcanAddOPEntries.">");
}

if (!isset($iniParams["EmailFontSize"])) {
    logIntoFile("Wir setzen EmailFontSize");
    $EmailFontSize = 14;
    file_put_contents($configFile, "; ####------------------------------------------------------------------\n", FILE_APPEND | LOCK_EX);
    file_put_contents($configFile, "; # Schriftgroesse fuer emails\n", FILE_APPEND | LOCK_EX);
    file_put_contents($configFile, "EmailFontSize = 14;\n", FILE_APPEND | LOCK_EX);
} else {
    $EmailFontSize = $iniParams["EmailFontSize"];
    debugIntoFile("EmailFontSize hat einen Wert - naemlich <".$EmailFontSize.">");
}


#---------------------------------------------------------------------
# (c) www.glawar.at: liefert in Abhaengigkeit der obigen Parameter in
#                    $connection eine gueltige Datenbankverbindung
#---------------------------------------------------------------------
function getConnection() {
    global $connection;
    global $usedb;
    global $sqlHost;
    global $sqlUser;
    global $sqlPass;
    global $sqlDB;
    global $oracleUsername;
    global $oraclePassword;
    global $oracleServiceName;
    global $mySqlDB;

    if ($usedb == "mysql") {
        #$connection = mysql_connect($sqlHost, $sqlUser, $sqlPass);
        $connection = mysqli_connect($sqlHost, $sqlUser, $sqlPass, $mySqlDB);
        if (!$connection) {
            logSQLError();
            echo "Kein Zugriff auf die MySQL-Datenbank moeglich: ".getError();
            exit;
        }

        /*if (!mysqli_select_db($mySqlDB)) {
            echo "Kann die Datenbank ".$mySqlDB." nicht auswaehlen: " . getError();
            exit;
        }*/
    } else if ($usedb == "oracle") {
        $connection = oci_connect ($oracleUsername, $oraclePassword, $oracleServiceName);
         if (!$connection) {
            echo "Kein Zugriff auf die Oracle-Datenbank moeglich: ".getError();
            exit;
        }
    }
}


#---------------------------------------------------------------------
# (c) www.glawar.at: schließt die offene DB-Connection $connection
#---------------------------------------------------------------------
function closeConnection(){
    global $connection;
    global $usedb;

    if ($usedb == "mysql") {
        mysqli_close($connection);
    } else if ($usedb == "oracle") {
        oci_close($connection);
    }
}


#---------------------------------------------------------------------
# (c) www.glawar.at: liefert in Abhaengigkeit der obigen Parameter
#                    eine gueltige Ressource
#---------------------------------------------------------------------
function getRessource ($query) {
    global $connection;
    global $usedb;

    #debugIntoDB ("getRessource: ".$query);

    if ($usedb == "mysql") {
        #$retVal = mysql_query($query, $connection);
        $retVal = mysqli_query($connection, $query);
    } else if ($usedb == "oracle") {
        $retVal = oci_parse($connection, $query);
        oci_execute($retVal);
    }

    return $retVal;
}

#---------------------------------------------------------------------
# (c) www.glawar.at: liefert in Abhaengigkeit der obigen Parameter
#                    den DB-Error
#---------------------------------------------------------------------
function getError () {
    global $usedb;
    global $connection;

    if ($usedb == "mysql") {
        $retVal = mysqli_error($connection);
    } else if ($usedb == "oracle") {
        $retVal = oci_error();
    }
    return $retVal;
}


#---------------------------------------------------------------------
# (c) www.glawar.at: liefert in Abhaengigkeit der obigen Parameter
#                    die Anzahl der vom Select betroffenen Datensaetze
#                    Wurde als DB oracle gewaehlt, so liefert dieses
#                    Funktion bei einem Select KEINE korrekten Werte!!
#---------------------------------------------------------------------
function getAmountOfResults ($ressource) {
    global $usedb;

    if ($usedb == "mysql") {
        $retVal = mysql_num_rows($ressource);
    } else if ($usedb == "oracle") {
        $retVal = oci_num_rows($ressource);
    }
}


#---------------------------------------------------------------------
# (c) www.glawar.at: liefert in Abhaengigkeit der obigen Parameter
#                    einen Datensatz
#---------------------------------------------------------------------
function getRow ($ressource) {
    global $usedb;

    if ($usedb == "mysql") {
        #$retVal = mysql_fetch_assoc($ressource);
        $retVal = mysqli_fetch_assoc($ressource);
    } else if ($usedb == "oracle") {
        $retVal = oci_fetch_assoc($ressource);
    }

    return $retVal;
}


#---------------------------------------------------------------------
# (c) www.glawar.at: gibt die belegte Ressource wieder frei
#---------------------------------------------------------------------
function freeRessource($ressource){
    global $usedb;
    if ($usedb == "oracle") {
        oci_free_statement($ressource);
    }
}


#---------------------------------------------------------------------
# (c) www.glawar.at: Verschluesselt das Kennwort
#---------------------------------------------------------------------
function transformPwd ($pwd) {
    global $usePwdTransformation;

    if ($usePwdTransformation == "md5") {
        return md5($pwd);
    } else {
        return $pwd;
    }
}

#---------------------------------------------------------------------
# (c) www.glawar.at: Schreibt debugText in OPLIST_DEBUG
#---------------------------------------------------------------------
function debugIntoDB ($debugText) {
    global $debugSQL;

    $content = str_replace("'", "''", $debugText);
    $len = strlen($content);
    if ($len > 3995) {
        $len = 3995;
    }
    $content2 = substr($content, 0, $len);

    $sQuery = "INSERT INTO OPLIST_DEBUG (VALUE) VALUES ('".$content2."')";
    debugIntoFile ("Insert into Logging-Table: <".$sQuery.">");
    #if ($debugSQL == 1) {
    #    echo "<p><b>Insert into Logging-Table:</b>".$sQuery."</p>";
    #}
    $result = getRessource($sQuery);
    echo getError();
    logSQLError();
    freeRessource($result);
}


#---------------------------------------------------------------------
# (c) www.glawar.at: Holt die Email
#---------------------------------------------------------------------
function getEmailOfId ($userId) {
    global $debugSQL;

    $retVal = null;

    $sQuery = "SELECT DISTINCT OPUEMAIL FROM OPLIST_USERS WHERE OPUID = ".$userId." AND OPUACTIVE = 1 AND OPUEMAIL IS NOT NULL";
    debugIntoFile("Select getEmailOfId: <".$sQuery.">");
    #if ($debugSQL == 1) {
    #    echo "<p><b>Email-Select:</b>".$sQuery."</p>";
    #}
    $result = getRessource($sQuery);
    echo getError();
    logSQLError();
    while ($val = getRow($result)) {
        $retVal = $val['OPUEMAIL'];
    }
    echo getError();
    freeRessource($result);

    return $retVal;
}


#---------------------------------------------------------------------
# (c) www.glawar.at: logs an sql-error
#---------------------------------------------------------------------
function logSQLError () {
    global $defaultErrorMsg;

    $errorMessage = getError();
    if(empty($errorMessage)) {
        $retVal = 0;
    } else {
        if(empty($defaultErrorMsg)) {
            $_SESSION['ERRORMESSAGE'] = $errorMessage;
        } else {
            $_SESSION['ERRORMESSAGE'] = $defaultErrorMsg." (".$errorMessage.")";
        }
        logError($errorMessage);
        $retVal = 1;
    }

    return $retVal;
}


function logError($error) {
    if(!empty($error)) {
        logIntoFile($error);
    }
}

function getDBVersion() {
    $retVal = 1;

    $sQuerySub = "SELECT OPVVERSION, OPVDESC FROM OPLIST_VERSION WHERE OPVID = 1";
    $resultSub = getRessource ($sQuerySub);
    logSQLError($sQuerySub);

    while ($val = getRow($resultSub)) {
        $retVal = $val['OPVVERSION'];
    }
    freeRessource($resultSub);

    return $retVal;
}

#---------------------------------------------------------------------
# (c) www.glawar.at: besseres Debugging bei Problemen mit Emailversand
#---------------------------------------------------------------------
function debugEmailFunction ($fromEmail, $subject, $message, $toEmail, $header) {
    debugIntoFile("======================================================================");

    debugIntoFile("from Email:");
    debugIntoFile($fromEmail);
    debugIntoFile("----------------------------------------------------------------------");

    debugIntoFile("to Email:");
    debugIntoFile($toEmail);
    debugIntoFile("----------------------------------------------------------------------");

    debugIntoFile("Subject:");
    debugIntoFile($subject);
    debugIntoFile("----------------------------------------------------------------------");

    debugIntoFile("Header:");
    debugIntoFile($header);
    debugIntoFile("----------------------------------------------------------------------");

    debugIntoFile("Message:");
    debugIntoFile($message);

    debugIntoFile("======================================================================");
}


#---------------------------------------------------------------------
# (c) www.glawar.at: MAIN
#---------------------------------------------------------------------

if (isset($_POST['mode'])) {
    $mode = $_POST['mode'];
} elseif  (isset($_GET['mode'])) {
    $mode = $_GET['mode'];
}

getConnection();

if (!$connection) {
    echo "Keine Verbindung zur DB: " . getError();
    exit;
}


# check for update
check4NecessaryDBUpdates();




# keine Sonderzeichen fuer Username und Kennwort moeglich
$sanitizeUserPwd = "";


#---------------------------------------------------------------------
# (c) ds.it@gmx.de: Loescht die nicht erlaubten Zeichen aus dem
#                   uebergebenen String
# $string der zu ueberpruefende String
# $allowed Array der zusaetzlich erlaubten Zeichen
#---------------------------------------------------------------------
function sanitize($string, $allowed = array())    {
    $allow = "";

    if(!empty($allowed)) {
        foreach ($allowed as $value) {
            $allow .= "\\$value";
        }
    }

    if(is_array($string)){
        foreach ($string as $key => $clean) {
            $cleaned[$key] = preg_replace( "/[^{$allow}a-zA-Z0-9]/", "", $clean);
        }
    } else{
        $cleaned = preg_replace( "/[^{$allow}a-zA-Z0-9]/", "", $string );
    }

    return $cleaned;
}


function getApplicationUrl () {
    $retVal = "";

    if (isset ($_SERVER["HTTPS"])) {
        $retVal="https";
    } else {
        $retVal="http";
    }

    $retVal .= "://".$_SERVER["SERVER_NAME"].dirname($_SERVER["PHP_SELF"])."/";

    return $retVal;
}

# user logged in?
if (empty($_SESSION['OPUID']) || empty($_SESSION['OPGID'])) {
    logIntoFile("user is not logged in");
    # no -> redirect to login page

    if ( !empty($_POST['USER']) && !empty($_POST['PASS']) ) {
        $user = sanitize($_POST['USER'], $sanitizeUserPwd);
        $pass = sanitize($_POST['PASS'], $sanitizeUserPwd);

        $sQuery = "SELECT OPU.OPUID, OPU.OPGID, OPU.OPUEMAIL, OPU.OPULNAME, OPU.OPUFNAME, OPG.OPGTEXT, OPG.INTERNAL, OPG.CLIENT FROM OPLIST_USERS OPU, OPLIST_GROUP OPG WHERE OPG.OPGID = OPU.OPGID AND OPU.OPUACTIVE = 1 AND UPPER(OPU.OPUUSERNAME) = UPPER('".$user."') AND OPU.OPUPASSWORD = '".transformPwd($pass)."'";
        debugIntoFile("Login-Select: <".$sQuery.">");
        #if ($debugSQL == 1) {
        #    echo "<p><b>Login-Select:</b>".$sQuery."</p>";
        #}
        $result = getRessource ($sQuery);
        logSQLError();
        echo getError();

        if (!$result) {
            echo "Anfrage ($sQuery) konnte nicht ausgefuehrt werden : " . getError();
            exit;
        }

        //debugIntoFile("A");

        $userArr = array();
        $intCount = 0;

        while ($val = getRow($result)) {
            $_SESSION['OPUID']=$val['OPUID'];
            $_SESSION['OPUUSERNAME']=$user;
            $_SESSION['OPGID']=$val['OPGID'];
            $_SESSION['OPUEMAIL']=$val['OPUEMAIL'];
            $_SESSION['OPULNAME']=$val['OPULNAME'];
            $_SESSION['OPUFNAME']=$val['OPUFNAME'];
            $_SESSION['OPUPASSWORD']=transformPwd($pass);
            $_SESSION['OPGTEXT']=$val['OPGTEXT'];
            $_SESSION['OPGINTERNAL']=$val['INTERNAL'];
            $_SESSION['OPGCLIENT']=$val['CLIENT'];

            $intCount = $intCount + 1;
            #header ("Location: index.php");
        }

        freeRessource($result);
        #debugIntoFile ("Paco.mode=".$mode);
        #debugIntoFile ("Paco.OPID=".$_POST['OPID']);
        if ($mode == "comment" && isset ($_POST['OPID'])) {
            //debugIntoFile("B");
            header ("Location: index.php?mode=comment&OPID=".$_POST['OPID']);
        } else {
            //debugIntoFile("C");
            header ("Location: index.php");
        }

        //debugIntoFile("D");

        #header ("Location: index.php");

        if ($intCount == 0) {
            //debugIntoFile("E");
            echo "Benutzerkonto wurde deaktiviert! |".$intCount."|";
            exit;
        }
    } else {
        # Paco.Anmeldung an ToDo-Liste
        $tmpHTML = "<div id='content'><fieldset>
            <form method=post action=\"".$_SERVER['PHP_SELF']."\">
            <table border='0'><tr><td>";
        if (isset ($_GET['mode']) && isset ($_GET['OPID'])) {
            $tmpHTML .= "<input type='hidden' name='mode' value='".$_GET['mode']."'>
                <input type='hidden' name='OPID' value ='".$_GET['OPID']."'>";
        }
        $tmpHTML .= "<label for='user'>Benutzername</label></td><td><input class='textfield' type='text' name='USER'></td></tr><tr><td><label for='pass'>Kennwort</label></td><td><input class='textfield' type='password' name='PASS'></td></tr><tr><td colspan='2'><input type='submit' value='Anmelden'></td></tr></fieldset></form>
            </table>";
    }
} else {
    logIntoFile("user is logged in");
    $header .= "
        <script src='js/sort.js'></script>
        <div class='menuBar'>";
    $header .= "<a class='menuitem' title='Meine OP-Punke' href='?mode=userlist'><img src='img/home.png' width=32 height=32 border=0 hspace=10 alt='Meine OP-Punkte'></a>";
    $header .= "<a class='menuitem' title='Alle OP-Punke' href='?mode=list'><img hspace=10 src='img/list.png' width=32 height=32 border=0 alt='Alle OP-Punke'></a>";

    if (($_SESSION['OPGID'] == "1" || $_SESSION['OPGCLIENT'] == 1 || $IBNcanAddOPEntries == 1) && ($addNewItemAllowed == 1) ) {
        $header .= "<a class='menuitem' title='Neuer OP-Punkt' href='?mode=new'><img hspace=10 src='img/new.png' width=32 height=32 border=0 alt='Neuer OP-Punkt'></a>";
    }

    $header .= "<a class='menuitem' title='Benutzerverwaltung' href='?mode=config'><img hspace=10 src='img/config.png' width=32 height=32 border=0 alt='Benutzerverwaltung'></a><a class='menuitem' title='Benutzerhinweise' href='?mode=help'><img hspace=10 src='img/help.png' width=32 height=32 border=0 alt='Benutzerhinweise'></a>";
    $header .= "<a class='menuitem' title='alle OP-Punkte ausdrucken' href='?mode=printall'><img hspace=10 src='img/printer-32x40.png' width=40 height=32 border=0 alt='alle OP-Punkte ausdrucken'></a>";

    $header .= "</div>";

    $header .= "<div class='loggedInUser'> ".$_SESSION['OPULNAME']." ".$_SESSION['OPUFNAME']." (".$_SESSION['OPGTEXT'].")</div>";

    $header .= "<div class='filterMenuBar'>";

    $header .= "<form method='post' action=".$_SERVER['PHP_SELF'].">";
    $header .= "<select name='FISTAT' class='textSizeFilter'>";
    $header .= "<option value='-1'>Alle Stati</option>";

    $sQuery = "SELECT OPSID, OPSTEXT FROM OPLIST_STAT WHERE (ACTIVE=1) ORDER BY OPSRC";
    debugIntoFile("Status-Select: <".$sQuery.">");

    $result = getRessource($sQuery);
    logSQLError();
    echo getError();
    $statArr = array();
    while ($rows = getRow($result )) {
        Array_push($statArr, $rows);
    }

    freeRessource($result);

    if (!isset ($_SESSION['FISTAT'])) {
        $_SESSION['FISTAT'] = "-1";
    }

    if (isset($_POST['FISTAT'])) {
        $_SESSION['FISTAT'] = $_POST['FISTAT'];
    }

    foreach ($statArr as $key => $val) {
        $tempSelected = "";
        if ($_SESSION['FISTAT'] == $val['OPSID']) {
            $tempSelected = " selected";
        }
        $header .=  "<option".$tempSelected." value='".$val['OPSID']."'>".$val['OPSTEXT']."</option>";
    }
    $header .= "</select>";

    $sQuery = "SELECT OPAID, OPATEXT FROM OPLIST_AREA WHERE (ACTIVE=1) ORDER BY OPARC, OPATEXT";
    debugIntoFile("Bereichs-Select: <".$sQuery.">");

    $result = getRessource($sQuery);
    logSQLError();
    echo getError();
    $typeArr = array();
    while ($rows = getRow($result )) {
        Array_push($typeArr,$rows);
    }

    freeRessource($result);

    if (!isset ($_SESSION['FIAREA'])) {
        $_SESSION['FIAREA'] = "-1";
    }
    if (isset($_POST['FIAREA'])) {
        $_SESSION['FIAREA'] = $_POST['FIAREA'];
    }

    $header .= "<select name='FIAREA' class='textSizeFilter'>";
    $header .= "<option value='-1'>--- ".$areaText." ---</option>";
    foreach ($typeArr as $key => $val) {
        $tempSelected = "";
        if ($_SESSION['FIAREA'] == $val['OPAID']) {
            $tempSelected = " selected";
        }
        $header .=  "<option".$tempSelected." value='".$val['OPAID']."'>".$val['OPATEXT']."</option>";
    }
    $header .= "</select>";


    $sQuery = "SELECT OPPID, OPPTEXT FROM OPLIST_PRODUCT WHERE (ACTIVE=1) ORDER BY OPPRC, OPPTEXT";
    debugIntoFile("Produkte-Select: <".$sQuery.">");

    $result = getRessource($sQuery);
    logSQLError();
    echo getError();
    $productArr = array();

    while ($rows = getRow($result )) {
        Array_push($productArr,$rows);
    }
    freeRessource($result);

    if (!isset ($_SESSION['FIPROD'])) {
        $_SESSION['FIPROD'] = "-1";
    }

    if (isset($_POST['FIPROD'])) {
        $_SESSION['FIPROD'] = $_POST['FIPROD'];
    }

    if ($useProducts == 1) {
        $header .= "<select name='FIPROD' class='textSizeFilter'>";
        $header .= "<option value='-1'>--- ".$productText." ---</option>";
        foreach ($productArr as $key => $val) {
            $tempSelected = "";
            if ($_SESSION['FIPROD'] == $val['OPPID']) {
                $tempSelected = " selected";
            }
            $header .=  "<option".$tempSelected." value='".$val['OPPID']."'>".$val['OPPTEXT']."</option>";
        }
        $header .= "</select>";
    }

    if (!isset ($_SESSION['SEARCHTXT'])) {
        $_SESSION['SEARCHTXT'] = "";
    }

    $header .= "<input class='textsearchFilter' size='20' type=text name='SEARCHTXT' value='".$_SESSION['SEARCHTXT']."'>";
    $header .= "<input type=submit value='Filter' name='FILTERME' class='textSize1'>";
    $header .= "</form>";
    $header .= "</div>
    <div class='logoutMenuBar'><a class='menuitem' title='Benutzer abmelden' href='?mode=logout'><img src='img/lock.png' width=32 height=32 border=0 hspace=5 alt='Benutzer abmelden'></a></div></div>
    <div id='content' style=''>";
    $sQuery = "SELECT * FROM OPLIST_USERS ORDER BY UPPER(OPUUSERNAME)";
    debugIntoFile("Benutzer-Select: <".$sQuery.">");

    $result = getRessource($sQuery);
    logSQLError();
    echo getError();
    $userArr = array();

    while ($rows = getRow($result )) {
        Array_push($userArr, $rows);
    }
    freeRessource($result);

    if ($usedb == "mysql") {
        $dateNow = "now()";
    } else if ($usedb == "oracle") {
        $dateNow = "sysdate";
    }

    $OPENTRY = "";
    $OPAID = "";
    $OPPID = "";
    $OPDESC = "";
    $OPSID = "";
    $OPPRIO = "";
    $OPUID_ASSIGNED = "";
    $OPDEADLINE = "";

    $prioArr = array(0 => "niedrig", 1 => "mittel", 2 => "hoch");

    if (!empty($_POST['updateuser'])) {
        logIntoFile("user will be updated");
        $OPUACTIVE = "0";
        if (isset ($_POST["OPUACTIVE"]) && $_POST["OPUACTIVE"] == "on") {
            $OPUACTIVE = "1";
        }

        if (!empty($_POST['OPUPASSWORD'])) {
            $tempPwdString = "OPUPASSWORD = '".transformPwd($_POST["OPUPASSWORD"])."', ";
        } else {
            $tempPwdString = " ";
        }

        $sQuery = "UPDATE OPLIST_USERS SET " .
            "OPUEMAIL = '" . $_POST["OPUEMAIL"] . "', " .
            "OPUUSERNAME = '" . $_POST["OPUUSERNAME"] . "', " .
            "OPUACTIVE = " . $OPUACTIVE . ", " .
            "OPULNAME = '" . $_POST["OPULNAME"] . "', " .
            "OPUFNAME = '" . $_POST["OPUFNAME"] . "', " .
            $tempPwdString.
            "OPGID = " . $_POST["OPGID"] .
            " WHERE OPUID = ".$_POST["OPUID"];

        debugIntoFile("Update-User-Select: <".$sQuery.">");

        $result = getRessource($sQuery);
        logSQLError();
        echo getError();
        freeRessource($result);
    } else if (!empty($_POST['UPDATEUSERME'])) {
        logIntoFile("user changes his personal data");
        if (!empty($_POST['OPUPASSWORD'])) {
            $tempPwdString = "OPUPASSWORD = '".transformPwd($_POST["OPUPASSWORD"])."'";
        } else {
            $tempPwdString = " ";
        }

        $sQuery = "UPDATE OPLIST_USERS SET " .
            "OPUEMAIL = '" . $_POST["OPUEMAIL"] . "', " .
            "OPULNAME = '" . $_POST["OPULNAME"] . "', " .
            $tempPwdString.
            ", OPUFNAME = '" . $_POST["OPUFNAME"] . "' " .
            "WHERE OPUID = ".$_POST["OPUID"];
        debugIntoFile("Update-User-Select: <".$sQuery.">");

        $result = getRessource($sQuery);
        logSQLError();
        echo getError();
        freeRessource($result);
        $_SESSION['OPUEMAIL']=$_POST['OPUEMAIL'];
        $_SESSION['OPULNAME']=$_POST['OPULNAME'];
        $_SESSION['OPUFNAME']=$_POST['OPUFNAME'];
    } else if (!empty($_POST['SAVEUSER'])) {
        logIntoFile("user will be added");
        $OPUACTIVE = "0";
        if ($_POST["OPUACTIVE"]=="on") {
            $OPUACTIVE ="1";
        }

        if ($usedb == "mysql") {
            #$dateNow = "'".date("d.m.Y, H:i \U\h\\r")."'";
            $dateNow = "now()";
            $nextId = "null";
        } else if ($usedb == "oracle") {
            $dateNow = "sysdate";
            $nextId = "oplistusers_seq.nextval";
        }

        $sQuery = "INSERT INTO OPLIST_USERS (OPUID, OPGID, OPUUSERNAME, OPULNAME, OPUFNAME, OPUEMAIL, OPUPASSWORD, OPUACTIVE, OPUDATE) VALUES (".$nextId.", ".$_POST["OPGID"].", '".
            $_POST["OPUUSERNAME"]."','".
            $_POST["OPULNAME"] . "', '" .
            $_POST["OPUFNAME"] . "', '" .
            $_POST["OPUEMAIL"] . "', '" .
            transformPwd($_POST["OPUPASSWORD"]) . "', " .
            $OPUACTIVE . ", ".$dateNow.")";
        debugIntoFile("Neuer-Benutzer-Select: <".$sQuery.">");

        $result = getRessource($sQuery);
        logSQLError();
        echo getError();
        freeRessource($result);
    } else if (!empty($_POST['deleteuser'])) {
        logIntoFile("user will be deleted");
        $sQuery = "DELETE FROM OPLIST_USERS WHERE OPUID = ".$_POST["OPUID"];
        debugIntoFile("Benutzer-Loeschen-Select: <".$sQuery.">");

        $result = getRessource($sQuery);
        logSQLError();
        echo getError();
        freeRessource($result);
    } else if (isset($_POST['save'])) {
        logIntoFile("new op entry will be created");
        # lege neuen OP an
        if ($usedb == "mysql") {
            $dateNow = "now()";
            $nextId = "null";
        } else if ($usedb == "oracle") {
            $dateNow = "sysdate";
            $nextId="oplist_seq.nextval";
        }

        $OPUID_ASSIGNED = $defaultAssigned;
        if (!empty($_POST['OPUID_ASSIGNED'])){
            $OPUID_ASSIGNED = $_POST['OPUID_ASSIGNED'];
        }

        if ($_POST['OPPID'] == "-1") {
            $OPPID = "4";
        } else {
            $OPPID = $_POST['OPPID'];
        }

        if ($_POST['OPAID'] == "-1") {
            $OPAID = "4";
        } else {
            $OPAID = $_POST['OPAID'];
        }

        $TempOPDEADLINE = 'null';

        if ( !empty($_POST['OPDEADLINE']) ) {
            $TempOPDEADLINE = "'".$_POST['OPDEADLINE']."'";
        }

        $sQuery = "INSERT INTO OPLIST (OPID, OPDATECREATED, OPDATEUPDATED, OPSID, OPENTRY, OPAID, OPDESC, OPPID, OPPRIO, OPUID_ASSIGNED, OPUID_CREATED, OPUID_UPDATED, OPDEADLINE)  VALUES (".$nextId."," .
            $dateNow . ", ".$dateNow.", ".$_POST['OPSID'].", " .
             "'" . str_replace("'","''",$_POST['OPENTRY']) . "'," .
            $OPAID . "," .
             "'" .str_replace("'","''",$_POST['OPDESC'])  . "'," .
            $OPPID . "," .
            $_POST['OPPRIO']. ",".
            $OPUID_ASSIGNED . ", ".$_SESSION['OPUID'].", ".$_SESSION['OPUID'].",".$TempOPDEADLINE.")";
        debugIntoFile("Neuer-OP-Select: <".$sQuery.">");

        $result = getRessource($sQuery);
        logSQLError();
        echo getError();
        freeRessource($result);

        # determine the id of the op entry
        $sQuery = "SELECT OPID FROM OPLIST WHERE OPENTRY = '" . str_replace("'","''",$_POST['OPENTRY']) . "' ORDER BY OPDATECREATED DESC";
        debugIntoFile("Get-ID of actual OP-Query: <".$sQuery.">");
        $result = getRessource($sQuery);
        logSQLError();
        echo getError();

        $foundOPID = 0;
        while ($val = getRow($result)) {
            if ($foundOPID == 0) {
                $foundOPID = $val['OPID'];
                logIntoFile("ID of last inserted OPEntry <".$val['OPID'].">");
            }
        }
        freeRessource($result);

        # add file if some added
        if (!empty($_FILES['datei']['name'])) {
            if ($usedb == "mysql") {
                $nextId = "null";
                $sQuery = "INSERT INTO OPLIST_FILE (OPLFT) VALUES (1)";
                debugIntoFile("Naechste-File-Id-ermitteln-Select: <".$sQuery.">");

                $result = getRessource($sQuery);
                logSQLError();
                freeRessource($result);

                $newFileName = mysql_insert_id();
            } else if ($usedb == "oracle") {
                $nextId="OPLISTCOMMENT_SEQ.nextval";
                $sQuery = "SELECT OPLISTFILENAME_SEQ.NEXTVAL FROM DUAL";
                debugIntoFile("Naechstes-Attachment-Select: <".$sQuery.">");

                $result = getRessource($sQuery);
                logSQLError();
                echo getError();
                while ($val = getRow($result)) {
                    $newFileName = $val['NEXTVAL'];
                }
                freeRessource($result);
            }

            $file_namerev = strrev($_FILES['datei']['name']);
            $parts = explode(".", $file_namerev);
            $endung = strrev($parts[0]);
            #echo "Dateiendung: ".$endung."<br>";
            $newFileName .= ".".$endung;
            #echo "A2".$newFileName."<br>";

            if (!move_uploaded_file($_FILES['datei']['tmp_name'], "uploads/".$newFileName)) {
                echo "Die Datei ".$_FILES['datei']['name']." konnte nicht gespeichert werden.";
            }
            $newFileName = "'".$newFileName."'";
            $sQuery = "INSERT INTO OPLIST_COMMENT (OPCID, OPUID, OPCTEXT, OPID, OPCPRIVATE, OPCFILENAME) VALUES (".$nextId.", ".$_SESSION['OPUID'].", 'Dateianhang zur OP-Beschreibung oben', ".$foundOPID.", 0, ".$newFileName.")";
            debugIntoFile("Insert-Attachment-Select: <".$sQuery.">");
            $result = getRessource($sQuery);
            logSQLError();
            echo getError();
            freeRessource($result);
        }


        #logIntoFile("I am the debug Tester");
        #logIntoFile("SeppDepp");
        #logIntoFile("mailModus <".$mailModus.">");
        #logIntoFile("debugMail <".$debugMail.">");
        #logIntoFile("debugSQL  <".$debugSQL.">");

        if ( $_POST['OPSID'] == "1" ) {
            # wir schicken nur eine Email, wenn ein OP-Punkt mit Status 1 eingetragen wurde (OFFEN)
            if ($mailModus == 1 || $mailModus == 2) {
                # wir schicken den Betroffenen eine Email

                # 2016-02-14 - bestimme OP-Beschreibung
                $sQuery = "SELECT OPDESC FROM OPLIST WHERE OPID = (SELECT MAX(OPID) FROM OPLIST)";
                debugIntoFile("GetOPDescription-Select: <".$sQuery.">");
                $result = getRessource($sQuery);
                logSQLError();
                echo getError();
                while ($val = getRow($result)) {
                    $opDescriptionFromDB = $val['OPDESC'];
                }
                freeRessource($result);

                if ( $defaultEmailFrom == "info@oplist.com") {
                    $email['FROMMAIL'] = getEmailOfId ($_SESSION['OPUID']);
                } else {
                    $email['FROMMAIL'] = $defaultEmailFrom;
                }

                $email['SUBJECT'] = $projectName." - Neuer OP-Punkt: ".$_POST['OPENTRY'];
                $email['MSG'] = "<html><body>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>Der OP-Punkt</div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>".$_POST['OPENTRY']."</div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'><a href=".$appUrl."index.php?mode=comment&OPID=".$foundOPID." target=_blank>".$appUrl."index.php?mode=comment&OPID=".$foundOPID."</a></div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>wurde hinzugefügt:</div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>".$opDescriptionFromDB."</div>";
                $email['MSG'] .= "</body></html>";

                $email['HEADERS'] = "Return-path: ".$email['FROMMAIL']."\n";
                $email['HEADERS'] .= "Content-type: text/html; charset=utf-8\n";
                $email['HEADERS'] .= "From: <".$email['FROMMAIL'].">\n";
                $email['HEADERS'] .= "Reply-To: <".$email['FROMMAIL'].">\n";

                $sQuery = "SELECT DISTINCT OPULNAME, OPUEMAIL FROM OPLIST_USERS WHERE (OPUID in (".$OPUID_ASSIGNED.") OR (OPGID IN (".$mailGroupString."))) AND OPUACTIVE = 1 AND OPUEMAIL IS NOT NULL AND OPUID != ".$_SESSION['OPUID'];

                debugIntoFile("Select Emailrecipients for new entry: <".$sQuery.">");
                $result = getRessource($sQuery);
                logSQLError();
                echo getError();
                while ($val = getRow($result)) {
                    logIntoFile("Sendemailaboutnewentryto <".$val['OPUEMAIL'].">");
                    $email['TOMAIL'] = $val['OPUEMAIL'];
                    #debugIntoDB ($val['OPULNAME']." (".$email['TOMAIL'].")|".$email['SUBJECT']."|".$email['MSG']."|".$email['HEADERS']);
                    #debugEmailFunction ($email['FROMMAIL'], $email['SUBJECT'], $email['MSG'], $email['TOMAIL'], $email['HEADERS']);
                    if ($debugMail == 0) {
                        if (!@mail($email['TOMAIL'], $email['SUBJECT'], $email['MSG'], $email['HEADERS'])) {
                            debugIntoDB ("ERR-Mail, User=".$val['OPULNAME'].", Email=".$email['TOMAIL'].", Subject=".$email['SUBJECT'].", Message=".$email['MSG']);
                            logIntoFile("Email konnte nicht gesendet werden");
                        } else {
                            debugIntoDB ("OK-Mail, User=".$val['OPULNAME'].", Email=".$email['TOMAIL'].", Subject=".$email['SUBJECT'].", Message=".$email['MSG']);
                            debugIntoFile("Email erfolgreich versandt");
                        }
                    } else {
                        debugIntoDB ("Debug-Mail, User=".$val['OPULNAME'].", Email=".$email['TOMAIL'].", Subject=".$email['SUBJECT'].", Message=".$email['MSG']);
                        logIntoFile("debugMail ist nicht <0>");
                    }
                }
                freeRessource($result);
            }
        }
    } else if (isset($_POST['addcomment'])) {
        logIntoFile("new comment will be added");
        $OPCPRIVATE = "0";

        if (isset ($_POST["OPSIDNEW"])) {
            $sQuery = "UPDATE OPLIST set OPSID = ".$_POST["OPSIDNEW"]." WHERE OPID = ".$_POST["OPID"];
            debugIntoFile("update status of op entry: <".$sQuery.">");
            $result = getRessource($sQuery);
            logSQLError();
            echo getError();
            freeRessource($result);
        }

        if ($usedb == "mysql") {
            $sQuery = "UPDATE OPLIST set OPPRIO = ".$_POST["OPPRIO"]." WHERE OPID = ".$_POST["OPID"];
            debugIntoFile("Update-OP-auf-Fertig-Select: <".$sQuery.">");
            $result = getRessource($sQuery);
            logSQLError();
            echo getError();
            freeRessource($result);
        } else if ($usedb == "oracle") {
            $sQuery = "UPDATE OPLIST set OPPRIO = ".$_POST["OPPRIO"]." WHERE OPID = ".$_POST["OPID"];
            debugIntoFile("Update-OP-auf-Fertig-Select: <".$sQuery.">");
            $result = getRessource($sQuery);
            logSQLError();
            echo getError();
            freeRessource($result);
        }



        if (isset ($_POST["OPCHANGESTATUS"]) && $_POST["OPCHANGESTATUS"] == "on") {
            // we will change the status directly
            if ($_SESSION['OPGCLIENT'] == 1) {
                logIntoFile("Status FERTIG von Kunde gesetzt");
                $NEWSTATUS=4;
            } else {
                logIntoFile("Status FERTIG von IBN oder SYS gesetzt");
                $NEWSTATUS=3;
            }
            if ($usedb == "mysql") {
                $sQuery = "UPDATE OPLIST set OPSID = ".$NEWSTATUS." WHERE OPID = ".$_POST["OPID"];
                debugIntoFile("Update-OP-auf-Fertig-Select: <".$sQuery.">");
                $result = getRessource($sQuery);
                logSQLError();
                echo getError();
                freeRessource($result);
            } else if ($usedb == "oracle") {
                $sQuery = "UPDATE OPLIST set OPSID = ".$NEWSTATUS." WHERE OPID = ".$_POST["OPID"];
                debugIntoFile("Update-OP-auf-Fertig-Select: <".$sQuery.">");
                $result = getRessource($sQuery);
                logSQLError();
                echo getError();
                freeRessource($result);
            }
        } else {
            debugIntoFile ("Kein OPCHANGESTATUS");
        }

        if (isset ($_POST["OPCHANGERETOUR"]) && $_POST["OPCHANGERETOUR"] == "on") {
            // we will change the status directly
            if ($_SESSION['OPGCLIENT'] == 1) {
                logIntoFile("Status FERTIG von Kunde gesetzt");
                $NEWSTATUS=2;

                if ($usedb == "mysql") {
                    $sQuery = "UPDATE OPLIST set OPSID = ".$NEWSTATUS." WHERE OPID = ".$_POST["OPID"];
                    debugIntoFile("Update-OP-auf-Weitere-Bearbeitung-Select: <".$sQuery.">");
                    $result = getRessource($sQuery);
                    logSQLError();
                    echo getError();
                    freeRessource($result);
                } else if ($usedb == "oracle") {
                    $sQuery = "UPDATE OPLIST set OPSID = ".$NEWSTATUS." WHERE OPID = ".$_POST["OPID"];
                    debugIntoFile("Update-OP-auf-Weitere-Bearbeitung-Select: <".$sQuery.">");
                    $result = getRessource($sQuery);
                    logSQLError();
                    echo getError();
                    freeRessource($result);
                }
            }
        } else {
            debugIntoFile ("Kein OPCHANGERETOUR");
        }

        if (isset ($_POST["OPCPRIVATE"]) && $_POST["OPCPRIVATE"] == "on") {
            $OPCPRIVATE = "1";
        }
        if ($usedb == "mysql") {
            $nextId = "null";
        } else if ($usedb == "oracle") {
            $nextId="OPLISTCOMMENT_SEQ.nextval";
        }

        if (!empty($_FILES['datei']['name'])) {
            if ($usedb == "mysql") {
                $sQuery = "INSERT INTO OPLIST_FILE (OPLFT) VALUES (1)";
                debugIntoFile("Naechste-File-Id-ermitteln-Select: <".$sQuery.">");

                $result = getRessource($sQuery);
                logSQLError();
                freeRessource($result);

                $newFileName = mysql_insert_id();
            } else if ($usedb == "oracle") {
                $sQuery = "SELECT OPLISTFILENAME_SEQ.NEXTVAL FROM DUAL";
                debugIntoFile("Naechstes-Attachment-Select: <".$sQuery.">");

                $result = getRessource($sQuery);
                logSQLError();
                echo getError();
                while ($val = getRow($result)) {
                    $newFileName = $val['NEXTVAL'];
                }
                freeRessource($result);
            }

            $file_namerev = strrev($_FILES['datei']['name']);
            $parts = explode(".", $file_namerev);
            $endung = strrev($parts[0]);
            #echo "Dateiendung: ".$endung."<br>";
            $newFileName .= ".".$endung;
            #echo "A2".$newFileName."<br>";

            if (!move_uploaded_file($_FILES['datei']['tmp_name'], "uploads/".$newFileName)) {
                echo "Die Datei ".$_FILES['datei']['name']." konnte nicht gespeichert werden.";
            }
            $newFileName = "'".$newFileName."'";
        } else {
            $newFileName = "null";
        }

        $sQuery = "INSERT INTO OPLIST_COMMENT (OPCID, OPUID, OPCTEXT, OPID, OPCPRIVATE, OPCFILENAME) VALUES (".$nextId.", ".$_SESSION['OPUID'].", '".str_replace("'","''",$_POST["OPCTEXT"])."', ".$_POST["OPID"].", ".$OPCPRIVATE.", ".$newFileName.")";
        debugIntoFile("Insert-Kommentar-Select: <".$sQuery.">");

        $result = getRessource($sQuery);
        logSQLError();
        echo getError();
        freeRessource($result);

        if ($usedb == "mysql") {
            $dateNow = "now()";
        } else if ($usedb == "oracle") {
            $dateNow = "sysdate";
        }

        $sQuery = "UPDATE OPLIST SET OPDATEUPDATED = ".$dateNow.", OPUID_UPDATED = ".$_SESSION['OPUID']." WHERE OPID = ".$_POST["OPID"];
        debugIntoFile("Aktualisiere-OP-Select: <".$sQuery.">");

        $result = getRessource($sQuery);
        logSQLError();
        echo getError();
        freeRessource($result);

        debugIntoFile ("mailModus <".$mailModus.">");
        debugIntoFile ("mailGroup <".$mailGroupString.">");

        # bestimme neuen Kommentar
        $sQuery = "SELECT OPCTEXT FROM OPLIST_COMMENT WHERE OPID = ".$_POST['OPID']." AND OPCID = (SELECT MAX(OPCID) FROM OPLIST_COMMENT WHERE OPID = ".$_POST['OPID'].")";
        debugIntoFile("Comment-Select: <".$sQuery.">");
        $result = getRessource($sQuery);
        logSQLError();
        echo getError();
        while ($rows = getRow($result))  {
            $newComment = $rows['OPCTEXT'];
        }
        freeRessource($result);

        if ($mailModus == 1) {
            $sendMail = 1;
            logIntoFile("Oeffentlicher Eintrag (0) oder privater Eintrag (1) <".$OPCPRIVATE.">");
            #if ($OPCPRIVATE == 0) {
                logIntoFile("OP erhaelt einen Kommentar --> Email an Eigentümer");
                # Email an OP-Ersteller
                #echo "Email an Eigentuemer";
                $sendMail = 1;
                $tempFromEmail = $_SESSION['OPUID'];
                if ( $defaultEmailFrom == "info@oplist.com") {
                    $email['FROMMAIL'] = getEmailOfId ($_SESSION['OPUID']);
                } else {
                    $email['FROMMAIL'] = $defaultEmailFrom;
                }
                $sQuery = "SELECT OPUID_ASSIGNED, OPUID_CREATED, OPENTRY FROM OPLIST WHERE OPID = ".$_POST['OPID'];
                debugIntoFile("Select OP-Info: <".$sQuery.">");
                $result = getRessource($sQuery);
                logSQLError();
                echo getError();
                while ($rows = getRow($result )) {
                    $assigned = $rows['OPUID_ASSIGNED'];
                    $oldUIdCreated = $rows['OPUID_CREATED'];
                    $opEntry = $rows['OPENTRY'];
                }
                freeRessource($result);
                $tempToMail = $oldUIdCreated;
            #}
            if ($sendMail == 1) {
                $email['SUBJECT'] = $projectName." - Neuer Kommentar zu OP-Punk: ".$_POST['OPID']."-".$opEntry;

                $email['MSG'] = "<html><body>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>Der OP-Punkt</div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>".$_POST['OPID']."-".$opEntry."</div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'><a href=".$appUrl."index.php?mode=comment&OPID=".$_POST["OPID"]." target=_blank>".$appUrl."index.php?mode=comment&OPID=".$_POST["OPID"]."</a></div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>erhielt einen neuen Kommentar:</div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
                $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>".$newComment."</div>";
                $email['MSG'] .= "</body></html>";

                $email['HEADERS'] = "Return-path: ".$email['FROMMAIL']."\n";
                $email['HEADERS'] .= "Content-type: text/html; charset=utf-8\n";
                $email['HEADERS'] .= "From: <".$email['FROMMAIL'].">\n";
                $email['HEADERS'] .= "Reply-To: <".$email['FROMMAIL'].">\n";
                $sQuery = "SELECT DISTINCT OPULNAME, OPUEMAIL, CLIENT FROM OPLIST_USERS, OPLIST_GROUP WHERE (OPUID in (".$tempToMail.",".$assigned.") OR (OPLIST_USERS.OPGID IN (".$mailGroupString."))) AND OPUACTIVE = 1 AND OPUEMAIL IS NOT NULL AND OPUID != ".$_SESSION['OPUID']." AND OPLIST_USERS.OPGID = OPLIST_GROUP.OPGID";

                debugIntoFile("Select Emailrecipients: <".$sQuery.">");
                $result = getRessource($sQuery);
                logSQLError();
                echo getError();
                while ($val = getRow($result)) {
                    logIntoFile("Sendemailaboutnewcomment <".$val['OPUEMAIL'].">");
                    $email['TOMAIL'] = $val['OPUEMAIL'];
                    #debugIntoDB ($val['OPULNAME']." (".$email['TOMAIL'].")|".$email['SUBJECT']."|".$email['MSG']."|".$email['HEADERS']);
                    #debugEmailFunction ($email['FROMMAIL'], $email['SUBJECT'], $email['MSG'], $email['TOMAIL'], $email['HEADERS']);
                    if ($debugMail == 0) {
                        if (!(  ($OPCPRIVATE == 1) &&  ($val['CLIENT'] == 1)  )) {
                            if (!@mail($email['TOMAIL'], $email['SUBJECT'], $email['MSG'], $email['HEADERS'])) {
                                debugIntoDB ("ERR-Mail, User=".$val['OPULNAME'].", Email=".$email['TOMAIL'].", Subject=".$email['SUBJECT'].", Message=".$email['MSG']);
                                logIntoFile("Email konnte nicht gesendet werden");
                            } else {
                                debugIntoDB ("OK-Mail, User=".$val['OPULNAME'].", Email=".$email['TOMAIL'].", Subject=".$email['SUBJECT'].", Message=".$email['MSG']);
                                debugIntoFile("Email erfolgreich versandt");
                            }
                        } else {
                            debugIntoFile("OP-Eintrag ist privat und wird nicht an Kunde <".$email['TOMAIL']."> versandt");
                        }
                    } else {
                        if (!(  ($OPCPRIVATE == 1) &&  ($val['CLIENT'] == 1)  )) {
                            debugIntoDB ("Debug-Mail, User=".$val['OPULNAME'].", Email=".$email['TOMAIL'].", Subject=".$email['SUBJECT'].", Message=".$email['MSG']);
                        }
                        logIntoFile("debugMail ist nicht <0>");
                    }
                }
                freeRessource($result);
            }
        } else if ($mailModus == 2) {
            # wir schicken immer eine Email
            $sQuery = "SELECT OPUID_ASSIGNED, OPENTRY, OPUID_CREATED FROM OPLIST WHERE OPDELETED = 0 AND OPID = ".$_POST["OPID"];
            debugIntoFile("Select OP-Info (mailModus=2): <".$sQuery.">");
            $result = getRessource($sQuery);
            logSQLError();
            $AssignedUser = 0;
            $OPName = null;
            $Owner = 0;
            echo getError();
            while ($val = getRow($result)) {
                $AssignedUser = $val['OPUID_ASSIGNED'];
                $opEntry = $val['OPENTRY'];
                $Owner = $val['OPUID_CREATED'];
            }
            freeRessource($result);

            if ( $defaultEmailFrom == "info@oplist.com") {
                $email['FROMMAIL'] = getEmailOfId ($_SESSION['OPUID']);
            } else {
                $email['FROMMAIL'] = $defaultEmailFrom;
            }


            $email['SUBJECT'] = $projectName." - Neuer Kommentar zu OP-Punk: ".$_POST['OPID']."-".$opEntry;

            $email['MSG'] = "<html><body>";
            $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>Der OP-Punkt</div>";
            $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
            $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>".$_POST['OPID']."-".$opEntry."</div>";
            $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
            $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'><a href=".$appUrl."index.php?mode=comment&OPID=".$_POST["OPID"]." target=_blank>".$appUrl."index.php?mode=comment&OPID=".$_POST["OPID"]."</a></div>";
            $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
            $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
            $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>erhielt einen neuen Kommentar:</div>";
            $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
            $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
            $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>".$newComment."</div>";
            $email['MSG'] .= "</body></html>";

            $email['HEADERS'] = "Return-path: ".$email['FROMMAIL']."\n";
            $email['HEADERS'] .= "Content-type: text/html; charset=utf-8\n";
            $email['HEADERS'] .= "From: <".$email['FROMMAIL'].">\n";
            $email['HEADERS'] .= "Reply-To: <".$email['FROMMAIL'].">\n";

            $sQuery = "SELECT DISTINCT OPULNAME, OPUEMAIL, CLIENT FROM OPLIST_USERS, OPLIST_GROUP WHERE (OPUID in (".$AssignedUser.") OR (OPLIST_USERS.OPGID IN (".$mailGroupString."))) AND OPUACTIVE = 1 AND OPUEMAIL IS NOT NULL AND OPUID != ".$_SESSION['OPUID']." AND OPLIST_USERS.OPGID = OPLIST_GROUP.OPGID";

            debugIntoFile("Select Emailrecipients (mailModus=2): <".$sQuery.">");
            $result = getRessource($sQuery);
            logSQLError();
            echo getError();
            while ($val = getRow($result)) {
                logIntoFile("Sendemailaboutnewcomment (mailModus=2) <".$val['OPUEMAIL'].">");
                $email['TOMAIL'] = $val['OPUEMAIL'];
                #debugIntoDB ($val['OPULNAME']." (".$email['TOMAIL'].") |".$email['SUBJECT']."|".$email['MSG']."|".$email['HEADERS']);
                if ($debugMail == 0) {
                    if (!(  ($OPCPRIVATE == 1) &&  ($val['CLIENT'] == 1)  )) {
                        if (!@mail($email['TOMAIL'], $email['SUBJECT'], $email['MSG'], $email['HEADERS'])) {
                            debugIntoDB ("ERR-Mail, User=".$val['OPULNAME'].", Email=".$email['TOMAIL'].", Subject=".$email['SUBJECT'].", Message=".$email['MSG']);
                            logIntoFile("Email konnte nicht gesendet werden");
                        } else {
                            debugIntoDB ("OK-Mail, User=".$val['OPULNAME'].", Email=".$email['TOMAIL'].", Subject=".$email['SUBJECT'].", Message=".$email['MSG']);
                            debugIntoFile("Email erfolgreich versandt");
                        }
                    } else {
                        debugIntoFile("OP-Eintrag ist privat und wird nicht an Kunde <".$email['TOMAIL']."> versandt");
                    }
                } else {
                    if (!(  ($OPCPRIVATE == 1) &&  ($val['CLIENT'] == 1)  )) {
                        debugIntoDB ("Debug-Mail, User=".$val['OPULNAME'].", Email=".$email['TOMAIL'].", Subject=".$email['SUBJECT'].", Message=".$email['MSG']);
                    }
                    logIntoFile("debugMail ist nicht <0>");
                }
            }
            freeRessource($result);

            if ($OPCPRIVATE == 0) {
                # Kommentar ist oeffentlich --> wir muessen noch den Owner ueberpruefen
                #echo $Owner."|".$_SESSION['OPUID'];
                if ($Owner != $_SESSION['OPUID']) {
                    $tempOwner = getEmailOfId ($Owner);
                    logIntoFile("SendemailaboutnewcommentAdditional (mailModus=2) <".$tempOwner.">");
                    $email['TOMAIL'] = $tempOwner;
                    #debugIntoDB ($val['OPULNAME']." (".$email['TOMAIL'].") |".$email['SUBJECT']."|".$email['MSG']."|".$email['HEADERS']);
                    if ($debugMail == 0) {
                        if (!@mail($email['TOMAIL'], $email['SUBJECT'], $email['MSG'], $email['HEADERS'])) {
                            debugIntoDB ("ERR-Mail-Owner, UserId=".$Owner.", Email=".$email['TOMAIL'].", Subject=".$email['SUBJECT'].", Message=".$email['MSG']);
                            logIntoFile("Email konnte nicht gesendet werden");
                        } else {
                            debugIntoDB ("OK-Mail-Owner, UserId=".$Owner.", Email=".$email['TOMAIL'].", Subject=".$email['SUBJECT'].", Message=".$email['MSG']);
                            debugIntoFile("Email erfolgreich versandt");
                        }
                    } else {
                        debugIntoDB ("Debug-Mail-Owner, UserId=".$Owner.", Email=".$email['TOMAIL'].", Subject=".$email['SUBJECT'].", Message=".$email['MSG']);
                        logIntoFile("debugMail ist nicht <0>");
                    }
                }
            }
        }
    } else if (isset($_POST['update'])) {
        logIntoFile("existing op entry will be updated");
        # Update Bug-Eintrag
        if ($_POST['OPAID'] == "-1") {
            $OPAID = "4";
        } else {
            $OPAID = $_POST['OPAID'];
        }

        if ($_POST['OPPID'] == "-1") {
            $OPPID = "4";
        } else {
            $OPPID = $_POST['OPPID'];
        }

        $oldBugStatus = 0;
        $sQuery = "SELECT OPSID, OPUID_CREATED, OPUID_ASSIGNED FROM OPLIST WHERE OPID = ".$_POST['OPID'];
        debugIntoFile("Select: <".$sQuery.">");

        $result = getRessource($sQuery);
        logSQLError();
        echo getError();
        while ($rows = getRow($result )) {
            $oldBugStatus = $rows['OPSID'];
            $oldUIdCreated = $rows['OPUID_CREATED'];
            $oldUIdAssigned = $rows['OPUID_ASSIGNED'];
        }
        freeRessource($result);
        #echo "OldStatus".$oldBugStatus;
        #echo "Erstreller".$oldUIdCreated;
        #echo "Zugewiesen".$oldUIdAssigned;

        if ($usedb == "mysql") {
            $dateNow = "now()";
        } else if ($usedb == "oracle") {
            $dateNow = "sysdate";
        }

        $TempOPDEADLINE = 'null';

        if ( !empty($_POST['OPDEADLINE']) ) {
            $TempOPDEADLINE = "'".$_POST['OPDEADLINE']."'";
        }


        if (isset ($_POST['OPENTRY']) && isset ($_POST['OPDESC'])) {
            $sQuery = "UPDATE OPLIST SET
                OPDATEUPDATED = ".$dateNow.",
                OPSID = ".$_POST['OPSID'].",
                OPENTRY = '".str_replace("'", "''", $_POST['OPENTRY'])."',
                OPAID = ".$OPAID.",
                OPDESC = '".str_replace("'", "''", $_POST['OPDESC'])."',
                OPPID = ".$OPPID.",
                OPPRIO = ".$_POST['OPPRIO'].",
                OPUID_UPDATED = ".$_SESSION['OPUID'].",
                OPUID_ASSIGNED = ".$_POST['OPUID_ASSIGNED'].",
                OPDEADLINE = ".$TempOPDEADLINE."
                WHERE OPID = ".$_POST['OPID'];
        } else {
            $sQuery = "UPDATE OPLIST SET
                OPDATEUPDATED = ".$dateNow.",
                OPSID = ".$_POST['OPSID'].",
                OPAID = ".$OPAID.",
                OPPID = ".$OPPID.",
                OPPRIO = ".$_POST['OPPRIO'].",
                OPUID_UPDATED = ".$_SESSION['OPUID'].",
                OPUID_ASSIGNED = ".$_POST['OPUID_ASSIGNED'].",
                OPDEADLINE = ".$TempOPDEADLINE."
                WHERE OPID = ".$_POST['OPID'];
        }
        debugIntoFile("Aktualisiere-OP-Select: <".$sQuery.">");

        $result = getRessource($sQuery);
        logSQLError();
        echo getError();
        freeRessource($result);


        $tempEmailChangedText = " ";
        $sendMail = 0;
        logIntoFile("New Assigned to <".$_POST['OPUID_ASSIGNED'].">");
        logIntoFile("New OP-Status   <".$_POST['OPSID'].">");
        logIntoFile("oldUIdAssigned  <".$oldUIdAssigned.">");
        logIntoFile("oldOPStatus     <".$oldBugStatus.">");
        if ($oldUIdAssigned == 0 && $_POST['OPUID_ASSIGNED'] != 0) {
            logIntoFile("OP war nicht zugewiesen und ist nun zugewiesen --> Email an zugewiesenen IBN");
            # Email an zugewiesenen IBN
            #echo "Email an IBN";
            $sendMail = 1;
            $tempFromEmail = $oldUIdCreated;
            if ( $defaultEmailFrom == "info@oplist.com") {
                $email['FROMMAIL'] = getEmailOfId ($oldUIdCreated);
            } else {
                $email['FROMMAIL'] = $defaultEmailFrom;
            }

            $tempToMail = $_POST['OPUID_ASSIGNED'];
            $tempEmailChangedText = "OP-Punkt wurde einem Mitarbeiter zugewiesen";
        } else if ((  ($oldBugStatus == 1 || $oldBugStatus == 2) && $_POST['OPSID'] == 3) || ( ($oldBugStatus == 4) & ( ($_POST['OPSID'] == 1) || ($_POST['OPSID'] == 2) || ($_POST['OPSID'] == 3) ))) {
            # Eigentümer des OP-Punkts wird informiert, da
            # Status von offen oder in Bearbeitung nach erledigt geht oder
            # weil Status von abgeschlossen auf offen, in Bearbeitung oder erledigt geht
            logIntoFile("OP hatte Status offen oder in Bearbeitung und wechselt nun zu erledigt --> Email an OP-Eigentümer");
            # Email an OP-Ersteller
            #echo "Email an Eigentuemer";
            $sendMail = 1;
            $tempFromEmail = $_SESSION['OPUID'];
            if ( $defaultEmailFrom == "info@oplist.com") {
                $email['FROMMAIL'] = getEmailOfId ($_SESSION['OPUID']);
            } else {
                $email['FROMMAIL'] = $defaultEmailFrom;
            }

            $tempToMail = $oldUIdCreated;
            $tempEmailChangedText = "Status des OP-Punkts hat sich geändert";
        } else if ((($oldBugStatus == 3 || $oldBugStatus == 4) && $_POST['OPSID'] != $oldBugStatus) || (($oldBugStatus == 1 || $oldBugStatus == 2 || $oldBugStatus == 3) && $_POST['OPSID'] == 4))  {
            logIntoFile("OP hatte Status erledigt oder abgeschlossen und der Status wurde auf offen oder in Bearbeitung gestellt --> Email an zugewiesenen IBN");
            logIntoFile("oder: OP hatte Status offen, in Bearbeitung oder erledigt und wird auf Status abgeschlossen gedreht --> Email an IBN");
            # Email an zugewiesenen IBN
            #echo "Email an IBN2";
            $sendMail = 1;
            $tempFromEmail = $oldUIdCreated;
            if ( $defaultEmailFrom == "info@oplist.com") {
                $email['FROMMAIL'] = getEmailOfId ($oldUIdCreated);
            } else {
                $email['FROMMAIL'] = $defaultEmailFrom;
            }

            $tempToMail = $_POST['OPUID_ASSIGNED'];
            $tempEmailChangedText = "Status des OP-Punkts hat sich geändert";
        }

        $tempOPEntry = "";
        if (isset ($_POST['OPENTRY'])) {
            $tempOPEntry = "-".$_POST['OPENTRY'];
        }
        $email['SUBJECT'] = $projectName." - Aktualisierung OP-Punkt: ".$_POST['OPID'].$tempOPEntry;

        $email['MSG'] = "<html><body>";
        $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>Der OP-Punkt</div>";
        $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
        $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>".$_POST['OPID'].$tempOPEntry."</div>";
        $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
        $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'><a href=".$appUrl."index.php?mode=comment&OPID=".$_POST["OPID"]." target=_blank>".$appUrl."index.php?mode=comment&OPID=".$_POST["OPID"]."</a></div>";
        $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
        $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
        $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>wurde aktualisiert:</div>";
        $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
        $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>&nbsp;</div>";
        $email['MSG'] .= "<div style='font-size: ".$EmailFontSize ."pt;'>".$tempEmailChangedText."</div>";
        $email['MSG'] .= "</body></html>";

        if ($mailModus == 1) {
            if ($sendMail == 1) {
                $email['HEADERS'] = "Return-path: ".$email['FROMMAIL']."\n";
                $email['HEADERS'] .= "Content-type: text/html; charset=utf-8\n";
                $email['HEADERS'] .= "From: <".$email['FROMMAIL'].">\n";
                $email['HEADERS'] .= "Reply-To: <".$email['FROMMAIL'].">\n";
                $sQuery = "SELECT DISTINCT OPULNAME, OPUEMAIL FROM OPLIST_USERS WHERE (OPUID in (".$tempToMail.") OR (OPGID IN (".$mailGroupString."))) AND OPUACTIVE = 1 AND OPUEMAIL IS NOT NULL AND OPUID != ".$_SESSION['OPUID'];

                debugIntoFile("Select Emailrecipients: <".$sQuery.">");
                $result = getRessource($sQuery);
                logSQLError();
                echo getError();
                while ($val = getRow($result)) {
                    logIntoFile("Sendemailaboutchangedstatus <".$val['OPUEMAIL'].">");
                    $email['TOMAIL'] = $val['OPUEMAIL'];
                    #debugIntoDB ($val['OPULNAME']." (".$email['TOMAIL'].") |".$email['SUBJECT']."|".$email['MSG']."|".$email['HEADERS']);
                    if ($debugMail == 0) {
                        if (!@mail($email['TOMAIL'], $email['SUBJECT'], $email['MSG'], $email['HEADERS'])) {
                            debugIntoDB ("ERR-Mail, User=".$val['OPULNAME'].", Email=".$email['TOMAIL'].", Subject=".$email['SUBJECT'].", Message=".$email['MSG']);
                            logIntoFile("Email konnte nicht gesendet werden");
                        } else {
                            debugIntoDB ("OK-Mail, User=".$val['OPULNAME'].", Email=".$email['TOMAIL'].", Subject=".$email['SUBJECT'].", Message=".$email['MSG']);
                            debugIntoFile("Email erfolgreich versandt");
                        }
                    } else {
                        debugIntoDB ("Debug-Mail, User=".$val['OPULNAME'].", Email=".$email['TOMAIL'].", Subject=".$email['SUBJECT'].", Message=".$email['MSG']);
                        logIntoFile("debugMail ist nicht <0>");
                    }
                }
                freeRessource($result);
            }
        } else if ($mailModus == 2) {
            if ( $defaultEmailFrom == "info@oplist.com") {
                $email['FROMMAIL'] = getEmailOfId ($oldUIdCreated);
            } else {
                $email['FROMMAIL'] = $defaultEmailFrom;
            }

            $email['HEADERS'] = "Return-path: ".$email['FROMMAIL']."\n";
            $email['HEADERS'] .= "Content-type: text/html; charset=utf-8\n";
            $email['HEADERS'] .= "From: <".$email['FROMMAIL'].">\n";
            $email['HEADERS'] .= "Reply-To: <".$email['FROMMAIL'].">\n";
            $sQuery = "SELECT DISTINCT OPULNAME, OPUEMAIL FROM OPLIST_USERS WHERE (OPUID in (".$_POST['OPUID_ASSIGNED'].") OR (OPGID IN (".$mailGroupString."))) AND OPUACTIVE = 1 AND OPUEMAIL IS NOT NULL AND OPUID != ".$_SESSION['OPUID'];

            debugIntoFile("Select Emailrecipients (mailModus=2): <".$sQuery.">");
            $result = getRessource($sQuery);
            logSQLError();
            echo getError();
            while ($val = getRow($result)) {
                logIntoFile("Sendemailaboutchangedstatus (mailModus=2) <".$val['OPUEMAIL'].">");
                $email['TOMAIL'] = $val['OPUEMAIL'];
                #debugIntoDB ($val['OPUEMAIL']." (".$email['TOMAIL'].") |".$email['SUBJECT']."|".$email['MSG']."|".$email['HEADERS']);
                if ($debugMail == 0) {
                    if (!@mail($email['TOMAIL'], $email['SUBJECT'], $email['MSG'], $email['HEADERS'])) {
                        debugIntoDB ("ERR-Mail, User=".$val['OPULNAME'].", Email=".$email['TOMAIL'].", Subject=".$email['SUBJECT'].", Message=".$email['MSG']);
                        logIntoFile("Email konnte nicht gesendet werden");
                    } else {
                        debugIntoDB ("OK-Mail, User=".$val['OPULNAME'].", Email=".$email['TOMAIL'].", Subject=".$email['SUBJECT'].", Message=".$email['MSG']);
                        debugIntoFile("Email erfolgreich versandt");
                    }
                } else {
                    debugIntoDB ("Debug-Mail, User=".$val['OPULNAME'].", Email=".$email['TOMAIL'].", Subject=".$email['SUBJECT'].", Message=".$email['MSG']);
                    logIntoFile("debugMail ist nicht <0>");
                }
            }
            freeRessource($result);
        }
    }

    $tempFilter = "";
    #if (isset($_POST['FILTERME'])) {}

    if (isset($_POST['FISTAT'])) {
        $_SESSION['FISTAT'] = $_POST['FISTAT'];
    }

    if ($_SESSION['FISTAT'] != "-1") {
        $tempFilter = " AND OP.OPSID = ".$_SESSION['FISTAT'];
    }
    #echo $tempFilter;
    if (isset($_POST['FIAREA'])) {
        $_SESSION['FIAREA'] = $_POST['FIAREA'];
    }
    if ($_SESSION['FIAREA'] != "-1") {
        $tempFilter .= " AND OP.OPAID = ".$_SESSION['FIAREA'];
    }
    if (isset($_POST['FIPROD'])) {
        $_SESSION['FIPROD'] = $_POST['FIPROD'];
    }
    if ($_SESSION['FIPROD'] != "-1") {
        $tempFilter .= " AND OP.OPPID = ".$_SESSION['FIPROD'];
    }

    if (isset ($_POST['SEARCHTXT'])) {
        $_SESSION['SEARCHTXT'] = $_POST['SEARCHTXT'];
    }

    if (isset($_SESSION['SEARCHTXT'])) {
        if ($_SESSION['OPGCLIENT'] == 1) {
            $tempFilter .= " AND (UPPER(OP.OPENTRY) LIKE UPPER('%".$_SESSION['SEARCHTXT']."%') OR OP.OPID IN (SELECT OPC.OPID FROM OPLIST_COMMENT OPC WHERE upper(OPC.OPCTEXT) LIKE UPPER('%".$_SESSION['SEARCHTXT']."%') AND OPC.OPID = OP.OPID AND OPC.OPCPRIVATE = 0))";
        } else {
            $tempFilter .= " AND (
    UPPER(OP.OPENTRY) LIKE UPPER('%".$_SESSION['SEARCHTXT']."%') OR OP.OPID IN (SELECT OPC.OPID FROM OPLIST_COMMENT OPC WHERE UPPER(OPC.OPCTEXT) LIKE UPPER('%".$_SESSION['SEARCHTXT']."%') AND OPC.OPID = OP.OPID))";
        }
    } else {
        $_SESSION['SEARCHTXT'] = "";
    }

    if ($usedb == "mysql") {
        $beforeToChar = "";
        $afterToChar = "";
    } else if ($usedb == "oracle") {
        $beforeToChar = "TO_CHAR (";
        $afterToChar = ", 'DD.MM.YYYY HH24:MI')";
    }

    $sQuery = "SELECT OP.OPID, OP.OPSID, OPUC.OPUUSERNAME CREATEDUSER, OPS.OPSTEXT, OP.OPPRIO, OPA.OPATEXT, OPP.OPPTEXT, OP.OPENTRY, ".$beforeToChar."OP.OPDATECREATED".$afterToChar." OPDATECREATED, ".$beforeToChar."OP.OPDATEUPDATED".$afterToChar." OPDATEUPDATED, OP.OPUID_ASSIGNED, OPUU.OPUUSERNAME UPDATEDUSER, OP.OPAID, OP.OPPID, OPUA.OPUUSERNAME ASSIGNEDUSER, OPUA.OPULNAME ASSIGNEDUSER2, OPUC.OPULNAME CREATEDUSER2, OP.OPDEADLINE
FROM OPLIST OP, OPLIST_AREA OPA, OPLIST_PRODUCT OPP, OPLIST_STAT OPS, OPLIST_USERS OPUU, OPLIST_USERS OPUC, OPLIST_USERS OPUA
WHERE OPA.OPAID = OP.OPAID
    AND OPP.OPPID = OP.OPPID
    AND OPS.OPSID = OP.OPSID
    AND OPUU.OPUID = OP.OPUID_UPDATED
    AND OP.OPDELETED = 0
    AND OP.OPUID_CREATED = OPUC.OPUID
    AND OPUA.OPUID = OP.OPUID_ASSIGNED".$tempFilter."
ORDER BY ".orderingOfOPEntries();

    if (!empty($_GET['mode']) && $_GET['mode'] == "userlist") {
        if ($_SESSION['OPGCLIENT'] == 1) {
            # wir sind Kunde
            $groupFilter=" AND OP.OPUID_CREATED = '".$_SESSION['OPUID']."'";
        } else if ($_SESSION['OPGID'] == '3') {
            # wir sind IBN
            $groupFilter=" AND OP.OPUID_ASSIGNED = '".$_SESSION['OPUID']."'";
        } else {
            # wir sind SYS oder Admin
            $groupFilter=" AND OP.OPUID_ASSIGNED = '".$_SESSION['OPUID']."'";
        }
        $sQuery = "SELECT OP.OPID, OP.OPSID, OPUC.OPUUSERNAME CREATEDUSER, OPS.OPSTEXT, OP.OPPRIO, OPA.OPATEXT, OPP.OPPTEXT, OP.OPENTRY, ".$beforeToChar."OP.OPDATECREATED".$afterToChar." OPDATECREATED, ".$beforeToChar."OP.OPDATEUPDATED".$afterToChar." OPDATEUPDATED, OP.OPUID_ASSIGNED, OPUU.OPUUSERNAME UPDATEDUSER, OP.OPAID, OP.OPPID, OPUA.OPUUSERNAME ASSIGNEDUSER, OPUA.OPULNAME ASSIGNEDUSER2, OPUC.OPULNAME CREATEDUSER2, OP.OPDEADLINE
FROM OPLIST OP, OPLIST_AREA OPA, OPLIST_PRODUCT OPP, OPLIST_STAT OPS, OPLIST_USERS OPUU, OPLIST_USERS OPUC, OPLIST_USERS OPUA
WHERE OPA.OPAID = OP.OPAID
    AND OPP.OPPID = OP.OPPID
    AND OPS.OPSID = OP.OPSID
    AND OPUU.OPUID = OP.OPUID_UPDATED
    AND OP.OPDELETED = 0
    AND OP.OPUID_CREATED = OPUC.OPUID
    AND OPUA.OPUID = OP.OPUID_ASSIGNED".$tempFilter.$groupFilter."
ORDER BY ".orderingOfOPEntries();
    }
    debugIntoFile("OP-Listen-Select: <".$sQuery.">");
    $result = getRessource($sQuery);
    logSQLError();
    echo getError();
    $bugArr = array();
    while ($rows = getRow($result )) {
        Array_push($bugArr,$rows);
    }
    freeRessource($result);

    $sQuery = "SELECT OPGID, OPGTEXT FROM OPLIST_GROUP WHERE (ACTIVE=1) ORDER BY OPGTEXT";
    debugIntoFile("OP-Gruppen-Select: <".$sQuery.">");
    $result = getRessource($sQuery);
    logSQLError();
    echo getError();
    $grpArr = array();
    while ($rows = getRow($result )) {
        Array_push($grpArr,$rows);
    }
    freeRessource($result);

    if ($mode == "edit") {
        $sQuery = "SELECT * FROM OPLIST WHERE OPDELETED = 0 AND OPID = '".$_GET['OPID']."'";
        debugIntoFile("Select: <".$sQuery.">");
        $result = getRessource($sQuery);
        logSQLError();
        echo getError();
        while ($rows = getRow($result )) {
            $OPID           = $rows['OPID'];
            $OPDATECREATED  = $rows['OPDATECREATED'];
            $OPDATEUPDATED  = $rows['OPDATEUPDATED'];
            $OPSID          = $rows['OPSID'];
            $OPENTRY        = $rows['OPENTRY'];
            $OPAID          = $rows['OPAID'];
            $OPDESC         = $rows['OPDESC'];
            $OPPID          = $rows['OPPID'];
            $OPPRIO         = $rows['OPPRIO'];
            $OPUID_CREATED  = $rows['OPUID_CREATED'];
            $OPUID_UPDATED  = $rows['OPUID_UPDATED'];
            $OPUID_ASSIGNED = $rows['OPUID_ASSIGNED'];
            $OPDEADLINE     = $rows['OPDEADLINE'];
        }
        freeRessource($result);
    } else if ($mode == "del") {
        $sQuery = "UPDATE OPLIST SET OPDELETED = 1 WHERE OPID = '".$_GET['OPID']."'";
        debugIntoFile("Select: <".$sQuery.">");
        #if ($debugSQL == 1) {
        $result = getRessource($sQuery);
        logSQLError();
        echo getError();
        freeRessource($result);
    } /*else if ($mode=="savepwd") {
        $pass = sanitize($_POST['NEWPASS']);

        $sQuery = "UPDATE OPLIST_USERS SET OPUPASSWORD = '".transformPwd($OPUPASSWORD)."' WHERE OPUID = ".$_SESSION['OPUID'];
        $result = getRessource($sQuery);
        logSQLError();
    }*/

    if ($mode == "del") {
        $tmpHTML .= "Eintrag gel&ouml;scht.";
    } else if ($mode == "comment") {
        $sQuery = "SELECT * FROM OPLIST WHERE OPDELETED = 0 AND OPID = '".$_GET['OPID']."'";
        debugIntoFile("Select: <".$sQuery.">");
        $result = getRessource($sQuery);
        logSQLError();
        echo getError();
        while ($rows = getRow($result )) {
            $OPID    = $rows['OPID'];
            $OPENTRY = $rows['OPENTRY'];
            $OPDESC  = $rows['OPDESC'];
            $OPPRIO  = $rows['OPPRIO'];
        }
        freeRessource ($result);
        $tmpHTML .= '
            <form method="post" name="addcommentform" enctype="multipart/form-data" accept-charset="UTF-8">
            <center>
            <table width=98% border="0" cellpadding=3 cellspacing=2>
            <tr bgcolor="#f0f0f0" >
            <td colspan=4 valign=center align=left>
            <b style="font-size:20px;">#'.$OPID .'&nbsp;'.$OPENTRY.'</b>
            </td>
            </tr>
            <tr bgcolor="#f0f0f0">
            <td colspan=4 valign=center align=left>
            <b style="font-size:14px;"><b>Priorit&auml;t</b></b>
            <select name="OPPRIO">';

        for ($i=0;$i<=count($prioArr)-1;$i++) {
            if ($i == $OPPRIO ) {
                $tmpHTML .=  "<option selected value='".$i."' >".$prioArr[$i];
            } else {
                $tmpHTML .=  "<option value='".$i."' >".$prioArr[$i];
            }
        }

        $tmpHTML .= '</select>
            </td>
            </tr>
            <tr bgcolor="#f0f0f0">
            <td>&nbsp;</td>
            <td colspan=3 valign=center align=left>
            <span style="font-size:14px;">'.$OPDESC.'</span>
            </td>
            </tr>
            <tr bgcolor="#f0f0f0">
            <td colspan=4>&nbsp;</td>
            </tr>
            <tr bgcolor="#f0f0f0">
            <td valign=top align=center style="width:20px;">&nbsp;</td>
            <td valign=top align=center style="width:*;">
            <b>Kommentar</b>
            </td>
            <td valign=top align=center style="width:110px;">
            <b>erstellt</b>
            </td>
            <td valign=top align=center style="width:50px;">
            <b>von</b>
            </td>
            </tr>';


        if ( $_SESSION['OPGINTERNAL'] == "1" ) {
            # Gruppe zu der der angemeldete Benutzer gehoehrt ist als
            # INTERNAL identifiziert --> darf interne Kommentare sehen
            $tempSQL = "";
        } else {
            # Gruppe zu der der angemeldete Benutzer gehoehrt ist NICHT als
            # INTERNAL identifiziert --> darf interne Kommentare sehen

            $tempSQL = " AND OPC.OPCPRIVATE = 0";
        }

        if ($usedb == "mysql") {
            $beforeToChar = "";
            $afterToChar = "";
        } else if ($usedb == "oracle") {
            $beforeToChar = "TO_CHAR (";
            $afterToChar = ", 'DD.MM.YYYY HH24:MI')";
        }

        $sQuery = "SELECT OPC.OPCFILENAME, OPC.OPCID, OPC.OPCTEXT, ".$beforeToChar."OPC.OPCDATE".$afterToChar." OPCDATE, OPU.OPUUSERNAME, OPU.OPULNAME, OPC.OPCPRIVATE FROM OPLIST_COMMENT OPC, OPLIST_USERS OPU WHERE OPC.OPID = ".$_GET['OPID']." AND OPU.OPUID = OPC.OPUID".$tempSQL." ORDER BY OPC.OPCID";
        debugIntoFile("Select for Comments: <".$sQuery.">");
        $result = getRessource($sQuery);
        logSQLError();
        echo getError();
        while ($rows = getRow($result )) {
            if ($rows['OPCPRIVATE'] == "0") {
                $tmpHTML .=  "<tr style=\"background:#80FF80;\">";
            } else {
                $tmpHTML .=  "<tr style=\"background:#FF8040;\">";
            }

            if ($rows['OPCFILENAME'] != "") {
                $tmpHTML .= '<td valign=top align=left><a href="uploads/'.$rows['OPCFILENAME'].'" target=_newWindow><img src="img/file.png" width=16 height=16 border=0 alt="Dateianhang"></a></td>';
            } else {
                $tmpHTML .= '<td valign=top align=left>&nbsp;</td>';
            }

            $tmpHTML .= '
                <td valign=top align=left style="font-size:12px;">'.$rows['OPCTEXT'].'
                </td>
                <td valign=top align=left style="font-size:10px;">'.$rows['OPCDATE'].'
                </td>
                <td valign=top align=left style="font-size:10px;">';

            if ( $displayName == 0 ) {
                $tmpHTML .= $rows['OPUUSERNAME'];
            } else {
                $tmpHTML .= $rows['OPULNAME'];
            }
            $tmpHTML .= '</td>
                </tr>';
        }
        freeRessource ($result);
        $tmpHTML .= '
            <tr>
            <td></td>
            <td valign=top>
            <textarea name="OPCTEXT" style="width:750px;" rows=10></textarea>
            <input type="file" name="datei"><br>';
        if ( $_SESSION['OPGINTERNAL'] == "1" ) {
            $tmpHTML .= '
                <input name="OPCPRIVATE" type="checkbox" checked>&nbsp;<b>interner Kommentar</b><br>';
        }
        if ( $_SESSION['OPGCLIENT'] == "1" ) {
            # nur wenn der Benutzer der Gruppe KUNDE zugeordnet ist, kann er auch die weitere Bearbeitung setzen
            $tmpHTML .= '
                <input name="OPCHANGESTATUS" type="checkbox" unchecked>&nbsp;<b>OP-Punkt abschließen</b><br>';

            $tmpHTML .= '
                <input name="OPCHANGERETOUR" type="checkbox" unchecked>&nbsp;<b>OP-Punkt benötigt weitere Bearbeitung</b>';
        }
        $tmpHTML .= '

            </td>
            <td colspan=2 align=right valign=bottom>';
            if ( canChangeStatus() ) {
                $tmpHTML .= '
                <b>Status</b>
                <select name="OPSIDNEW">';

                    $sQuery = "SELECT OPSID FROM OPLIST WHERE OPID = ".$_GET['OPID'];
                    debugIntoFile("get status id of op entry: <".$sQuery.">");
                    $result = getRessource($sQuery);
                    logSQLError();
                    echo getError();

                    $foundOPStatusID = 0;
                    while ($val = getRow($result)) {
                        $foundOPStatusID = $val['OPSID'];
                    }
                    freeRessource($result);

                    foreach ($statArr as $k => $v) {
                        if ($foundOPStatusID == $v['OPSID']) {
                            $tmpHTML .=  '<option selected value="'.$v['OPSID'].'">' . $v['OPSTEXT'];
                        } else {
                            $tmpHTML .=  '<option value="'.$v['OPSID'].'">' . $v['OPSTEXT'];
                        }
                    }


                $tmpHTML .= '
                        </select><div>&nbsp;</div><div>&nbsp;</div>';
            }
            $tmpHTML .= '
            <input type="submit" name="addcomment" style="width:180px;" value="Kommentar hinzufügen" onClick="return(checkAddComment(tinyMCE.activeEditor.getContent()));">
            <input type="hidden" name="OPID" value="'.$_GET['OPID'].'">
            </td>
            </tr>
            </table>
            </center>
            </form>
            <br><br><br>';
    } else if ($mode == "new" || $mode == "edit") {
        $tmpHTML .= '
            <form method="post" action="'.$_SERVER['PHP_SELF'].'" name="opform" enctype="multipart/form-data" accept-charset="UTF-8">
            <table width=100% border="0" cellpadding=3 cellspacing=2>';

        if ($mode == "edit") {
            $tmpHTML .= '
                <tr bgcolor="#f0f0f0" >
                    <td colspan=3 valign=center align=left>
                    <table width=100%>
                    <tr>
                    <td colspan=3>
                    <b style="font-size:20px;"> #'.$OPID .'&nbsp;'.substr($OPENTRY, 0, 80).'</b>
                    </td>
                    </tr>
                    <tr>
                    <td>
                    <b>&nbsp;</b>
                    </td>
                    <td>

                    </td>
                    <td align=right>&nbsp;
                    </td>
                    </tr>
                    </table>

                    </td>
                    <td bgcolor="#ffffff" ></td>
                </tr>';
        }
        $tmpHTML .= '
            <tr bgcolor="#f0f0f0" >
                <td valign=top width=150>&nbsp;<b>Titel (*):</b></td>
                <td colspan=2>';
        if ($ChangeTitleDescriptionPossible == 0) {
            if ($mode == "edit") {
                $tmpHTML .= '<span style="font-size:14px;">'.$OPENTRY.'</span>';
            } else {
                $tmpHTML .= '<input type="text" name="OPENTRY" value="'.$OPENTRY.'" style="width:650px;">';
            }
        } else {
            # wir koennen jetzt immer den Titel aendern!
            $tmpHTML .= '<input type="text" name="OPENTRY" value="'.$OPENTRY.'" style="width:650px;">';
        }

        $tmpHTML .= '</td>
                <td bgcolor="#ffffff" ></td>
            </tr>

            <tr bgcolor="#f0f0f0" >
                <td valign=top>&nbsp;<b>'.$areaText.':</b></td>
                <td valign=middle align=left colspan=2><select name="OPAID" style="width:200px;">
                    ';


        foreach ($typeArr as $key => $val) {
            if ($OPAID != "") {
                if ($val['OPAID'] == $OPAID) {
                    $tmpHTML .= "<option selected value='".$val['OPAID']."'>".$val['OPATEXT'];
                } else {
                    $tmpHTML .=  "<option value='".$val['OPAID']."'>".$val['OPATEXT'];
                }
            } else {
                $tmpHTML .= "<option value='".$val['OPAID']."'>".$val['OPATEXT'];
            }
        }
        $tmpHTML .= '</select>';

        $tmpHTML .= '</td>
            <td valign=top  bgcolor="#ffffff" ></td>
        </tr>';

        if ($useProducts == 1) {
            $tmpHTML .= '<tr bgcolor="#f0f0f0" >
                <td valign=top>&nbsp;<b>'.$productText.':</b></td>
                <td valign=middle align=left colspan=2><select name="OPPID" style="width:200px;">
                    <option value="-1">-- Bitte auswählen --';

            foreach ($productArr as $key => $val) {
                if ($OPPID != "") {
                    if ($val['OPPID'] == $OPPID) {
                        $tmpHTML .=  "<option selected value='".$val['OPPID']."'>".$val['OPPTEXT'];
                    } else {
                        $tmpHTML .=  "<option value='".$val['OPPID']."'>".$val['OPPTEXT'];
                    }
                } else {
                        $tmpHTML .=  "<option value='".$val['OPPID']."'>".$val['OPPTEXT'];
                }
            }
            $tmpHTML .= '</select>';

            $tmpHTML .= '</td>
                <td bgcolor="#ffffff" ></td>
            </tr>';
        } else {
            $tmpHTML .= '<input name="OPPID" value=-1 type=hidden>';
        }


        if ($viewDeadline == 1) {
            $tmpHTML .= '<tr bgcolor="#f0f0f0" >
            <td valign=top>&nbsp;<b>Termin (yyyy-mm-dd):</b></td>
            <td colspan=2>';
            $tmpHTML .= '<input type="date" name="OPDEADLINE" id="date" value="'.$OPDEADLINE.'" style="width:150px;">';
            $tmpHTML .= '</td>
                <td bgcolor="#ffffff" ></td>
            </tr>';
        } else {
            $tmpHTML .= '<input name="OPDEADLINE" value="" type=hidden>';
        }



        $tmpHTML .= '<tr bgcolor="#f0f0f0" >
            <td valign=top>&nbsp;<b>Beschreibung:</b></td>
            <td colspan=2>';
        if ($ChangeTitleDescriptionPossible == 0) {
            if ($mode == "edit") {
                $tmpHTML .= '<span style="font-size:14px;">'.$OPDESC.'</span>';
            } else {
                $tmpHTML .= '<textarea name="OPDESC" style="width:650px;" rows=10>'.$OPDESC.'</textarea>';
            }
        } else {
            # wir koennen immer die Beschreibung aendern
            $tmpHTML .= '<textarea name="OPDESC" style="width:650px;" rows=10>'.$OPDESC.'</textarea>';
        }


        $tmpHTML .= '</td>
                    <td bgcolor="#ffffff" ></td>
                </tr>';
        if ($mode == "new") {
                $tmpHTML .= '<tr bgcolor="#f0f0f0" >
                    <td valign=top>&nbsp;<b>Anhang:</b></td>
                    <td colspan=2><input type="file" name="datei"></td>
                    <td bgcolor="#ffffff" ></td>
                </tr>
                ';
        }
        if ($_SESSION['OPGID'] == "1" || $_SESSION['OPGID'] == "4" || $_SESSION['OPGID'] == "3") {
            $tmpHTML .= '<tr bgcolor="#f0f0f0" >
                <td valign=middle>&nbsp;<b>Zugewiesen an:</b></td>
                <td valign=middle align=left colspan=2><select name="OPUID_ASSIGNED" style="width:200px;">
                <option value="">Bitte auswählen';

            foreach ($userArr as $k => $v) {
                if ($OPUID_ASSIGNED == $v['OPUID']) {
                    $tmpHTML .=  '<option selected value="'.$v['OPUID'].'">' . $v['OPUUSERNAME'];
                } else {
                    if ($v['OPUACTIVE'] == "1") {
                        $tmpHTML .=  '<option value="'.$v['OPUID'].'">' . $v['OPUUSERNAME'];
                    }
                }
            }
            $tmpHTML .= '</select>';
        } else {
            $tmpHTML .= '<input type="hidden" name="OPUID_ASSIGNED" value="'.$OPUID_ASSIGNED.'">';
        }

        $tmpHTML .= '</td>
            <td bgcolor="#ffffff" ></td>
        </tr>';
        if ( empty($OPSID) ) {
            $OPSID = $DefaultStatusNewOPEntry;
        }
        $tmpHTML .= '
                <tr bgcolor="#f0f0f0" >
                    <td valign=top>&nbsp;<b>Status</b></td>
                    <td colspan=2>
                    <select name="OPSID">';

                foreach ($statArr as $k => $v) {
                    if ($OPSID == $v['OPSID']) {
                        $tmpHTML .=  '<option selected value="'.$v['OPSID'].'">' . $v['OPSTEXT'];
                    } else {
                        $tmpHTML .=  '<option value="'.$v['OPSID'].'">' . $v['OPSTEXT'];
                    }
                }

                $tmpHTML .= '
                    </select>
                    </td>
                    <td bgcolor="#ffffff" ></td>
                </tr>
                <tr bgcolor="#f0f0f0" >
                    <td valign=top>&nbsp;<b>Priorit&auml;t</b></td>
                    <td colspan=2><select name="OPPRIO">
                    <option value="">-- Bitte auswählen --';

                for ($i=0;$i<=count($prioArr)-1;$i++) {
                    if ($i == $OPPRIO ) {
                        $tmpHTML .=  "<option selected value='".$i."' >".$prioArr[$i];
                    } else {
                        $tmpHTML .=  "<option value='".$i."' >".$prioArr[$i];
                    }
                }
                $tmpHTML .= '
                        </select>
                        </td>
                        <td bgcolor="#ffffff" ></td>
                    </tr>';
        debugIntoFile("20161022-A=".$_SESSION['OPGID']);
        if ($OPUID_ASSIGNED == $_SESSION['OPUID'] || $_SESSION['OPGID'] == "1" || $_SESSION['OPGID'] == "4" || $_SESSION['OPGCLIENT'] == 1 || $IBNcanAddOPEntries == 1) {
            if ($mode == "edit") {
                $tmpHTML .= '
                    <tr >
                    <td colspan=3 align=center><input type="hidden" name="OPID" value="'.$OPID .'"><input type="submit" name="update" style="width:180px;" value="Änderungen speichern" onClick="return(checkOPEntry(document.opform.OPENTRY.value));"></td>
                    <td bgcolor="#ffffff" ></td>
                    </tr>';
            } else {
                $tmpHTML .= '
                    <tr >
                    <td colspan=3 align=center><input type="submit" name="save" style="width:180px;" value="Eintrag hinzufügen" onClick="return(checkOPEntry(document.opform.OPENTRY.value));"></td>
                    <td bgcolor="#ffffff" ></td>
                    </tr>';
            }
        }


            $tmpHTML .= '

            </table>
            </form>
            <br><br><br>';
    } else if ($mode == "list" || $mode == "" || $mode == "userlist") {
        $tmpHTML .= '
            <center>
            <table class="sortable" id="unique_id" cellpadding=3 cellspacing=2 style="border:1px solid gray;" width=98%>
            <tr style="font-weight:bold;background:#A2B5CD;">
                <td valign=top class="tableColumn1">&nbsp;</td>';

        # check which columns are in which order
        for ($i = 0; $i < $oplistcolumnsAmount; $i++) {
            if ( strtoupper($oplistcolumns[$i]) == "NR" ) {
                if ($viewOPID == 1) {
                    $tmpHTML .= '
                        <td valign=top class="tableColumnNumber">Nr.</td>';
                }
            } elseif ( strtoupper($oplistcolumns[$i]) == "TITLE" ) {
                 $tmpHTML .= '
                    <td valign=top class="tableColumnTitle">Titel</td>';
            } elseif ( strtoupper($oplistcolumns[$i]) == "CREATED" ) {
                if ($viewAddedBy == 1) {
                    $tmpHTML .= '
                        <td valign=top class="tableColumnCreated">angelegt</td>';
                }
            } elseif ( strtoupper($oplistcolumns[$i]) == "STATE" ) {
                $tmpHTML .= '
                    <td valign=top class="tableColumnState">Status</td>';
            } elseif ( strtoupper($oplistcolumns[$i]) == "DEADLINE" ) {
                if ($viewDeadline == 1) {
                    $tmpHTML .= '
                        <td valign=top class="tableColumnDeadline">Termin</td>';
                }
            } elseif ( strtoupper($oplistcolumns[$i]) == "PRIORITY" ) {
                $tmpHTML .= '
                    <td valign=top class="tableColumnPriority">Prio</td>';
            } elseif ( strtoupper($oplistcolumns[$i]) == "AREA" ) {
                $tmpHTML .= '
                    <td valign=top class="tableColumnArea">'.$areaText.'</td>';
            } elseif ( strtoupper($oplistcolumns[$i]) == "PRODUCT" ) {
                if ($useProducts == 1) {
                    $tmpHTML .= '<td valign=top class="tableColumnProduct">'.$productText.'</td>';
                }
            } elseif ( strtoupper($oplistcolumns[$i]) == "CHANGED" ) {
                $tmpHTML .= '
                    <!--<td valign=top style="width:110px; font-size:10px;">erstellt</td>-->
                    <td valign=top class="tableColumnChanged">letzte &Auml;nderung</td>
                    <!--<td valign=top style="width:70px; font-size:10px;">ge&auml;ndert</td>-->';
            } elseif ( strtoupper($oplistcolumns[$i]) == "ASSIGNED" ) {
                if ($viewAllocated == 1) {
                    $tmpHTML .= '
                        <td valign=top class="tableColumnAssigned">zugewiesen</td>';
                }
            }
        }
        $tmpHTML .= '
            </tr>';


        foreach ($bugArr as $k => $v) {
            if ($v['OPSID'] == "4") {
                    $tmpHTML .=  "<tr class='status4'>";
                } else if ($v['OPSID'] == "3") {
                    $tmpHTML .=  "<tr class='status3'>";
                } else if ($v['OPSID'] == "1") {
                    $tmpHTML .=  "<tr class='status1'>";
                } else if ($v['OPSID'] == "2") {
                    $tmpHTML .=  "<tr class='status2'>";
                } else {
                    $tmpHTML .=  "<tr class='status0'>";
                }

                $tmpHTML .=  "<td nowrap='nowrap' valign='top' class='tableLeft'>";
                if (( $_SESSION['OPGCLIENT'] == 0 ) || ($_SESSION['OPGCLIENT'] == 1 && $CustomerCanChangeOPEntries == 1)) {
                    $tmpHTML .=  "<a href='" .$_SERVER['PHP_SELF'] . "?mode=edit&OPID=".$v['OPID']."'><img src='img/edit.png' hspace=2 border=0></a>";
                }
                if ($_SESSION['OPGID'] == "1") {
                    $tmpHTML .=  "<a href=\"" .$_SERVER['PHP_SELF'] . "?mode=del&OPID=".$v['OPID']."\" onClick=\"return(confirmDialogIntoFile('Wollen Sie diesen OP-Punkt wirklich löschen?'));\"><img src='img/deletenew.png' hspace=2 border=0></a>";
                }

                $tmpHTML .=  "</td>";
            for ($i = 0; $i < $oplistcolumnsAmount; $i++) {

                if ( strtoupper($oplistcolumns[$i]) == "NR" ) {
                    if ($viewOPID == 1) {
                        $tmpHTML .=  "<td valign='top' class='tableRight'>".$v['OPID']."</td>";
                    }
                } elseif ( strtoupper($oplistcolumns[$i]) == "TITLE" ) {
                    $tmpHTML .=  "<td valign='top' class='tableLeft'><a class='link' href='" .$_SERVER['PHP_SELF'] . "?mode=comment&OPID=".$v['OPID']."'>".$v['OPENTRY']."</a></td>";
                } elseif ( strtoupper($oplistcolumns[$i]) == "CREATED" ) {
                    if ($viewAddedBy == 1) {
                        if ( $displayName == 0 ) {
                            $tmpHTML .=  "<td valign='top' class='tableLeft'>".$v['CREATEDUSER']."</td>";
                        } else {
                            $tmpHTML .=  "<td valign='top' class='tableLeft'>".$v['CREATEDUSER2']."</td>";
                        }
                    }
                } elseif ( strtoupper($oplistcolumns[$i]) == "STATE" ) {
                    $tmpHTML .=  "<td valign='top' class='tableLeft'>".$v['OPSTEXT']."</td>";
                } elseif ( strtoupper($oplistcolumns[$i]) == "DEADLINE" ) {
                    if ($viewDeadline == 1) {
                        $tmpHTML .=  "<td valign='top' class='tableLeft'>".$v['OPDEADLINE']."</td>";
                    }
                } elseif ( strtoupper($oplistcolumns[$i]) == "PRIORITY" ) {
                    $tmpHTML .=  "<td valign='top' class='tableLeft'>".$prioArr[$v['OPPRIO']] . "</td>";
                } elseif ( strtoupper($oplistcolumns[$i]) == "AREA" ) {
                    $tmpHTML .=  "<td valign='top' class='tableLeft'>".$v['OPATEXT']."</td>";
                } elseif ( strtoupper($oplistcolumns[$i]) == "PRODUCT" ) {
                    if ($useProducts == 1) {
                          $tmpHTML .=  "<td valign='top' class='tableLeft'>".$v['OPPTEXT']."</td>";
                    }
                } elseif ( strtoupper($oplistcolumns[$i]) == "CHANGED" ) {
                    $tmpHTML .=  "<td valign='top' class='tableLeft'>".date_format(new DateTime($v['OPDATEUPDATED']), 'Y-m-d H:i:s')."</td>";
                } elseif ( strtoupper($oplistcolumns[$i]) == "ASSIGNED" ) {
                    if ($viewAllocated == 1) {
                        if ( $displayName == 0 ) {
                            $tmpHTML .=  "<td valign='top' class='tableLeft'>".$v['ASSIGNEDUSER']."</td>";
                        } else {
                            $tmpHTML .=  "<td valign='top' class='tableLeft'>".$v['ASSIGNEDUSER2']."</td>";
                        }
                    }
                }

            }

            $tmpHTML .= '</tr>';
        }
        $tmpHTML .= '
            </table>
            </center>
            <br><br>';
    } else if ($mode == "logout") {
        unset($_SESSION['BUID']);
        unset($_SESSION['USERNAME']);
        session_unset();
        session_destroy();
        header("Location: index.php");
    } else if ($mode == "config") {
        $tmpHTML .= '<form name=pwd method=post>';

        if ($_SESSION['OPGID'] == "1") {
            #userlist
            $tmpHTML .=  "<table border=0 width=1024><tr><td width=500 valign=top><table border=0 cellpadding=3 cellspacing=2 width=300 style='border:1px solid gray;' ><tr><td><h3>gespeicherte Benutzer <input type='button' onclick='location.href=\"index.php?mode=config&OPUID=NEW\"' value='Neu'></h3></td></tr>";
            foreach ($userArr as $kk => $kv) {
                if ($kv['OPUID'] != "0") {
                    $tempActivated = " ";
                    if ($kv['OPUACTIVE'] == "0") {
                        $tempActivated = " (Konto deaktiviert)";
                    }
                    $tmpHTML .=  "<tr><td nowrap='nowrap'><a href='" .$_SERVER['PHP_SELF'] . "?mode=config&OPUID=".$kv['OPUID']."'><!--<img src='img/edit.png' hspace=2 border=0 align=absmiddle>-->".$kv['OPUUSERNAME']."</a>".$tempActivated."</tr>";
                }
            }
            $tmpHTML .= '</table></td>';
            #edit user
            if (isset ($_GET['OPUID']) && $_GET['OPUID'] != "NEW") {
                $tmpHTML .= '<td width=500 valign=top><table width=100% border=0 cellpadding=3 cellspacing=2 style="border:1px solid gray;" >';
                foreach ($userArr as $k=>$v) {
                    if (($v['OPUID']==$_GET['OPUID'])) {
                        $OPUACTIVE = "";
                        if ($v['OPUACTIVE']=="1") {
                            $OPUACTIVE = "checked";
                        }


                        $tmpHTML .= '<tr><td class="tdh">Gruppe (*):</td><td><select name="OPGID" style="width:300px;">
                            <option value="-1">-- Bitte auswählen --';

                        foreach ($grpArr as $key => $val) {
                            if ($v['OPGID']!="") {
                                if ($val['OPGID'] == $v['OPGID']) {
                                    $tmpHTML .= "<option selected value='".$val['OPGID']."'>".$val['OPGTEXT'];
                                } else {
                                    $tmpHTML .=  "<option value='".$val['OPGID']."'>".$val['OPGTEXT'];
                                }
                            } else {
                                $tmpHTML .= "<option value='".$val['OPGID']."'>".$val['OPGTEXT'];
                            }
                        }
                        $tmpHTML .= '</select></td></tr>';

                        $tmpHTML .= '



                            <tr><td class="tdh">Benutzername (*):</td><td><input name="OPUUSERNAME" type="text" value="'.$v['OPUUSERNAME'].'" style="width:200px;"></td>
                            </tr><tr><td class="tdh">EMail:</td><td><input name="OPUEMAIL" type="text" value="'.$v['OPUEMAIL'].'" style="width:200px;"></td>
                            </tr><tr><td class="tdh">Aktiviert:</td><td><input name="OPUACTIVE" type="checkbox" '.$OPUACTIVE.'></td>
                            </tr><tr><td class="tdh">Familienname (*):</td><td><input name="OPULNAME" type="text" value="'.$v['OPULNAME'] .'" style="width:200px;"></td>
                            </tr><tr><td class="tdh">Vorname (*):</td><td><input name="OPUFNAME" type="text" value="'. $v['OPUFNAME'] .'" style="width:200px;"></td>
                            </tr><tr><td class="tdh">Kennwort (*):</td><td><input name="OPUPASSWORD" type="password" value="" style="width:200px;"></td>
                            </tr><tr><td></td><td><input type="submit" name="deleteuser" value="Löschen"><input type="submit" name="updateuser" value="Aktualisieren" onClick="return(checkNewUser(document.pwd.OPUUSERNAME.value, document.pwd.OPGID.value, document.pwd.OPUFNAME.value, document.pwd.OPULNAME.value, document.pwd.OPUEMAIL.value, document.pwd.OPUPASSWORD.value));"><input name="OPUID" type="hidden" value="'.$v['OPUID'].'"><br><br></td></tr>';
                        }
                    }
                } else {
                    $tmpHTML .= '<td width=500 valign=top><table width=100% border=0 cellpadding=3 cellspacing=2 style="border:1px solid gray;" >';

                    $tmpHTML .= '<tr><td class="tdh">Gruppe (*):</td><td><select name="OPGID" style="width:300px;">
                        <option value="-1">-- Bitte auswählen --';

                    foreach ($grpArr as $key => $val) {
                        $tmpHTML .= "<option value='".$val['OPGID']."'>".$val['OPGTEXT'];
                    }
                    $tmpHTML .= '</select></td></tr>';

                    $tmpHTML .= '
                        <tr><td class="tdh">Benutzername (*):</td><td><input name="OPUUSERNAME" type="text" value="" style="width:200px;"></td>
                        </tr><tr><td class="tdh">EMail:</td><td><input name="OPUEMAIL" type="text" value="" style="width:200px;"></td>
                        </tr><tr><td class="tdh">Aktiviert:</td><td><input name="OPUACTIVE" type="checkbox" checked></td>
                        </tr><tr><td class="tdh">Familienname (*):</td><td><input name="OPULNAME" type="text" value="" style="width:200px;"></td>
                        </tr><tr><td class="tdh">Vorname (*):</td><td><input name="OPUFNAME" type="text" value="" style="width:200px;"></td>
                        </tr><tr><td class="tdh">Kennwort (*):</td><td><input name="OPUPASSWORD" type="password" value="" style="width:200px;"></td>
                        </tr><tr><td></td><td><input type="submit" name="SAVEUSER" value="Benutzer anlegen" onClick="return(checkNewUser(document.pwd.OPUUSERNAME.value, document.pwd.OPGID.value, document.pwd.OPUFNAME.value, document.pwd.OPULNAME.value, document.pwd.OPUEMAIL.value, document.pwd.OPUPASSWORD.value));"><br><br></td></tr>';
                }

            $tmpHTML .=  "</table></td></tr></table>";
        } else {
            $tmpHTML .= '<table cellpadding=3 cellspacing=2 style="border:1px solid gray;" >';
            $tmpHTML .= '
                <tr><td class="tdh">Benutzername:</td><td>'.$_SESSION['OPUUSERNAME'].'</td>
                </tr><tr><td class="tdh">EMail:</td><td><input name="OPUEMAIL" type="text" value="'.$_SESSION['OPUEMAIL'].'" style="width:200px;"></td>
                </tr><tr><td class="tdh">Familienname (*):</td><td><input name="OPULNAME" type="text" value="'.$_SESSION['OPULNAME'] .'" style="width:200px;"></td>
                </tr><tr><td class="tdh">Vorname (*):</td><td><input name="OPUFNAME" type="text" value="'. $_SESSION['OPUFNAME'] .'" style="width:200px;"></td>
                </tr><tr><td class="tdh">Kennwort (*):</td><td><input type="password" name="OPUPASSWORD" value="" style="width:200px;"></td>
                </tr><tr><td></td><td><input type="submit" name="UPDATEUSERME" value="Aktualisieren" onClick="return(checkUserAdaption(document.pwd.OPUFNAME.value, document.pwd.OPULNAME.value, document.pwd.OPUEMAIL.value, document.pwd.OPUPASSWORD.value));"><input name="OPUID" type="hidden" value="'.$_SESSION['OPUID'].'"><br><br></td></tr></table>';
        }

        $tmpHTML .= '</form>';
    } else if ($mode == "help") {
        # Paco.Help ausgewaehlt
        $tmpHTML .= '
            <table cellpadding=3 cellspacing=2      width=100%>
            <tr style="">
                <td>
                <div style="border: 1px solid gray; padding: 5px; width: 90%;">
                    <div style="background: rgb(240, 240, 240) none repeat scroll 0% 50%; font-size: 16px;">
                        <strong>Filter</strong>
                    </div>
                    <ul>
                        <br><strong>Meine OP-Punkte</strong> - Auswahl alle OP-Punkte, die dem angemeldeten Benutzer zugeweisen worden sind<br>
                        <br><strong>Alle OP-Punkte</strong> - Auswahl aller OP-Punkte<br>
                        <br><strong>Neuer OP-Punk</strong> - Anlage eines neuen OP-Punkts<br>
                        <br><strong>Benutzerverwaltung</strong> - Administratoren k&ouml;nnen alle Benutzer verwalten, der Rest ber Benutzer kann jeweils nur sein eigenes Benutzerkonto auml;ndern<br>
                        <br><strong>Filter nach Stati</strong> - Filter nach den einzelnen Stati<br>
                        <br><strong>Filter nach Bereichen</strong> - Filter nach Bereichen<br>
                        <br><strong>Filter nach Produkten</strong> - Filter nach den einzelnen Produkten<br>
                        <br><strong>Volltextsuche</strong> - Volltextsuche erfolgt auch in den OP-Kommentaren<br>
                    </ul>
                </div>
                <br><br>

                <div style="border: 1px solid gray; padding: 5px; width: 90%;">
                    <div style="background: rgb(240, 240, 240) none repeat scroll 0% 50%; font-size: 16px;">
                        <strong>Stati</strong>
                    </div>
                    <ul>
                        <br><strong>offen</strong> - unbearbeitete OP-Punkte aus interner Sicht<br>
                        <br><strong>in Bearbeitung</strong> - OP-Punkt befindet sich aus interner Sicht in Bearbeitung<br>
                        <br><strong>erledigt</strong> - intern ist der OP-Punkt erledigt<br>
                        <br><strong>abgeschlossen</strong> - Kunde &uuml;berpr&uuml;ft den Status und best&auml;tigt diesen<br>
                    </ul>
                </div>
                <br><br>


                <div style="border: 1px solid gray; padding: 5px; width: 90%;">
                    <div style="background: rgb(240, 240, 240) none repeat scroll 0% 50%; font-size: 16px;">
                        <strong>Bereiche</strong>
                    </div>
                    <ul>
                        <br><strong>AT/Steuerung</strong> - betrifft AT/Steuerung<br>
                        <br><strong>IT</strong> - betrifft IT<br>
                        <br><strong>Mechanik</strong> - betrifft Mechanik<br>
                        <br><strong>unbekannt</strong> - allgemeiner Status, wenn der Kunde keinen zuweist<br>
                        <br>Zus&auml;tzliche Bereiche k&ouml;nnen direkt in der Datenbank (OPLIST_AREA) erfasst werden<br>
                    </ul>
                </div>
                <br><br>


                <div style="border: 1px solid gray; padding: 5px; width: 90%;">
                    <div style="background: rgb(240, 240, 240) none repeat scroll 0% 50%; font-size: 16px;">
                        <strong>Produkte</strong>
                    </div>
                    <ul>
                        <br><strong>CI_LOG</strong> - betrifft CI_LOG<br>
                        <br><strong>Infosystem</strong> - betrifft Infosystem<br>
                        <br>Zus&auml;tzliche Produkte k&ouml;nnen direkt in der Datenbank (OPLIST_PRODUCT) erfasst werden<br>
                    </ul>
                </div>
                <br><br>


                <div style="border: 1px solid gray; padding: 5px; width: 90%;">
                    <div style="background: rgb(240, 240, 240) none repeat scroll 0% 50%; font-size: 16px;">
                        <strong>Benutzergruppen</strong>
                    </div>
                    <ul>
                        <br>Jeder Benutzer ist einer Benutzergruppe zugewiesen:<br>
                        <br><strong>Administrator</strong> - administriert die OP-Liste und legt Benutzer an<br>
                        <br><strong>IBN</strong> - Inbetriebnehmer, kann keine OP-Punkte anlegen<br>
                        <br><strong>Kunde</strong> - Kunde - darf OP-Punkte anlegen, Stati setzen<br>
                        <br><strong>PL/AT-SYS/IT-SYS</strong> - Projektleiter - darf Aufgaben zuweisen, Stati setzen<br>
                    </ul>
                </div>
                <br><br>


                <div style="border: 1px solid gray; padding: 5px; width: 90%;">
                    <div style="background: rgb(240, 240, 240) none repeat scroll 0% 50%; font-size: 16px;">
                        <strong>Kommentare</strong>
                    </div>
                    <ul>
                        <br>Durch Klick auf den OP-Punkt k&ouml;nnen jedem OP-Punkt beliebig viele Kommentare hinzugef&uuml;gt werden. Dabei existieren Kommentare, die ausschlie&szlig;lich intern gelesen werden k&ouml;nnen (interne Kommentare).<br>
                    </ul>
                </div>
                <br><br>



                <div style="border: 1px solid gray; padding: 5px; width: 90%;">
                    <div style="background: rgb(240, 240, 240) none repeat scroll 0% 50%; font-size: 16px;">
                        <strong>Dateinanh&auml;nge</strong>
                    </div>
                    <ul>
                        <br>Durch Klick auf einen Kommentar kann eine beliebige Datei upgeloaded werden.<br>
                    </ul>
                </div>
                <br><br>


                <div style="border: 1px solid gray; padding: 5px; width: 90%;">
                    <div style="background: rgb(240, 240, 240) none repeat scroll 0% 50%; font-size: 16px;">
                        <strong>Emailversand</strong>
                    </div>
                    <ul>
                        <br>Es gibt hier 3 verschiedene Stufen:<br>
                        <br><strong>mailModus = 0</strong> - kein Emailversand<br>
                        <br><strong>mailModus = 1 (Standard)</strong> - Sobald sich die Stati eines OP-Punkts zwischen ERLEDIGT und ABGESCHLOSSEN &auml;ndern, werden jeweils der Ersteller des OP-Punkts auch als der zugewiesene Mitarbeiter informiert (je nachdem, wer den Status &auml;ndert).<br>
                        <br><strong>mailModus = 2</strong> - jede &Auml;nderung verursacht einen Emailversand<br>
                        <br>Zus&auml;tzlich kann auch eine Gruppe (Standard PL/AT-SYS/IT-SYS) definiert werden, die zu den Punkten 2 und 2 auch noch zus&auml;tzlich informiert werden.<br>
                    </ul>
                </div>
                <br><br>
                </td>
            </tr>
            </table>';
    } else if ($mode == "printall") {
        debugIntoFile("20151221.A");
        $first = 0;
        $tmpHTML .= '
                <div class=paHeader>Übersicht über alle OP-Punkte</div>
                <div>&nbsp;</div>
                <table class=paTable width=100%>
                <tr>
                <th class=paFirstColumn>&nbsp;</th>
                <th>OP-Punkt/Beschreibung</th>
                <th>erstellt</th>
                <th>geändert</th>
                <th>Status</th>
                </tr>
                ';
        if ($usedb == "mysql") {
            $sQuery = "SELECT OP.OPID, OP.OPDATECREATED, OP.OPDATEUPDATED, OP.OPENTRY, OP.OPDESC, OS.OPSTEXT, OA.OPATEXT, OPR.OPPTEXT, OP.OPSID FROM OPLIST OP, OPLIST_STAT OS, OPLIST_AREA OA, OPLIST_PRODUCT OPR WHERE OP.OPSID = OS.OPSID AND OP.OPAID = OA.OPAID AND OP.OPPID = OPR.OPPID ORDER BY OS.OPSRC, OP.OPPRIO";
        } else if ($usedb == "oracle") {
            $sQuery = "SELECT OP.OPID, TO_CHAR (OP.OPDATECREATED, 'DD.MM.YYYY HH24:MI') OPDATECREATED, TO_CHAR (OP.OPDATEUPDATED, 'DD.MM.YYYY HH24:MI') OPDATEUPDATED, OP.OPENTRY, OP.OPDESC, OS.OPSTEXT, OA.OPATEXT, OPR.OPPTEXT, OP.OPSID FROM OPLIST OP, OPLIST_STAT OS, OPLIST_AREA OA, OPLIST_PRODUCT OPR WHERE OP.OPSID = OS.OPSID AND OP.OPAID = OA.OPAID AND OP.OPPID = OPR.OPPID ORDER BY OS.OPSRC, OP.OPPRIO";
        }

        debugIntoFile("Print-Select: <".$sQuery.">");
        debugIntoFile("20151221.B");

        $result = getRessource($sQuery);
        debugIntoFile("20151221.C");
        echo getError();
        logSQLError();
        debugIntoFile("20151221.D");
        while ($val = getRow($result)) {
            if ( $first != 0 ) {
                $tmpHTML .= '
                    <tr>
                        <td colspan=5>&nbsp;</td>
                    </tr>';
                $first = 1;
            }
            $tempClass = "";
            if ( $val['OPSID'] == 1 ) {
                $tempClass = "paColor1";
            } else if ( $val['OPSID'] == 2 ) {
                $tempClass = "paColor2";
            } else if ( $val['OPSID'] == 3 ) {
                $tempClass = "paColor3";
            } else if ( $val['OPSID'] == 4 ) {
                $tempClass = "paColor4";
            } else {
                $tempClass = "";
            }
            $tmpHTML .= '
                <tr>
                    <td colspan=2 class="paOPList '.$tempClass.'">'.$val['OPID'].": ".$val['OPENTRY'].'</td>
                    <td class="paDetails paDateWidth '.$tempClass.'">'.$val['OPDATECREATED'].'</td>
                    <td class="paDetails paDateWidth '.$tempClass.'">'.$val['OPDATEUPDATED'].'</td>
                    <td class="paDetails paStatusWidth '.$tempClass.'">'.$val['OPSTEXT'].'</td>
                </tr>';
            if ( !empty($val['OPDESC']) && $val['OPDESC'] != "<div>&nbsp;</div>" ) {
                $tmpHTML .= '
                    <tr>
                        <td class=paFirstColumn>&nbsp;</td>
                        <td class=paDetails>'.$val['OPDESC'].'</td>
                        <td class="paDetails paDateWidth">'.$val['OPDATECREATED'].'</td>
                    <td class="paDetails paDateWidth">'.$val['OPDATEUPDATED'].'</td>
                    <td class="paDetails paStatusWidth">&nbsp;</td>
                    </tr>';
            }

            if ( $_SESSION['OPGINTERNAL'] == "1" ) {
                # angemeldeter benutzer gehoert zu einer Gruppe, die auch
                # interne Kommentare sehen darf --> auch ausdrucken darf
                # wir brauchen keine weitere Einschraenkung
                $sQuerySubPrivate = " ";
            } else {
                $sQuerySubPrivate = " AND OPCPRIVATE = 0";
            }

            if ($usedb == "mysql") {
                $sQuery = "SELECT OPCTEXT, OPCDATE FROM OPLIST_COMMENT WHERE OPID = ".$val['OPID']." ".$sQuerySubPrivate." ORDER BY OPCDATE";
            } else if ($usedb == "oracle") {
                $sQuery = "SELECT OPCTEXT, TO_CHAR (OPCDATE, 'DD.MM.YYYY HH24:MI') OPCDATE FROM OPLIST_COMMENT WHERE OPID = ".$val['OPID']." ".$sQuerySubPrivate." ORDER BY OPCDATE";
            }

            $result2 = getRessource($sQuery);
            echo getError();
            logSQLError();
            while ($val = getRow($result2)) {
                $tmpHTML .= '
                    <tr>
                        <td>&nbsp;</td>
                        <td class="paDetails paDetailsWidth">'.$val['OPCTEXT'].'</td>
                        <td class="paDetails paDateWidth">'.$val['OPCDATE'].'</td>
                        <td class="paDetails paDateWidth">&nbsp;</td>
                        <td class="paDetails paStatusWidth">&nbsp;</td>
                    </tr>';
            }
            echo getError();
            freeRessource($result2);
        }
        echo getError();
        freeRessource($result);




        $tmpHTML .= '
            </table>';
    }

    $tmpHTML .= "<script>";
    $tmpHTML .= "function submitter(command) {";
    $tmpHTML .= "    document.forms.siteflx.action.value = command;";
    $tmpHTML .= "    document.forms.siteflx.submit();";
    $tmpHTML .= " } ";
    $tmpHTML .= "</script>";
}


if ( $isDevelopment == 1) {
    $tmpHTML .= "<table border=1><col width=150>";
    $sQuery = "SELECT ERST, VALUE FROM OPLIST_DEBUG ORDER BY ERST";
    $result = getRessource($sQuery);
    echo getError();
    logSQLError();
    while ($val = getRow($result)) {
        $tmpHTML .= '
        <tr>
        <td valign=top>'.$val['ERST'].'</td>
        <td>'.$val['VALUE'].'</td>
        </tr>';
    }
    echo getError();
    freeRessource($result);
    $tmpHTML .= "</table>";
}

$footer = '</div><div class="footer"><small>';

if ( $displayDevInfos == 1) {
    $footer .= $_SESSION['OPUUSERNAME'].' ('.$_SESSION['OPUID'].') gehoert zur Gruppe '.$_SESSION['OPGTEXT'].' ('.$_SESSION['OPGID'].'), sieht ';

    if ( $_SESSION['OPGINTERNAL'] == "1" ) {
        $footer .= 'auch interne Kommentare';
    } else {
        $footer .= 'nur öffentliche Kommentare';
    }
    $footer .= '('.$_SESSION['OPGINTERNAL'].')';

    if ( $_SESSION['OPGCLIENT'] == "1" ) {
        $footer .= ', ist Kunde';
    } else {
        $footer .= ', ist KEIN Kunde';
    }
    $footer .= '('.$_SESSION['OPGCLIENT'].')';

    $footer .= '&nbsp;';
}

$footer .= '&copy; 2011 by <a href="http://software.glawar.at/oplist/" target="_blank">OPList</a> v'
.$myVersion.'.'.$SVNRevision.' [DB='.getDBVersion().'/'.$databaseMinVersion.']';

if ($nightlyBuild == 0) {
    $footer .= ' ('.$myVersionDate.')';
} else {
    $footer .= ' (nightly build)';
}
$footer .= '&nbsp;&nbsp;&nbsp;</small></div></body></html>';



closeConnection();


echo $header . $tmpHTML . $footer;
?>
