<?PHP
######################################################################
# Authors: Franz-Peter Glawar <office@glawar.at>, 2015
#
# Individuelle Anpassungen werden hiermit ermoeglicht.
#
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# 2015-08-07 Paco Anlage der Indiv-Datei
#                 - orderingOfOPEntries: Festlegen der Sortierung
#                   der OP-Eintraege
#                 - shouldInternalsBePrinted: Ausdruck von internen
#                   Kommentaren
# 2015-08-25 Paco Anlage neuer Indiv-Entries
#                 - canChangeStatus
#                 - userIsClient
#                 - displayInternalComment
# 2015-12-21 Paco - shouldInternalsBePrinted wurde geloescht
#                 - displayInternalComment wurde geloescht
#                 - userIsClient wurde geloescht
# 2017-06-29 Paco orderingOfOPEntries wurde um das Feld TERMIN erweitert
######################################################################


#---------------------------------------------------------------------
# (c) www.glawar.at: legt die Standardsortierung der OP-Eintraege fest
#---------------------------------------------------------------------
function orderingOfOPEntries() {
    global $usedb;
    
    # default value is "OP.OPDEADLINE, OPS.OPSRC ASC, OP.OPPRIO DESC, OP.OPID";
    if ($usedb == "mysql") {
        return "-OP.OPDEADLINE DESC, OPS.OPSRC ASC, OP.OPPRIO DESC, OP.OPID";
    } else {
        return "OP.OPDEADLINE, OPS.OPSRC ASC, OP.OPPRIO DESC, OP.OPID";
    }
    #return "OPS.OPSRC ASC, OP.OPPRIO DESC, OP.OPDATEUPDATED DESC, OP.OPDATEUPDATED DESC";
}


#---------------------------------------------------------------------
# (c) www.glawar.at: stellt fest, ob der angemeldete Benutzer den Status einfach so aendern kann
#---------------------------------------------------------------------
function canChangeStatus() {
    global $CustomerCanChangeStatus;

    if ( ( $_SESSION['OPGID'] == "1" || $_SESSION['OPGID'] == "3" || $_SESSION['OPGID'] == "4") || ($_SESSION['OPGID'] == "2" && $CustomerCanChangeStatus == 1) ) {
        return true;
    } else {
        return false;
    }
}
?>
