/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.io.InputStream;
import java.util.Properties;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class GDSExceptionHelper {
    private static final Logger log = LoggerFactory.getLogger(class$org$firebirdsql$gds$GDSExceptionHelper == null ? (class$org$firebirdsql$gds$GDSExceptionHelper = GDSExceptionHelper.class$("org.firebirdsql.gds.GDSExceptionHelper")) : class$org$firebirdsql$gds$GDSExceptionHelper, false);
    private static final String MESSAGES = "isc_error_msg";
    private static Properties messages = new Properties();
    private static boolean initialized = false;
    static /* synthetic */ Class class$org$firebirdsql$gds$GDSExceptionHelper;
    static /* synthetic */ Class class$org$firebirdsql$gds$GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        try {
            ClassLoader cl = (class$org$firebirdsql$gds$GDSException == null ? (class$org$firebirdsql$gds$GDSException = GDSExceptionHelper.class$("org.firebirdsql.gds.GDSException")) : class$org$firebirdsql$gds$GDSException).getClassLoader();
            String res = MESSAGES.replace('.', '/') + ".properties";
            InputStream in = cl.getResourceAsStream(res);
            if (in == null) {
                cl = Thread.currentThread().getContextClassLoader();
                in = cl.getResourceAsStream(res);
            }
            if (in != null) {
                messages.load(in);
            }
        }
        catch (Exception ex) {
            if (log != null) {
                log.info("Exception in init of GDSExceptionHelper", ex);
            }
        }
        finally {
            initialized = true;
        }
    }

    public static GDSMessage getMessage(int code) {
        if (!initialized) {
            GDSExceptionHelper.init();
        }
        return new GDSMessage(messages.getProperty("" + code, "No message for code " + code + " found."));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class GDSMessage {
        private String template;
        private String[] params;

        public GDSMessage(String template) {
            this.template = template;
            this.params = new String[this.getParamCount()];
        }

        public int getParamCount() {
            int count = 0;
            for (int i = 0; i < this.template.length(); ++i) {
                if (this.template.charAt(i) != '{') continue;
                ++count;
            }
            return count;
        }

        public void setParameter(int position, String text) {
            if (position < this.params.length) {
                this.params[position] = text;
            }
        }

        public String toString() {
            String message = this.template;
            for (int i = 0; i < this.params.length; ++i) {
                String param = "{" + i + "}";
                int pos = message.indexOf(param);
                if (pos <= -1) continue;
                String temp = message.substring(0, pos);
                temp = temp + (this.params[i] == null ? "" : this.params[i]);
                message = temp = temp + message.substring(pos + param.length());
            }
            return message;
        }
    }
}

