/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.FBResourceTransactionException;
import org.firebirdsql.jdbc.AbstractConnection;

public class FBLocalTransaction
implements LocalTransaction,
javax.resource.cci.LocalTransaction {
    private final FBManagedConnection mc;
    private Xid xid = null;
    private final ConnectionEvent beginEvent;
    private final ConnectionEvent commitEvent;
    private final ConnectionEvent rollbackEvent;

    public FBLocalTransaction(FBManagedConnection mc, AbstractConnection c) {
        this.mc = mc;
        if (c == null) {
            this.beginEvent = null;
            this.commitEvent = null;
            this.rollbackEvent = null;
        } else {
            this.beginEvent = new ConnectionEvent((ManagedConnection)mc, 2, null);
            this.beginEvent.setConnectionHandle((Object)c);
            this.commitEvent = new ConnectionEvent((ManagedConnection)mc, 3, null);
            this.commitEvent.setConnectionHandle((Object)c);
            this.rollbackEvent = new ConnectionEvent((ManagedConnection)mc, 4, null);
            this.rollbackEvent.setConnectionHandle((Object)c);
        }
    }

    public void begin() throws ResourceException {
        this.internalBegin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalBegin() throws ResourceException {
        if (this.xid != null) {
            throw new FBResourceTransactionException("Local transaction active: can't begin another", "25S02");
        }
        this.xid = new FBLocalXid();
        FBManagedConnection fBManagedConnection = this.mc;
        synchronized (fBManagedConnection) {
            try {
                this.mc.internalStart(this.xid, 0);
            }
            catch (XAException ex) {
                this.xid = null;
                throw new FBResourceException(ex);
            }
            catch (GDSException ex) {
                this.xid = null;
                throw new FBResourceException(ex);
            }
            if (this.beginEvent != null) {
                this.mc.notify(FBManagedConnection.localTransactionStartedNotifier, this.beginEvent);
            }
        }
    }

    public void commit() throws ResourceException {
        this.internalCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalCommit() throws ResourceException {
        if (this.xid == null) {
            throw new FBResourceTransactionException("No local transaction active: can't commit", "25S01");
        }
        FBManagedConnection fBManagedConnection = this.mc;
        synchronized (fBManagedConnection) {
            try {
                this.mc.internalEnd(this.xid, 0x4000000);
                this.mc.internalCommit(this.xid, true);
            }
            catch (XAException ex) {
                throw new FBResourceTransactionException(ex.getMessage(), ex);
            }
            catch (GDSException ex) {
                throw new FBResourceException(ex);
            }
            finally {
                this.xid = null;
            }
            if (this.commitEvent != null) {
                this.mc.notify(FBManagedConnection.localTransactionCommittedNotifier, this.commitEvent);
            }
        }
    }

    public void rollback() throws ResourceException {
        this.internalRollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalRollback() throws ResourceException {
        if (this.xid == null) {
            throw new FBResourceTransactionException("No local transaction active: can't rollback", "25S01");
        }
        FBManagedConnection fBManagedConnection = this.mc;
        synchronized (fBManagedConnection) {
            try {
                this.mc.internalEnd(this.xid, 0x4000000);
                this.mc.internalRollback(this.xid);
            }
            catch (XAException ex) {
                throw new FBResourceTransactionException(ex.getMessage());
            }
            catch (GDSException ex) {
                throw new FBResourceTransactionException(ex.getMessage(), ex);
            }
            finally {
                this.xid = null;
            }
            if (this.rollbackEvent != null) {
                this.mc.notify(FBManagedConnection.localTransactionRolledbackNotifier, this.rollbackEvent);
            }
        }
    }

    static class FBLocalXid
    implements Xid {
        private static final int formatId = 258;

        public byte[] getGlobalTransactionId() {
            return null;
        }

        public byte[] getBranchQualifier() {
            return null;
        }

        public int getFormatId() {
            return 258;
        }
    }
}

