/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.AbstractPreparedStatement;
import org.firebirdsql.jdbc.FBDriverConsistencyCheckException;
import org.firebirdsql.jdbc.FBEscapedCallParser;
import org.firebirdsql.jdbc.FBProcedureCall;
import org.firebirdsql.jdbc.FBProcedureParam;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class AbstractCallableStatement
extends AbstractPreparedStatement
implements CallableStatement {
    static final String NATIVE_CALL_COMMAND = "EXECUTE PROCEDURE";
    private static final Logger log = LoggerFactory.getLogger(class$org$firebirdsql$jdbc$AbstractStatement == null ? (class$org$firebirdsql$jdbc$AbstractStatement = AbstractCallableStatement.class$("org.firebirdsql.jdbc.AbstractStatement")) : class$org$firebirdsql$jdbc$AbstractStatement, false);
    private ResultSet currentRs;
    private FBProcedureCall procedureCall;
    static /* synthetic */ Class class$org$firebirdsql$jdbc$AbstractStatement;

    protected AbstractCallableStatement(AbstractConnection c, String sql, int rsType, int rsConcurrency) throws SQLException {
        super(c, rsType, rsConcurrency);
        FBEscapedCallParser parser = new FBEscapedCallParser();
        this.procedureCall = parser.parseCall(c.nativeSQL(sql));
    }

    protected void setRequiredTypes() throws SQLException {
        FBResultSet resultSet = (FBResultSet)this.getCurrentResultSet();
        Iterator iter = this.procedureCall.getOutputParams().iterator();
        while (iter.hasNext()) {
            FBProcedureParam param = (FBProcedureParam)iter.next();
            if (param == null) continue;
            FBField field = resultSet.getField(this.procedureCall.mapOutParamIndexToPosition(param.getIndex()), false);
            field.setRequiredType(param.getType());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            try {
                this.c.ensureInTransaction();
                this.currentRs = null;
                this.prepareFixedStatement(this.procedureCall.getSQL(), true);
                boolean hasResultSet = this.internalExecute(true);
                if (hasResultSet) {
                    if (this.c.willEndTransaction()) {
                        this.cacheResultSet();
                    }
                    this.setRequiredTypes();
                }
                boolean bl = hasResultSet;
                return bl;
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
            finally {
                this.c.checkEndTransaction();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet executeQuery() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            try {
                this.c.ensureInTransaction();
                this.currentRs = null;
                this.prepareFixedStatement(this.procedureCall.getSQL(), true);
                if (!this.internalExecute(true)) {
                    throw new FBSQLException("No resultset for sql", "07005");
                }
                if (this.c.willEndTransaction()) {
                    this.cacheResultSet();
                } else {
                    this.getResultSet();
                }
                this.setRequiredTypes();
                ResultSet resultSet = this.getCurrentResultSet();
                return resultSet;
            }
            catch (GDSException ex) {
                throw new FBSQLException(ex);
            }
            finally {
                this.c.checkEndTransaction();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            try {
                this.c.ensureInTransaction();
                this.currentRs = null;
                this.prepareFixedStatement(this.procedureCall.getSQL(), true);
                boolean hasResults = this.internalExecute(true);
                if (hasResults) {
                    if (this.c.willEndTransaction()) {
                        this.cacheResultSet();
                    }
                    this.setRequiredTypes();
                }
                int n = this.getUpdateCount();
                return n;
            }
            catch (GDSException ex) {
                throw new FBSQLException(ex);
            }
            finally {
                this.c.checkEndTransaction();
            }
        }
    }

    protected boolean internalExecute(boolean sendOutParams) throws SQLException {
        int counter = 0;
        List inputParams = this.procedureCall.getInputParams();
        Iterator iter = inputParams.iterator();
        while (iter.hasNext()) {
            FBProcedureParam param = (FBProcedureParam)iter.next();
            if (param == null || !param.isParam()) continue;
            Object value = param.getValue();
            FBField field = this.getField(++counter);
            if (value == null) {
                field.setNull();
                continue;
            }
            if (value instanceof TimestampWithCalendar) {
                field.setTimestamp((TimestampWithCalendar)value, ((TimestampWithCalendar)value).getCalendar());
                continue;
            }
            field.setObject(value);
        }
        return super.internalExecute(sendOutParams);
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.procedureCall.registerOutParam(parameterIndex, sqlType);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.procedureCall.registerOutParam(parameterIndex, sqlType);
    }

    public boolean wasNull() throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        return this.getCurrentResultSet().wasNull();
    }

    public String getString(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getString(parameterIndex);
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getBoolean(parameterIndex);
    }

    public byte getByte(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getByte(parameterIndex);
    }

    public short getShort(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getShort(parameterIndex);
    }

    public int getInt(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getInt(parameterIndex);
    }

    public long getLong(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getLong(parameterIndex);
    }

    public float getFloat(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getFloat(parameterIndex);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getDouble(parameterIndex);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getBigDecimal(parameterIndex, scale);
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getBytes(parameterIndex);
    }

    public Date getDate(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getDate(parameterIndex);
    }

    public Time getTime(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getTime(parameterIndex);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getTimestamp(parameterIndex);
    }

    public Object getObject(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getObject(parameterIndex);
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getBigDecimal(parameterIndex);
    }

    public Object getObject(int parameterIndex, Map map) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getObject(parameterIndex, map);
    }

    public Ref getRef(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getRef(parameterIndex);
    }

    public Blob getBlob(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getBlob(parameterIndex);
    }

    public Clob getClob(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getClob(parameterIndex);
    }

    public Array getArray(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getArray(parameterIndex);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getDate(parameterIndex, cal);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getTime(parameterIndex, cal);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getTimestamp(parameterIndex, cal);
    }

    protected void assertHasData(ResultSet rs) throws SQLException {
        if (rs.getRow() != 0) {
            return;
        }
        rs.next();
        if (rs.getRow() == 0) {
            throw new FBSQLException("Current statement has not data to return.", "07005");
        }
    }

    protected ResultSet getCurrentResultSet() throws SQLException {
        if (this.currentRs == null) {
            this.currentRs = super.getResultSet();
        }
        return this.currentRs;
    }

    protected void cacheResultSet() throws SQLException {
        if (this.currentRs != null) {
            throw new FBDriverConsistencyCheckException("Trying to cache result set before closing exitsing one.");
        }
        this.currentRs = this.getCachedResultSet(false);
    }

    public ResultSet getResultSet() throws SQLException {
        return this.getCurrentResultSet();
    }

    public void setArray(int i, Array x) throws SQLException {
        this.procedureCall.getInputParam(i).setValue(x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(inputStream);
    }

    public void setBlob(int parameterIndex, Blob blob) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(blob);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new Boolean(x));
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new Byte(x));
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(reader);
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new Double(x));
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new Float(x));
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new Integer(x));
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new Long(x));
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(null);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(null);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new Short(x));
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new TimestampWithCalendar(x, cal));
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TimestampWithCalendar
    extends Timestamp {
        private Calendar c;

        private TimestampWithCalendar(Timestamp t, Calendar c) {
            super(t.getTime() + (long)(t.getNanos() / 1000000));
            this.c = c;
        }

        private Calendar getCalendar() {
            return this.c;
        }
    }
}

