/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.XSQLDA;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBResultSetMetaData;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBStatement;
import org.firebirdsql.jdbc.FirebirdPreparedStatement;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FBWorkaroundStringField;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class AbstractPreparedStatement
extends FBStatement
implements FirebirdPreparedStatement {
    private boolean[] isParamSet;
    private FBField[] fields = null;
    private boolean[] isBlob = null;
    private boolean hasBlobs = false;
    private boolean isExecuteProcedureStatement;
    private static final Logger log = LoggerFactory.getLogger(class$org$firebirdsql$jdbc$AbstractStatement == null ? (class$org$firebirdsql$jdbc$AbstractStatement = AbstractPreparedStatement.class$("org.firebirdsql.jdbc.AbstractStatement")) : class$org$firebirdsql$jdbc$AbstractStatement, false);
    private LinkedList batchList = new LinkedList();
    static /* synthetic */ Class class$org$firebirdsql$jdbc$AbstractStatement;

    protected AbstractPreparedStatement(AbstractConnection c, int rsType, int rsConcurrency) throws SQLException {
        super(c, rsType, rsConcurrency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractPreparedStatement(AbstractConnection c, String sql, int rsType, int rsConcurrency) throws SQLException {
        super(c, rsType, rsConcurrency);
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            try {
                c.ensureInTransaction();
                this.prepareFixedStatement(sql, true);
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
            finally {
                c.checkEndTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet executeQuery() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            try {
                this.c.ensureInTransaction();
                if (!this.internalExecute(this.isExecuteProcedureStatement)) {
                    throw new FBSQLException("No resultset for sql", "07005");
                }
                if (this.c.willEndTransaction()) {
                    ResultSet resultSet = this.getCachedResultSet(false);
                    return resultSet;
                }
                ResultSet resultSet = this.getResultSet();
                return resultSet;
            }
            finally {
                this.c.checkEndTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            int n;
            try {
                this.c.ensureInTransaction();
                if (this.internalExecute(this.isExecuteProcedureStatement)) {
                    throw new FBSQLException("Update statement returned results.");
                }
                n = this.getUpdateCount();
            }
            catch (Throwable throwable) {
                this.c.checkEndTransaction();
                throw throwable;
            }
            this.c.checkEndTransaction();
            return n;
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.getField(parameterIndex).setNull();
    }

    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.getField(parameterIndex).setBinaryStream(inputStream, length);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.getField(parameterIndex).setBytes(x);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.getField(parameterIndex).setBoolean(x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.getField(parameterIndex).setByte(x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.getField(parameterIndex).setDate(x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.getField(parameterIndex).setDouble(x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.getField(parameterIndex).setFloat(x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.getField(parameterIndex).setInteger(x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.getField(parameterIndex).setLong(x);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.getField(parameterIndex).setObject(x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.getField(parameterIndex).setShort(x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.getField(parameterIndex).setString(x);
    }

    public void setStringForced(int parameterIndex, String x) throws SQLException {
        FBField field = this.getField(parameterIndex);
        if (field instanceof FBWorkaroundStringField) {
            ((FBWorkaroundStringField)field).setStringForced(x);
        } else {
            field.setString(x);
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.getField(parameterIndex).setTime(x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.getField(parameterIndex).setTimestamp(x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.getField(parameterIndex).setBigDecimal(x);
    }

    protected XSQLVAR getXsqlvar(int columnIndex) {
        return this.fixedStmt.getInSqlda().sqlvar[columnIndex - 1];
    }

    protected FBField getField(int columnIndex) throws SQLException {
        if (columnIndex > this.fields.length) {
            throw new FBSQLException("Invalid column index.", "HY002");
        }
        this.isParamSet[columnIndex - 1] = true;
        return this.fields[columnIndex - 1];
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }

    public void clearParameters() throws SQLException {
        if (this.isParamSet == null) {
            return;
        }
        for (int i = 0; i < this.isParamSet.length; ++i) {
            this.isParamSet[i] = false;
        }
        XSQLVAR[] xsqlvar = this.fixedStmt.getInSqlda().sqlvar;
        for (int i = 0; i < xsqlvar.length; ++i) {
            xsqlvar[i].sqldata = null;
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            boolean bl;
            try {
                this.c.ensureInTransaction();
                boolean hasResultSet = this.internalExecute(this.isExecuteProcedureStatement);
                if (hasResultSet && this.c.willEndTransaction()) {
                    this.getCachedResultSet(false);
                }
                bl = hasResultSet;
            }
            catch (Throwable throwable) {
                this.c.checkEndTransaction();
                throw throwable;
            }
            this.c.checkEndTransaction();
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean internalExecute(boolean sendOutParams) throws SQLException {
        Object syncObject;
        boolean canExecute = true;
        for (int i = 0; i < this.isParamSet.length; ++i) {
            canExecute = canExecute && this.isParamSet[i];
        }
        if (!canExecute) {
            throw new FBSQLException("Not all parameters were set.");
        }
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            int i;
            if (this.hasBlobs) {
                for (i = 0; i < this.isParamSet.length; ++i) {
                    if (!this.isBlob[i]) continue;
                    FBFlushableField flushableField = (FBFlushableField)((Object)this.getField(i + 1));
                    flushableField.flushCachedData();
                }
            }
            try {
                this.closeResultSet();
                this.c.executeStatement(this.fixedStmt, sendOutParams);
                this.isResultSet = this.fixedStmt.getOutSqlda().sqld > 0;
                i = this.fixedStmt.getOutSqlda().sqld > 0 ? 1 : 0;
                return i != 0;
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
            finally {
                this.hasMoreResults = true;
            }
        }
    }

    public void addBatch() throws SQLException {
        boolean allParamsSet = true;
        for (int i = 0; i < this.isParamSet.length; ++i) {
            allParamsSet &= this.isParamSet[i];
        }
        if (!allParamsSet) {
            throw new FBSQLException("Not all parameters set.");
        }
        XSQLVAR[] oldXsqlvar = this.fixedStmt.getInSqlda().sqlvar;
        XSQLVAR[] newXsqlvar = new XSQLVAR[oldXsqlvar.length];
        for (int i = 0; i < newXsqlvar.length; ++i) {
            newXsqlvar[i] = new XSQLVAR();
            newXsqlvar[i].aliasname = oldXsqlvar[i].aliasname;
            newXsqlvar[i].ownname = oldXsqlvar[i].ownname;
            newXsqlvar[i].relname = oldXsqlvar[i].relname;
            newXsqlvar[i].sqllen = oldXsqlvar[i].sqllen;
            newXsqlvar[i].sqlname = oldXsqlvar[i].sqlname;
            newXsqlvar[i].sqlscale = oldXsqlvar[i].sqlscale;
            newXsqlvar[i].sqlsubtype = oldXsqlvar[i].sqlsubtype;
            newXsqlvar[i].sqltype = oldXsqlvar[i].sqltype;
            newXsqlvar[i].sqldata = oldXsqlvar[i].sqldata;
        }
        this.batchList.add(newXsqlvar);
    }

    public void clearBatch() throws SQLException {
        this.batchList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        Object syncObject = this.getSynchronizationObject();
        LinkedList<Integer> results = new LinkedList<Integer>();
        Iterator iter = this.batchList.iterator();
        boolean commit = false;
        Object object = syncObject;
        synchronized (object) {
            int[] nArray;
            this.c.ensureInTransaction();
            try {
                while (iter.hasNext()) {
                    XSQLVAR[] vars = (XSQLVAR[])iter.next();
                    this.fixedStmt.getInSqlda().sqlvar = vars;
                    for (int i = 0; i < this.isParamSet.length; ++i) {
                        this.isParamSet[i] = true;
                    }
                    try {
                        if (this.internalExecute(this.isExecuteProcedureStatement)) {
                            throw new BatchUpdateException(this.toArray(results));
                        }
                        int updateCount = this.getUpdateCount();
                        results.add(new Integer(updateCount));
                    }
                    catch (SQLException ex) {
                        throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), this.toArray(results));
                    }
                }
                commit = true;
                nArray = this.toArray(results);
            }
            catch (Throwable throwable) {
                this.c.checkEndTransaction(commit);
                throw throwable;
            }
            this.c.checkEndTransaction(commit);
            return nArray;
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.getField(parameterIndex).setCharacterStream(reader, length);
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void setBlob(int parameterIndex, Blob blob) throws SQLException {
        if (!(blob instanceof FBBlob)) {
            throw new FBSQLException("You must use FBBlobs with Firebird.", "HY105");
        }
        this.getField(parameterIndex).setBlob((FBBlob)blob);
    }

    public void setClob(int i, Clob x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void setArray(int i, Array x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new FBResultSetMetaData(this.fixedStmt.getOutSqlda().sqlvar, this.c);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.getField(parameterIndex).setDate(x, cal);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.getField(parameterIndex).setTime(x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.getField(parameterIndex).setTimestamp(x, cal);
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    protected void prepareFixedStatement(String sql, boolean describeBind) throws GDSException, SQLException {
        super.prepareFixedStatement(sql, describeBind);
        XSQLDA inSqlda = this.fixedStmt.getInSqlda();
        if (!describeBind && inSqlda == null) {
            inSqlda = new XSQLDA();
            inSqlda.sqln = 0;
            inSqlda.sqlvar = new XSQLVAR[0];
        }
        this.isParamSet = new boolean[inSqlda.sqln];
        this.fields = new FBField[inSqlda.sqln];
        this.isBlob = new boolean[inSqlda.sqln];
        XSQLVAR[] inVars = inSqlda.sqlvar;
        for (int i = 0; i < this.isParamSet.length; ++i) {
            this.isParamSet[i] = false;
            this.fields[i] = FBField.createField(this.getXsqlvar(i + 1), null, i, false);
            this.fields[i].setConnection(this.c);
            boolean bl = this.isBlob[i] = FBField.isType(this.getXsqlvar(i + 1), 2004) || FBField.isType(this.getXsqlvar(i + 1), -2) || FBField.isType(this.getXsqlvar(i + 1), -1);
            if (!this.isBlob[i]) continue;
            this.hasBlobs = true;
        }
        this.isExecuteProcedureStatement = this.isExecuteProcedureStatement(sql);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

