/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.isc_stmt_handle;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdStatement;
import org.firebirdsql.jdbc.Synchronizable;

public abstract class AbstractStatement
implements FirebirdStatement,
Synchronizable {
    protected AbstractConnection c;
    protected isc_stmt_handle fixedStmt;
    private FBResultSet currentRs;
    private boolean closed;
    private boolean escapedProcessing = true;
    protected SQLWarning firstWarning = null;
    protected boolean isResultSet;
    protected boolean hasMoreResults;
    private ResultSet currentCachedResultSet;
    protected int maxRows = 0;
    protected int fetchSize = 0;
    private int maxFieldSize = 0;
    private int queryTimeout = 0;
    private String cursorName;
    private int rsConcurrency;
    private int rsType;
    private FBObjectListener.ResultSetListener resultSetListener = new RSListener();
    private static final int INSERTED_ROWS_COUNT = 1;
    private static final int UPDATED_ROWS_COUNT = 2;
    private static final int DELETED_ROWS_COUNT = 3;
    private LinkedList batchList = new LinkedList();

    protected AbstractStatement(AbstractConnection c, int rsType, int rsConcurrency) {
        this.c = c;
        this.rsConcurrency = rsConcurrency;
        this.rsType = rsType;
        this.closed = false;
    }

    String getCursorName() {
        return this.cursorName;
    }

    public boolean isValid() {
        return this.fixedStmt != null && this.fixedStmt.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSynchronizationObject() throws SQLException {
        AbstractConnection abstractConnection = this.c;
        synchronized (abstractConnection) {
            if (this.c.getAutoCommit()) {
                return this.c;
            }
            return this;
        }
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            this.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet executeQuery(String sql) throws SQLException {
        Object syncObject;
        if (this.closed) {
            throw new FBSQLException("Statement is closed");
        }
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            try {
                this.c.ensureInTransaction();
                if (!this.internalExecute(sql)) {
                    throw new FBSQLException("Query did not return a result set.", "07005");
                }
                if (this.c.willEndTransaction()) {
                    ResultSet rs;
                    ResultSet resultSet = rs = this.getCachedResultSet(false);
                    return resultSet;
                }
                ResultSet rs = this.getResultSet();
                return rs;
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
            finally {
                this.c.checkEndTransaction();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String sql) throws SQLException {
        Object syncObject;
        if (this.closed) {
            throw new FBSQLException("Statement is closed");
        }
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            try {
                this.c.ensureInTransaction();
                if (this.internalExecute(sql)) {
                    throw new FBSQLException("Update statement returned results.");
                }
                int n = this.getUpdateCount();
                return n;
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
            finally {
                this.c.checkEndTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        Object syncObject;
        if (this.closed) {
            throw new FBSQLException("This statement is already closed.");
        }
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            block17: {
                try {
                    if (this.fixedStmt != null) {
                        try {
                            try {
                                if (this.currentRs != null) {
                                    this.currentRs.close();
                                }
                                if (this.currentCachedResultSet != null) {
                                    this.currentCachedResultSet.close();
                                }
                                Object var4_3 = null;
                                this.currentRs = null;
                                this.currentCachedResultSet = null;
                            }
                            catch (Throwable throwable) {
                                Object var4_4 = null;
                                this.currentRs = null;
                                this.currentCachedResultSet = null;
                                this.c.closeStatement(this.fixedStmt, true);
                                throw throwable;
                            }
                            this.c.closeStatement(this.fixedStmt, true);
                            {
                                break block17;
                            }
                        }
                        catch (GDSException ge) {
                            throw new FBSQLException(ge);
                        }
                        finally {
                            this.fixedStmt = null;
                            this.closed = true;
                        }
                    }
                    this.closed = true;
                }
                finally {
                    this.c.notifyStatementClosed(this);
                }
            }
        }
    }

    boolean isClosed() {
        return this.closed;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            throw new FBSQLException("Can't set max field size negative", "HY009");
        }
        this.maxFieldSize = max;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new FBSQLException("Max rows can't be less than 0", "HY009");
        }
        this.maxRows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapedProcessing = enable;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new FBSQLException("Can't set query timeout negative", "HY009");
        }
        this.queryTimeout = seconds;
    }

    public void cancel() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.firstWarning;
    }

    public void clearWarnings() throws SQLException {
        this.firstWarning = null;
    }

    public void setCursorName(String name) throws SQLException {
        this.cursorName = name;
    }

    boolean isUpdatableCursor() {
        return this.cursorName != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(String sql) throws SQLException {
        Object syncObject;
        if (this.closed) {
            throw new FBSQLException("Statement is closed");
        }
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            try {
                this.c.ensureInTransaction();
                boolean hasResultSet = this.internalExecute(sql);
                if (hasResultSet && this.c.willEndTransaction()) {
                    this.getCachedResultSet(false);
                }
                boolean bl = hasResultSet;
                return bl;
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
            finally {
                this.c.checkEndTransaction();
            }
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            if (this.cursorName != null) {
                this.c.setCursorName(this.fixedStmt, this.cursorName);
            }
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
        if (this.currentRs != null) {
            throw new FBSQLException("Only one resultset at a time/statement.");
        }
        if (this.fixedStmt == null) {
            throw new FBSQLException("No statement was executed.");
        }
        if (this.currentCachedResultSet != null) {
            ResultSet rs = this.currentCachedResultSet;
            this.currentCachedResultSet = null;
            return rs;
        }
        if (this.isResultSet) {
            this.currentRs = new FBResultSet(this.c, this, this.fixedStmt, this.resultSetListener, this.rsType, this.rsConcurrency);
            return this.currentRs;
        }
        return null;
    }

    ResultSet getCachedResultSet(boolean trimStrings) throws SQLException {
        if (this.currentRs != null) {
            throw new FBSQLException("Only one resultset at a time/statement.");
        }
        if (this.fixedStmt == null) {
            throw new FBSQLException("No statement was executed.");
        }
        this.currentCachedResultSet = new FBResultSet(this.c, this, this.fixedStmt, trimStrings, this.resultSetListener);
        return this.currentCachedResultSet;
    }

    public boolean hasOpenResultSet() {
        return this.currentRs != null;
    }

    public int getUpdateCount() throws SQLException {
        if (this.isResultSet || !this.hasMoreResults) {
            return -1;
        }
        try {
            this.c.getSqlCounts(this.fixedStmt);
            int insCount = this.fixedStmt.getInsertCount();
            int updCount = this.fixedStmt.getUpdateCount();
            int delCount = this.fixedStmt.getDeleteCount();
            int resCount = updCount > delCount ? updCount : delCount;
            int n = resCount = resCount > insCount ? resCount : insCount;
            return n;
        }
        catch (GDSException ge) {
            throw new FBSQLException(ge);
        }
        finally {
            this.hasMoreResults = false;
        }
    }

    private int getChangedRowsCount(int type) throws SQLException {
        if (this.isResultSet || !this.hasMoreResults) {
            return -1;
        }
        try {
            this.c.getSqlCounts(this.fixedStmt);
            switch (type) {
                case 1: {
                    return this.fixedStmt.getInsertCount();
                }
                case 2: {
                    return this.fixedStmt.getUpdateCount();
                }
                case 3: {
                    return this.fixedStmt.getDeleteCount();
                }
            }
            throw new IllegalArgumentException("Specified type is unknown.");
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    public int getDeletedRowsCount() throws SQLException {
        return this.getChangedRowsCount(3);
    }

    public int getInsertedRowsCount() throws SQLException {
        return this.getChangedRowsCount(1);
    }

    public int getUpdatedRowsCount() throws SQLException {
        return this.getChangedRowsCount(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMoreResults() throws SQLException {
        this.hasMoreResults = false;
        if (this.currentRs != null) {
            try {
                this.currentRs.close();
            }
            finally {
                this.currentRs = null;
            }
        }
        if (this.currentCachedResultSet != null) {
            try {
                this.currentCachedResultSet.close();
            }
            finally {
                this.currentCachedResultSet = null;
            }
        }
        return this.hasMoreResults;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new FBDriverNotCapableException();
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new FBSQLException("Can't set negative fetch size", "HY009");
        }
        if (this.maxRows > 0 && rows > this.maxRows) {
            throw new FBSQLException("Can't set fetch size > maxRows", "HY009");
        }
        this.fetchSize = rows;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.rsConcurrency;
    }

    public int getResultSetType() throws SQLException {
        return this.rsType;
    }

    public void addBatch(String sql) throws SQLException {
        this.batchList.add(sql);
    }

    public void clearBatch() throws SQLException {
        this.batchList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        if (this.closed) {
            throw new FBSQLException("Statement is closed");
        }
        if (this.c.getAutoCommit()) {
            this.c.addWarning(new SQLWarning("Batch updates should be run with auto-commit disabled.", "1000"));
        }
        Object syncObject = this.getSynchronizationObject();
        LinkedList<Integer> responses = new LinkedList<Integer>();
        boolean commit = false;
        Object object = syncObject;
        synchronized (object) {
            int[] nArray;
            try {
                this.c.ensureInTransaction();
                Iterator iter = this.batchList.iterator();
                while (iter.hasNext()) {
                    String sql = (String)iter.next();
                    try {
                        boolean hasResultSet = this.internalExecute(sql);
                        if (hasResultSet) {
                            throw new BatchUpdateException(this.toArray(responses));
                        }
                        responses.add(new Integer(this.getUpdateCount()));
                    }
                    catch (GDSException ge) {
                        throw new BatchUpdateException(ge.getMessage(), "HY000", ge.getFbErrorCode(), this.toArray(responses));
                    }
                }
                commit = true;
                nArray = this.toArray(responses);
            }
            catch (Throwable throwable) {
                this.c.checkEndTransaction(commit);
                throw throwable;
            }
            this.c.checkEndTransaction(commit);
            return nArray;
        }
    }

    protected int[] toArray(Collection list) {
        int[] result = new int[list.size()];
        int counter = 0;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            result[counter++] = (Integer)iter.next();
        }
        return result;
    }

    public Connection getConnection() {
        return this.c;
    }

    void closeResultSet() throws SQLException {
        this.currentCachedResultSet = null;
        if (this.currentRs != null) {
            try {
                this.c.closeStatement(this.fixedStmt, false);
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
            this.currentRs = null;
        }
    }

    public void forgetResultSet() {
        this.currentRs = null;
        if (this.fixedStmt != null) {
            this.fixedStmt.clearRows();
        }
    }

    protected boolean isExecuteProcedureStatement(String sql) throws SQLException {
        String trimmedSql = this.c.nativeSQL(sql).trim();
        return trimmedSql.startsWith("EXECUTE");
    }

    protected boolean internalExecute(String sql) throws GDSException, SQLException {
        if (this.closed) {
            throw new FBSQLException("Statement is already closed.");
        }
        this.closeResultSet();
        this.prepareFixedStatement(sql, false);
        this.c.executeStatement(this.fixedStmt, this.isExecuteProcedureStatement(sql));
        this.isResultSet = this.fixedStmt.getOutSqlda().sqld > 0;
        this.hasMoreResults = true;
        return this.fixedStmt.getOutSqlda().sqld > 0;
    }

    protected void prepareFixedStatement(String sql, boolean describeBind) throws GDSException, SQLException {
        if (this.fixedStmt == null) {
            this.fixedStmt = this.c.getAllocatedStatement();
        }
        this.c.prepareSQL(this.fixedStmt, this.escapedProcessing ? this.c.nativeSQL(sql) : sql, describeBind);
    }

    protected void addWarning(SQLWarning warning) {
        if (this.firstWarning == null) {
            this.firstWarning = warning;
        } else {
            SQLWarning lastWarning = this.firstWarning;
            while (lastWarning.getNextWarning() != null) {
                lastWarning = lastWarning.getNextWarning();
            }
            lastWarning.setNextWarning(warning);
        }
    }

    private class RSListener
    implements FBObjectListener.ResultSetListener {
        private RSListener() {
        }

        public void resultSetClosed(ResultSet rs) {
            if (AbstractStatement.this.currentRs == rs) {
                AbstractStatement.this.currentRs = null;
            } else if (AbstractStatement.this.currentCachedResultSet == rs) {
                AbstractStatement.this.currentCachedResultSet = null;
            }
        }
    }
}

