/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.isc_blob_handle;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdBlob;
import org.firebirdsql.jdbc.Synchronizable;

public class FBBlob
implements FirebirdBlob,
Synchronizable {
    private static final boolean SEGMENTED = true;
    public static final int READ_FULLY_BUFFER_SIZE = 16384;
    private int bufferlength;
    private boolean isNew;
    private long blob_id;
    private AbstractConnection c;
    private Collection inputStreams = new HashSet();
    private FBBlobOutputStream blobOut = null;

    private FBBlob(AbstractConnection c, boolean isNew) {
        this.c = c;
        this.isNew = isNew;
        this.bufferlength = c.getBlobBufferLength();
    }

    public FBBlob(AbstractConnection c) {
        this(c, true);
    }

    public FBBlob(AbstractConnection c, long blob_id) {
        this(c, false);
        this.blob_id = blob_id;
    }

    public Object getSynchronizationObject() {
        return this.c;
    }

    public void close() throws IOException {
        IOException error = null;
        Iterator i = this.inputStreams.iterator();
        while (i.hasNext()) {
            try {
                ((FBBlobInputStream)i.next()).close();
            }
            catch (IOException ex) {
                error = ex;
            }
        }
        this.inputStreams.clear();
        if (error != null) {
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public byte[] getInfo(byte[] items, int buffer_length) throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            try {
                byte[] byArray;
                this.c.ensureInTransaction();
                isc_blob_handle blob = this.c.openBlobHandle(this.blob_id, true);
                try {
                    GDS gds = this.c.getInternalAPIHandler();
                    byArray = gds.isc_blob_info(blob, items, buffer_length);
                }
                catch (Throwable throwable) {
                    try {
                        this.c.closeBlob(blob);
                        throw throwable;
                    }
                    catch (GDSException ex) {
                        throw new FBSQLException(ex);
                    }
                }
                this.c.closeBlob(blob);
                return byArray;
            }
            finally {
                if (this.c.willEndTransaction()) {
                    this.c.checkEndTransaction();
                }
            }
        }
    }

    public long length() throws SQLException {
        byte[] info = this.getInfo(new byte[]{6}, 20);
        return this.interpretLength(info, 0);
    }

    private long interpretLength(byte[] info, int position) throws SQLException {
        if (info[position] != 6) {
            throw new FBSQLException("Length is not available.");
        }
        int dataLength = this.c.getInternalAPIHandler().isc_vax_integer(info, position + 1, 2);
        return this.c.getInternalAPIHandler().isc_vax_integer(info, position + 3, dataLength);
    }

    public boolean isSegmented() throws SQLException {
        byte[] info = this.getInfo(new byte[]{7}, 20);
        if (info[0] != 7) {
            throw new FBSQLException("Cannot determine BLOB type");
        }
        int dataLength = this.c.getInternalAPIHandler().isc_vax_integer(info, 1, 2);
        int type = this.c.getInternalAPIHandler().isc_vax_integer(info, 3, dataLength);
        return type == 0;
    }

    public FirebirdBlob detach() throws SQLException {
        return new FBBlob(this.c, this.blob_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes(long pos, int length) throws SQLException {
        Object syncObject;
        if (pos > Integer.MAX_VALUE) {
            throw new FBSQLException("Blob position is limited to 2^31 - 1 due to isc_seek_blob limitations.", "HY009");
        }
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.c.ensureInTransaction();
            try {
                byte[] byArray;
                FirebirdBlob.BlobInputStream in = (FirebirdBlob.BlobInputStream)((Object)this.getBinaryStream());
                try {
                    byte[] result = new byte[length];
                    in.seek((int)pos - 1);
                    in.readFully(result);
                    byArray = result;
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new FBSQLException(ex);
                    }
                }
                in.close();
                return byArray;
            }
            finally {
                if (this.c.willEndTransaction()) {
                    this.c.checkEndTransaction();
                }
            }
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        FBBlobInputStream blobstream = new FBBlobInputStream(this);
        this.inputStreams.add(blobstream);
        return blobstream;
    }

    public long position(byte[] pattern, long start) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public long position(Blob pattern, long start) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void truncate(long param1) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public int setBytes(long param1, byte[] param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public int setBytes(long param1, byte[] param2, int param3, int param4) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        if (this.blobOut != null) {
            throw new FBSQLException("Only one blob output stream open at a time!");
        }
        if (pos < 0L) {
            throw new FBSQLException("You can't start before the beginning of the blob", "HY009");
        }
        if (this.isNew && pos > 0L) {
            throw new FBSQLException("Previous value was null, you must start at position 0", "HY009");
        }
        this.blobOut = new FBBlobOutputStream();
        if (pos > 0L) {
            // empty if block
        }
        return this.blobOut;
    }

    public long getBlobId() throws SQLException {
        if (this.isNew) {
            throw new FBSQLException("No Blob ID is available in new Blob object.");
        }
        return this.blob_id;
    }

    void setBlobId(long blob_id) {
        this.blob_id = blob_id;
        this.isNew = false;
    }

    public void copyStream(InputStream inputStream, int length) throws SQLException {
        OutputStream os = this.setBinaryStream(0L);
        byte[] buffer = new byte[this.bufferlength];
        try {
            int chunk;
            while (length > 0 && (chunk = inputStream.read(buffer, 0, length < this.bufferlength ? length : this.bufferlength)) != -1) {
                os.write(buffer, 0, chunk);
                length -= chunk;
            }
            os.close();
        }
        catch (IOException ioe) {
            throw new FBSQLException(ioe);
        }
    }

    public void copyCharacterStream(Reader inputStream, int length) throws SQLException {
        OutputStream os = this.setBinaryStream(0L);
        OutputStreamWriter osw = new OutputStreamWriter(os);
        char[] buffer = new char[this.bufferlength];
        try {
            int chunk;
            while (length > 0 && (chunk = inputStream.read(buffer, 0, length < this.bufferlength ? length : this.bufferlength)) != -1) {
                osw.write(buffer, 0, chunk);
                length -= chunk;
            }
            os.close();
        }
        catch (IOException ioe) {
            throw new FBSQLException(ioe);
        }
    }

    public class FBBlobOutputStream
    extends OutputStream
    implements FirebirdBlob.BlobOutputStream {
        private isc_blob_handle blob;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FBBlobOutputStream() throws SQLException {
            Object syncObject;
            Object object = syncObject = FBBlob.this.getSynchronizationObject();
            synchronized (object) {
                try {
                    DatabaseParameterBuffer dpb = FBBlob.this.c.getDatabaseParameterBuffer();
                    boolean useStreamBlobs = dpb.hasArgument(131);
                    this.blob = FBBlob.this.c.createBlobHandle(!useStreamBlobs);
                }
                catch (GDSException ge) {
                    throw new FBSQLException(ge);
                }
            }
            if (FBBlob.this.isNew) {
                FBBlob.this.setBlobId(this.blob.getBlob_id());
            }
        }

        public void seek(int position, int seekMode) throws SQLException {
            try {
                FBBlob.this.c.getInternalAPIHandler().isc_seek_blob(this.blob, position, seekMode);
            }
            catch (GDSException ex) {
                throw new FBSQLException(ex);
            }
        }

        public long length() throws IOException {
            Object syncObject;
            Object object = syncObject = FBBlob.this.getSynchronizationObject();
            synchronized (object) {
                try {
                    byte[] info = FBBlob.this.c.getInternalAPIHandler().isc_blob_info(this.blob, new byte[]{6}, 20);
                    return FBBlob.this.interpretLength(info, 0);
                }
                catch (GDSException ex) {
                    throw new IOException(ex.getMessage());
                }
                catch (SQLException ex) {
                    throw new IOException(ex.getMessage());
                }
            }
        }

        public void write(int b) throws IOException {
            throw new IOException("FBBlobOutputStream.write(int b) not implemented");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                byte[] buf = new byte[FBBlob.this.bufferlength];
                while (len > 0) {
                    Object syncObject;
                    int chunk;
                    if (len >= FBBlob.this.bufferlength) {
                        chunk = FBBlob.this.bufferlength;
                    } else {
                        buf = new byte[len];
                        chunk = len;
                    }
                    System.arraycopy(b, off, buf, 0, chunk);
                    Object object = syncObject = FBBlob.this.getSynchronizationObject();
                    synchronized (object) {
                        FBBlob.this.c.putBlobSegment(this.blob, buf);
                    }
                    len -= chunk;
                }
            }
            catch (GDSException ge) {
                throw new IOException("Problem writing to FBBlobOutputStream: " + ge);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.blob != null) {
                try {
                    Object syncObject;
                    Object object = syncObject = FBBlob.this.getSynchronizationObject();
                    synchronized (object) {
                        FBBlob.this.c.closeBlob(this.blob);
                    }
                    FBBlob.this.setBlobId(this.blob.getBlob_id());
                }
                catch (GDSException ge) {
                    throw new IOException("could not close blob: " + ge);
                }
                this.blob = null;
            }
        }
    }

    public class FBBlobInputStream
    extends InputStream
    implements FirebirdBlob.BlobInputStream {
        private byte[] buffer = null;
        private isc_blob_handle blob;
        private int pos = 0;
        private boolean closed;
        private FBBlob owner;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FBBlobInputStream(FBBlob owner) throws SQLException {
            Object syncObject;
            this.owner = owner;
            this.closed = false;
            if (FBBlob.this.isNew) {
                throw new FBSQLException("You can't read a new blob");
            }
            Object object = syncObject = FBBlob.this.getSynchronizationObject();
            synchronized (object) {
                try {
                    this.blob = FBBlob.this.c.openBlobHandle(FBBlob.this.blob_id, true);
                }
                catch (GDSException ge) {
                    throw new FBSQLException(ge);
                }
            }
        }

        public FirebirdBlob getBlob() {
            return this.owner;
        }

        public void seek(int position) throws IOException {
            this.seek(position, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void seek(int position, int seekMode) throws IOException {
            Object syncObject;
            Object object = syncObject = FBBlob.this.getSynchronizationObject();
            synchronized (object) {
                try {
                    FBBlob.this.c.getInternalAPIHandler().isc_seek_blob(this.blob, position, seekMode);
                }
                catch (GDSException ex) {
                    throw new IOException(ex.getMessage());
                }
            }
        }

        public long length() throws IOException {
            Object syncObject;
            Object object = syncObject = FBBlob.this.getSynchronizationObject();
            synchronized (object) {
                try {
                    byte[] info = FBBlob.this.c.getInternalAPIHandler().isc_blob_info(this.blob, new byte[]{6}, 20);
                    return FBBlob.this.interpretLength(info, 0);
                }
                catch (GDSException ex) {
                    throw new IOException(ex.getMessage());
                }
                catch (SQLException ex) {
                    throw new IOException(ex.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            this.checkClosed();
            if (this.buffer == null) {
                Object syncObject;
                if (this.blob.isEof()) {
                    return -1;
                }
                Object object = syncObject = FBBlob.this.getSynchronizationObject();
                synchronized (object) {
                    try {
                        this.buffer = FBBlob.this.c.getBlobSegment(this.blob, FBBlob.this.bufferlength);
                    }
                    catch (GDSException ge) {
                        throw new IOException("Blob read problem: " + ge.toString());
                    }
                }
                this.pos = 0;
                if (this.buffer.length == 0) {
                    return -1;
                }
            }
            return this.buffer.length - this.pos;
        }

        public int read() throws IOException {
            this.checkClosed();
            if (this.available() <= 0) {
                return -1;
            }
            int result = this.buffer[this.pos++] & 0xFF;
            if (this.pos == this.buffer.length) {
                this.buffer = null;
            }
            return result;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.checkClosed();
            int result = this.available();
            if (result <= 0) {
                return -1;
            }
            if (result > len) {
                System.arraycopy(this.buffer, this.pos, b, off, len);
                this.pos += len;
                return len;
            }
            System.arraycopy(this.buffer, this.pos, b, off, result);
            this.buffer = null;
            this.pos = 0;
            return result;
        }

        public void readFully(byte[] b, int off, int len) throws IOException {
            int counter = 0;
            int pos = 0;
            byte[] buffer = new byte[16384];
            for (int toRead = len; toRead > 0 && (counter = this.read(buffer, 0, toRead)) != -1; toRead -= counter) {
                System.arraycopy(buffer, 0, b, pos, counter);
                pos += counter;
            }
            if (counter == -1) {
                throw new EOFException();
            }
        }

        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Object syncObject;
            Object object = syncObject = FBBlob.this.getSynchronizationObject();
            synchronized (object) {
                if (this.blob != null) {
                    try {
                        FBBlob.this.c.closeBlob(this.blob);
                    }
                    catch (GDSException ge) {
                        throw new IOException("couldn't close blob: " + ge);
                    }
                    this.blob = null;
                    this.closed = true;
                }
            }
        }

        private void checkClosed() throws IOException {
            if (this.closed) {
                throw new IOException("Input stream is already closed.");
            }
        }
    }
}

