/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.FBTpb;
import org.firebirdsql.jca.FBTpbMapper;

public class FBConnectionHelper {
    public static final String TRANSACTION_SERIALIZABLE = "TRANSACTION_SERIALIZABLE";
    public static final String TRANSACTION_REPEATABLE_READ = "TRANSACTION_REPEATABLE_READ";
    public static final String TRANSACTION_READ_COMMITTED = "TRANSACTION_READ_COMMITTED";
    public static final String DPB_PREFIX = "isc_dpb_";
    public static final String TPB_PREFIX = "isc_tpb_";
    public static final String ISC_ENCODINGS_RESOURCE = "isc_encodings.properties";
    public static final String ISC_ENCODING_SIZE_RESOURCE = "isc_encoding_size.properties";
    private static final HashMap dpbTypes = new HashMap();
    private static final HashMap tpbTypes = new HashMap();
    private static final HashMap iscEncodings = new HashMap();
    private static final HashMap javaEncodings = new HashMap();
    private static final HashMap iscEncodingSizes = new HashMap();
    private static boolean encodingsLoaded = false;
    private static boolean encodingSizesLoaded = false;
    private static final int[][] CHARSET_MAXIMUM_SIZE;
    static /* synthetic */ Class class$org$firebirdsql$gds$ISCConstants;
    static /* synthetic */ Class class$org$firebirdsql$jdbc$FBConnectionHelper;

    public static FBConnectionRequestInfo getDefaultCri(GDS gds) {
        FBConnectionRequestInfo result = FBConnectionRequestInfo.newInstance(gds);
        return result;
    }

    public static FBConnectionRequestInfo getCri(Properties info, FBConnectionRequestInfo baseCri) {
        FBConnectionRequestInfo cri = baseCri.deepCopy();
        FBConnectionHelper.copyPropertiesIntoCri(info, cri);
        return cri;
    }

    public static FBConnectionRequestInfo getCri(Properties info, GDS gdsToUse) {
        FBConnectionRequestInfo cri = FBConnectionHelper.getDefaultCri(gdsToUse).deepCopy();
        FBConnectionHelper.copyPropertiesIntoCri(info, cri);
        return cri;
    }

    private static void copyPropertiesIntoCri(Properties info, FBConnectionRequestInfo cri) {
        Iterator<Object> keys = info.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = info.getProperty(key);
            Integer type = (Integer)dpbTypes.get(key);
            if (type == null) continue;
            try {
                byte byteValue = Byte.parseByte(value);
                cri.setProperty((int)type, new byte[]{byteValue});
            }
            catch (NumberFormatException nfex) {
                if ("".equals(value)) {
                    cri.setProperty(type);
                    continue;
                }
                cri.setProperty((int)type, value);
            }
        }
    }

    public static FBTpb getTpb(Properties info) {
        FBTpb tpb = new FBTpb(FBTpbMapper.DEFAULT_MAPPER);
        Iterator<Object> keys = info.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Integer type = (Integer)tpbTypes.get(key);
            if (type == null) continue;
            tpb.add(type);
        }
        return tpb;
    }

    public static FBTpbMapper getTpbMapper(Properties info) throws FBResourceException {
        String tpbMapping = info.getProperty("tpb_mapping");
        FBTpbMapper tpbMapper = null;
        if (tpbMapping != null) {
            tpbMapper = new FBTpbMapper(tpbMapping, (class$org$firebirdsql$jdbc$FBConnectionHelper == null ? (class$org$firebirdsql$jdbc$FBConnectionHelper = FBConnectionHelper.class$("org.firebirdsql.jdbc.FBConnectionHelper")) : class$org$firebirdsql$jdbc$FBConnectionHelper).getClassLoader());
        } else {
            HashMap<String, Object> mapping = new HashMap<String, Object>();
            if (info.containsKey(TRANSACTION_SERIALIZABLE)) {
                mapping.put(TRANSACTION_SERIALIZABLE, info.get(TRANSACTION_SERIALIZABLE));
            }
            if (info.containsKey(TRANSACTION_REPEATABLE_READ)) {
                mapping.put(TRANSACTION_REPEATABLE_READ, info.get(TRANSACTION_REPEATABLE_READ));
            }
            if (info.containsKey(TRANSACTION_READ_COMMITTED)) {
                mapping.put(TRANSACTION_READ_COMMITTED, info.get(TRANSACTION_READ_COMMITTED));
            }
            if (mapping.size() > 0) {
                tpbMapper = new FBTpbMapper(mapping);
            }
        }
        return tpbMapper;
    }

    public static Integer getTpbParam(String name) {
        return (Integer)tpbTypes.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadEncodings() {
        ClassLoader cl = (class$org$firebirdsql$jdbc$FBConnectionHelper == null ? (class$org$firebirdsql$jdbc$FBConnectionHelper = FBConnectionHelper.class$("org.firebirdsql.jdbc.FBConnectionHelper")) : class$org$firebirdsql$jdbc$FBConnectionHelper).getClassLoader();
        InputStream in = null;
        in = cl == null ? ClassLoader.getSystemResourceAsStream(ISC_ENCODINGS_RESOURCE) : cl.getResourceAsStream(ISC_ENCODINGS_RESOURCE);
        if (in == null) {
            return;
        }
        Properties props = new Properties();
        try {
            props.load(in);
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            return;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        iscEncodings.putAll(props);
        Iterator<Object> iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            String iscEncoding = (String)iterator.next();
            String javaEncoding = (String)props.get(iscEncoding);
            javaEncodings.put(javaEncoding, iscEncoding);
        }
        encodingsLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadEncodingSizes() {
        ClassLoader cl = (class$org$firebirdsql$jdbc$FBConnectionHelper == null ? (class$org$firebirdsql$jdbc$FBConnectionHelper = FBConnectionHelper.class$("org.firebirdsql.jdbc.FBConnectionHelper")) : class$org$firebirdsql$jdbc$FBConnectionHelper).getClassLoader();
        InputStream in = null;
        in = cl == null ? ClassLoader.getSystemResourceAsStream(ISC_ENCODING_SIZE_RESOURCE) : cl.getResourceAsStream(ISC_ENCODING_SIZE_RESOURCE);
        if (in == null) {
            return;
        }
        Properties props = new Properties();
        try {
            props.load(in);
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            return;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        Iterator<Object> iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            String iscEncoding = (String)iterator.next();
            String size = (String)props.get(iscEncoding);
            iscEncodingSizes.put(iscEncoding, new Byte(size));
        }
        encodingSizesLoaded = true;
    }

    public static String getJavaEncoding(String iscEncoding) {
        if (!encodingsLoaded) {
            FBConnectionHelper.loadEncodings();
        }
        String javaEncoding = (String)iscEncodings.get(iscEncoding);
        String defaultEncoding = System.getProperty("file.encoding");
        if (javaEncoding == null || javaEncoding.equalsIgnoreCase(defaultEncoding)) {
            return null;
        }
        return javaEncoding;
    }

    public static String getIscEncoding(String javaEncoding) {
        if (!encodingsLoaded) {
            FBConnectionHelper.loadEncodings();
        }
        return (String)javaEncodings.get(javaEncoding);
    }

    public static int getIscEncodingSize(String iscEncoding) {
        Byte result;
        if (!encodingSizesLoaded) {
            FBConnectionHelper.loadEncodingSizes();
        }
        if ((result = (Byte)iscEncodingSizes.get(iscEncoding)) == null) {
            return 1;
        }
        return result.byteValue();
    }

    public static int getCharacterSetSize(int characterSetId) {
        for (int i = 0; i < CHARSET_MAXIMUM_SIZE.length; ++i) {
            if (CHARSET_MAXIMUM_SIZE[i][0] != characterSetId) continue;
            return CHARSET_MAXIMUM_SIZE[i][1];
        }
        return 1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Class iscClass = class$org$firebirdsql$gds$ISCConstants == null ? (class$org$firebirdsql$gds$ISCConstants = FBConnectionHelper.class$("org.firebirdsql.gds.ISCConstants")) : class$org$firebirdsql$gds$ISCConstants;
        Field[] fields = iscClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Integer value;
            if (!fields[i].getType().getName().equals("int")) continue;
            String name = fields[i].getName();
            try {
                value = (Integer)fields[i].get(null);
            }
            catch (IllegalAccessException iaex) {
                continue;
            }
            if (name.startsWith(DPB_PREFIX)) {
                dpbTypes.put(name.substring(DPB_PREFIX.length()), value);
                dpbTypes.put(name, value);
                continue;
            }
            if (!name.startsWith(TPB_PREFIX)) continue;
            tpbTypes.put(name.substring(TPB_PREFIX.length()), value);
            tpbTypes.put(name, value);
        }
        CHARSET_MAXIMUM_SIZE = new int[][]{{0, 1}, {1, 1}, {2, 1}, {3, 3}, {5, 2}, {6, 2}, {9, 1}, {10, 1}, {11, 1}, {12, 1}, {13, 1}, {14, 1}, {15, 1}, {16, 1}, {17, 1}, {18, 1}, {19, 1}, {21, 1}, {22, 1}, {23, 1}, {34, 1}, {35, 1}, {36, 1}, {37, 1}, {38, 1}, {39, 1}, {40, 1}, {44, 2}, {45, 1}, {46, 1}, {47, 1}, {48, 1}, {49, 1}, {50, 1}, {51, 1}, {52, 1}, {53, 1}, {54, 1}, {55, 1}, {56, 2}, {57, 2}, {58, 1}, {59, 1}, {60, 1}};
    }
}

