/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.firebirdsql.jdbc.FBSQLParseException;

public class FBEscapedFunctionHelper {
    private static final HashMap FUNCTION_MAP = new HashMap();

    private static void checkSyntax(String functionCall) throws FBSQLParseException {
        int parenthesisStart = functionCall.indexOf(40);
        if (parenthesisStart == -1) {
            throw new FBSQLParseException("No opening parenthesis found, not a function call.");
        }
        if (functionCall.charAt(functionCall.length() - 1) != ')') {
            throw new FBSQLParseException("No closing parenthesis found, not a function call.");
        }
    }

    public static String parseFunction(String functionCall) throws FBSQLParseException {
        functionCall = functionCall.trim();
        FBEscapedFunctionHelper.checkSyntax(functionCall);
        int parenthesisStart = functionCall.indexOf(40);
        return functionCall.substring(0, parenthesisStart);
    }

    public static List parseArguments(String functionCall) throws FBSQLParseException {
        functionCall = functionCall.trim();
        FBEscapedFunctionHelper.checkSyntax(functionCall);
        int parenthesisStart = functionCall.indexOf(40);
        String paramsString = functionCall.substring(parenthesisStart + 1, functionCall.length() - 1);
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        boolean inQuotes = false;
        boolean inDoubleQuotes = false;
        char[] chars = paramsString.toCharArray();
        block6: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\'': {
                    sb.append(chars[i]);
                    if (inDoubleQuotes) continue block6;
                    inQuotes = !inQuotes;
                    continue block6;
                }
                case '\"': {
                    sb.append(chars[i]);
                    if (inQuotes) continue block6;
                    inDoubleQuotes = !inDoubleQuotes;
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (!inQuotes && !inDoubleQuotes) continue block6;
                    sb.append(chars[i]);
                    continue block6;
                }
                case ',': {
                    if (inQuotes || inDoubleQuotes) {
                        sb.append(chars[i]);
                        continue block6;
                    }
                    params.add(sb.toString());
                    sb = new StringBuffer();
                    continue block6;
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        if (sb.length() > 0) {
            params.add(sb.toString());
        }
        if (inQuotes || inDoubleQuotes) {
            throw new FBSQLParseException("String literal is not properly closed.");
        }
        return params;
    }

    public static String convertTemplate(String functionCall) throws FBSQLParseException {
        String name = FBEscapedFunctionHelper.parseFunction(functionCall);
        List params = FBEscapedFunctionHelper.parseArguments(functionCall);
        String firebirdTemplate = (String)FUNCTION_MAP.get(name.toUpperCase());
        if (firebirdTemplate == null) {
            return null;
        }
        return MessageFormat.format(firebirdTemplate, params.toArray());
    }

    static {
        FUNCTION_MAP.put("ABS", null);
        FUNCTION_MAP.put("ACOS", null);
        FUNCTION_MAP.put("ASIN", null);
        FUNCTION_MAP.put("ATAN", null);
        FUNCTION_MAP.put("ATAN2", null);
        FUNCTION_MAP.put("CEILING", null);
        FUNCTION_MAP.put("COS", null);
        FUNCTION_MAP.put("COT", null);
        FUNCTION_MAP.put("DEGREES", null);
        FUNCTION_MAP.put("EXP", null);
        FUNCTION_MAP.put("FLOOR", null);
        FUNCTION_MAP.put("LOG", null);
        FUNCTION_MAP.put("LOG10", null);
        FUNCTION_MAP.put("MOD", null);
        FUNCTION_MAP.put("PI", null);
        FUNCTION_MAP.put("POWER", null);
        FUNCTION_MAP.put("RADIANS", null);
        FUNCTION_MAP.put("RAND", null);
        FUNCTION_MAP.put("ROUND", null);
        FUNCTION_MAP.put("SIGN", null);
        FUNCTION_MAP.put("SIN", null);
        FUNCTION_MAP.put("SQRT", null);
        FUNCTION_MAP.put("TAN", null);
        FUNCTION_MAP.put("TRUNCATE", null);
        FUNCTION_MAP.put("ASCII", null);
        FUNCTION_MAP.put("CHAR", null);
        FUNCTION_MAP.put("CONCAT", "{0}||{1}");
        FUNCTION_MAP.put("DIFFERENCE", null);
        FUNCTION_MAP.put("INSERT", null);
        FUNCTION_MAP.put("LCASE", "LOWER({0})");
        FUNCTION_MAP.put("LEFT", null);
        FUNCTION_MAP.put("LENGTH", null);
        FUNCTION_MAP.put("LOCATE", null);
        FUNCTION_MAP.put("LTRIM", null);
        FUNCTION_MAP.put("REPEAT", null);
        FUNCTION_MAP.put("REPLACE", null);
        FUNCTION_MAP.put("RIGHT", null);
        FUNCTION_MAP.put("RTRIM", null);
        FUNCTION_MAP.put("SOUNDEX", null);
        FUNCTION_MAP.put("SPACE", null);
        FUNCTION_MAP.put("SUBSTRING", "SUBSTRING({0} FROM {1} FOR {2})");
        FUNCTION_MAP.put("UCASE", "UPPER({0})");
        FUNCTION_MAP.put("CURDATE", "CURRENT_DATE");
        FUNCTION_MAP.put("CURTIME", "CURRENT_TIME");
        FUNCTION_MAP.put("DAYNAME", null);
        FUNCTION_MAP.put("DAYOFMONTH", null);
        FUNCTION_MAP.put("DAYOFWEEK", null);
        FUNCTION_MAP.put("DAYOFYEAR", "EXTRACT(DAY FROM {0})");
        FUNCTION_MAP.put("HOUR", "EXTRACT(HOUR FROM {0})");
        FUNCTION_MAP.put("MINUTE", "EXTRACT(MINUTE FROM {0})");
        FUNCTION_MAP.put("MONTH", "EXTRACT(MONTH FROM {0})");
        FUNCTION_MAP.put("MONTHNAME", null);
        FUNCTION_MAP.put("NOW", "CURRENT_TIMESTAMP");
        FUNCTION_MAP.put("QUARTER", null);
        FUNCTION_MAP.put("SECOND", "EXTRACT(SECOND FROM {0})");
        FUNCTION_MAP.put("TIMESTAMPADD", null);
        FUNCTION_MAP.put("TIMESTAMPDIFF", null);
        FUNCTION_MAP.put("WEEK", null);
        FUNCTION_MAP.put("YEAR", "EXTRACT(YEAR FROM {0})");
        FUNCTION_MAP.put("DATABASE", null);
        FUNCTION_MAP.put("IFNULL", "COALESCE({0}, {1})");
        FUNCTION_MAP.put("CONVERT", null);
    }
}

