/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.FBConnectionHelper;

public class FBParameterMetaData
implements ParameterMetaData {
    private final XSQLVAR[] xsqlvars;
    private final AbstractConnection connection;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Array;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$math$BigDecimal;

    protected FBParameterMetaData(XSQLVAR[] xsqlvars, AbstractConnection connection) throws SQLException {
        this.xsqlvars = xsqlvars;
        this.connection = connection;
    }

    private String getIscEncoding() {
        if (this.connection != null) {
            return this.connection.getIscEncoding();
        }
        return "NONE";
    }

    public int getParameterCount() {
        return this.xsqlvars.length;
    }

    public int isNullable(int parameter) throws SQLException {
        if ((this.getXsqlvar((int)parameter).sqltype & 1) == 1) {
            return 1;
        }
        return 0;
    }

    public boolean isSigned(int parameter) throws SQLException {
        switch (this.getXsqlvar((int)parameter).sqltype & 0xFFFFFFFE) {
            case 480: 
            case 482: 
            case 496: 
            case 500: 
            case 530: 
            case 580: {
                return true;
            }
        }
        return false;
    }

    public int getPrecision(int parameter) throws SQLException {
        int colType = this.getParameterType(parameter);
        switch (colType) {
            case 2: 
            case 3: {
                return this.estimatePrecision(parameter);
            }
            case 1: 
            case 12: {
                XSQLVAR var = this.getXsqlvar(parameter);
                int charset = var.sqlsubtype & 0xFF;
                int charSetSize = charset == 127 ? FBConnectionHelper.getIscEncodingSize(this.getIscEncoding()) : FBConnectionHelper.getCharacterSetSize(charset);
                return var.sqllen / charSetSize;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 5;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 8;
            }
            case 93: {
                return 19;
            }
        }
        return 0;
    }

    public int getScale(int parameter) throws SQLException {
        return this.getXsqlvar((int)parameter).sqlscale * -1;
    }

    public int getParameterType(int parameter) throws SQLException {
        int sqltype = this.getXsqlvar((int)parameter).sqltype & 0xFFFFFFFE;
        int sqlscale = this.getXsqlvar((int)parameter).sqlscale;
        int sqlsubtype = this.getXsqlvar((int)parameter).sqlsubtype;
        if (sqlscale < 0) {
            switch (sqltype) {
                case 480: 
                case 496: 
                case 500: 
                case 580: {
                    if (sqlsubtype == 2) {
                        return 3;
                    }
                    return 2;
                }
            }
        }
        switch (sqltype) {
            case 500: {
                return 5;
            }
            case 496: {
                return 4;
            }
            case 480: 
            case 530: {
                return 8;
            }
            case 482: {
                return 6;
            }
            case 452: {
                return 1;
            }
            case 448: {
                return 12;
            }
            case 510: {
                return 93;
            }
            case 560: {
                return 92;
            }
            case 570: {
                return 91;
            }
            case 580: {
                if (sqlsubtype == 2) {
                    return 3;
                }
                return 2;
            }
            case 520: {
                if (sqlsubtype < 0) {
                    return 2004;
                }
                if (sqlsubtype == 0) {
                    return -4;
                }
                if (sqlsubtype == 1) {
                    return -1;
                }
                return 1111;
            }
            case 550: {
                return 1111;
            }
        }
        return 0;
    }

    public String getParameterTypeName(int parameter) throws SQLException {
        int sqltype = this.getXsqlvar((int)parameter).sqltype & 0xFFFFFFFE;
        int sqlscale = this.getXsqlvar((int)parameter).sqlscale;
        int sqlsubtype = this.getXsqlvar((int)parameter).sqlsubtype;
        if (sqlscale < 0) {
            switch (sqltype) {
                case 480: 
                case 496: 
                case 500: 
                case 580: {
                    if (sqlsubtype == 2) {
                        return "DECIMAL";
                    }
                    return "NUMERIC";
                }
            }
        }
        switch (sqltype) {
            case 500: {
                return "SMALLINT";
            }
            case 496: {
                return "INTEGER";
            }
            case 480: 
            case 530: {
                return "DOUBLE PRECISION";
            }
            case 482: {
                return "FLOAT";
            }
            case 452: {
                return "CHAR";
            }
            case 448: {
                return "VARCHAR";
            }
            case 510: {
                return "TIMESTAMP";
            }
            case 560: {
                return "TIME";
            }
            case 570: {
                return "DATE";
            }
            case 580: {
                if (sqlsubtype == 2) {
                    return "DECIMAL";
                }
                return "NUMERIC";
            }
            case 520: {
                if (sqlsubtype < 0) {
                    return "BLOB SUB_TYPE <0";
                }
                if (sqlsubtype == 0) {
                    return "BLOB SUB_TYPE 0";
                }
                if (sqlsubtype == 1) {
                    return "BLOB SUB_TYPE 1";
                }
                return "BLOB SUB_TYPE >1";
            }
            case 550: {
                return "ARRAY";
            }
        }
        return "NULL";
    }

    public String getParameterClassName(int parameter) throws SQLException {
        switch (this.getXsqlvar((int)parameter).sqltype & 0xFFFFFFFE) {
            case 452: {
                return (class$java$lang$String == null ? (class$java$lang$String = FBParameterMetaData.class$("java.lang.String")) : class$java$lang$String).getName();
            }
            case 448: {
                return (class$java$lang$String == null ? (class$java$lang$String = FBParameterMetaData.class$("java.lang.String")) : class$java$lang$String).getName();
            }
            case 500: {
                return (class$java$lang$Short == null ? (class$java$lang$Short = FBParameterMetaData.class$("java.lang.Short")) : class$java$lang$Short).getName();
            }
            case 496: {
                return (class$java$lang$Long == null ? (class$java$lang$Long = FBParameterMetaData.class$("java.lang.Long")) : class$java$lang$Long).getName();
            }
            case 482: {
                return (class$java$lang$Float == null ? (class$java$lang$Float = FBParameterMetaData.class$("java.lang.Float")) : class$java$lang$Float).getName();
            }
            case 480: {
                return (class$java$lang$Double == null ? (class$java$lang$Double = FBParameterMetaData.class$("java.lang.Double")) : class$java$lang$Double).getName();
            }
            case 530: {
                return (class$java$lang$Double == null ? (class$java$lang$Double = FBParameterMetaData.class$("java.lang.Double")) : class$java$lang$Double).getName();
            }
            case 510: {
                return (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = FBParameterMetaData.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).getName();
            }
            case 520: {
                return (class$java$sql$Blob == null ? (class$java$sql$Blob = FBParameterMetaData.class$("java.sql.Blob")) : class$java$sql$Blob).getName();
            }
            case 540: {
                return (class$java$sql$Array == null ? (class$java$sql$Array = FBParameterMetaData.class$("java.sql.Array")) : class$java$sql$Array).getName();
            }
            case 550: {
                return (class$java$lang$Long == null ? (class$java$lang$Long = FBParameterMetaData.class$("java.lang.Long")) : class$java$lang$Long).getName();
            }
            case 560: {
                return (class$java$sql$Time == null ? (class$java$sql$Time = FBParameterMetaData.class$("java.sql.Time")) : class$java$sql$Time).getName();
            }
            case 570: {
                return (class$java$sql$Date == null ? (class$java$sql$Date = FBParameterMetaData.class$("java.sql.Date")) : class$java$sql$Date).getName();
            }
            case 580: {
                if (this.getXsqlvar((int)parameter).sqlscale == 0) {
                    return (class$java$lang$Long == null ? (class$java$lang$Long = FBParameterMetaData.class$("java.lang.Long")) : class$java$lang$Long).getName();
                }
                return (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = FBParameterMetaData.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName();
            }
        }
        throw new SQLException("Unkown sql type");
    }

    public int getParameterMode(int param) throws SQLException {
        return 1;
    }

    private XSQLVAR getXsqlvar(int parameterIndex) {
        return this.xsqlvars[parameterIndex - 1];
    }

    private int estimatePrecision(int parameterIndex) {
        int sqltype = this.getXsqlvar((int)parameterIndex).sqltype & 0xFFFFFFFE;
        int sqlscale = this.getXsqlvar((int)parameterIndex).sqlscale;
        switch (sqltype) {
            case 500: {
                return 5;
            }
            case 496: {
                return 10;
            }
            case 580: {
                return 19;
            }
            case 480: {
                return 19;
            }
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

