/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.firebirdsql.jdbc.FBProcedureParam;
import org.firebirdsql.jdbc.FBSQLException;

public class FBProcedureCall {
    private static final boolean OLD_CALLABLE_STATEMENT_COMPATIBILITY = true;
    private String name;
    private Vector inputParams = new Vector();
    private Vector outputParams = new Vector();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FBProcedureParam getInputParam(int index) {
        FBProcedureParam result = this.getParam(this.inputParams, index);
        if (result == null || result == NullParam.NULL_PARAM) {
            result = this.getParam(this.outputParams, index);
            if (this.inputParams.size() < index) {
                this.inputParams.setSize(index);
            }
            this.inputParams.set(index - 1, result);
        }
        return result;
    }

    public FBProcedureParam getOutputParam(int index) {
        return this.getParam(this.outputParams, index);
    }

    private FBProcedureParam getParam(Collection params, int index) {
        boolean counter = false;
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            FBProcedureParam param = (FBProcedureParam)iter.next();
            if (param == null || param.getIndex() != index) continue;
            return param;
        }
        return NullParam.NULL_PARAM;
    }

    public int mapOutParamIndexToPosition(int index) throws FBSQLException {
        int position = -1;
        Iterator iter = this.outputParams.iterator();
        while (iter.hasNext()) {
            FBProcedureParam param = (FBProcedureParam)iter.next();
            if (param == null || !param.isParam()) continue;
            ++position;
            if (param.getIndex() != index) continue;
            return position + 1;
        }
        if (position == -1) {
            return index;
        }
        if (position == -1) {
            throw new FBSQLException("Specified parameter does not exist.", "HY002");
        }
        return position;
    }

    public List getInputParams() {
        return this.inputParams;
    }

    public List getOutputParams() {
        return this.outputParams;
    }

    public void addInputParam(FBProcedureParam param) {
        if (this.inputParams.size() < param.getPosition() + 1) {
            this.inputParams.setSize(param.getPosition() + 1);
        }
        this.inputParams.set(param.getPosition(), param);
    }

    public void addOutputParam(FBProcedureParam param) {
        if (this.outputParams.size() < param.getPosition() + 1) {
            this.outputParams.setSize(param.getPosition() + 1);
        }
        this.outputParams.set(param.getPosition(), param);
    }

    public FBProcedureParam addParam(int position, String param) {
        String possibleInIndicator;
        String possibleOutIndicator;
        param = param.trim();
        boolean isInputParam = true;
        if (param.length() > 3 && "OUT".equalsIgnoreCase(possibleOutIndicator = param.substring(0, 3)) && Character.isSpaceChar(param.charAt(3))) {
            isInputParam = false;
            param = param.substring(3).trim();
        }
        if (param.length() > 2 && "IN".equalsIgnoreCase(possibleInIndicator = param.substring(0, 2)) && Character.isSpaceChar(param.charAt(2))) {
            param = param.substring(2).trim();
        }
        FBProcedureParam callParam = new FBProcedureParam(position, param);
        Vector params = isInputParam ? this.inputParams : this.outputParams;
        if (params.size() < position + 1) {
            params.setSize(position + 1);
        }
        params.set(position, callParam);
        return callParam;
    }

    public void registerOutParam(int index, int type) throws SQLException {
        FBProcedureParam param = this.getInputParam(index);
        if (param == null || param == NullParam.NULL_PARAM) {
            param = this.getOutputParam(index);
        } else {
            if (this.outputParams.size() < param.getPosition() + 1) {
                this.outputParams.setSize(param.getPosition() + 1);
            }
            this.outputParams.set(param.getPosition(), param);
            if (!param.isValueSet()) {
                this.inputParams.set(param.getPosition(), null);
            }
        }
        if (param == null || param == NullParam.NULL_PARAM) {
            throw new FBSQLException("Cannot find parameter with the specified position.", "HY002");
        }
        param.setType(type);
    }

    public String getSQL() throws FBSQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("EXECUTE PROCEDURE");
        sb.append(" ");
        sb.append(this.name);
        StringBuffer paramsBuffer = new StringBuffer();
        boolean firstParam = true;
        Iterator iter = this.inputParams.iterator();
        while (iter.hasNext()) {
            FBProcedureParam param = (FBProcedureParam)iter.next();
            if (param == null) continue;
            if (!param.isValueSet() && param.isParam() && this.outputParams.size() > 0 && this.outputParams.get(param.getPosition()) == null) {
                throw new FBSQLException("Value of parameter " + param.getIndex() + " not set and " + "it was not registered as output parameter.", "07001");
            }
            if (param == null) continue;
            if (!firstParam) {
                paramsBuffer.append(", ");
            } else {
                firstParam = false;
            }
            paramsBuffer.append(param.getParamValue());
        }
        if (paramsBuffer.length() > 0) {
            sb.append('(').append(paramsBuffer).append(')');
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FBProcedureCall)) {
            return false;
        }
        FBProcedureCall that = (FBProcedureCall)obj;
        boolean result = this.name != null ? this.name.equals(that.name) : that.name == null;
        result &= this.inputParams.equals(that.inputParams);
        return result &= this.outputParams.equals(that.outputParams);
    }

    private static final class NullParam
    extends FBProcedureParam {
        private static final NullParam NULL_PARAM = new NullParam();

        private NullParam() {
        }

        public void setValue(Object value) throws SQLException {
            throw new FBSQLException("You cannot set value of an non-existing parameter.", "HY009");
        }
    }
}

