/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.isc_stmt_handle;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.AbstractStatement;
import org.firebirdsql.jdbc.FBCachedFetcher;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBResultSetMetaData;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBSQLWarning;
import org.firebirdsql.jdbc.FBStatementFetcher;
import org.firebirdsql.jdbc.FBUpdatableFetcher;
import org.firebirdsql.jdbc.field.FBField;

public class FBResultSet
implements ResultSet {
    private FBFetcher fbFetcher;
    protected AbstractConnection c;
    public XSQLVAR[] xsqlvars;
    public byte[][] row = null;
    private int maxRows = 0;
    private int fetchSize = 0;
    private boolean wasNull = false;
    private boolean wasNullValid = false;
    private boolean closed = false;
    private boolean trimStrings;
    private SQLWarning firstWarning = null;
    private FBField[] fields = null;
    private HashMap colNames = new HashMap();
    private String cursorName;
    private FBObjectListener.ResultSetListener listener;
    private int rsType = 1003;
    private int rsConcurrency = 1007;
    private boolean paranoiaModa;

    protected FBResultSet(AbstractConnection c, AbstractStatement fbstatement, isc_stmt_handle stmt, FBObjectListener.ResultSetListener listener, int rsType, int rsConcurrency) throws SQLException {
        this.c = c;
        this.cursorName = fbstatement.getCursorName();
        this.listener = listener;
        this.rsType = rsType;
        this.rsConcurrency = rsConcurrency;
        this.checkParanoiaMode(c);
        this.xsqlvars = stmt.getOutSqlda().sqlvar;
        this.maxRows = fbstatement.getMaxRows();
        this.prepareVars(false);
        boolean updatableCursor = fbstatement.isUpdatableCursor();
        if (!updatableCursor && rsType == 1004) {
            this.fbFetcher = new FBCachedFetcher(this.c, fbstatement, stmt, this);
        } else {
            if (rsConcurrency == 1008) {
                c.addWarning(new FBSQLWarning("Result set concurrency changed. Only ResultSet.CONCUR_READ_ONLY concurrency is supported."));
                rsConcurrency = 1007;
            }
            if (rsType == 1005) {
                c.addWarning(new FBSQLWarning("Result set type changed. ResultSet.TYPE_SCROLL_SENSITIVE is not supported."));
                rsType = 1004;
            }
            this.fbFetcher = updatableCursor ? new FBUpdatableFetcher(this.c, fbstatement, stmt, this) : new FBStatementFetcher(this.c, fbstatement, stmt, this);
        }
    }

    protected FBResultSet(AbstractConnection c, AbstractStatement fbStatement, isc_stmt_handle stmt, boolean trimStrings, FBObjectListener.ResultSetListener listener) throws SQLException {
        this.c = c;
        this.trimStrings = trimStrings;
        this.listener = listener;
        this.checkParanoiaMode(c);
        this.maxRows = fbStatement.getMaxRows();
        this.xsqlvars = stmt.getOutSqlda().sqlvar;
        this.prepareVars(true);
        this.fbFetcher = new FBCachedFetcher(this.c, fbStatement, stmt, this);
    }

    protected FBResultSet(XSQLVAR[] xsqlvars, ArrayList rows) throws SQLException {
        this.maxRows = 0;
        this.fbFetcher = new FBCachedFetcher(rows, this);
        this.xsqlvars = xsqlvars;
        this.prepareVars(true);
    }

    private void checkParanoiaMode(AbstractConnection c) {
        DatabaseParameterBuffer dpb = c.getDatabaseParameterBuffer();
        this.paranoiaModa = dpb.hasArgument(132);
    }

    private void prepareVars(boolean cached) throws SQLException {
        this.fields = new FBField[this.xsqlvars.length];
        this.colNames = new HashMap(this.xsqlvars.length, 1.0f);
        for (int i = 0; i < this.xsqlvars.length; ++i) {
            this.fields[i] = FBField.createField(this.xsqlvars[i], this, i, cached);
            this.fields[i].setConnection(this.c);
        }
    }

    protected void checkCursorMove() throws SQLException {
        if (this.closed) {
            throw new FBSQLException("The resultSet is closed");
        }
        this.wasNullValid = false;
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].close();
        }
    }

    public boolean next() throws SQLException {
        this.checkCursorMove();
        return this.fbFetcher.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.closed && this.paranoiaModa) {
            throw new FBSQLException("The resultSet is closed");
        }
        this.wasNullValid = false;
        this.closed = true;
        try {
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i].close();
            }
        }
        finally {
            this.fbFetcher.close();
        }
        if (this.listener != null) {
            this.listener.resultSetClosed(this);
        }
    }

    public boolean wasNull() throws SQLException {
        if (!this.wasNullValid) {
            throw new FBSQLException("Look at a column before testing null.");
        }
        if (this.row == null) {
            throw new FBSQLException("No row available for wasNull.");
        }
        return this.wasNull;
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getAsciiStream();
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBigDecimal();
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBinaryStream();
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBlob();
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBoolean();
    }

    public byte getByte(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getByte();
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBytes();
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getDate();
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getDouble();
    }

    public float getFloat(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getFloat();
    }

    public int getInt(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getInt();
    }

    public long getLong(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getLong();
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getObject();
    }

    public short getShort(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getShort();
    }

    public String getString(int columnIndex) throws SQLException {
        if (this.trimStrings) {
            String result = this.getField(columnIndex).getString();
            return result != null ? result.trim() : null;
        }
        return this.getField(columnIndex).getString();
    }

    public Time getTime(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getTime();
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getTimestamp();
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getUnicodeStream();
    }

    protected XSQLVAR getXsqlvar(int columnIndex) {
        return this.xsqlvars[columnIndex - 1];
    }

    public FBField getField(int columnIndex) throws SQLException {
        FBField field = this.getField(columnIndex, true);
        this.wasNullValid = true;
        this.wasNull = this.row[columnIndex - 1] == null;
        return field;
    }

    public FBField getField(int columnIndex, boolean checkRowPosition) throws SQLException {
        if (this.closed) {
            throw new FBSQLException("The resultSet is closed");
        }
        if (checkRowPosition && this.row == null) {
            throw new FBSQLException("The resultSet is not in a row, use next", "01S06");
        }
        if (columnIndex > this.xsqlvars.length) {
            throw new FBSQLException("Invalid column index.", "HY002");
        }
        return this.fields[columnIndex - 1];
    }

    public FBField getField(String columnName) throws SQLException {
        int colNum;
        if (this.closed) {
            throw new FBSQLException("The resultSet is closed");
        }
        if (this.row == null) {
            throw new FBSQLException("The resultSet is not in a row, use next", "01S06");
        }
        if (columnName == null) {
            throw new FBSQLException("Column identifier must be not null.", "HY002");
        }
        Integer fieldNum = (Integer)this.colNames.get(columnName);
        if (fieldNum == null) {
            colNum = this.findColumn(columnName);
            fieldNum = new Integer(colNum);
            this.colNames.put(columnName, fieldNum);
        }
        colNum = fieldNum;
        FBField field = this.fields[colNum - 1];
        this.wasNullValid = true;
        this.wasNull = this.row[colNum - 1] == null;
        return field;
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getField(columnIndex).getBigDecimal(scale);
    }

    public String getString(String columnName) throws SQLException {
        if (this.trimStrings) {
            String result = this.getField(columnName).getString();
            return result != null ? result.trim() : null;
        }
        return this.getField(columnName).getString();
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getField(columnName).getBoolean();
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getField(columnName).getByte();
    }

    public short getShort(String columnName) throws SQLException {
        return this.getField(columnName).getShort();
    }

    public int getInt(String columnName) throws SQLException {
        return this.getField(columnName).getInt();
    }

    public long getLong(String columnName) throws SQLException {
        return this.getField(columnName).getLong();
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getField(columnName).getFloat();
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getField(columnName).getDouble();
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getField(columnName).getBigDecimal(scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getField(columnName).getBytes();
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getField(columnName).getDate();
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getField(columnName).getTime();
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getField(columnName).getTimestamp();
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getField(columnName).getAsciiStream();
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getField(columnName).getUnicodeStream();
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getField(columnName).getBinaryStream();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.firstWarning;
    }

    public void clearWarnings() throws SQLException {
        this.firstWarning = null;
    }

    public String getCursorName() throws SQLException {
        return this.cursorName;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new FBResultSetMetaData(this.xsqlvars, this.c);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getField(columnName).getObject();
    }

    public int findColumn(String columnName) throws SQLException {
        if (columnName == null || columnName.equals("")) {
            throw new FBSQLException("Empty string does not identify column.", "HY002");
        }
        if (columnName.startsWith("\"") && columnName.endsWith("\"")) {
            int i;
            columnName = columnName.substring(1, columnName.length() - 1);
            for (i = 0; i < this.xsqlvars.length; ++i) {
                if (!columnName.equals(this.xsqlvars[i].aliasname)) continue;
                return ++i;
            }
            for (i = 0; i < this.xsqlvars.length; ++i) {
                if (!columnName.equals(this.xsqlvars[i].sqlname)) continue;
                return ++i;
            }
        } else {
            int i;
            for (i = 0; i < this.xsqlvars.length; ++i) {
                if (!columnName.equalsIgnoreCase(this.xsqlvars[i].aliasname)) continue;
                return ++i;
            }
            for (i = 0; i < this.xsqlvars.length; ++i) {
                if (!columnName.equalsIgnoreCase(this.xsqlvars[i].sqlname)) continue;
                return ++i;
            }
        }
        throw new FBSQLException("Column name " + columnName + " not found in result set.", "HY002");
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getCharacterStream();
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getField(columnName).getCharacterStream();
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getField(columnName).getBigDecimal();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.fbFetcher.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        return this.fbFetcher.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        return this.fbFetcher.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.fbFetcher.isLast();
    }

    public void beforeFirst() throws SQLException {
        this.checkCursorMove();
        this.fbFetcher.beforeFirst();
    }

    public void afterLast() throws SQLException {
        this.checkCursorMove();
        this.fbFetcher.afterLast();
    }

    public boolean first() throws SQLException {
        this.checkCursorMove();
        return this.fbFetcher.first();
    }

    public boolean last() throws SQLException {
        this.checkCursorMove();
        return this.fbFetcher.last();
    }

    public int getRow() throws SQLException {
        return this.fbFetcher.getRowNum();
    }

    public boolean absolute(int row) throws SQLException {
        this.checkCursorMove();
        return this.fbFetcher.absolute(row);
    }

    public boolean relative(int rows) throws SQLException {
        this.checkCursorMove();
        return this.fbFetcher.relative(rows);
    }

    public boolean previous() throws SQLException {
        this.checkCursorMove();
        return this.fbFetcher.previous();
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new FBDriverNotCapableException("Can't set fetch direction");
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new FBSQLException("Can't set negative fetch size.", "HY009");
        }
        if (this.maxRows > 0 && rows > this.maxRows) {
            throw new FBSQLException("Can't set fetch size > maxRows.", "HY009");
        }
        this.fetchSize = rows;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getType() throws SQLException {
        return this.rsType;
    }

    public int getConcurrency() throws SQLException {
        return this.rsConcurrency;
    }

    public boolean rowUpdated() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public boolean rowInserted() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public boolean rowDeleted() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateNull(String columnName) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateShort(String columnName, short x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateInt(String columnName, int x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateLong(String columnName, long x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateString(String columnName, String x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void insertRow() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateRow() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void deleteRow() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void refreshRow() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void cancelRowUpdates() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void moveToInsertRow() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void moveToCurrentRow() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public Statement getStatement() {
        return this.fbFetcher.getStatement();
    }

    public Object getObject(int i, Map map) throws SQLException {
        return this.getField(i).getObject(map);
    }

    public Ref getRef(int i) throws SQLException {
        return this.getField(i).getRef();
    }

    public Clob getClob(int i) throws SQLException {
        return this.getField(i).getClob();
    }

    public Array getArray(int i) throws SQLException {
        return this.getField(i).getArray();
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        return this.getField(columnName).getObject(map);
    }

    public Ref getRef(String columnName) throws SQLException {
        return this.getField(columnName).getRef();
    }

    public Blob getBlob(String columnName) throws SQLException {
        return this.getField(columnName).getBlob();
    }

    public Clob getClob(String columnName) throws SQLException {
        return this.getField(columnName).getClob();
    }

    public Array getArray(String columnName) throws SQLException {
        return this.getField(columnName).getArray();
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getField(columnIndex).getDate(cal);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getField(columnName).getDate(cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getField(columnIndex).getTime(cal);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getField(columnName).getTime(cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getField(columnIndex).getTimestamp(cal);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getField(columnName).getTimestamp(cal);
    }

    public URL getURL(int param1) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public URL getURL(String param1) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateRef(int param1, Ref param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateRef(String param1, Ref param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateBlob(int param1, Blob param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateBlob(String param1, Blob param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateClob(int param1, Clob param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateClob(String param1, Clob param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateArray(int param1, Array param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateArray(String param1, Array param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    protected void addWarning(SQLWarning warning) {
        if (this.firstWarning == null) {
            this.firstWarning = warning;
        } else {
            SQLWarning lastWarning = this.firstWarning;
            while (lastWarning.getNextWarning() != null) {
                lastWarning = lastWarning.getNextWarning();
            }
            lastWarning.setNextWarning(warning);
        }
    }
}

