/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.isc_stmt_handle;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.AbstractStatement;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

class FBStatementFetcher
implements FBFetcher {
    private boolean wasFetched;
    private AbstractConnection c;
    protected AbstractStatement fbStatement;
    protected FBResultSet rs;
    private isc_stmt_handle stmt;
    private Object[] rowsArray;
    private int size;
    protected byte[][] _nextRow;
    private static final Logger log = LoggerFactory.getLogger(class$org$firebirdsql$jdbc$FBStatementFetcher == null ? (class$org$firebirdsql$jdbc$FBStatementFetcher = FBStatementFetcher.class$("org.firebirdsql.jdbc.FBStatementFetcher")) : class$org$firebirdsql$jdbc$FBStatementFetcher, false);
    private int rowNum = 0;
    private int rowPosition = 0;
    private boolean isEmpty = false;
    private boolean isBeforeFirst = false;
    private boolean isFirst = false;
    private boolean isLast = false;
    private boolean isAfterLast = false;
    static /* synthetic */ Class class$org$firebirdsql$jdbc$FBStatementFetcher;

    FBStatementFetcher(AbstractConnection c, AbstractStatement fbStatement, isc_stmt_handle stmth, FBResultSet rs) throws SQLException {
        this.c = c;
        this.fbStatement = fbStatement;
        this.stmt = stmth;
        this.rs = rs;
        c.registerStatement(fbStatement);
        this.isEmpty = false;
        this.isBeforeFirst = false;
        this.isFirst = false;
        this.isLast = false;
        this.isAfterLast = false;
        if (this.stmt.getAllRowsFetched()) {
            this.rowsArray = this.stmt.getRows();
            this.size = this.stmt.size();
        }
    }

    protected byte[][] getNextRow() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this._nextRow;
    }

    protected void setNextRow(byte[][] nextRow) {
        this._nextRow = nextRow;
        if (!this.wasFetched) {
            this.wasFetched = true;
            if (this._nextRow == null) {
                this.isEmpty = true;
            } else {
                this.isBeforeFirst = true;
            }
        }
    }

    public boolean next() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        this.setIsBeforeFirst(false);
        this.setIsFirst(false);
        this.setIsLast(false);
        this.setIsAfterLast(false);
        if (this.isEmpty()) {
            return false;
        }
        if (this.getNextRow() == null || this.fbStatement.maxRows != 0 && this.getRowNum() == this.fbStatement.maxRows) {
            this.setIsAfterLast(true);
            this.setRowNum(0);
            return false;
        }
        this.rs.row = this.getNextRow();
        this.fetch();
        this.setRowNum(this.getRowNum() + 1);
        if (this.getRowNum() == 1) {
            this.setIsFirst(true);
        }
        if (this.getNextRow() == null || this.fbStatement.maxRows != 0 && this.getRowNum() == this.fbStatement.maxRows) {
            this.setIsLast(true);
        }
        return true;
    }

    public boolean absolute(int row) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public boolean first() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public boolean last() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public boolean previous() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public boolean relative(int row) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void beforeFirst() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void afterLast() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void fetch() throws SQLException {
        int fetchSize;
        int maxRows = 0;
        if (this.fbStatement.maxRows != 0) {
            maxRows = this.fbStatement.maxRows - this.rowNum;
        }
        if ((fetchSize = this.fbStatement.fetchSize) == 0) {
            fetchSize = 400;
        }
        if (maxRows != 0 && fetchSize > maxRows) {
            fetchSize = maxRows;
        }
        if (!(this.stmt.getAllRowsFetched() || this.rowsArray != null && this.size != this.rowPosition)) {
            try {
                this.c.fetch(this.stmt, fetchSize);
                this.rowPosition = 0;
                this.rowsArray = this.stmt.getRows();
                this.size = this.stmt.size();
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
        }
        if (this.rowsArray != null && this.size > this.rowPosition) {
            this.setNextRow((byte[][])this.rowsArray[this.rowPosition]);
            this.rowsArray[this.rowPosition] = null;
            ++this.rowPosition;
        } else {
            this.setNextRow(null);
        }
    }

    public void close() throws SQLException {
        this.fbStatement.closeResultSet();
    }

    public AbstractStatement getStatement() {
        return this.fbStatement;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(int rowNumValue) {
        this.rowNum = rowNumValue;
    }

    public boolean isEmpty() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isEmpty;
    }

    public void setIsEmpty(boolean isEmptyValue) {
        this.isEmpty = isEmptyValue;
    }

    public boolean isBeforeFirst() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isBeforeFirst;
    }

    public void setIsBeforeFirst(boolean isBeforeFirstValue) {
        this.isBeforeFirst = isBeforeFirstValue;
    }

    public boolean isFirst() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isFirst;
    }

    public void setIsFirst(boolean isFirstValue) {
        this.isFirst = isFirstValue;
    }

    public boolean isLast() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isLast;
    }

    public void setIsLast(boolean isLastValue) {
        this.isLast = isLastValue;
    }

    public boolean isAfterLast() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isAfterLast;
    }

    public void setIsAfterLast(boolean isAfterLastValue) {
        this.isAfterLast = isAfterLastValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

