/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import org.firebirdsql.gds.isc_stmt_handle;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.AbstractStatement;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBStatementFetcher;

public class FBUpdatableFetcher
extends FBStatementFetcher {
    FBUpdatableFetcher(AbstractConnection c, AbstractStatement fbStatement, isc_stmt_handle stmth, FBResultSet rs) throws SQLException {
        super(c, fbStatement, stmth, rs);
    }

    public boolean next() throws SQLException {
        boolean maxRowReached;
        if (this.isBeforeFirst()) {
            this.setIsBeforeFirst(false);
            this.setIsEmpty(false);
            this.setIsFirst(true);
            this.setRowNum(this.getRowNum() + 1);
            this.rs.row = this.getNextRow();
            return true;
        }
        this.setIsBeforeFirst(false);
        this.setIsFirst(false);
        this.setIsLast(false);
        this.setIsAfterLast(false);
        if (this.isEmpty()) {
            return false;
        }
        if (this.getNextRow() == null || this.fbStatement.maxRows != 0 && this.getRowNum() == this.fbStatement.maxRows) {
            this.setIsAfterLast(true);
            this.setRowNum(0);
            return false;
        }
        this.fetch();
        boolean bl = maxRowReached = this.fbStatement.maxRows != 0 && this.getRowNum() == this.fbStatement.maxRows;
        if (this.getNextRow() == null || maxRowReached) {
            this.setIsAfterLast(true);
            return false;
        }
        this.rs.row = this.getNextRow();
        this.setRowNum(this.getRowNum() + 1);
        return true;
    }

    public boolean isLast() throws SQLException {
        throw new FBDriverNotCapableException("isLast() operation is not defined in case of updatable cursors, because server cannot determine cursor position without additional fetch.");
    }
}

