/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.field.FBField;

public class FBBigDecimalField
extends FBField {
    private static final BigInteger MAX_SHORT = BigInteger.valueOf(32767L);
    private static final BigInteger MIN_SHORT = BigInteger.valueOf(-32768L);
    private static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    private int fieldType = 0;

    FBBigDecimalField(XSQLVAR field, FBResultSet rs, int numCol, int fieldType, int requiredType) throws SQLException {
        super(field, rs, numCol, requiredType);
        this.fieldType = fieldType;
    }

    public boolean getBoolean() throws SQLException {
        return this.getByte() == 1;
    }

    public byte getByte() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        long longValue = this.getLong();
        if (longValue > 127L || longValue < -128L) {
            throw (SQLException)FBBigDecimalField.createException(BYTE_CONVERSION_ERROR).fillInStackTrace();
        }
        return (byte)longValue;
    }

    public double getDouble() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0;
        }
        return this.getBigDecimal().doubleValue();
    }

    public float getFloat() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0f;
        }
        double doubleValue = this.getDouble();
        if (doubleValue > 3.4028234663852886E38 || doubleValue < -3.4028234663852886E38) {
            throw (SQLException)FBBigDecimalField.createException(FLOAT_CONVERSION_ERROR).fillInStackTrace();
        }
        return (float)doubleValue;
    }

    public int getInt() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        long longValue = this.getLong();
        if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
            throw (SQLException)FBBigDecimalField.createException(INT_CONVERSION_ERROR).fillInStackTrace();
        }
        return (int)longValue;
    }

    public long getLong() throws SQLException {
        return this.getBigDecimal().longValue();
    }

    public short getShort() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        long longValue = this.getLong();
        if (longValue > 32767L || longValue < -32768L) {
            throw (SQLException)FBBigDecimalField.createException(SHORT_CONVERSION_ERROR).fillInStackTrace();
        }
        return (short)longValue;
    }

    public String getString() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return STRING_NULL_VALUE;
        }
        return this.getBigDecimal().toString();
    }

    /*
     * WARNING - void declaration
     */
    public BigDecimal getBigDecimal() throws SQLException {
        void var1_1;
        long longValue;
        if (this.rs.row[this.numCol] == null) {
            return BIGDECIMAL_NULL_VALUE;
        }
        if (this.fieldType == 2) {
            longValue = this.field.decodeInt(this.rs.row[this.numCol]);
        } else if (this.fieldType == 3) {
            longValue = this.field.decodeLong(this.rs.row[this.numCol]);
        } else if (this.fieldType == 1) {
            longValue = this.field.decodeShort(this.rs.row[this.numCol]);
        } else {
            throw (SQLException)FBBigDecimalField.createException(BIGDECIMAL_CONVERSION_ERROR).fillInStackTrace();
        }
        return BigDecimal.valueOf((long)var1_1, -this.field.sqlscale);
    }

    public void setBoolean(boolean value) throws SQLException {
        this.setInteger(value ? 1 : 0);
    }

    public void setByte(byte value) throws SQLException {
        this.setLong(value);
    }

    public void setDouble(double value) throws SQLException {
        this.setBigDecimal(new BigDecimal(Double.toString(value)));
    }

    public void setFloat(float value) throws SQLException {
        this.setDouble(value);
    }

    public void setInteger(int value) throws SQLException {
        this.setLong(value);
    }

    public void setLong(long value) throws SQLException {
        this.setBigDecimal(BigDecimal.valueOf(value, 0));
    }

    public void setShort(short value) throws SQLException {
        this.setLong(value);
    }

    public void setString(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        try {
            this.setBigDecimal(new BigDecimal(value));
        }
        catch (NumberFormatException nex) {
            throw (SQLException)FBBigDecimalField.createException(STRING_CONVERSION_ERROR).fillInStackTrace();
        }
    }

    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == BIGDECIMAL_NULL_VALUE) {
            this.setNull();
            return;
        }
        value = value.setScale(-this.field.sqlscale, 4);
        if (this.fieldType == 1) {
            if (value.unscaledValue().compareTo(MAX_SHORT) > 0 || value.unscaledValue().compareTo(MIN_SHORT) < 0) {
                throw (SQLException)FBBigDecimalField.createException(BIGDECIMAL_CONVERSION_ERROR).fillInStackTrace();
            }
            this.field.sqldata = this.field.encodeShort(value.unscaledValue().shortValue());
        } else if (this.fieldType == 2) {
            if (value.unscaledValue().compareTo(MAX_INT) > 0 || value.unscaledValue().compareTo(MIN_INT) < 0) {
                throw (SQLException)FBBigDecimalField.createException(BIGDECIMAL_CONVERSION_ERROR).fillInStackTrace();
            }
            this.field.sqldata = this.field.encodeInt(value.unscaledValue().intValue());
        } else if (this.fieldType == 3) {
            if (value.unscaledValue().compareTo(MAX_LONG) > 0 || value.unscaledValue().compareTo(MIN_LONG) < 0) {
                throw (SQLException)FBBigDecimalField.createException(BIGDECIMAL_CONVERSION_ERROR).fillInStackTrace();
            }
            this.field.sqldata = this.field.encodeLong(value.unscaledValue().longValue());
        } else {
            throw (SQLException)FBBigDecimalField.createException(BIGDECIMAL_CONVERSION_ERROR).fillInStackTrace();
        }
    }
}

