/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ngds;

import org.firebirdsql.gds.AbstractGDS;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.GDSType;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.XSQLDA;
import org.firebirdsql.gds.isc_blob_handle;
import org.firebirdsql.gds.isc_db_handle;
import org.firebirdsql.gds.isc_stmt_handle;
import org.firebirdsql.gds.isc_svc_handle;
import org.firebirdsql.gds.isc_tr_handle;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.ngds.BlobParameterBufferImp;
import org.firebirdsql.ngds.DatabaseParameterBufferImp;
import org.firebirdsql.ngds.ServiceParameterBufferImp;
import org.firebirdsql.ngds.ServiceRequestBufferImp;
import org.firebirdsql.ngds.isc_blob_handle_impl;
import org.firebirdsql.ngds.isc_db_handle_impl;
import org.firebirdsql.ngds.isc_stmt_handle_impl;
import org.firebirdsql.ngds.isc_svc_handle_impl;
import org.firebirdsql.ngds.isc_tr_handle_impl;

public class GDS_Impl
extends AbstractGDS
implements GDS {
    private static Logger log = LoggerFactory.getLogger(class$org$firebirdsql$ngds$GDS_Impl == null ? (class$org$firebirdsql$ngds$GDS_Impl = GDS_Impl.class$("org.firebirdsql.ngds.GDS_Impl")) : class$org$firebirdsql$ngds$GDS_Impl, false);
    private static final String[] LIST_OF_CLIENT_LIBRARIES_TO_TRY = new String[]{"fbclient.dll", "libfbclient.so", "gds32.dll", "libgds.so"};
    private static final String[] LIST_OF_EMBEDDED_SERVER_LIBRARIES_TO_TRY = new String[]{"fbembed.dll", "libfbembed.so"};
    static final byte[] describe_database_info = new byte[]{62, 12, 32, 33, 1};
    private static byte[] stmtInfo = new byte[]{23, 21, 1};
    private static int INFO_SIZE = 128;
    static /* synthetic */ Class class$org$firebirdsql$ngds$GDS_Impl;

    public GDS_Impl() {
    }

    public GDS_Impl(GDSType gdsType) {
        super(gdsType);
        boolean logging;
        boolean bl = logging = log != null;
        if (logging) {
            log.info("Attempting to loadLibrary for \"jaybird\"");
        }
        try {
            System.loadLibrary("jaybird");
        }
        catch (SecurityException ex) {
            if (logging) {
                log.error("Failed to load native library. SecurityException caught.", ex);
            }
            throw ex;
        }
        catch (UnsatisfiedLinkError ex) {
            if (logging) {
                log.error("Failed to load native library. UnsatisfiedLinkError caught.", ex);
            }
            throw ex;
        }
        if (logging) {
            log.info("loadLibrary for \"java_gds\" returned OK.");
        }
        if (logging) {
            log.info("Attempting to initilize native library.");
        }
        if (this.getGdsType() == GDSType.NATIVE || this.getGdsType() == GDSType.NATIVE_LOCAL) {
            this.attemptToLoadAClientLibraryFromList(LIST_OF_CLIENT_LIBRARIES_TO_TRY);
        } else if (this.getGdsType() == GDSType.NATIVE_EMBEDDED) {
            this.attemptToLoadAClientLibraryFromList(LIST_OF_EMBEDDED_SERVER_LIBRARIES_TO_TRY);
        } else {
            throw new RuntimeException("Unrecognized GDS type.");
        }
        if (logging) {
            log.info("Initilized native library OK.");
        }
    }

    private void attemptToLoadAClientLibraryFromList(String[] clientLibraryList) {
        boolean logging = log != null;
        int n = clientLibraryList.length;
        for (int i = 0; i < n; ++i) {
            String currentClientLibraryToTry = clientLibraryList[i];
            try {
                this.nativeInitilize(currentClientLibraryToTry);
            }
            catch (Throwable th) {
                th.printStackTrace();
                if (logging) {
                    log.debug("Failed to load client library # " + i + " - \"" + currentClientLibraryToTry + "\".", th);
                }
                if (i != clientLibraryList.length - 1) continue;
                throw new RuntimeException("Failed to initilize jaybird native library. This is most likley due to a failure to load the firebird client library.");
            }
            if (!logging) break;
            log.info("Successfully loaded client library # " + i + " - \"" + currentClientLibraryToTry + "\".");
            break;
        }
    }

    private native void nativeInitilize(String var1);

    public ServiceParameterBuffer newServiceParameterBuffer() {
        return new ServiceParameterBufferImp();
    }

    public ServiceRequestBuffer newServiceRequestBuffer(int taskIdentifier) {
        return new ServiceRequestBufferImp(taskIdentifier);
    }

    public DatabaseParameterBuffer newDatabaseParameterBuffer() {
        return new DatabaseParameterBufferImp();
    }

    public BlobParameterBuffer newBlobParameterBuffer() {
        return new BlobParameterBufferImp();
    }

    public synchronized isc_db_handle get_new_isc_db_handle() {
        return new isc_db_handle_impl();
    }

    public synchronized isc_tr_handle get_new_isc_tr_handle() {
        return new isc_tr_handle_impl();
    }

    public synchronized isc_stmt_handle get_new_isc_stmt_handle() {
        return new isc_stmt_handle_impl();
    }

    public synchronized isc_blob_handle get_new_isc_blob_handle() {
        return new isc_blob_handle_impl();
    }

    public isc_svc_handle get_new_isc_svc_handle() {
        return new isc_svc_handle_impl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_create_database(String file_name, isc_db_handle db_handle, DatabaseParameterBuffer databaseParameterBuffer) throws GDSException {
        if (db_handle == null) {
            throw new GDSException(0x14000004);
        }
        byte[] dpbBytes = databaseParameterBuffer == null ? null : ((DatabaseParameterBufferImp)databaseParameterBuffer).getBytesForNativeCode();
        GDS_Impl gDS_Impl = this;
        synchronized (gDS_Impl) {
            this.native_isc_create_database(this.getServerUrl(file_name), db_handle, dpbBytes);
        }
    }

    private native void native_isc_create_database(String var1, isc_db_handle var2, byte[] var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_attach_database(String file_name, isc_db_handle db_handle, DatabaseParameterBuffer databaseParameterBuffer) throws GDSException {
        if (db_handle == null) {
            throw new GDSException(0x14000004);
        }
        DatabaseParameterBuffer cleanDPB = this.removeInternalDPB(databaseParameterBuffer);
        byte[] dpbBytes = databaseParameterBuffer == null ? null : ((DatabaseParameterBufferImp)cleanDPB).getBytesForNativeCode();
        GDS_Impl gDS_Impl = this;
        synchronized (gDS_Impl) {
            this.native_isc_attach_database(this.getServerUrl(file_name), db_handle, dpbBytes);
        }
        this.parseAttachDatabaseInfo(this.isc_database_info(db_handle, describe_database_info, 1024), db_handle);
    }

    private DatabaseParameterBuffer removeInternalDPB(DatabaseParameterBuffer dpb) {
        DatabaseParameterBuffer result = dpb.deepCopy();
        result.removeArgument(129);
        result.removeArgument(130);
        result.removeArgument(131);
        result.removeArgument(132);
        return result;
    }

    private void parseAttachDatabaseInfo(byte[] info, isc_db_handle handle) throws GDSException {
        boolean debug;
        boolean bl = debug = log != null && log.isDebugEnabled();
        if (debug) {
            log.debug("parseDatabaseInfo: first 2 bytes are " + this.isc_vax_integer(info, 0, 2) + " or: " + info[0] + ", " + info[1]);
        }
        int value = 0;
        int len = 0;
        int i = 0;
        isc_db_handle_impl db = (isc_db_handle_impl)handle;
        block7: while (info[i] != 1) {
            switch (info[i++]) {
                case 62: {
                    len = this.isc_vax_integer(info, i, 2);
                    value = this.isc_vax_integer(info, i += 2, len);
                    i += len;
                    db.setDialect(value);
                    if (!debug) continue block7;
                    log.debug("isc_info_db_sql_dialect:" + value);
                    continue block7;
                }
                case 12: {
                    len = this.isc_vax_integer(info, i, 2);
                    i += 2;
                    if (debug) {
                        log.debug("isc_info_version len:" + len);
                    }
                    byte[] vers = new byte[len - 2];
                    System.arraycopy(info, i + 2, vers, 0, len - 2);
                    String versS = new String(vers);
                    i += len;
                    db.setVersion(versS);
                    if (!debug) continue block7;
                    log.debug("isc_info_version:" + versS);
                    continue block7;
                }
                case 32: {
                    len = this.isc_vax_integer(info, i, 2);
                    value = this.isc_vax_integer(info, i += 2, len);
                    i += len;
                    db.setODSMajorVersion(value);
                    if (!debug) continue block7;
                    log.debug("isc_info_ods_version:" + value);
                    continue block7;
                }
                case 33: {
                    len = this.isc_vax_integer(info, i, 2);
                    value = this.isc_vax_integer(info, i += 2, len);
                    i += len;
                    db.setODSMinorVersion(value);
                    if (!debug) continue block7;
                    log.debug("isc_info_ods_minor_version:" + value);
                    continue block7;
                }
                case 2: {
                    if (debug) {
                        log.debug("isc_info_truncated ");
                    }
                    return;
                }
            }
            throw new GDSException(335544583);
        }
    }

    private native void native_isc_attach_database(String var1, isc_db_handle var2, byte[] var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] isc_database_info(isc_db_handle db_handle, byte[] items, int buffer_length) throws GDSException {
        isc_db_handle isc_db_handle2 = db_handle;
        synchronized (isc_db_handle2) {
            byte[] returnValue = new byte[buffer_length];
            this.native_isc_database_info(db_handle, items.length, items, buffer_length, returnValue);
            return returnValue;
        }
    }

    public native void native_isc_database_info(isc_db_handle var1, int var2, byte[] var3, int var4, byte[] var5) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_detach_database(isc_db_handle db_handle) throws GDSException {
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        GDS_Impl gDS_Impl = this;
        synchronized (gDS_Impl) {
            if (db.hasTransactions()) {
                throw new GDSException(335544357, db.getOpenTransactionCount());
            }
            this.native_isc_detach_database(db_handle);
        }
    }

    public native void native_isc_detach_database(isc_db_handle var1) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_drop_database(isc_db_handle db_handle) throws GDSException {
        if (db_handle == null) {
            throw new GDSException(0x14000004);
        }
        GDS_Impl gDS_Impl = this;
        synchronized (gDS_Impl) {
            this.native_isc_drop_database(db_handle);
        }
    }

    public native void native_isc_drop_database(isc_db_handle var1) throws GDSException;

    public byte[] isc_expand_dpb(byte[] dpb, int dpb_length, int param, Object[] params) throws GDSException {
        return dpb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_start_transaction(isc_tr_handle tr_handle, isc_db_handle db_handle, byte[] tpb) throws GDSException {
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        isc_db_handle isc_db_handle2 = db_handle;
        synchronized (isc_db_handle2) {
            if (tr.getState() != 0) {
                throw new GDSException(335544468);
            }
            tr.setState(1);
            byte[] arg = new byte[tpb.length + 1];
            arg[0] = 3;
            System.arraycopy(tpb, 0, arg, 1, tpb.length);
            this.native_isc_start_transaction(tr_handle, db_handle, arg);
            tr.setDbHandle((isc_db_handle_impl)db_handle);
            tr.setState(2);
        }
    }

    public native void native_isc_start_transaction(isc_tr_handle var1, isc_db_handle var2, byte[] var3) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_commit_transaction(isc_tr_handle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2 && tr.getState() != 4) {
                throw new GDSException(335544468);
            }
            tr.setState(5);
            this.native_isc_commit_transaction(tr_handle);
            tr.setState(0);
            tr.unsetDbHandle();
        }
    }

    public native void native_isc_commit_transaction(isc_tr_handle var1) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_rollback_transaction(isc_tr_handle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() == 0) {
                throw new GDSException(335544468);
            }
            tr.setState(6);
            this.native_isc_rollback_transaction(tr_handle);
            tr.setState(0);
            tr.unsetDbHandle();
        }
    }

    public native void native_isc_rollback_transaction(isc_tr_handle var1) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_commit_retaining(isc_tr_handle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2 && tr.getState() != 4) {
                throw new GDSException(335544468);
            }
            tr.setState(5);
            this.native_isc_commit_retaining(tr_handle);
            tr.setState(2);
        }
    }

    public native void native_isc_commit_retaining(isc_tr_handle var1) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_prepare_transaction(isc_tr_handle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2) {
                throw new GDSException(335544468);
            }
            tr.setState(3);
            this.native_isc_prepare_transaction(tr_handle);
            tr.setState(4);
        }
    }

    public native void native_isc_prepare_transaction(isc_tr_handle var1) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_prepare_transaction2(isc_tr_handle tr_handle, byte[] bytes) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2) {
                throw new GDSException(335544468);
            }
            tr.setState(3);
            this.native_isc_prepare_transaction2(tr_handle, bytes);
            tr.setState(4);
        }
    }

    public native void native_isc_prepare_transaction2(isc_tr_handle var1, byte[] var2) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_rollback_retaining(isc_tr_handle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2 && tr.getState() != 4) {
                throw new GDSException(335544468);
            }
            tr.setState(6);
            this.native_isc_rollback_retaining(tr_handle);
            tr.setState(2);
        }
    }

    public native void native_isc_rollback_retaining(isc_tr_handle var1) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_dsql_allocate_statement(isc_db_handle db_handle, isc_stmt_handle stmt_handle) throws GDSException {
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        if (db_handle == null) {
            throw new GDSException(0x14000004);
        }
        if (stmt_handle == null) {
            throw new GDSException(335544327);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            this.native_isc_dsql_allocate_statement(db_handle, stmt_handle);
            stmt.setRsr_rdb((isc_db_handle_impl)db_handle);
            stmt.setAllRowsFetched(false);
        }
    }

    public native void native_isc_dsql_allocate_statement(isc_db_handle var1, isc_stmt_handle var2) throws GDSException;

    public void isc_dsql_alloc_statement2(isc_db_handle db_handle, isc_stmt_handle stmt_handle) throws GDSException {
        throw new GDSException(335544378);
    }

    public native void native_isc_dsql_alloc_statement2(isc_db_handle var1, isc_stmt_handle var2) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSQLDA isc_dsql_describe(isc_stmt_handle stmt_handle, int da_version) throws GDSException {
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        if (stmt == null) {
            throw new GDSException(335544327);
        }
        isc_db_handle_impl isc_db_handle_impl2 = stmt.getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            stmt.setInSqlda(this.native_isc_dsql_describe(stmt_handle, da_version));
            return stmt_handle.getInSqlda();
        }
    }

    public native XSQLDA native_isc_dsql_describe(isc_stmt_handle var1, int var2) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSQLDA isc_dsql_describe_bind(isc_stmt_handle stmt_handle, int da_version) throws GDSException {
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl isc_db_handle_impl2 = stmt.getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            stmt.setInSqlda(this.native_isc_dsql_describe_bind(stmt_handle, da_version));
            return stmt_handle.getInSqlda();
        }
    }

    public native XSQLDA native_isc_dsql_describe_bind(isc_stmt_handle var1, int var2) throws GDSException;

    public void isc_dsql_execute(isc_tr_handle tr_handle, isc_stmt_handle stmt_handle, int da_version, XSQLDA xsqlda) throws GDSException {
        this.isc_dsql_execute2(tr_handle, stmt_handle, da_version, xsqlda, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_dsql_execute2(isc_tr_handle tr_handle, isc_stmt_handle stmt_handle, int da_version, XSQLDA in_xsqlda, XSQLDA out_xsqlda) throws GDSException {
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl isc_db_handle_impl2 = stmt.getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            this.native_isc_dsql_execute2(tr_handle, stmt_handle, da_version, in_xsqlda, out_xsqlda);
            if (out_xsqlda != null) {
                stmt.ensureCapacity(1);
                this.readSQLData(out_xsqlda, stmt);
                stmt.setAllRowsFetched(true);
                stmt.setIsSingletonResult(true);
            } else {
                stmt.setAllRowsFetched(false);
                stmt.setIsSingletonResult(false);
            }
        }
    }

    public native void native_isc_dsql_execute2(isc_tr_handle var1, isc_stmt_handle var2, int var3, XSQLDA var4, XSQLDA var5) throws GDSException;

    public void isc_dsql_execute_immediate(isc_db_handle db_handle, isc_tr_handle tr_handle, String statement, int dialect, XSQLDA xsqlda) throws GDSException {
        this.isc_dsql_exec_immed2(db_handle, tr_handle, statement, dialect, xsqlda, null);
    }

    public void isc_dsql_execute_immediate(isc_db_handle db_handle, isc_tr_handle tr_handle, String statement, String encoding, int dialect, XSQLDA xsqlda) throws GDSException {
        this.isc_dsql_exec_immed2(db_handle, tr_handle, statement, encoding, dialect, xsqlda, null);
    }

    public void isc_dsql_exec_immed2(isc_db_handle db_handle, isc_tr_handle tr_handle, String statement, int dialect, XSQLDA in_xsqlda, XSQLDA out_xsqlda) throws GDSException {
        this.isc_dsql_exec_immed2(db_handle, tr_handle, statement, "NONE", dialect, in_xsqlda, out_xsqlda);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_dsql_exec_immed2(isc_db_handle db_handle, isc_tr_handle tr_handle, String statement, String encoding, int dialect, XSQLDA in_xsqlda, XSQLDA out_xsqlda) throws GDSException {
        isc_db_handle isc_db_handle2 = db_handle;
        synchronized (isc_db_handle2) {
            this.native_isc_dsql_exec_immed2(db_handle, tr_handle, statement, encoding, dialect, in_xsqlda, out_xsqlda);
        }
    }

    public native void native_isc_dsql_exec_immed2(isc_db_handle var1, isc_tr_handle var2, String var3, String var4, int var5, XSQLDA var6, XSQLDA var7) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_dsql_fetch(isc_stmt_handle stmt_handle, int da_version, XSQLDA xsqlda, int fetchSize) throws GDSException {
        isc_db_handle_impl db;
        fetchSize = 1;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl isc_db_handle_impl2 = db = stmt.getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            if (stmt_handle == null) {
                throw new GDSException(335544327);
            }
            if (xsqlda == null) {
                throw new GDSException(335544583);
            }
            if (fetchSize <= 0) {
                throw new GDSException(335544583);
            }
            stmt.ensureCapacity(fetchSize);
            for (int i = 0; i < fetchSize; ++i) {
                boolean isRowPresent = this.native_isc_dsql_fetch(stmt_handle, da_version, xsqlda, fetchSize);
                if (!isRowPresent) {
                    stmt.setAllRowsFetched(true);
                    return;
                }
                this.readSQLData(xsqlda, stmt);
            }
        }
    }

    public void readSQLData(XSQLDA xsqlda, isc_stmt_handle_impl stmt) {
        int numCols = xsqlda.sqld;
        byte[][] row = new byte[numCols][];
        for (int i = 0; i < numCols; ++i) {
            row[i] = xsqlda.sqlvar[i].sqldata;
        }
        if (stmt != null) {
            stmt.addRow(row);
        }
    }

    public native boolean native_isc_dsql_fetch(isc_stmt_handle var1, int var2, XSQLDA var3, int var4) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_dsql_free_statement(isc_stmt_handle stmt_handle, int option) throws GDSException {
        isc_db_handle_impl db;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl isc_db_handle_impl2 = db = stmt.getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            if (stmt_handle == null) {
                throw new GDSException(335544327);
            }
            if (stmt.getIsSingletonResult() && option == 1) {
                return;
            }
            if (option == 2) {
                stmt.setInSqlda(null);
                stmt.setOutSqlda(null);
                stmt.setRsr_rdb(null);
            }
            this.native_isc_dsql_free_statement(stmt_handle, option);
        }
    }

    public native void native_isc_dsql_free_statement(isc_stmt_handle var1, int var2) throws GDSException;

    public XSQLDA isc_dsql_prepare(isc_tr_handle tr_handle, isc_stmt_handle stmt_handle, String statement, int dialect) throws GDSException {
        return this.isc_dsql_prepare(tr_handle, stmt_handle, statement, "NONE", dialect);
    }

    public native XSQLDA native_isc_dsql_prepare(isc_tr_handle var1, isc_stmt_handle var2, String var3, int var4) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSQLDA isc_dsql_prepare(isc_tr_handle tr_handle, isc_stmt_handle stmt_handle, String statement, String encoding, int dialect) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl isc_db_handle_impl2 = db = stmt.getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            if (tr_handle == null) {
                throw new GDSException(335544332);
            }
            if (stmt_handle == null) {
                throw new GDSException(335544327);
            }
            stmt.setInSqlda(null);
            stmt.setOutSqlda(null);
            stmt.setOutSqlda(this.native_isc_dsql_prepare(tr_handle, stmt_handle, statement, dialect));
            return stmt_handle.getOutSqlda();
        }
    }

    public native XSQLDA native_isc_dsql_prepare(isc_tr_handle var1, isc_stmt_handle var2, String var3, String var4, int var5) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_dsql_set_cursor_name(isc_stmt_handle stmt_handle, String cursor_name, int type) throws GDSException {
        isc_db_handle_impl db;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl isc_db_handle_impl2 = db = stmt.getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            if (stmt_handle == null) {
                throw new GDSException(335544327);
            }
            this.native_isc_dsql_set_cursor_name(stmt_handle, cursor_name, type);
        }
    }

    public native void native_isc_dsql_set_cursor_name(isc_stmt_handle var1, String var2, int var3) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] isc_dsql_sql_info(isc_stmt_handle stmt_handle, byte[] items, int buffer_length) throws GDSException {
        isc_db_handle_impl isc_db_handle_impl2 = ((isc_stmt_handle_impl)stmt_handle).getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            return this.native_isc_dsql_sql_info(stmt_handle, items, buffer_length);
        }
    }

    public native byte[] native_isc_dsql_sql_info(isc_stmt_handle var1, byte[] var2, int var3) throws GDSException;

    public void getSqlCounts(isc_stmt_handle stmt_handle) throws GDSException {
        byte type;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        byte[] buffer = this.isc_dsql_sql_info(stmt, stmtInfo, INFO_SIZE);
        int pos = 0;
        block10: while ((type = buffer[pos++]) != 1) {
            int length = this.isc_vax_integer(buffer, pos, 2);
            pos += 2;
            switch (type) {
                case 23: {
                    byte t;
                    while ((t = buffer[pos++]) != 1) {
                        int l = this.isc_vax_integer(buffer, pos, 2);
                        pos += 2;
                        switch (t) {
                            case 14: {
                                stmt.setInsertCount(this.isc_vax_integer(buffer, pos, l));
                                break;
                            }
                            case 15: {
                                stmt.setUpdateCount(this.isc_vax_integer(buffer, pos, l));
                                break;
                            }
                            case 16: {
                                stmt.setDeleteCount(this.isc_vax_integer(buffer, pos, l));
                                break;
                            }
                            case 13: {
                                stmt.setSelectCount(this.isc_vax_integer(buffer, pos, l));
                                break;
                            }
                        }
                        pos += l;
                    }
                    continue block10;
                }
                case 21: {
                    stmt.setStatementType(this.isc_vax_integer(buffer, pos, length));
                    pos += length;
                    continue block10;
                }
            }
            pos += length;
        }
    }

    public int isc_vax_integer(byte[] buffer, int pos, int length) {
        int shift = 0;
        int value = 0;
        int i = pos;
        while (--length >= 0) {
            value += (buffer[i++] & 0xFF) << shift;
            shift += 8;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_create_blob2(isc_db_handle db_handle, isc_tr_handle tr_handle, isc_blob_handle blob_handle, BlobParameterBuffer blobParameterBuffer) throws GDSException {
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_blob_handle_impl blob = (isc_blob_handle_impl)blob_handle;
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        if (tr == null) {
            throw new GDSException(335544332);
        }
        if (blob == null) {
            throw new GDSException(335544328);
        }
        byte[] bpb = blobParameterBuffer == null ? null : ((BlobParameterBufferImp)blobParameterBuffer).getBytesForNativeCode();
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            this.native_isc_create_blob2(db_handle, tr_handle, blob_handle, bpb);
            blob.setDb(db);
            blob.setTr(tr);
            tr.addBlob(blob);
        }
    }

    private native void native_isc_create_blob2(isc_db_handle var1, isc_tr_handle var2, isc_blob_handle var3, byte[] var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_open_blob2(isc_db_handle db_handle, isc_tr_handle tr_handle, isc_blob_handle blob_handle, BlobParameterBuffer blobParameterBuffer) throws GDSException {
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_blob_handle_impl blob = (isc_blob_handle_impl)blob_handle;
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        if (tr == null) {
            throw new GDSException(335544332);
        }
        if (blob == null) {
            throw new GDSException(335544328);
        }
        byte[] bpb = blobParameterBuffer == null ? null : ((BlobParameterBufferImp)blobParameterBuffer).getBytesForNativeCode();
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            this.native_isc_open_blob2(db_handle, tr_handle, blob_handle, bpb);
            blob.setDb(db);
            blob.setTr(tr);
            tr.addBlob(blob);
        }
    }

    private native void native_isc_open_blob2(isc_db_handle var1, isc_tr_handle var2, isc_blob_handle var3, byte[] var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] isc_get_segment(isc_blob_handle blob, int maxread) throws GDSException {
        isc_db_handle_impl isc_db_handle_impl2 = ((isc_blob_handle_impl)blob).getDb();
        synchronized (isc_db_handle_impl2) {
            return this.native_isc_get_segment(blob, maxread);
        }
    }

    public native byte[] native_isc_get_segment(isc_blob_handle var1, int var2) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_put_segment(isc_blob_handle blob_handle, byte[] buffer) throws GDSException {
        isc_db_handle_impl isc_db_handle_impl2 = ((isc_blob_handle_impl)blob_handle).getDb();
        synchronized (isc_db_handle_impl2) {
            this.native_isc_put_segment(blob_handle, buffer);
        }
    }

    public native void native_isc_put_segment(isc_blob_handle var1, byte[] var2) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_close_blob(isc_blob_handle blob_handle) throws GDSException {
        isc_blob_handle_impl blob = (isc_blob_handle_impl)blob_handle;
        isc_db_handle_impl db = blob.getDb();
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        isc_tr_handle_impl tr = blob.getTr();
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = ((isc_blob_handle_impl)blob_handle).getDb();
        synchronized (isc_db_handle_impl2) {
            this.native_isc_close_blob(blob_handle);
        }
        tr.removeBlob(blob);
    }

    public native void native_isc_close_blob(isc_blob_handle var1) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] isc_blob_info(isc_blob_handle handle, byte[] items, int buffer_length) throws GDSException {
        isc_blob_handle_impl blob;
        isc_blob_handle_impl isc_blob_handle_impl2 = blob = (isc_blob_handle_impl)handle;
        synchronized (isc_blob_handle_impl2) {
            return this.native_isc_blob_info(blob, items, buffer_length);
        }
    }

    public native byte[] native_isc_blob_info(isc_blob_handle_impl var1, byte[] var2, int var3) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_seek_blob(isc_blob_handle handle, int position, int mode) throws GDSException {
        isc_blob_handle_impl blob = (isc_blob_handle_impl)handle;
        isc_blob_handle isc_blob_handle2 = handle;
        synchronized (isc_blob_handle2) {
            this.native_isc_seek_blob(blob, position, mode);
        }
    }

    public native void native_isc_seek_blob(isc_blob_handle_impl var1, int var2, int var3) throws GDSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_service_attach(String service, isc_svc_handle serviceHandle, ServiceParameterBuffer serviceParameterBuffer) throws GDSException {
        ServiceParameterBufferImp serviceParameterBufferImp = (ServiceParameterBufferImp)serviceParameterBuffer;
        byte[] serviceParameterBufferBytes = serviceParameterBufferImp == null ? null : serviceParameterBufferImp.toByteArray();
        isc_svc_handle isc_svc_handle2 = serviceHandle;
        synchronized (isc_svc_handle2) {
            if (serviceHandle.isValid()) {
                throw new GDSException("serviceHandle is already attached.");
            }
            this.native_isc_service_attach(service, serviceHandle, serviceParameterBufferBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_service_detach(isc_svc_handle serviceHandle) throws GDSException {
        isc_svc_handle isc_svc_handle2 = serviceHandle;
        synchronized (isc_svc_handle2) {
            if (serviceHandle.isNotValid()) {
                throw new GDSException("serviceHandle is not attached.");
            }
            this.native_isc_service_detach(serviceHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_service_start(isc_svc_handle serviceHandle, ServiceRequestBuffer serviceRequestBuffer) throws GDSException {
        ServiceRequestBufferImp serviceRequestBufferImp = (ServiceRequestBufferImp)serviceRequestBuffer;
        byte[] serviceRequestBufferBytes = serviceRequestBufferImp == null ? null : serviceRequestBufferImp.toByteArray();
        isc_svc_handle isc_svc_handle2 = serviceHandle;
        synchronized (isc_svc_handle2) {
            if (serviceHandle.isNotValid()) {
                throw new GDSException("serviceHandle is not attached.");
            }
            this.native_isc_service_start(serviceHandle, serviceRequestBufferBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isc_service_query(isc_svc_handle serviceHandle, ServiceParameterBuffer serviceParameterBuffer, ServiceRequestBuffer serviceRequestBuffer, byte[] resultBuffer) throws GDSException {
        ServiceParameterBufferImp serviceParameterBufferImp = (ServiceParameterBufferImp)serviceParameterBuffer;
        byte[] serviceParameterBufferBytes = serviceParameterBufferImp == null ? null : serviceParameterBufferImp.toByteArray();
        ServiceRequestBufferImp serviceRequestBufferImp = (ServiceRequestBufferImp)serviceRequestBuffer;
        byte[] serviceRequestBufferBytes = serviceRequestBufferImp == null ? null : serviceRequestBufferImp.toByteArray();
        isc_svc_handle isc_svc_handle2 = serviceHandle;
        synchronized (isc_svc_handle2) {
            if (serviceHandle.isNotValid()) {
                throw new GDSException("serviceHandle is not attached.");
            }
            this.native_isc_service_query(serviceHandle, serviceParameterBufferBytes, serviceRequestBufferBytes, resultBuffer);
        }
    }

    public native void native_isc_service_attach(String var1, isc_svc_handle var2, byte[] var3) throws GDSException;

    public native void native_isc_service_detach(isc_svc_handle var1) throws GDSException;

    public native void native_isc_service_start(isc_svc_handle var1, byte[] var2) throws GDSException;

    public native void native_isc_service_query(isc_svc_handle var1, byte[] var2, byte[] var3, byte[] var4) throws GDSException;

    private String getServerUrl(String file_name) throws GDSException {
        if (this.getGdsType() == GDSType.NATIVE) {
            return this.getRemoteServerUrl(file_name);
        }
        if (this.getGdsType() == GDSType.NATIVE_LOCAL || this.getGdsType() == GDSType.NATIVE_EMBEDDED) {
            return this.getEmbeddedServerUrl(file_name);
        }
        throw new RuntimeException("Unrecognized gds type.");
    }

    private String getRemoteServerUrl(String file_name) throws GDSException {
        DbAttachInfo dbai;
        if (log != null) {
            log.debug("Original file name: " + file_name);
        }
        String fileName = (dbai = new DbAttachInfo(file_name)).getFileName().indexOf(58) == -1 && !dbai.getFileName().startsWith("/") ? dbai.getServer() + "/" + dbai.getPort() + ":" + "/" + dbai.getFileName() : dbai.getServer() + "/" + dbai.getPort() + ":" + dbai.getFileName();
        if (log != null) {
            log.debug("File name for native code: " + fileName);
        }
        return fileName;
    }

    private String getEmbeddedServerUrl(String file_name) throws GDSException {
        if (log != null) {
            log.debug("Original file name: " + file_name);
        }
        String fileName = file_name;
        if (log != null) {
            log.debug("File name for native code: " + fileName);
        }
        return fileName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class DbAttachInfo {
        private String server = "localhost";
        private int port = 3050;
        private String fileName;

        public String getConnectionString() {
            if (this.getServer().compareToIgnoreCase("loopback") == 0 || this.getServer().compareToIgnoreCase("localhost") == 0) {
                return this.getFileName();
            }
            return this.getServer() + "/" + this.getPort() + ":" + this.getFileName();
        }

        public DbAttachInfo(String connectInfo) throws GDSException {
            char portSepChar;
            char hostSepChar;
            if (connectInfo == null) {
                throw new GDSException("Connection string missing");
            }
            if ((connectInfo = connectInfo.trim()).startsWith("//")) {
                connectInfo = connectInfo.substring(2);
                hostSepChar = '/';
                portSepChar = ':';
            } else {
                hostSepChar = ':';
                portSepChar = '/';
            }
            int sep = connectInfo.indexOf(hostSepChar);
            if (sep == 0 || sep == connectInfo.length() - 1) {
                throw new GDSException("Bad connection string: '" + hostSepChar + "' at beginning or end of:" + connectInfo + 335544323);
            }
            if (sep > 0) {
                this.server = connectInfo.substring(0, sep);
                this.fileName = connectInfo.substring(sep + 1);
                int portSep = this.server.indexOf(portSepChar);
                if (portSep == 0 || portSep == this.server.length() - 1) {
                    throw new GDSException("Bad server string: '" + portSepChar + "' at beginning or end of: " + this.server + 335544323);
                }
                if (portSep > 0) {
                    this.port = Integer.parseInt(this.server.substring(portSep + 1));
                    this.server = this.server.substring(0, portSep);
                }
            } else if (sep == -1) {
                this.fileName = connectInfo;
            }
        }

        public DbAttachInfo(String server, Integer port, String fileName) throws GDSException {
            if (fileName == null || fileName.equals("")) {
                throw new GDSException("null filename in DbAttachInfo");
            }
            if (server != null) {
                this.server = server;
            }
            if (port != null) {
                this.port = port;
            }
            this.fileName = fileName;
            if (fileName == null || fileName.equals("")) {
                throw new GDSException("null filename in DbAttachInfo");
            }
        }

        public String getServer() {
            return this.server;
        }

        public int getPort() {
            return this.port;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

